<?php
namespace App\Components;
use App\Models\Algo;
use Auth;
class AlgoManager
{
	public static $_instance;

    public static function getInstance() {
        if ( !(self::$_instance instanceof self) ) {
            self::$_instance = new self();
        }
        return self::$_instance;
    }
	
	public function getAlgoById($id)
	{
		return Algo::find($id);
	}
	
	public function checkAlgoCount($name, $id = null) {
		return Algo::where(['name' => $name])->first();
	}

	public function create($data) {
		$status = Algo::create($data);
		
		if($status)
		{

			return true;			
		}
		return false;
	}
	
	public function updateById($id, $data) {
		$obj = $this->getAlgoById($id);
		$status = $obj->update($data);
		
		if($status)
		{
						
			return true;
			
		}
		
		return false;
	}
	
	public function deleteById($id)
	{
		$obj = $this->getAlgoById($id);
		
		$clone = $obj->replicate();
		
		if($obj->delete())
		{
			
			return true;
		}
		
		return false;
	}
	
	private function historyStore($id, $obj, $clone, $mode)
	{
			$string = 'id = '.$id.', new description = '.$obj->name.', old description = '.$clone->name;
            $string.=' ';
			$data = ['name' => "Algo Master", 'data' => $string, 'user_id' => Auth::user()->id, 'mode' => $mode];
			\App\Models\HistoryReport::create($data);			
	}
}
