<?php

namespace App\Console\Commands;

use App\Models\User;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;
use Throwable;
use App\Library\EPP;
use Firebase\JWT\JWT;
use Config;
use \Firebase\JWT\Key;
use Illuminate\Support\Facades\Session;

class BilldeskSettlement extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'command:billdesksettlement';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
      
        
    $users = DB::table('transactions')
    ->whereDate('created_at','<=',Carbon::now()->subDays(2)->format('Y-m-d'))
    ->where('transaction_status','0002')->get();

    foreach ($users as $user){
    
        $data=DB::table('payment_gateway_setting')->where('id',2)->first();

        $mid = $data->merchant_id;
        $secretKey = $data->checksum_key;
        $clientId = $data->security_id;

        $payloadData = [
            "mercid" => $mid,
            "orderid" =>$user->reference_id ,
        ];
                
        $traceid = uniqid();
        $currentTimestamp = time();

        $headers = ["alg" => "HS256", "clientid" => $clientId, "kid" => "HMAC"];

         $curl_payload = JWT::encode($payloadData, $secretKey, "HS256", null ,$headers);

        $apiurl="https://api.billdesk.com/payments/ve1_2/transactions/get";

        $curl = curl_init($apiurl);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_HTTPHEADER, [
            'Content-Type: application/jose', 
            'Accept: application/jose', 
            'BD-Traceid: ' . $traceid, 
            'BD-Timestamp: ' . $currentTimestamp,
        ]);
         
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $curl_payload);
         
        $result = curl_exec($curl);
        
        curl_close($curl);

        $encodedString = $result;
   
        $decodedresponse = JWT::decode($encodedString, new Key($secretKey, 'HS256'));


        try{
      

        if ($decodedresponse->auth_status=='0300'){

            $trans=DB::table('transactions')->where('reference_id',$decodedresponse->orderid)->where('transaction_status','0002')->first();
            
            $status=false;

            if($trans!=null){

                $payment_type = $trans->transaction_type;
                $user_id=$trans->user_id;
    
                $status=DB::table('transactions')->where('reference_id','=',$decodedresponse->orderid)->update(
                    [
                        'transaction_status'=>'0300',
                        'transaction_id'=>$decodedresponse->transactionid,
                        'response'=>json_encode($decodedresponse),
                        'response_format'=>'cron',
                        'updated_at'=>date('Y-m-d H:i:s')
                    ]
                );
    
            }

          
            if($status){

                if ($payment_type == 'domainRegister'){
                    $updated_date = date('Y-m-d H:i:s');
                    $user = User::find($user_id);
                    $user->domainStatus = 3;
                    $user->updated_at = $updated_date;
                    $user->save();
    
                    if($trans->dns!='' && $trans->dns!=null){

                        $nameserver=json_decode($trans->dns,true);
    
                        DB::table('user_name_servers')
                            ->updateOrInsert(
                            ['user_id' => $user_id],
                            $nameserver
                        );

                    }
                   
    
                    if(Session::get('dnsse_data')!=null){
    
                        $dns_id = DB::table('user_name_servers')->where('user_id','=', $user_id)->first()->id;
                        DB::table('dns_security-extension')->where('user_dns_server_id','=',$dns_id)->delete();
                        
                        foreach (Session::get('dnsse_data') as $dnssec){
                            $dnssec['user_dns_server_id'] = $dns_id;
                            DB::table('dns_security-extension')->insert($dnssec);
                        }
    
                    }
                    

                }elseif ($payment_type == 'domainRegisterWithNameServer'){
                    
                    $nameserver=json_decode($trans->dns);
                    
                    DB::table('user_name_servers')
                        ->updateOrInsert(
                            ['user_id' => $user_id],
                            [
                                  "user_id" => $user_id,
                                  "server_type" => $nameserver->server_type??1,
                                  "primary_name_server" => $nameserver->primary_name_server??'',
                                  "secondary_name_server1" => $nameserver->secondary_name_server1??'',
                                  "secondary_name_server2" => $nameserver->secondary_name_server2??'',
                                  "secondary_name_server3" => $nameserver->secondary_name_server3??'',
                                  "secondary_name_server4" => $nameserver->secondary_name_server4??'',
                                  "secondary_name_server5" => $nameserver->secondary_name_server5??'',
                                  "ernet_name_server_duration_year" => $nameserver->ernet_name_server_duration_year??1,
                            ]
    
                        );
        
                    $updated_date = date('Y-m-d H:i:s');
                    $user = User::find($user_id);
                    $user->domainStatus = 3;
                    $user->updated_at = $updated_date;
                    $user->save();
    
               
                }elseif ($payment_type == 'nameServerUpdate'){
                    $nameserver1=json_decode($trans->dns);
                    
                    DB::table('user_name_servers')
                        ->updateOrInsert(
                            ['user_id' => $user_id],
                            [
                                  "user_id" => $user_id,
                                  "server_type" => $nameserver1->server_type??1,
                                  "primary_name_server" => $nameserver1->primary_name_server??'',
                                  "secondary_name_server1" => $nameserver1->secondary_name_server1??'',
                                  "secondary_name_server2" => $nameserver1->secondary_name_server2??'',
                                  "secondary_name_server3" => $nameserver1->secondary_name_server3??'',
                                  "secondary_name_server4" => $nameserver1->secondary_name_server4??'',
                                  "secondary_name_server5" => $nameserver1->secondary_name_server5??'',
                                  "ernet_name_server_duration_year" => $nameserver1->ernet_name_server_duration_year??1,
                            ]
                        );
    
                        $namserver=DB::table('user_name_servers')->where('user_id',$user_id)->first();
    
                        if($namserver!=null){
                            
                        $savedns=[
                            $namserver->primary_name_server,
                            $namserver->secondary_name_server1,
                        ];
                    
                        $paramscreate=[
                            'ns1'=>[
                                'host'=>$namserver->primary_name_server,
                                'ip4'=>$namserver->primary_name_server_ip,
                                'ip6'=>$namserver->primary_name_server_ip6,
                            ],
                            'ns2'=>[
                                'host'=>$namserver->secondary_name_server1,
                                'ip4'=>$namserver->secondary_name_server1_ip,
                                'ip6'=>$namserver->secondary_name_server1_ip6,
                            ],
                        ];
                    
                        if($namserver->secondary_name_server2!=null){
                            $paramscreate['ns3']=[
                                'host'=>$namserver->secondary_name_server2,
                                'ip4'=>$namserver->secondary_name_server2_ip,
                                'ip6'=>$namserver->secondary_name_server2_ip6,
                            ];
                            array_push($savedns,$namserver->secondary_name_server2);
                        }
                    
                        if($namserver->secondary_name_server3!=null){
                            $paramscreate['ns4']=[
                                'host'=>$namserver->secondary_name_server3,
                                'ip4'=>$namserver->secondary_name_server3_ip,
                                'ip6'=>$namserver->secondary_name_server3_ip6,
                            ];
                            array_push($savedns,$namserver->secondary_name_server3);
                        }
                    
                        if($namserver->secondary_name_server4!=null){
                            $paramscreate['ns5']=[
                                'host'=>$namserver->secondary_name_server4,
                                'ip4'=>$namserver->secondary_name_server4_ip,
                                'ip6'=>$namserver->secondary_name_server4_ip6,
                            ];
                            array_push($savedns,$namserver->secondary_name_server4);
                        }
                    
                        if($namserver->secondary_name_server5!=null){
                            $paramscreate['ns6']=[
                                'host'=>$namserver->secondary_name_server5,
                                'ip4'=>$namserver->secondary_name_server5_ip,
                                'ip6'=>$namserver->secondary_name_server5_ip6,
                            ];
                            array_push($savedns,$namserver->secondary_name_server5);
                        }
    
                    
                        $epp=new EPP();
                    
                        $user = DB::table('users')->where('id',$user_id)->first();
                    
                        $respone=$epp->domainInfo($user->domainName);
                    
                        $xml = new \SimpleXMLElement($respone);
                    
                        $xml->registerXPathNamespace('domain', 'urn:ietf:params:xml:ns:domain-1.0');
                    
                        $nameservers = $xml->xpath('//domain:hostObj');
                    
                        $remNSD = array();
                        foreach ($nameservers as $nameserver) {
                         $remNSD[] = (string) $nameserver;
                        }
                        $res=$epp->domainupdateNameServerLatest($user->domainName,$paramscreate,$savedns,$remNSD);

                       
    
                        $updated_date = date('Y-m-d H:i:s');
    
                        $status = DB::table('zones')
                        ->updateOrInsert(
                            ['user_id' => $user_id],
                            [
                                'server'=>$namserver->primary_name_server,
                                'user_id' => $user_id,
                                'domain'=>$user->domainPunycode,
                                'reverse_zone'=>1,
                                'custom_settings'=>0,
                                'refresh'=>0,
                                'retry'=>7200,
                                'expire'=>3628800,
                                'negative_ttl'=>0,
                                'default_ttl'=>345640,
                                'updated_at'=>$updated_date
                            ]
                        );
    
                        $zone=Zone::where('domain',$user->domainPunycode)->first();
           
                        
    
                    }
                 
                }elseif ($payment_type == 'userNameServerUpdate'){
                    
                    if($trans->dns!='' && $trans->dns!=null){

                        $nameserver=json_decode($trans->dns,true);
    
                        DB::table('user_name_servers')
                            ->updateOrInsert(
                            ['user_id' => $user_id],
                            $nameserver
                        );

                    }

                    $dns_record = DB::table('user_name_servers')->where('user_id','=', $user_id)->first();
    
                    $dns_id = $dns_record->id;
    
                    DB::table('dns_security-extension')->where('user_dns_server_id','=',$dns_id)->delete();
                    
                    if(Session::get('dnsse_data')!=null){
    
                        foreach (Session::get('dnsse_data') as $dnssec){
                            $dnssec['user_dns_server_id'] = $dns_id;
                            DB::table('dns_security-extension')->insert($dnssec);
                        }
    
                    }
    
                    $namserver=DB::table('user_name_servers')->where('user_id',$user_id)->first();
    
                    $savedns=[
                        $namserver->primary_name_server,
                        $namserver->secondary_name_server1,
                    ];
                
                    $paramscreate=[
                        'ns1'=>[
                            'host'=>$namserver->primary_name_server,
                            'ip4'=>$namserver->primary_name_server_ip,
                            'ip6'=>$namserver->primary_name_server_ip6,
                        ],
                        'ns2'=>[
                            'host'=>$namserver->secondary_name_server1,
                            'ip4'=>$namserver->secondary_name_server1_ip,
                            'ip6'=>$namserver->secondary_name_server1_ip6,
                        ],
                    ];
                
                    if($namserver->secondary_name_server2!=null){
                        $paramscreate['ns3']=[
                            'host'=>$namserver->secondary_name_server2,
                            'ip4'=>$namserver->secondary_name_server2_ip,
                            'ip6'=>$namserver->secondary_name_server2_ip6,
                        ];
                        array_push($savedns,$namserver->secondary_name_server2);
                    }
                
                    if($namserver->secondary_name_server3!=null){
                        $paramscreate['ns4']=[
                            'host'=>$namserver->secondary_name_server3,
                            'ip4'=>$namserver->secondary_name_server3_ip,
                            'ip6'=>$namserver->secondary_name_server3_ip6,
                        ];
                        array_push($savedns,$namserver->secondary_name_server3);
                    }
                
                    if($namserver->secondary_name_server4!=null){
                        $paramscreate['ns5']=[
                            'host'=>$namserver->secondary_name_server4,
                            'ip4'=>$namserver->secondary_name_server4_ip,
                            'ip6'=>$namserver->secondary_name_server4_ip6,
                        ];
                        array_push($savedns,$namserver->secondary_name_server4);
                    }
                
                    if($namserver->secondary_name_server5!=null){
                        $paramscreate['ns6']=[
                            'host'=>$namserver->secondary_name_server5,
                            'ip4'=>$namserver->secondary_name_server5_ip,
                            'ip6'=>$namserver->secondary_name_server5_ip6,
                        ];
                        array_push($savedns,$namserver->secondary_name_server5);
                    }
                
                    $epp=new EPP();
                
                    $user = DB::table('users')->where('id',$user_id)->first();
                
                    $respone=$epp->domainInfo($user->domainName);
                
                    $xml = new \SimpleXMLElement($respone);
    
                    $xmlElement = new \SimpleXMLElement($respone);
                    $xmlElement->registerXPathNamespace('secDNS', 'urn:ietf:params:xml:ns:secDNS-1.1');
                
                    $dsDataArray = [];
                    $dsDataElements = $xmlElement->xpath('//secDNS:dsData');
                
                    if($dsDataElements!=null){
                        foreach ($dsDataElements as $dsDataElement) {
                            $dsDataArray[] = [
                                'keyTag' => (string) $dsDataElement->children('secDNS', true)->keyTag,
                                'alg' => (string) $dsDataElement->children('secDNS', true)->alg,
                                'digestType' => (string) $dsDataElement->children('secDNS', true)->digestType,
                                'digest' => (string) $dsDataElement->children('secDNS', true)->digest
                            ];
                        }
                        $res=$epp->domainremDNSSEC($user->domainName,$dsDataArray);
                    }
                
                    $xml->registerXPathNamespace('domain', 'urn:ietf:params:xml:ns:domain-1.0');
                
                    $nameservers = $xml->xpath('//domain:hostObj');
                
                    $remNSD = array();
                    foreach ($nameservers as $nameserver) {
                     $remNSD[] = (string) $nameserver;
                    }
                
                  
                    $res=$epp->domainupdateNameServerLatest($user->domainName,$paramscreate,$savedns,$remNSD);
                    
                    $dsdtaas=DB::table('dns_security-extension')->where('user_dns_server_id',$namserver->id)->get();
    
                    $addDsData=[];
    
                    foreach ($dsdtaas as $name) {
                        if($name->key_tag!=null || $name->key_tag!=''){
                        $addDsData[] = [
                            'keyTag' => $name->key_tag,
                            'alg' => $name->algorithm,
                            'digestType' => $name->digest_type=='SHA1'?"1":'',
                            'digest' => $name->digest,
                        ];
                        }
                    }
    
                    $res=$epp->domainupdateDNSSEC($user->domainName,$addDsData);
    
                    $data['title'] = 'Name server of your domain ('.Auth::user()->domainName.') has been updated';
                    $data['email'] = Auth::user()->email;
                    $data['name'] = Auth::user()->name;
                    $data['domain'] = Auth::user()->domainName;
                    Mail::send('front.email.user-name-server-updated', $data, function($message)use($data) {
                        $message->to($data["email"], $data["name"])
                            ->subject($data["title"]);
                    });
    
                
    
                    if($dns_record->server_type==2){
    
                        $zone=Zone::where('domain',$user->domainPunycode)->first();
           
                        if($zone!=null){
                            $this->deletezone($zone);
                        }
    
                    }
    
                }elseif ($payment_type == 'domainRenewal'){
                    $updated_date = date('Y-m-d H:i:s');
                    $user = User::find($user_id);

                    $update = DB::table('user_documents')
                    ->where('user_id','=', $user_id)
                    ->update(['status'=>1]);

                    $domainPrice = $trans->total_amount;
                    $user->domainPrice = $domainPrice;
                    $user->domainStatus = 10;

                    if($user->renew_years==1){
                        $user->renew_years = $trans->period-1;
                    }else if($user->renew_years==2){
                        $user->renew_years = $trans->period-2;   
                    }else{
                        $user->renew_years = $trans->period;
                    }

                    $user->updated_at = $updated_date;
                    $user->save();
       
                    $user2 = User::find($user_id);

                    $epp=new EPP();
            
                    $expiryDate = Carbon::parse($user2->domainExpiryDate);
                    $currentDate = Carbon::now();
            
            if ($currentDate->diffInDays($expiryDate) >= 40) {
            
                $futureDate = $expiryDate->addDays(40);
            
                $orderDate = $futureDate->format('Y-m-d\TH:i:s\.0\Z');
            
                $currentDateTime = Carbon::now('Asia/Kolkata');
            
                $outputDateTime = $currentDateTime->format('Y-m-d\TH:i:s\.0\Z');
            
                $epp->domainRestoreRequest($user2->domainName);
            
                $epp->domainRestoreReport($user2->domainName,$orderDate,$outputDateTime);
            
                $epp->domainStatusUpdate($user2->domainName,'clientHold','add');

            }
                    
                    
                }else{

              
                }

            }else{

                
           
            }
           
        }else{
          
        }

        }catch(\Throwable $e){

          
        }
        
    
    }

    }
}
