<?php

namespace App\Console\Commands;

use App\Models\User;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;
use Throwable;

class DailyReport extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
    */
    protected $signature = 'domain:reportdaily';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        try {
        
            $date=date('Y-m-d');
            $totalreg=DB::table('users')->whereDate('domainCreationDate',$date)->count();
        
            $totalrenew=DB::table('domain_trails')->whereDate('created_at',$date)->count();
        
            $totalpending=DB::table('users')->whereDate('applicationDate',$date)->count();

            $totalpayment=DB::table('transactions')->whereDate('created_at',$date)->where('transaction_status','0300')->sum('total_amount');

            $status = DB::table('daily_reports')
            ->updateOrInsert(
                ['date' => $date],
                [
                    'registered' => $totalreg,
                    'renew'=>$totalrenew,
                    'pending_creation'=>$totalpending,
                    'total_payment'=>$totalpayment
                ]
            );

            
        } catch (Throwable $e) {
            Log::info($e);
        }
    }
}
