<?php

namespace App\Console\Commands;

use App\Models\User;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;
use App\Library\EPP;

class DocRejectionDelete extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'command:docRejectionDelete';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        
        $users = DB::table('users')
        ->where('document_status',1)
        ->get();

        foreach ($users as $user){
        	$data = [];
         	$data['email'] = $user->email;
            $data['name'] = $user->name;
            $data['title'] = 'Reminder for  Domain ('.$user->domainName .') . Clarification has been raised on documents.';

            $data['domain']=$user->domainName;
            
            $data['ccMails']=getCCMail($user->id);  

            $titlefromadmin=getmisc();
           
            $data['content'] = $titlefromadmin->doc_rejection_reminders;
            
        try {   

            $updatedDate = Carbon::parse($user->updated_at);
            $currentDate = Carbon::now();
            $daysDifference = $updatedDate->diffInDays($currentDate);
        

        } catch (Throwable $e) {
            Log::info($e);
        }

        }

    }
}
