<?php

namespace App\Console\Commands;

use App\Models\User;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;
use App\Library\EPP;
use Throwable;
use App\Components\MailManager;

class DomainDelete extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'command:domainDeleted';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $setting = DB::table('misc_settings')->first();

        $days=$setting->hold_domain_period+$setting->restorable_domain_period;

        $users = DB::table('users')
               ->whereDate('domainExpiryDate','=',Carbon::now()->subDays($days)->format('Y-m-d'))
               ->whereIn('domainStatus',[11,8])
               ->get();

        $data = [];

        $titlefromadmin=getmisc();

        foreach ($users as $user){
            
            $data['email'] = $user->email;
            $data['name'] = $user->name;
            $data['subject'] = 'Your Domain ('.$user->domainName .') has been Deleted';
            $data['content'] = $titlefromadmin->email_delete;

            $data['domain']=$user->domainName;

            $data['ccMails']=getCCMail($user->id);

            try {

                $view = 'front.email.domainDeleted';

                $mailer = MailManager::getInstance();
    
                $status=$mailer->mailSender($view, $data);


            } catch (Throwable $e) {

               Log::info($e);

            }

            DB::table('deleted_users')->insert([
                'name'=>$user->name,
                'father_name'=>$user->father_name,
                'age'=>$user->age,
                'domainName'=>$user->domainName,
                'domainPunycode'=>$user->domainPunycode,
                'domainLangID'=>$user->domainLangID,
                'domainExtensionID'=>$user->domainExtensionID,
                'email'=>$user->email,
                'email_verified_at'=>$user->email_verified_at,
                'institute'=>$user->institute,
                'board'=>$user->board,
                'designation'=>$user->designation,
                'domainPeriod'=>$user->domainPeriod,
                'domainPrice'=>$user->domainPrice,
                'domainStatus'=>$user->domainStatus,
                'domainCreationDate'=>$user->domainCreationDate,
                'domainExpiryDate'=>$user->domainExpiryDate,
                'renew_years'=>$user->renew_years,
                'temp_status'=>0,
                'user_id'=>$user->id,
                'status'=>0
            ]);

            $epp=new EPP();
            $res=$epp->deletedomain($user->domainName);

            DB::table('users')->where('id',$user->id)->delete();
            
        }
    }
}
