<?php

namespace App\Console\Commands;

use App\Models\User;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;
use Throwable;
use App\Components\MailManager;

class DomainHoldReminders extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'command:DomainHoldReminders';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        try {
            $users = DB::table('users')->get();
            $settings = DB::table('misc_settings')->first();
            $data = [];
            foreach ($users as $user){


                if (Carbon::parse($user->domainExpiryDate)->addDays($settings->hold_domain_reminder_period)->format('Y-m-d') == Carbon::now()->format('Y-m-d') && Carbon::parse($user->domainExpiryDate)->addDays($settings->hold_domain_period)->format('Y-m-d') > Carbon::now()->format('Y-m-d') ){
                    $data['email'] = $user->email;
                    $data['name'] = $user->name;
                    $data['subject'] = 'Reminder- Your Domain ('.$user->domainName .') is on Hold';

                    $titlefromadmin=getmisc();
           
                    $data['content'] = $titlefromadmin->domain_hold_reminders;
                    
                    $data['ccMails']=getCCMail($user->id);

                    try {

                    $view = 'front.email.domainOnHold';

                    $mailer = MailManager::getInstance();
        
                    $status=$mailer->mailSender($view, $data);

                    }catch (Throwable $e) {
                        Log::info($e);
                    }

                }
                if (Carbon::parse($user->domainExpiryDate)->addDays($settings->hold_domain_reminder_period*2)->format('Y-m-d') == Carbon::now()->format('Y-m-d') && Carbon::parse($user->domainExpiryDate)->addDays($settings->hold_domain_period)->format('Y-m-d') > Carbon::now()->format('Y-m-d') ){
                    $data['email'] = $user->email;
                    $data['name'] = $user->name;
                    $data['subject'] = 'Reminder- Your Domain ('.$user->domainName .') is on Hold';

                    
                    $titlefromadmin=getmisc();
           
                    $data['content'] = $titlefromadmin->domain_hold_reminders;
                    $data['ccMails']=getCCMail($user->id);

                    try {

                        $view = 'front.email.domainOnHold';

                        $mailer = MailManager::getInstance();
            
                        $status=$mailer->mailSender($view, $data);
    
                    }catch (Throwable $e) {
                        Log::info($e);
                    }

                }
                if (Carbon::parse($user->domainExpiryDate)->addDays($settings->hold_domain_reminder_period*3)->format('Y-m-d') == Carbon::now()->format('Y-m-d') && Carbon::parse($user->domainExpiryDate)->addDays($settings->hold_domain_period)->format('Y-m-d') > Carbon::now()->format('Y-m-d') ){
                    $data['email'] = $user->email;
                    $data['name'] = $user->name;
                    $data['subject'] = 'Reminder- Your Domain ('.$user->domainName .') is on Hold';

                    $titlefromadmin=getmisc();
           
                    $data['content'] = $titlefromadmin->domain_hold_reminders;
                    
                    $data['ccMails']=getCCMail($user->id);

                    try {

                  
                    $view = 'front.email.domainOnHold';

                    $mailer = MailManager::getInstance();
        
                    $status=$mailer->mailSender($view, $data);


                     }catch (Throwable $e) {
                         Log::info($e);
                     }

                }
                if (Carbon::parse($user->domainExpiryDate)->addDays($settings->hold_domain_reminder_period*4)->format('Y-m-d') == Carbon::now()->format('Y-m-d') && Carbon::parse($user->domainExpiryDate)->addDays($settings->hold_domain_period)->format('Y-m-d') > Carbon::now()->format('Y-m-d') ){
                    $data['email'] = $user->email;
                    $data['name'] = $user->name;
                    $data['subject'] = 'Reminder- Your Domain ('.$user->domainName .') is on Hold';
                    
                    $titlefromadmin=getmisc();
           
                    $data['ccMails']=getCCMail($user->id);

                    $data['content'] = $titlefromadmin->domain_hold_reminders;
                    
                    try {


                        $view = 'front.email.domainOnHold';

                        $mailer = MailManager::getInstance();
            
                        $status=$mailer->mailSender($view, $data);
    

                    }catch (Throwable $e) {
                        Log::info($e);
                    }

                }
            }

        } catch (Throwable $e) {
            Log::info($e);
        }
    }
}
