<?php

namespace App\Console\Commands;

use App\Models\User;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;
use Throwable;

class DomainPending extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
    */
    protected $signature = 'domain:pending';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        try {
             $times=Carbon::now()->subHours(8);

              $users = DB::table('users')
              ->where('password','=', null)
              ->where('domainStatus',0)
              ->where('created_at','<=',$times)
              ->get();
            foreach ($users as $user){
              User::destroy($user->id);
            }
            
        } catch (Throwable $e) {
            Log::info($e);
        }
    }
}
