<?php

namespace App\Console\Commands;

use App\Models\User;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Mail;
use Throwable;
use App\Components\MailManager;

class DomainStatusInfo extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'command:DomainExpire';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
            $titlefromadmin=getmisc();
            $users = DB::table('users')
            ->whereDate('domainExpiryDate','=',Carbon::now()->addDays(60)->format('Y-m-d'))
            ->get();
            $data = [];

            foreach ($users as $user){

                $data['email'] = $user->email;
                $data['name'] = $user->name;
                $data['subject'] = ' Your Domain ('.$user->domainName .') will expire after 60 days';
                $data['content'] = $titlefromadmin->email_60days;
                $data['days'] = 60;
              
                $data['expiry'] = date('d/m/Y h:i a',strtotime($user->domainExpiryDate));

                $data['ccMails']=getCCMail($user->id);

                try {

                    
                $view = 'front.email.domainExpire';

                $mailer = MailManager::getInstance();
    
                $status=$mailer->mailSender($view, $data);

                
               } catch (Throwable $e) {
                
               }

            }

            $users = DB::table('users')
            ->whereDate('domainExpiryDate','=',Carbon::now()->addDays(45)->format('Y-m-d'))
            ->get();

            $data = [];

            foreach ($users as $user){

                $data['email'] = $user->email;
                $data['name'] = $user->name;
                $data['subject'] = ' Your Domain ('.$user->domainName .') will expire after 45 days';
                $data['content'] = $titlefromadmin->email_45days;
                $data['days'] = 45;
              
                $data['expiry'] = date('d/m/Y h:i a',strtotime($user->domainExpiryDate));

                $data['ccMails']=getCCMail($user->id);

                try {
                    
                $view = 'front.email.domainExpire';

                $mailer = MailManager::getInstance();
    
                $status=$mailer->mailSender($view, $data);

                } catch (Throwable $e) {
                
               }

            }

            $users = DB::table('users')
            ->whereDate('domainExpiryDate','=',Carbon::now()->addDays(30)->format('Y-m-d'))
            ->get();

            $data = [];

            foreach ($users as $user){
                $data['email'] = $user->email;
                $data['name'] = $user->name;
                $data['subject'] = ' Your Domain ('.$user->domainName .') will expire after 30 days';
                $data['content'] = $titlefromadmin->email_30days;
                $data['days'] = 30;
              
                $data['expiry'] = date('d/m/Y h:i a',strtotime($user->domainExpiryDate));

                $data['ccMails']=getCCMail($user->id);

                try {
                    
                $view = 'front.email.domainExpire';

                $mailer = MailManager::getInstance();
    
                $status=$mailer->mailSender($view, $data);

               } catch (Throwable $e) {
                
               }

            }

            $users = DB::table('users')
            ->whereDate('domainExpiryDate','=',Carbon::now()->addDays(15)->format('Y-m-d'))
            ->get();

            $data = [];

            foreach ($users as $user){
                $data['email'] = $user->email;
                $data['name'] = $user->name;
                $data['subject'] = ' Your Domain ('.$user->domainName .') will expire after 15 days';
                $data['content'] = $titlefromadmin->email_15days;
                $data['days'] = 15;
              
                $data['ccMails']=getCCMail($user->id);

                $data['expiry'] = date('d/m/Y h:i a',strtotime($user->domainExpiryDate));

                try {
                    
                $view = 'front.email.domainExpire';

                $mailer = MailManager::getInstance();
    
                $status=$mailer->mailSender($view, $data);

                } catch (Throwable $e) {
                
                }

            }

            $users = DB::table('users')
            ->whereDate('domainExpiryDate','=',Carbon::now()->addDays(7)->format('Y-m-d'))
            ->get();

            $data = [];

            foreach ($users as $user){

                $data['email'] = $user->email;
                $data['name'] = $user->name;
                $data['subject'] = ' Your Domain ('.$user->domainName .') will expire after 7 days';
                $data['content'] = $titlefromadmin->email_7days;
                $data['days'] = 7;
                $data['expiry'] = date('d/m/Y h:i a',strtotime($user->domainExpiryDate));

                $data['ccMails']=getCCMail($user->id);

                try {

                $view = 'front.email.domainExpire';

                $mailer = MailManager::getInstance();
    
                $status=$mailer->mailSender($view, $data);

                } catch (Throwable $e) {
                
                }

            }

            $users = DB::table('users')
            ->whereDate('domainExpiryDate','=',Carbon::now()->addDays(3)->format('Y-m-d'))
            ->get();

            $titlefromadmin=getmisc();

            $data = [];
            foreach ($users as $user){
                $data['email'] = $user->email;
                $data['name'] = $user->name;
                $data['subject'] = 'Your Domain ('.$user->domainName .') will expire after 3 days';
                $data['content'] = $titlefromadmin->email_90days;
                $data['days'] = 3;
              
                $data['expiry'] = date('d/m/Y h:i a',strtotime($user->domainExpiryDate));


                $data['ccMails']=getCCMail($user->id);

                try {

                $view = 'front.email.domainExpire';

                $mailer = MailManager::getInstance();
    
                $status=$mailer->mailSender($view, $data);

                } catch (Throwable $e) {
                    
                }

            }

            $users = DB::table('users')
            ->whereDate('domainExpiryDate','=',Carbon::now()->addDays(2)->format('Y-m-d'))
            ->get();

            $titlefromadmin=getmisc();

            $data = [];
            foreach ($users as $user){
                $data['email'] = $user->email;
                $data['name'] = $user->name;
                $data['subject'] = 'Your Domain ('.$user->domainName .') will expire after 2 days';
                $data['content'] = $titlefromadmin->email_90days;
                $data['days'] = 2;
              
                $data['expiry'] = date('d/m/Y h:i a',strtotime($user->domainExpiryDate));

                $data['ccMails']=getCCMail($user->id);

                try {

                $view = 'front.email.domainExpire';
                $mailer = MailManager::getInstance();
                $status=$mailer->mailSender($view, $data);

                } catch (Throwable $e) {
                    
                }

            }

            $users = DB::table('users')
            ->whereDate('domainExpiryDate','=',Carbon::now()->addDays(1)->format('Y-m-d'))
            ->get();

            $titlefromadmin=getmisc();

            $data = [];

            foreach ($users as $user){

                $data['email'] = $user->email;
                $data['name'] = $user->name;
                $data['subject'] = 'Your Domain ('.$user->domainName .') will expire after 1 days';
                $data['content'] = $titlefromadmin->email_90days;
                $data['days'] = 1;
              
                $data['expiry'] = date('d/m/Y h:i a',strtotime($user->domainExpiryDate));

                $data['ccMails']=getCCMail($user->id);

                try {

                $view = 'front.email.domainExpire';

                $mailer = MailManager::getInstance();
    
                $status=$mailer->mailSender($view, $data);

                } catch (Throwable $e) {
                    
                }

            }

    }
}
