<?php

namespace App\Console\Commands;

use App\Models\User;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;
use App\Library\EPP;

class FinalnotSubmitted extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'delete:finalpendingapp';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {

        $users = DB::table('users')
        ->whereIn('domainStatus',[3,4])
        ->whereRaw('DATEDIFF(CURRENT_DATE, created_at) > 60')
        ->get();

        foreach ($users as $user){
        	$data = [];
         	$data['email'] = $user->email;
            $data['name'] = $user->name;
            $data['title'] = 'Your Domain ('.$user->domainName .') has been Deleted';

            $data['ccMails']=getCCMail($user->id);

            $data['content'] = 'Since you did not responded to our email and not submitted the application in timely manner. So, your domain has been deleted. Please re-apply for domain.';
            // Mail::send('front.email.finalsubmissionpending', $data, function($message)use($data) {
            //     $message->to($data["email"], $data["name"])
            //     ->cc($data["ccMails"])
            //         ->subject($data["title"]);
            // });

            // DB::table('deleted_users')->insert([
            //     'name'=>$user->name,
            //     'father_name'=>$user->father_name,
            //     'age'=>$user->age,
            //     'domainName'=>$user->domainName,
            //     'domainPunycode'=>$user->domainPunycode,
            //     'domainLangID'=>$user->domainLangID,
            //     'domainExtensionID'=>$user->domainExtensionID,
            //     'email'=>$user->email,
            //     'email_verified_at'=>$user->email_verified_at,
            //     'institute'=>$user->institute,
            //     'board'=>$user->board,
            //     'designation'=>$user->designation,
            //     'domainPeriod'=>$user->domainPeriod,
            //     'domainPrice'=>$user->domainPrice,
            //     'domainStatus'=>$user->domainStatus,
            //     'domainCreationDate'=>$user->domainCreationDate,
            //     'domainExpiryDate'=>$user->domainExpiryDate,
            //     'renew_years'=>$user->renew_years,
            //     'is_active'=>2,
            //     'user_id'=>$user->id
            // ]);
            // DB::table('users')->where('id',$user->id)->delete();
            
        }
    }
}
