<?php

namespace App\Console\Commands;

use App\Models\User;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;
use App\Library\EPP;
use Throwable;
use App\Components\MailManager;

class PendingPayment extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'command:pendingpayment';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {

        $users = DB::table('users')
        ->whereIn('users.domainStatus', [0,1,2,3,4])
        ->where('created_at', '<', Carbon::now()->subDays(14))
        ->whereIn('document_status',[0,2])
        ->get();


        foreach ($users as $user){

            $pcount=DB::table('transactions')->where('user_id',$user->id)->where('transaction_status','0300')->count();

            if($pcount==0){

              try {   
                
                $data = [];
         	      $data['email'] = $user->email;
                $data['name'] = $user->name;
                $data['subject'] = 'Your Domain ('.$user->domainName .') has been deleted';
    
                $data['ccMails']=getCCMail($user->id);

                $titlefromadmin=getmisc();
               
                $data['content'] = $titlefromadmin->delete_payment_pending;
            
              //  $view = 'front.email.finalsubmissionpending';
   
              //  $mailer = MailManager::getInstance();
   
              //  $status=$mailer->mailSender($view, $data);
   
              //  DB::table('users')->where('id',$user->id)->delete();

              } catch (Throwable $e) {
                  
              }


            }
        	

        }
        
    }
}
