<?php

namespace App\Console\Commands;

use App\Models\User;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;
use App\Library\EPP;
use Throwable;
use App\Components\MailManager;

class ReminderDoc extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'mail:reminderdocumentrejected';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {

        $users = DB::table('users')
        ->whereRaw('DATEDIFF(NOW(), created_at) % 7 = 0')
        ->whereIn('domainStatus',[4,10])
        ->where('document_status',1)
        ->get();

        foreach ($users as $user){

            
            $data = [];
         	$data['email'] = $user->email;
            $data['name'] = $user->name;
            $data['subject'] = 'Reminder for  Domain ('.$user->domainName .') . Clarification has been raised on documents.';

            $data['ccMails']=getCCMail($user->id);

            $titlefromadmin=getmisc();

            $data['content'] = $titlefromadmin->doc_rejection_reminders;

          try {               

            $view = 'front.email.finalsubmissionpending';

            $mailer = MailManager::getInstance();

            $status=$mailer->mailSender($view, $data);

          } catch (Throwable $e) {
            Log::info($e);
          }
        	

        }

    }
}
