<?php

namespace App\Console\Commands;

use App\Models\User;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;
use Throwable;
use App\Models\Zone;
use App\Services\Formatters\BINDFormatter;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Hash;
use phpseclib3\Net\SFTP;

class ZoneFileTransfer extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
    */
    protected $signature = 'pushfile:zone';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     *
     * @return int
     */

     const BASEDIR = 'probind';

     const CONFIG_BASEDIR = self::BASEDIR.DIRECTORY_SEPARATOR.'configuration';
 
     const ZONE_BASEDIR = self::BASEDIR.DIRECTORY_SEPARATOR.'primary';
 
    public function handle()
    {
        try {


            $zones = Zone::where('transfer_leave',1)
            ->get();



    foreach ($zones as $zone){

        $this->createzone($zone);

        $update=Zone::where('id',$zone->id)->update(['transfer_leave'=>2]);

    }

            Log::info('calling zoner');
        } catch (Throwable $e) {
            Log::info($e);
            return false;
        }
    }


    private function createzone(Zone $zone){

        $zone->increaseSerialNumber();
        $content = BINDFormatter::getZoneFileContent($zone);
        $path = self::ZONE_BASEDIR.DIRECTORY_SEPARATOR.$zone->domain;
        Storage::put($path, $content);

        try {
           
            $destinationFileName = $zone->domain;

            $destinationServer = '49.50.97.169';
            $destinationUsername = 'root';
            $destinationPassword = 'y1BA8=W5@eK';
            $destinationFolder = '/var/zones/primary';

            $sftp = new SFTP($destinationServer,'2232');

            if (!$sftp->login($destinationUsername, $destinationPassword)) {
                throw new \Exception('SFTP login failed');
            }

            if (!$sftp->chdir($destinationFolder)) {
                throw new \Exception('Failed to change directory on the destination server');
            }

            if ($sftp->file_exists($destinationFileName)) {
                if (!$sftp->delete($destinationFileName)) {
                    throw new \Exception('Failed to delete the existing file on the destination server');
                }
            }

            if (!$sftp->put($destinationFileName, $content)) {
                throw new \Exception('Failed to transfer the file to the destination server');
            }else{
                
            }

            $sftp->disconnect();

        } catch (\Exception $e) {

            Log::info($e);
            return false;

        }

        return true;

    }


}
