<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {
         $schedule->command('command:DomainExpire')->dailyAt('23:10');
         $schedule->command('command:domainHold')->dailyAt('23:40');
         $schedule->command('command:pendingRestoreable')->dailyAt('23:30');
         $schedule->command('command:domainTempDeleted')->dailyAt('23:20');
         $schedule->command('command:domainDeleted')->dailyAt('23:10');
         $schedule->command('command:domainindelete')->dailyAt('23:40');
         $schedule->command('command:DomainHoldReminders')->dailyAt('23:50');
         $schedule->command('command:domainTempDeleteReminders')->dailyAt('23:10');
         $schedule->command('command:OfferExpire')->dailyAt('23:00');
         $schedule->command('command:docRejectionDelete')->dailyAt('23:20');
         $schedule->command('delete:vastempletedelete')->dailyAt('23:10');
         $schedule->command('delete:reminderdoc')->dailyAt('23:00');
         $schedule->command('delete:finalpendingapp')->dailyAt('23:10');
         $schedule->command('domain:reportdaily')->dailyAt('23:50');
         $schedule->command('domain:pending')->everyMinute();
         $schedule->command('mail:reminderdocumentrejected')->dailyAt('22:10');
         //$schedule->command('command:pendingRestoreable')->everyMinute();
         $schedule->command('command:billdesksettlement')->dailyAt('15:00');
         $schedule->command('reminder:process-users')->dailyAt('17:45');
        $schedule->command('command:renewalreminder')->dailyAt('23:30');
    }

    /**
     * Register the commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        $this->load(__DIR__.'/Commands');
        require base_path('routes/console.php');
    }
}
