<?php

namespace App\Http\Controllers\Api\Admin\Master;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use DB,Validator;

class BoardController extends Controller
{
    public function BoardList(Request $request){
        $page = $request->has('page') ? $request->get('page') : 1;
        $limit = 15;
        $data = DB::table('boards')->orderBy('id')->limit($limit)->offset(($page - 1) * $limit)->get();
        $dataCount = DB::table('boards')->count();
        if($data){
            return response()->json(['status' => 'success', 'boards' => $data,'dataCount'=>$dataCount], 200);
        } else {
            return response()->json(['status' => 'success', 'boards' => []], 200);
        }
    }
    public function BoardSearch(Request $request){
        $searchTxt=$request->searchtxt;
        $data=DB::table('boards')->where('boards.description', 'LIKE', "%$searchTxt%")->get();
        if($data){
            return response()->json(['status' => 'success', 'boards' => $data], 200);
        } else {
            return response()->json(['status' => 'success', 'boards' => []], 200);
        }
    }
    public function BoardAdd(Request $request){
        if($request->isMethod('post')){
            $params = $request->all();
            $validator = Validator::make($params,[
                'description' =>'required|unique:boards,description',
				'max_affilation_no' =>'required|numeric',
            ]);
            
            if($validator->fails())
            {
                return response()->json(['status'=>'errors', 'message' => $validator->errors()]);
            }
            $description = $request->description;
            $saved=DB::table('boards')->insert([
                'description' =>$request->description,
				'max_affilation_no' =>$request->max_affilation_no
            ]);

            if($saved)
            {
                return response()->json(['status'=>"success",'message' => "Board Save successfully"], 200);
            }
            
            return response()->json(['status'=>'error', 'message' => 'Something Wrong'],404);
        }
    
        return response()->json(['status'=>'error', 'message', 'Not valid'],404);
    }
    public function BoardUpdate(Request $request)
	{
			$params = $request->all();
			$validator = Validator::make($params,[
				'description' =>'required',
				'max_affilation_no' =>'required'
			]);
			
			if($validator->fails())
			{
				return response()->json(array('status'=>'errors', 'message' => $validator->errors()));
			}
			$id = $request->id;
			$description = $request->description;
			$boards = DB::table('boards')->where('id', $id)->first();
			if (!$boards) {
                return response()->json(['status' => 'success', 'message' => 'Board not found'], 200);
            }
			$update=DB::table('boards')->where('id', $id)->update([
                'description' =>$request->description,
				'max_affilation_no' =>$request->max_affilation_no,
            ]);
			if($update){
			    return response()->json(['status' => 'success','message' => 'Board updated successfully'],200);    
			}
			//return response()->json(['status' => 'success','message' => 'Something went wrong please try again.'],404);
	}
	
    public function BoardDelete(Request $request)
	{
        $id = $request->id;
        $boards = DB::table('boards')->where('id', $id)->first();
        
        if (!$boards) {
            return response()->json(['status' => 'success', 'message' => 'Board not found'], 200);
        }else{
            $status = DB::table('boards')->where('id', $id)->delete();
            if($status){
                return response()->json(array('status'=>'success', 'message' => 'Successfully Delete.'));
            }else{
                return response()->json(array('status'=>'error', 'message' => 'Something went wrong please try again.'));
            }
        }
        return response()->json(array('status'=>'error', 'message' => 'Something went wrong please try again.'));
	}
}
