<?php

namespace App\Http\Controllers\Api\Admin\Master;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use DB,Validator;
class DocumentController extends Controller
{
    public function DocumentMasterList(Request $request){
        $page = $request->has('page') ? $request->get('page') : 1;
        $limit = 15;
        $data = DB::table('document_category')->orderBy('id')->limit($limit)->offset(($page - 1) * $limit)->get();
        $dataCount = DB::table('document_category')->count();
        if($data){
            return response()->json(['status' => 'success', 'region' => $data,'dataCount'=>$dataCount], 200);
        } else {
            return response()->json(['status' => 'success', 'region' => []], 200);
        }
    }
    public function DocumentMasterSearch(Request $request){
        $searchTxt=$request->searchtxt;
        $data=DB::table('document_category')->where('document_category.title', 'LIKE', "%$searchTxt%")->get();
        if($data){
            return response()->json(['status' => 'success', 'region' => $data], 200);
        } else {
            return response()->json(['status' => 'success', 'region' => []], 200);
        }
    }
    public function DocumentMasterAdd(Request $request){
        if($request->isMethod('post')){
            $params = $request->all();
            $messages = [
                'max' => 'Doc Name should not be greater than 100 characters.',
            ];
            $validator = Validator::make($params,[
                'description'=>'required',
                'title' =>'required|max:100',
                'size'=>'required',
                'required'=>'required'
            ], $messages);
            if($validator->fails()){
                return response()->json(array('status'=>'errors', 'message' => $validator->errors()));
            }
            $data = [
                'description'=>$request->description,
                'title' => $request->title,
                'size'=>$request->size,
                'required'=>$request->required
            ];
            //dd($request->all());
            $save=DB::table('document_category')->insert($data);
            
            if($save){
                return response()->json(['status'=>"success",'message' => "Document Master Save successfully"], 200);
            }else{
                return response()->json(array('status'=>'error', 'message' => 'Something Wrong'));
            }
            
            return response()->json(array('status'=>'error', 'message' => 'Something went Wrong'));
        }
        return redirect('home')->with('error', 'Not valid');
		
    }
    public function DocumentMasterUpdate(Request $request){
        $params = $request->all();
        $messages = [
            'max' => 'Title should not be greater than 100 characters.',
        ];
        $validator = Validator::make($params,[
            'title' =>'required|max:100',
            'size'=>'required',
            'required'=>'required'
        ], $messages);
        
        if($validator->fails())
        {
            return response()->json(array('status'=>'errors', 'message' => $validator->errors()));
        }
        $id = $request->id;
        $title = $request->title;
        $description = $request->description;
        $state = DB::table('document_category')->where('id', $id)->first();
        if (!$state) {
            return response()->json(['status' => 'success', 'message' => 'Document Master not found'], 200);
        }
        $update=DB::table('document_category')->where('id', $id)->update(['title' => $title,'description' => $description,'size'=>$request->size,'required'=>$request->required]);
        if($update){
            return response()->json(['status' => 'success','message' => 'Document Master updated successfully'],200);    
        }
    }
    public function DocumentMasterDelete(Request $request){
        $id = $request->id;
        $document = DB::table('document_category')->where('id', $id)->first();
        
        if (!$document) {
            return response()->json(['status' => 'success', 'message' => 'Document Master not found'], 200);
        }else{
            $status = DB::table('document_category')->where('id', $id)->delete();
            if($status){
                return response()->json(array('status'=>'success', 'message' => 'Successfully Delete.'));
            }else{
                return response()->json(array('status'=>'error', 'message' => 'Something went wrong please try again.'));
            }
        }
        return response()->json(array('status'=>'error', 'message' => 'Something went wrong please try again.'));
    }

}
