<?php

namespace App\Http\Controllers\Api\Admin\Master;

use App\Http\Controllers\Controller;
use DB,Validator;
use Illuminate\Http\Request;

class InstitutionController extends Controller
{
    public function instituteList(Request $request) 
	{
        $page = $request->has('page') ? $request->get('page') : 1;
        $limit = 15;
        $institute = DB::table('school_affilation')->join('boards', 'school_affilation.board', '=', 'boards.id')->select('school_affilation.*', 'boards.description as name')->limit($limit)->offset(($page - 1) * $limit)->get();
        $instituteCount = DB::table('school_affilation')->count();
        if($institute){
            return response()->json(['status' => 'success', 'institute' => $institute,'instituteCount'=>$instituteCount], 200);
        } else {
            return response()->json(['status' => 'success', 'programs' => []], 200);
        }
    }
    public function instituteAdd(Request $request)
	{
			if($request->isMethod('post'))
			{
				$params = $request->all();
				$messages = [
					'max' => 'Description should not be greater than 50 characters.',
				];
				$validator = Validator::make($params,[
					'aff_no' =>'required|max:20|unique:school_affilation,aff_no',
                    'board' =>'required',
                    'school_name'=>'required',
                    'pincode'=>'required|min:6',
                    'address'=>'required',
                    'state'=>'required'
				], $messages);
				
				if($validator->fails())
				{
					return response()->json(['status'=>'errors', 'message' => $validator->errors()]);
				}
                $boards = DB::table('boards')->where('id', $request->board)->first();
                if($boards){
                    $data = [
                        'aff_no' =>$request->aff_no,
                        'board' =>$request->board,
                        'school_name'=>$request->school_name,
                        'pincode'=>$request->pincode,
                        'address'=>$request->address,
                        'state'=>$request->state,
                    ];
                    $save=DB::table('school_affilation')->insert($data);
                    if($save){
                        return response()->json(['status'=>"success",'program' => "institute Save successfully"], 200);
                    }
                }else{
                    return response()->json(['status' => 'error', 'message' => 'board not found'], 200);
                }
				return response()->json(array('status'=>'error', 'error' => 'Something Wrong'));
			}
			return redirect('home')->with('error', 'Not valid');
	}
    public function instituteUpdate(Request $request){
			$params = $request->all();
			$messages = [
				'max' => 'User ID should not be greater than 50 characters.',
			];
			$validator = Validator::make($params,[
                    'aff_no' =>'required|max:20',
                    'board' =>'required',
                    'school_name'=>'required',
                    'pincode'=>'required|min:6',
                    'address'=>'required',
                    'state'=>'required'
			], $messages);
			
			if($validator->fails())
			{
				return response()->json(array('status'=>'errors', 'message' => $validator->errors()));
			}
            

			$institute = DB::table('school_affilation')->where('id', $id)->first();
			if (!$institute) {
                return response()->json(['status' => 'success', 'message' => 'institute not found'], 200);
            }
			$update=DB::table('school_affilation')->where('id', $id)->update([
                'aff_no' =>$request->aff_no,
                'board' =>$request->board,
                'school_name'=>$request->school_name,
                'pincode'=>$request->pincode,
                'address'=>$request->address,
                'state'=>$request->state
            ]);
			if($update){
			    return response()->json(['status' => 'success','message' => 'institute updated successfully'],200);    
			}
			return response()->json(array('status'=>'error', 'message' => 'Something went wrong please try again.'));
		
		
    }
    public function instituteDelete(Request $request){
        $id = $request->id;
        $institute = DB::table('school_affilation')->where('id', $id)->first();
        
        if (!$institute) {
            return response()->json(['status' => 'success', 'message' => 'institute not found'], 200);
        }else{
            $status = DB::table('school_affilation')->where('id', $id)->delete();
            if($status){
                return response()->json(array('status'=>'success', 'message' => 'Successfully Delete.'));
            }else{
                return response()->json(array('status'=>'error', 'message' => 'Something went wrong please try again.'));
            }
        }
        return response()->json(array('status'=>'error', 'message' => 'Something went wrong please try again.'));
    }
    public function instituteFilter(Request $request){
        $board_id = $request->board_id;
        $searchTxt = $request->searchtxt;
        $query = DB::table('school_affilation');
        if ($board_id) {
            $query->where('school_affilation.board', $board_id);
        }
        if ($searchTxt) {
            $query->where('school_affilation.school_name', 'LIKE', "%$searchTxt%");
        }
        $institute = $query->get();

        if($institute){
            return response()->json(['status' => 'success', 'institute' => $institute], 200);
        } else {
            return response()->json(['status' => 'success', 'institute' => []], 200);
        }
    }
    public function boardList(Request $request) 
	{
        $boards = DB::table('boards')->get();
        if($boards){
            return response()->json(['status' => 'success', 'boards' => $boards], 200);
        } else {
            return response()->json(['status' => 'success', 'boards' => []], 200);
        }
    }
}
