<?php

namespace App\Http\Controllers\Api\Admin\Master;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use DB,Validator;

class LanguageController extends Controller
{
    public function languageList(Request $request)
    {
        $page = $request->has('page') ? $request->get('page') : 1;
        $limit = 15;
        $languageData = DB::table('domain_languages')->limit($limit)->offset(($page - 1) * $limit)->get();
        $languageCount = DB::table('domain_languages')->count();
        if($languageData){
            return response()->json(['status' => 'success', 'language' => $languageData,'languageCount'=>$languageCount], 200);
        } else {
            return response()->json(['status' => 'success', 'language' => []], 200);
        }
    }
    public function languageSearch(Request $request){
        $searchTxt=$request->searchtxt;
        $data=DB::table('domain_languages')->where('domain_languages.language_name', 'LIKE', "%$searchTxt%")->get();
        if($data){
            return response()->json(['status' => 'success', 'language' => $data], 200);
        } else {
            return response()->json(['status' => 'success', 'language' => []], 200);
        }
    }
    public function languageAdd(Request $request){
        $message['status']='error';
        $message['message']='Invalid Request';
        if($request->isMethod('post')){
            $created_date = date('Y-m-d H:i:s');
            $saved=DB::table('domain_languages')->insert([
                'language_name'=>$request->language_name,
                'status'=>$request->status,
                'created_by'=>'super_admin',
                'created_at'=> $created_date,
            ]);
            if($saved){
                return response()->json(['status'=>"success",'message' => "Language Save successfully"], 200);
            }
            return response()->json(['status'=>'error', 'message' => 'Something Wrong'],404);
        }
        return response()->json(['status'=>'error', 'message', 'Not valid'],404);
    }

    public function languageUpdate(Request $request){
        $params = $request->all();
        $message['status']='error';
        $message['message']='Invalid Request';
        
        $domain_languages = DB::table('domain_languages')->where('id', $request->id)->first();
        if (!$domain_languages) {
            return response()->json(['status' => 'success', 'message' => 'language not found'], 200);
        }
        $created_date = date('Y-m-d H:i:s');
        $update=DB::table('domain_languages')->where('id',$request->id)->update([
            'language_name'=>$request->language_name,
              'status'=>$request->status,
              'updated_at'=> $created_date
        ]);
        if($update){
            return response()->json(['status' => 'success','message' => 'language updated successfully'],200);    
        }else{
            return response()->json(['status' => 'success', 'message' => 'Something Went Wrong Please Try again.'], 200);
        }
	}


    public function languageDelete(Request $request)
	{
        $message['status']='error';
        $message['message']='Invalid Request';
        $id = $request->id;
        $domain_languages = DB::table('domain_languages')->where('id', $id)->first();
        if (!$domain_languages) {
            return response()->json(['status' => 'success', 'message' => 'Domain language not found'], 200);
        }else{
            $status = DB::table('domain_languages')->where('id', $id)->delete();
            if($status){
                return response()->json(array('status'=>'success', 'message' => 'Successfully Delete.'));
            }else{
                return response()->json(array('status'=>'error', 'message' => 'Something went wrong please try again.'));
            }
        }
        return response()->json(array('status'=>'error', 'message' => 'Something went wrong please try again.'));
	}
    
}
