<?php

namespace App\Http\Controllers\Api\Admin;
use App\Models\News;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Offer;
use App\Models\TipOfTheDay;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Validator;
use DB;
class PageManagementController extends Controller
{
    public function adminDashboard(Request $request)
    {
        
        
        $data['title'] = 'Find Users Details';
        $data['domainStatus']=8;
        $Query = DB::table('users');
        if ($request->has('name') && ! empty($request->name))
        {
            $Query->where('users.name', 'LIKE','%'. $request->name.'%');
        }
        if ($request->has('user_name') && ! empty($request->user_name))
        {
            $Query->where('users.domainName', 'LIKE','%'. $request->user_name.'%');
        }
        if ($request->has('institute_name') && ! empty($request->institute_name))
        {
            $Query->where('users.institute', 'LIKE','%'. $request->institute_name.'%');
        }
        if ($request->has('domainLangID') && ! empty($request->domainLangID))
        {
            // $lang = DB::table('domain_languages')->where('lang_code',$request->domainLangID)->first();
            $Query->where('users.domainLangID',  $request->domainLangID);
        }
        if ($request->has('status') && ! empty($request->status))
        {
            $Query->where('users.status', $request->status);
        }
        if ($request->has('lang') && ! empty($request->lang))
        {
            $lang = DB::table('domain_languages')->where('lang_code',$request->lang)->first();
            $Query->where('users.domainLangID', $lang->id);
        }
        if ($request->has('domainStatus') && ! empty($request->domainStatus))
        {
            if ($request->domainStatus == 2){
                $Query->whereIn('users.domainStatus', [0,1,2,3,4]);
                $Query->where('users.clarify',0);
            }else
            if ($request->domainStatus == 6){
                $Query->whereIn('users.domainStatus', [6,10]);
            }else{
                $Query->where('users.domainStatus', $request->domainStatus);
            }
            $data['domainStatus']=$request->domainStatus;
        }

        if ($request->creation_start_date != '' && $request->creation_end_date != '')
        {
            $start_date = Carbon::parse($request->creation_start_date);
            $end_date = Carbon::parse($request->creation_end_date);
            $Query->whereBetween('users.created_at', [$start_date->format('Y-m-d')." 00:00:00", $end_date->format('Y-m-d')." 23:59:59"]);
        }
        $data['creation_start_date']=$request->creation_start_date;
        $data['creation_end_date']=$request->creation_end_date;

        if ($request->expiry_start_date != '' && $request->expiry_end_date != '')
        {
            $start_date = Carbon::parse($request->expiry_start_date);
            $end_date = Carbon::parse($request->expiry_end_date);
            $Query->whereBetween('users.domainExpiryDate', [$start_date->format('Y-m-d')." 00:00:00", $end_date->format('Y-m-d')." 23:59:59"]);
        }
        $data['expiry_start_date']=$request->expiry_start_date;
        $data['expiry_end_date']=$request->expiry_end_date;

        $pagetext='Users Details List';

        if ($request->has('domaintext') && ! empty($request->domaintext))
        {
            $pagetext=$request->domaintext;
        }

        if ($request->has('domaintext') && $request->domaintext == 'Rejected')
        {
            $data['domaintext']='Rejected';
        }

        if ($request->has('domaintext') && $request->domaintext == 'No Zone Record')
        {
            $pagetext='Ernet Pending DNS Updation';
            $Query->where('users.zone_file',0)
            ->where('user_name_servers.server_type',1)->join('user_name_servers','user_name_servers.user_id','users.id');
        }

        if ($request->has('domaintext') && $request->domaintext == 'Active ERNET DNS')
        {
            $pagetext='Active ERNET DNS';
            $Query->where('user_name_servers.server_type',1)->join('user_name_servers','user_name_servers.user_id','users.id');
        }

        $Query->orderBy('users.id','desc');

        $data['domaintext']=$pagetext;

        $users = $Query->get();

        foreach ($users as $user){
            $userdocuments = DB::table('user_documents')->select('user_documents.*','document_category.title')->where('user_id',$user->id)->join('document_category','document_category.id','=','user_documents.document_category_id')->get();
            $user->is_doc_approved = 3;
            $user->pending_doc = 0;
            foreach ($userdocuments as $doc){
                if ($doc->status == 0){
                    $user->is_doc_approved = 0;
                    $user->pending_doc  = DB::table('user_documents')->where('user_id',$user->id)->where('status','=', 0)->count();
                     break;
                }elseif ($doc->status == 1){
                    $user->is_doc_approved = 1;
                     break;
                }else{
                    $user->is_doc_approved = 2;
                }
            }
        }

        $data['users_data']=$users;
        if($data){
            return response()->json(['status' => 'success', 'data' => $data], 200);
        } else {
            return response()->json(['status' => 'success', 'data' => []], 200);
        }
    }
    public function NewsSectionView(Request $request){
        $page = $request->has('page') ? $request->get('page') : 1;
        $limit = 15;
        $data = DB::table('news')->orderBy('id')->limit($limit)->offset(($page - 1) * $limit)->get();
        $dataCount = DB::table('news')->count();
        if($data){
            return response()->json(['status' => 'success', 'news' => $data,'dataCount'=>$dataCount], 200);
        } else {
            return response()->json(['status' => 'success', 'news' => []], 200);
        }
    }
    public function addNewsSection(Request $request){
        if($request->isMethod('post')){
            $params = $request->all();
            $messages = [
                'max' => 'Description should not be greater than 50 characters.',
            ];
            $validator = Validator::make($params,[
                'description' => 'required|max:255',
                'link' => 'required|mimes:pdf',//|max:2048',
            ], $messages);
            
            if($validator->fails())
            {
                return response()->json(['status'=>'errors', 'message' => $validator->errors()]);
            }
            
            $news = new News();
            $news->description = $request->input('description');
            if ($request->hasFile('link')) {
                $file = $request->file('link');
                $fileName = time() . '.' . $file->getClientOriginalExtension();
                $file->move(public_path('front/assets/news_pdf'), $fileName);
                $news->link = $fileName;
            }
            $news->status = '1';
            if ($news->save()) {
                return response()->json(['status'=>"success",'message' => "News Added successfully"], 200);
            } else {
                return response()->json(['status'=>"success",'message' => "Something went wrong. Please try again."], 200);
            }
        }
        return response()->json(['status'=>'error', 'error', 'Not valid'],404);
    }
    public function ChangeNewsStatus(Request $request){
        $message = [
            'status' => 'error',
            'message' => 'Invalid Request'
        ];
        
            $newsId = $request->input('newsId');
            $status = $request->input('status');
            
            $news = News::find($newsId);
        
            
            if ($news) {
                $news->status = $status;
                if ($news->save()) {
                    return response()->json(['status'=>"success",'message' => "Status updated successfully"], 200);
                } else {
                    return response()->json(['status'=>"success",'message' => "Something went wrong. Please try again."], 200);
                }
            }else{
                return response()->json(['status'=>"success",'message' => "News item not found."], 200);
            }
        
        return response()->json($message);
    }
    public function DeleteNews(Request $request){
        
            $newsId = $request->input('newsId');
            // Find the news item
            $news = News::find($newsId);
           
            if ($news) {
                $destinationPath = public_path('front/assets/news_pdf');
                if ($news->link) {
                    File::delete($destinationPath . '/' . $news->link);
                }
                $deleted=$news->delete();
                // Delete the news item
                if ($deleted) {
                    return response()->json(['status'=>'success', 'message' => 'Successfully Delete.'],200);
                } else {
                    return response()->json(['status'=>'success', 'message' => 'Something went wrong please try again.'],200);
                }
            } else {
                return response()->json(['status'=>'success', 'message' => 'News item not found.'],200);
            }
        return response()->json($message);
    }


    public function updateNewsSection(Request $request){
        $params = $request->all();
        $messages = [
            'max' => 'Description should not be greater than 50 characters.',
        ];
        $validator = Validator::make($params,[
            'description' =>'required|max:50',
        ], $messages);
        
        if($validator->fails())
        {
            return response()->json(array('status'=>'errors', 'message' => $validator->errors()));
        }
        $newsId = $request->input('newsId');
        $description = $request->input('description');
        $news = News::find($newsId);
         
        if (!$news) {
            return response()->json(['status' => 'success', 'message' => 'News not found'], 200);
        }
        $link = $request->input('link');
        if ($request->hasFile('link')) {
            $uploadedFile = $request->file('link');
            $fileName = time() . '.' . $uploadedFile->getClientOriginalExtension();
            $destinationPath = public_path('front/assets/news_pdf');
            if ($news->link) {
                File::delete($destinationPath . '/' . $news->link);
            }
            $uploadedFile->move($destinationPath, $fileName);
        }else {
            $fileName = $news->link;
        }
        if($news){
            $news->description = $description;
            $news->link = $fileName;
            $update=$news->save();
            if($update){
			    return response()->json(['status' => 'success','message' => 'News item updated successfully'],200);    
			}else{
                return response()->json(['status'=>'success', 'message' => 'Something went wrong please try again.'],200);
            }
        }else{
            return response()->json(['status'=>'success', 'message' => 'Something went wrong please try again.'],200);
        }
        
    }
    
    
    //Home page Offer section controller Api
    public function OfferSectionView(Request $request){
        $page = $request->has('page') ? $request->get('page') : 1;
        $limit = 15;
        $data = DB::table('offers')->orderBy('id')->limit($limit)->offset(($page - 1) * $limit)->get();
        $dataCount = DB::table('offers')->count();
        if($data){
            return response()->json(['status' => 'success', 'offers' => $data,'dataCount'=>$dataCount], 200);
        } else {
            return response()->json(['status' => 'success', 'offers' => []], 200);
        }
    }
    public function AddOfferSection(Request $request){
        if($request->isMethod('post')){
            $params = $request->all();
            $messages = [
                'max' => 'Description should not be greater than 50 characters.',
            ];
            $validator = Validator::make($params,[
                'title' => 'required|max:255',
                'description' => 'required|max:255',
                'discount' => 'required|numeric',
                'exp_date' => 'required|date',
            ], $messages);
            
            if($validator->fails())
            {
                return response()->json(['status'=>'errors', 'message' => $validator->errors()]);
            }
            $description = $request->description;
            $saved=DB::table('offers')->insert([
                'title' => $request->input('title'),
                'description' => $request->input('description'),
                'discount' => $request->input('discount'),
                'exp_date' => $request->input('exp_date'),
                'status' => '1',
            ]);

            if($saved)
            {
                return response()->json(['status'=>"success",'message' => "Offer Save successfully"], 200);
            }
            
            return response()->json(['status'=>'error', 'message' => 'Something Wrong'],200);
        }
        return response()->json(['status'=>'error', 'message' => 'Something Wrong'],200);
    }
    
    public function ChangeOfferStatus(Request $request){
        $message = [
            'status' => 'error',
            'message' => 'Invalid Request'
        ];
            $offerId = $request->input('offerId');
            $status = $request->input('status');
            $offer = Offer::find($offerId);
            if ($offer) {
                $offer->status = $status;
                if ($offer->save()) {
                     return response()->json(['status'=>"success",'message' => "Status updated successfully"], 200);
                } else {
                    return response()->json(['status'=>"success",'message' => "Something went wrong. Please try again."], 200);
                }
            }else{
                return response()->json(['status'=>"success",'message' => "Offer not found."], 200);
            }
        
        return response()->json($message);
    }
    
    public function deleteOffer(Request $request){
        $message = [
            'status' => 'error',
            'message' => 'Failed to delete the news item.'
        ];
            $offerId = $request->input('offerId');
            $offer = Offer::find($offerId);
            if ($offer) {
                if ($offer->delete()) {
                    return response()->json(['status'=>'success', 'message' => 'Successfully Delete.'],200);
                } else {
                    return response()->json(['status'=>'success', 'message' => 'Something went wrong please try again.'],200);
                }
            } else {
                return response()->json(['status'=>'success', 'message' => 'Offer item not found.'],200);
            }
        return response()->json($message);
    }
    
    
    public function updateOfferSection(Request $request){
        $params = $request->all();
		$messages = [
			'max' => 'Description should not be greater than 50 characters.',
		];
		$validator = Validator::make($params,[
			'title' => 'required|max:255',
            'description' => 'required|max:255',
            'discount' => 'required|numeric',
            'exp_date' => 'required|date',
		], $messages);
		
		if($validator->fails())
		{
			return response()->json(array('status'=>'errors', 'message' => $validator->errors()));
		}
	    $id = $request->input('offerId');
        $title = $request->input('title');
        $discount = $request->input('discount');
        $description = $request->input('description');
        $exp_date = $request->input('exp_date');
		$offers = DB::table('offers')->where('id', $id)->first();
		if (!$offers) {
            return response()->json(['status' => 'success', 'message' => 'offer not found'], 200);
        }
		$update=DB::table('offers')->where('id', $id)->update([
		    'title' => $title,
		    'discount' => $discount,
		    'description' => $description,
		    'exp_date' => $exp_date,
		    
		    ]);
		if($update){
		    return response()->json(['status' => 'success','message' => 'Offer updated successfully'],200);    
		}else{
		    return response()->json(['status' => 'success','message' => 'Something went wrong please try again.'],200);
		}
        return response()->json($message);
    }
    
    
    //Home page Tip of the day section controller Api
    
    public function TodSectionView(){
        $data = DB::table('tip_of_the_days')->first();
        if($data){
            return response()->json(['status' => 'success', 'offers' => $data], 200);
        } else {
            return response()->json(['status' => 'success', 'offers' => []], 200);
        }
    }
    
    public function changeTodStatus(Request $request){
        $message = [
            'status' => 'error',
            'message' => 'Invalid Request'
        ];
            $todId = $request->input('todId');
            $status = $request->input('status');
            $tod = TipOfTheDay::find($todId);
            if ($tod) {
                $tod->status = $status;
                if ($tod->save()) {
                     return response()->json(['status'=>"success",'message' => "Status updated successfully"], 200);
                } else {
                    return response()->json(['status'=>"success",'message' => "Something went wrong. Please try again."], 200);
                }
            }else{
                return response()->json(['status'=>"success",'message' => "Offer not found."], 200);
            }
        
        return response()->json($message);
    }
    
    public function updateTodSection(Request $request){
        $params = $request->all();
        $messages = [
            'max' => 'Description should not be greater than 50 characters.',
        ];
        $validator = Validator::make($params,[
            'title' => 'required|max:255',
            'description' => 'required|max:255',
        ], $messages);
        
        if($validator->fails())
        {
            return response()->json(array('status'=>'errors', 'message' => $validator->errors()));
        }
        $todId = $request->input('todId');
        $description = $request->input('description');
        $title = $request->input('title');
        $tod = TipOfTheDay::find($todId);
       
        if (!$tod) {
            return response()->json(['status' => 'success', 'message' => 'Tip Of The Day not found'], 200);
        }
        $image = $request->input('image');
        if ($request->hasFile('image')) {
            $uploadedFile = $request->file('image');
            $fileName = time() . '.' . $uploadedFile->getClientOriginalExtension();
            $destinationPath = public_path('front/assets/img');
            if ($tod->image) {
                File::delete($destinationPath . '/' . $tod->image);
            }
            $uploadedFile->move($destinationPath, $fileName);
        }else {
            $fileName = $tod->image;
        }
        $tod->image =$fileName;
        $tod->description=$description;
        $tod->title=$title; 
        $update=$tod->save();
        
        if($update){
		    return response()->json(['status' => 'success','message' => 'News item updated successfully'],200);    
		}else{
            return response()->json(['status'=>'success', 'message' => 'Something went wrong please try again.'],200);
        }

    }
}
