<?php

namespace App\Http\Controllers\Api\Admin\Master;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Admin;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use DB,Validator;
use Firebase\JWT\JWT;
use Config;
use \Firebase\JWT\Key;
use App\Library\EPP;
use Carbon\Carbon;
use App\Models\User;

class PassportAuthController extends Controller
{


    public function domainrestore(Request $request,$id){

        $user=User::find($request->id);
       
        $epp=new EPP();

        $expiryDate = Carbon::parse($user->domainExpiryDate);
        $currentDate = Carbon::now();

// if ($currentDate->diffInDays($expiryDate) >= 40) {

    $futureDate = $expiryDate->addDays(0);

    $orderDate = $futureDate->format('Y-m-d\TH:i:s\.0\Z');

    $currentDateTime = Carbon::now('Asia/Kolkata');

    $outputDateTime = $currentDateTime->format('Y-m-d\TH:i:s\.0\Z');

    $res=$epp->domainRestoreRequest($user->domainName);

    dd($res);
    

    // $epp->domainRestoreReport($user->domainName,$orderDate,$outputDateTime);

    // $epp->domainStatusUpdate($user->domainName,'clientHold','add');

// }


    }

    public function hold(Request $request,$id){

        
        $epp=new EPP();

        $epp->domainStatusUpdate($id,'clientHold','add');
        
        dd($res);

    }

    

    public function domainRestoreReport(Request $request,$id){

        
        $user=DB::table('users')->select('domainExpiryDate')->where('domainName',$id)->first();

        // $timestamp = new DateTime($user->domainExpiryDate, new DateTimeZone('UTC'));

        // $formattedTimestamp = $timestamp->format('Y-m-d\TH:i:s\.0\Z');
        // $orderDate = date('Y-m-d\TH:i:sP'); 

        $orderDate = Carbon::parse($user->domainExpiryDate);

        $futureDate = $orderDate->addDays(40);


        $outputDateTime = $futureDate->format('Y-m-d\TH:i:s\.0\Z');

        // $currentDateTime = Carbon::now('Asia/Kolkata');

        // $outputDateTime = $currentDateTime->format('Y-m-d\TH:i:s\.0\Z');
        dd($outputDateTime);
        // $epp=new EPP();

        // $res=$epp->domainRestoreReport($id);

        dd($user);

    }

    public function skipdns(Request $request,$id){

        DB::table('user_name_servers')->insert([
            'skip_status' => '1',
            'user_id'=>$id,
            'primary_name_server'=>'ns1.ernet.in'
         ]);

         dd('done');

    }
    

    
    
    public function billdeskresponse(Request $request){

        $secretKey = Config::get('custom-billdesk.secretkey');

        $response = $request->transaction_response;
        \Log::info('webhook calllsdf');
        \Log::info($request->all());

        $result=$response;

        $decodedresponse = JWT::decode($result, new Key($secretKey, 'HS256'));
        
        if ($decodedresponse->auth_status=='0300'){

            DB::table('billdesk_report')->insert(
                [
                    'transaction_id'=>$decodedresponse->transactionid,
                    'response'=>json_encode($decodedresponse),
                    'reference_id'=>$decodedresponse->orderid
                ]
            );
            
            return response()->json(['status' => true, 'message' =>'Payment Received' ], 200);

        }

        Log::info('webhook billdesk responsing');

        return response()->json(['status' => false, 'message' =>'Payment not Successfull' ], 200);

    }

    public function login(Request $request)
    {

        $data = [
            'username' => $request->username,
            'password' => $request->password,
            'device_token'=>$request->token,
        ];
        
        if (auth()->guard('admin')->attempt(['username'=>$request->username, 'password' =>$request->password])) {
            $user = auth()->guard('admin')->user();
            
            $count = DB::table('oauth_access_tokens')->where('user_id', $user->id)->count();
			if($count > 0) {
				DB::table('oauth_access_tokens')->where('user_id', $user->id)->delete();
			}
            $token = auth()->guard('admin')->user()->createToken('Laravel8PassportAuth')->accessToken;
            $userdb=DB::table('admins')->where('id', $user->id)->update(['device_token' => $request->token]);
            $res=DB::table('admins')->where('id', $user->id)->get();
            \Log::info($res);
            return response()->json(['token' => $token,'user' => $user], 200);
        } else {
            //dd("not done");
            return response()->json(['error' => 'hello'], 401);
        }
    }
 
    public function userInfo(){
        $user = auth()->user();
        return response()->json(['user' => $user], 200);
    }
    public function AdminLogout(Request $request) {
        
		$user = auth()->user();
        DB::table('admins')->where('id', $user->id)->update(['device_token' => null]);
		$accessToken = $user->token();
        $accessToken->revoke();
        DB::table('oauth_access_tokens')->where('user_id', $user->id)->delete();
        return response()->json(array('status' => true, 'message' => 'successfully logout'), 200);
    }
    
}
