<?php

namespace App\Http\Controllers\Api\Admin\Master;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use DB,Validator;
class PaymentGatewaySettingController extends Controller
{
     public function PaymentGatewayList(Request $request){
        $page = $request->has('page') ? $request->get('page') : 1;
        $limit = 15;
        $data = DB::table('payment_gateway_setting')->orderBy('id')->limit($limit)->offset(($page - 1) * $limit)->get();
        $dataCount = DB::table('payment_gateway_setting')->count();
        if($data){
            return response()->json(['status' => 'success', 'PaymentGateway' => $data,'dataCount'=>$dataCount], 200);
        } else {
            return response()->json(['status' => 'success', 'PaymentGateway' => []], 200);
        }
     }
     public function PaymentGatewaySearch(Request $request){
        $searchTxt=$request->searchtxt;
        $data=DB::table('payment_gateway_setting')->where('payment_gateway_setting.payment_gateway', 'LIKE', "%$searchTxt%")->get();
        if($data){
            return response()->json(['status' => 'success', 'PaymentGateway' => $data], 200);
        } else {
            return response()->json(['status' => 'success', 'PaymentGateway' => []], 200);
        }
    }
     public function PaymentGatewayAdd(Request $request){
        if($request->isMethod('post')){
            $params = $request->all();
            $validator = Validator::make($params,[
                'payment_gateway' =>'required',
                'transaction_url' =>'required',
                'merchant_id' =>'required',
                'security_id' =>'required',
                'checksum_key' =>'required',
            ]);
            if($validator->fails()){
                return response()->json(array('status'=>'errors', 'message' => $validator->errors()));
            }
            $saved=DB::table('payment_gateway_setting')->insert([
                'payment_gateway' => $request->payment_gateway,
                'transaction_url' => $request->transaction_url,
                'merchant_id' => $request->merchant_id,
                'security_id' => $request->security_id,
                'checksum_key' => $request->checksum_key
            ]);
            if($saved){
                return response()->json(['status'=>"success",'message' => "Payment Gateway Save successfully"], 200);
            }
            return response()->json(['status'=>'error', 'message' => 'Something Wrong'],200);
        }
        return response()->json(['status'=>'error', 'message', 'Not valid'],200);
     }
     public function PaymentGatewayUpdate(Request $request){
			$params = $request->all();
			$validator = Validator::make($params,[
                'payment_gateway' =>'required',
				'transaction_url' =>'required',
                'merchant_id' =>'required',
                'security_id' =>'required',
                'checksum_key' =>'required',
			]);
			if($validator->fails()){
				return response()->json(array('status'=>'errors', 'message' => $validator->errors()));
			}
                $data = DB::table('payment_gateway_setting')->where('id', $request->id)->first();
                if (!$data) {
                    return response()->json(['status' => 'success', 'message' => 'Payment Gateway not found'], 200);
                }
                $update=DB::table('payment_gateway_setting')->where('id', $request->id)->update([
                    'payment_gateway' =>$request->payment_gateway,
                    'transaction_url' =>$request->transaction_url,
                    'merchant_id' =>$request->merchant_id,
                    'security_id' =>$request->security_id,
                    'checksum_key' =>$request->checksum_key
                ]);
                if($update){
                    return response()->json(['status' => 'success','message' => 'Payment Gateway updated successfully'],200);    
                }else{
                    return response()->json(array('status'=>'error', 'message' => 'Something went wrong please try again.'));
                }
			return response()->json(array('status'=>'error', 'message' => 'Something went wrong please try again.'));
     }
    public function PaymentGatewayDelete(Request $request){
        $id = $request->id;
        $data = DB::table('payment_gateway_setting')->where('id', $id)->first();
        if (!$data) {
            return response()->json(['status' => 'success', 'message' => 'Payment Gateway not found'], 200);
        }else{
            $status = DB::table('payment_gateway_setting')->where('id', $id)->delete();
            if($status){
                return response()->json(array('status'=>'success', 'message' => 'Successfully Delete.'));
            }else{
                return response()->json(array('status'=>'error', 'message' => 'Something went wrong please try again.'));
            }
        }
        return response()->json(array('status'=>'error', 'message' => 'Something went wrong please try again.'));
     }
}
