<?php

namespace App\Http\Controllers\Billdesk;

use App\Http\Controllers\Controller as BaseController;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Session;
use JagdishJP\Billdesk\Http\Requests\AuthorizationConfirmation as Request;
use JagdishJP\Billdesk\Models\Transaction;
use App\Library\EPP;
use App\Models\Zone;
use App\Services\Formatters\BINDFormatter;
use Illuminate\Support\Facades\Storage;
use phpseclib3\Net\SFTP;
use Throwable;

class Controller extends BaseController
{
    /**
     * @param Request $request
     *
     * @return Response
     */

     const BASEDIR = 'probind';

     const CONFIG_BASEDIR = self::BASEDIR.DIRECTORY_SEPARATOR.'configuration';
 
     const ZONE_BASEDIR = self::BASEDIR.DIRECTORY_SEPARATOR.'primary';
 
    public function callback(Request $request)
    {

        $response = $request->handle();

        $payment_type = Session::get('payment_type');

        Log::info($response);

    
        if ($response['response_format'] == 'JSON') {
            return response()->json(['response' => $response, 'billdesk_response' => $request->all()]);
        }
        // Update your order status
        if ($response['status'] == 'succeeded'){
            $user_id = Auth::id();
            $payment_type = Session::get('payment_type');

            DB::table('transactions')->where('transaction_id','=',$response['transaction_id'])->update(
                [
                    'user_id'=>$user_id,
                    'transaction_type'=>$payment_type['transaction_type'],
                    'discountper'=>$payment_type['discountper'] ?? 0,
                    'discountamt'=>$payment_type['discountamt'] ?? 0,
                    'domain_amount'=>$payment_type['domain_amount'] ?? 0,
                    'late_charges'=>$payment_type['late_charges'] ?? 0,
                ]
            );

            if ($payment_type['transaction_type'] == 'domainRegister'){
                //update user status
                $updated_date = date('Y-m-d H:i:s');
                $user = User::find($user_id);
                $user->domainStatus = 3;
                $user->updated_at = $updated_date;
                $user->save();
                Session::flash('message', 'The Payment is Successfully done.');
                Session::flash('alert-class', 'alert-success');
                Session::forget('payment_type');
                return redirect('upload-documents');
            }elseif ($payment_type['transaction_type'] == 'domainRegisterWithNameServer'){
                DB::table('user_name_servers')
                    ->updateOrInsert(
                        ['user_id' => $user_id],
                        [
                            "user_id" => $user_id,
                              "server_type" => Session::get('data')['server_type'],
                              "primary_name_server" => Session::get('data')['primary_name_server'],
                              "secondary_name_server1" => Session::get('data')['secondary_name_server1'],
                              "secondary_name_server2" => Session::get('data')['secondary_name_server2'],
                              "secondary_name_server3" => Session::get('data')['secondary_name_server3'],
                              "secondary_name_server4" => Session::get('data')['secondary_name_server4'],
                              "secondary_name_server5" => Session::get('data')['secondary_name_server5'],
                              "ernet_name_server_duration_year" => Session::get('data')['ernet_name_server_duration_year'],
                        ]

                    );


                //update user status
                $updated_date = date('Y-m-d H:i:s');
                $user = User::find($user_id);
                $user->domainStatus = 3;
                $user->updated_at = $updated_date;
                $user->save();

                Session::forget('payment_type');
                Session::forget('data');
                Session::flash('message', 'The Payment is Successfully done.');
                Session::flash('alert-class', 'alert-success');
                return redirect('user-dashboard');
            }elseif ($payment_type['transaction_type'] == 'nameServerUpdate'){
                DB::table('user_name_servers')
                    ->updateOrInsert(
                        ['user_id' => $user_id],
                        [
                            "user_id" => $user_id,
                            "server_type" => Session::get('data')['server_type'],
                            "primary_name_server" => Session::get('data')['primary_name_server'],
                            "secondary_name_server1" => Session::get('data')['secondary_name_server1'],
                            "secondary_name_server2" => Session::get('data')['secondary_name_server2'],
                            "secondary_name_server3" => Session::get('data')['secondary_name_server3'],
                            "secondary_name_server4" => Session::get('data')['secondary_name_server4'],
                            "secondary_name_server5" => Session::get('data')['secondary_name_server5'],
                            "ernet_name_server_duration_year" => Session::get('data')['ernet_name_server_duration_year'],
                        ]

                    );

                    $namserver=DB::table('user_name_servers')->where('user_id',$user_id)->first();

                    if($namserver!=null){
                        
                    $savedns=[
                        $namserver->primary_name_server,
                        $namserver->secondary_name_server1,
                    ];
                
                    $paramscreate=[
                        'ns1'=>[
                            'host'=>$namserver->primary_name_server,
                            'ip4'=>$namserver->primary_name_server_ip,
                            'ip6'=>$namserver->primary_name_server_ip6,
                        ],
                        'ns2'=>[
                            'host'=>$namserver->secondary_name_server1,
                            'ip4'=>$namserver->secondary_name_server1_ip,
                            'ip6'=>$namserver->secondary_name_server1_ip6,
                        ],
                    ];
                
                    if($namserver->secondary_name_server2!=null){
                        $paramscreate['ns3']=[
                            'host'=>$namserver->secondary_name_server2,
                            'ip4'=>$namserver->secondary_name_server2_ip,
                            'ip6'=>$namserver->secondary_name_server2_ip6,
                        ];
                        array_push($savedns,$namserver->secondary_name_server2);
                    }
                
                    if($namserver->secondary_name_server3!=null){
                        $paramscreate['ns4']=[
                            'host'=>$namserver->secondary_name_server3,
                            'ip4'=>$namserver->secondary_name_server3_ip,
                            'ip6'=>$namserver->secondary_name_server3_ip6,
                        ];
                        array_push($savedns,$namserver->secondary_name_server3);
                    }
                
                    if($namserver->secondary_name_server4!=null){
                        $paramscreate['ns5']=[
                            'host'=>$namserver->secondary_name_server4,
                            'ip4'=>$namserver->secondary_name_server4_ip,
                            'ip6'=>$namserver->secondary_name_server4_ip6,
                        ];
                        array_push($savedns,$namserver->secondary_name_server4);
                    }
                
                    if($namserver->secondary_name_server5!=null){
                        $paramscreate['ns6']=[
                            'host'=>$namserver->secondary_name_server5,
                            'ip4'=>$namserver->secondary_name_server5_ip,
                            'ip6'=>$namserver->secondary_name_server5_ip6,
                        ];
                        array_push($savedns,$namserver->secondary_name_server5);
                    }

                    $user = Auth::user();

                    if($user->domainStatus>5){
                
                    $epp=new EPP();
                
                    #$user = Auth::user();
                
                    $respone=$epp->domainInfo($user->domainName);
                
                    $xml = new \SimpleXMLElement($respone);
                
                    $xml->registerXPathNamespace('domain', 'urn:ietf:params:xml:ns:domain-1.0');
                
                    $nameservers = $xml->xpath('//domain:hostObj');
                
                    $remNSD = array();
                    foreach ($nameservers as $nameserver) {
                     $remNSD[] = (string) $nameserver;
                    }
                
                    $remNS = array_diff($remNSD, $savedns);
                    $saveNS = array_diff($savedns, $remNSD);
                
                    $res=$epp->domainupdateNameServer($user->domainName,$paramscreate,$saveNS,$remNS);

                    }
            
                    if($user->domainStatus>5){

                    $updated_date = date('Y-m-d H:i:s');

                    $status = DB::table('zones')
                    ->updateOrInsert(
                        ['user_id' => $user_id],
                        [
                            'server'=>$namserver->primary_name_server,
                            'user_id' => $user_id,
                            'domain'=>$user->domainPunycode,
                            'reverse_zone'=>1,
                            'custom_settings'=>0,
                            'refresh'=>0,
                            'retry'=>7200,
                            'expire'=>3628800,
                            'negative_ttl'=>0,
                            'default_ttl'=>0,
                            'updated_at'=>$updated_date
                        ]
                    );

                    $zone=Zone::where('domain',$user->domainPunycode)->first();
       
                    $this->createzone($zone);

                    }

                }
                Session::forget('payment_type');
                Session::forget('data');
                Session::flash('message', 'The Payment is Successfully done.');
                Session::flash('alert-class', 'alert-success');
                return redirect('user-dashboard');
            }elseif ($payment_type['transaction_type'] == 'userNameServerUpdate'){
                DB::table('user_name_servers')
                    ->updateOrInsert(
                        ['user_id' => $user_id],
                        Session::get('data')
                    );
                $dns_id = DB::table('user_name_servers')->where('user_id','=', $user_id)->first()->id;
                DB::table('dns_security-extension')->where('user_dns_server_id','=',$dns_id)->delete();
                
                if(Session::get('dnsse_data')!=null){

                    foreach (Session::get('dnsse_data') as $dnssec){
                        $dnssec['user_dns_server_id'] = $dns_id;
                        DB::table('dns_security-extension')->insert($dnssec);
                    }

                }

                $namserver=DB::table('user_name_servers')->where('user_id',$user_id)->first();

                $savedns=[
                    $namserver->primary_name_server,
                    $namserver->secondary_name_server1,
                ];
            
                $paramscreate=[
                    'ns1'=>[
                        'host'=>$namserver->primary_name_server,
                        'ip4'=>$namserver->primary_name_server_ip,
                        'ip6'=>$namserver->primary_name_server_ip6,
                    ],
                    'ns2'=>[
                        'host'=>$namserver->secondary_name_server1,
                        'ip4'=>$namserver->secondary_name_server1_ip,
                        'ip6'=>$namserver->secondary_name_server1_ip6,
                    ],
                ];
            
                if($namserver->secondary_name_server2!=null){
                    $paramscreate['ns3']=[
                        'host'=>$namserver->secondary_name_server2,
                        'ip4'=>$namserver->secondary_name_server2_ip,
                        'ip6'=>$namserver->secondary_name_server2_ip6,
                    ];
                    array_push($savedns,$namserver->secondary_name_server2);
                }
            
                if($namserver->secondary_name_server3!=null){
                    $paramscreate['ns4']=[
                        'host'=>$namserver->secondary_name_server3,
                        'ip4'=>$namserver->secondary_name_server3_ip,
                        'ip6'=>$namserver->secondary_name_server3_ip6,
                    ];
                    array_push($savedns,$namserver->secondary_name_server3);
                }
            
                if($namserver->secondary_name_server4!=null){
                    $paramscreate['ns5']=[
                        'host'=>$namserver->secondary_name_server4,
                        'ip4'=>$namserver->secondary_name_server4_ip,
                        'ip6'=>$namserver->secondary_name_server4_ip6,
                    ];
                    array_push($savedns,$namserver->secondary_name_server4);
                }
            
                if($namserver->secondary_name_server5!=null){
                    $paramscreate['ns6']=[
                        'host'=>$namserver->secondary_name_server5,
                        'ip4'=>$namserver->secondary_name_server5_ip,
                        'ip6'=>$namserver->secondary_name_server5_ip6,
                    ];
                    array_push($savedns,$namserver->secondary_name_server5);
                }
            
                $epp=new EPP();
            
                $user = Auth::user();
            
                $respone=$epp->domainInfo($user->domainName);
            
                $xml = new \SimpleXMLElement($respone);

                $xmlElement = new \SimpleXMLElement($respone);
                $xmlElement->registerXPathNamespace('secDNS', 'urn:ietf:params:xml:ns:secDNS-1.1');
            
                $dsDataArray = [];
                $dsDataElements = $xmlElement->xpath('//secDNS:dsData');
            
                if($dsDataElements!=null){
                    foreach ($dsDataElements as $dsDataElement) {
                        $dsDataArray[] = [
                            'keyTag' => (string) $dsDataElement->children('secDNS', true)->keyTag,
                            'alg' => (string) $dsDataElement->children('secDNS', true)->alg,
                            'digestType' => (string) $dsDataElement->children('secDNS', true)->digestType,
                            'digest' => (string) $dsDataElement->children('secDNS', true)->digest
                        ];
                    }
                    $res=$epp->domainremDNSSEC($user->domainName,$dsDataArray);
                }
            
                $xml->registerXPathNamespace('domain', 'urn:ietf:params:xml:ns:domain-1.0');
            
                $nameservers = $xml->xpath('//domain:hostObj');
            
                $remNSD = array();
                foreach ($nameservers as $nameserver) {
                 $remNSD[] = (string) $nameserver;
                }
            
                $remNS = array_diff($remNSD, $savedns);
                $saveNS = array_diff($savedns, $remNSD);
            
                $res=$epp->domainupdateNameServer($user->domainName,$paramscreate,$saveNS,$remNS);

                $dsdtaas=DB::table('dns_security-extension')->where('user_dns_server_id',$namserver->id)->get();

                $addDsData=[];

                foreach ($dsdtaas as $name) {
                    if($name->key_tag!=null || $name->key_tag!=''){
                    $addDsData[] = [
                        'keyTag' => $name->key_tag,
                        'alg' => $name->algorithm,
                        'digestType' => $name->digest_type=='SHA1'?"1":'',
                        'digest' => $name->digest,
                    ];
                    }
                }

                $res=$epp->domainupdateDNSSEC($user->domainName,$addDsData);

                $data['title'] = 'Name server of your domain ('.Auth::user()->domainName.') has been updated';
                $data['email'] = Auth::user()->email;
                $data['name'] = Auth::user()->name;
                $data['domain'] = Auth::user()->domainName;
                Mail::send('front.email.user-name-server-updated', $data, function($message)use($data) {
                    $message->to($data["email"], $data["name"])
                        ->subject($data["title"]);
                });

                Mail::send('front.email.user-name-server-updated', $data, function($message)use($data) {
                    $message->to('helpdejj@domain.ernet.in', $data["name"])
                        ->subject($data["title"]);
                });

                Session::forget('payment_type');
                Session::forget('data');
                Session::forget('dnsse_data');
                Session::flash('message', 'The Payment is Successfully done.');
                Session::flash('alert-class', 'alert-success');
                return redirect('user-application-preview');
            }elseif ($payment_type['transaction_type'] == 'domainRenewal'){
                $updated_date = date('Y-m-d H:i:s');
                $user = User::find($user_id);
                $user->domainStatus = 10;
                $user->domainPrice = $payment_type['server_price_total'];
                $user->renew_years = DB::table('domain_extension_prices')->where('id','=',$payment_type['year'])->first()->year;
                $user->updated_at = $updated_date;
                $user->save();
                Session::flash('message', 'The Payment is Successfully done.');
                Session::flash('alert-class', 'alert-success');
                Session::forget('payment_type');
                return redirect('user-dashboard');
            }elseif ($payment_type['transaction_type'] == 'ewaas'){
                Session::flash('message', 'The Payment is Successfully done.');
                Session::flash('alert-class', 'alert-success');
                return redirect('projects');
            }elseif ($payment_type['transaction_type'] == 'elmaas'){
                Session::flash('message', 'The Payment is Successfully done.');
                Session::flash('alert-class', 'alert-success');
                return redirect('projects');
            }else{
                dd($payment_type['transaction_type']);
            }
        }else{
            Session::flash('message', $response['message']);
            Session::flash('alert-class', 'alert-danger');
            return back();
        }
    }

    /**
     * @param Request $request
     *
     * @return string
     */
    public function webhook(Request $request)
    {
        $response = $request->handle();
        Log::info('Webhook Calling');
        Log::info($response);          
        return 'OK';
    }

    private function createzone(Zone $zone){
        $zone->increaseSerialNumber();
        $content = BINDFormatter::getZoneFileContent($zone);
        $path = self::ZONE_BASEDIR.DIRECTORY_SEPARATOR.$zone->domain;
        Storage::append($path, $content);

        try {        

            $destinationFileName = $zone->domain;

           

            $destinationFileName1 = $zone->domain;

            $destinationServer1 = '202.141.18.85';
            $destinationUsername1 = 'ernet';
            $destinationPassword1 = '3rn3t@2023';
            $destinationFolder1 = '/var/zones/primary';

            $sftp1 = new SFTP($destinationServer1);

            if (!$sftp1->login($destinationUsername1, $destinationPassword1)) {
                throw new \Exception('SFTP login failed');
            }

            if (!$sftp1->chdir($destinationFolder1)) {
                throw new \Exception('Failed to change directory on the destination server');
            }

            if ($sftp1->file_exists($destinationFileName1)) {
                if (!$sftp1->delete($destinationFileName1)) {
                    throw new \Exception('Failed to delete the existing file on the destination server');
                }
            }

            if (!$sftp1->put($destinationFileName1, $content)) {

            $sftp1->disconnect();

            $destinationServer = '202.141.18.87';
            $destinationUsername = 'ernet';
            $destinationPassword = '3rn3t@2023';
            $destinationFolder = '/var/zones/primary';

            $sftp = new SFTP($destinationServer);

            if (!$sftp->login($destinationUsername, $destinationPassword)) {
                throw new \Exception('SFTP login failed');
            }

            if (!$sftp->chdir($destinationFolder)) {
                throw new \Exception('Failed to change directory on the destination server');
            }

            if ($sftp->file_exists($destinationFileName)) {
                if (!$sftp->delete($destinationFileName)) {
                    throw new \Exception('Failed to delete the existing file on the destination server');
                }
            }

            if (!$sftp->put($destinationFileName, $content)) {
                throw new \Exception('Failed to transfer the file to the destination server');
            }

            $sftp->disconnect();

            }


                        $sftp1->disconnect();

            // If the code reaches this point, the connection was successful
            // echo 'Successfully connected to the server and transferred the file!';
        } catch (\Exception $e) {
            // echo 'Error: ' . $e->getMessage();
        }
    }

}
