<?php

namespace App\Http\Controllers;

use App\Mail\UserDomainEnquiryMail;
use App\Models\Domain;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\Crypt;
use mysql_xdevapi\Collection;
use Validator;
use Session,Hash;
use App\Library\EPP;
use App\Models\Zone;
use Carbon\Carbon;
use Maatwebsite\Excel\Facades\Excel;
use App\Imports\DomainImport;
use Auth,Log;
use App\Exports\FailedDomain;
use Illuminate\Support\Facades\Response;
use Config;
use Firebase\JWT\JWT;
use \Firebase\JWT\Key;
use App\Models\Admin;
use Barryvdh\DomPDF\Facade\Pdf;

class BulkController extends Controller
{

    public function uploadDomain(Request $request){

        $pageTitle = 'Bulk Domain Panel';

        if(!is_logged_in())
        {
          return view('admin.pages.admin-login',compact('pageTitle'));
        }
  
        $checkundertake=Auth::guard('admin')->user()->is_undertake_completed;

        if($checkundertake==1){
            $type=$request->upload;
            return view('admin/bulkdomain/upload_domain',['type'=>$type]);    
        }else{
            return redirect()->route('bulkdomainDeclaration');
        }
       
	}

    public function bulkdomainDeclaration(Request $request){

        $pageTitle = 'Bulk Domain Panel';

        if(!is_logged_in())
        {
          return view('admin.pages.admin-login',compact('pageTitle'));
        }
  

        $checkundertake=Auth::guard('admin')->user()->is_undertake_completed;

        if($checkundertake==1){
            $type=$request->upload;
            return view('admin/bulkdomain/upload_domain',['type'=>$type]);    
        }else{
            return view('admin/bulkdomain/agree');    
        }
       
	}

    public function bulkDomainVerifyDeclaration(Request $request){

        $pageTitle = 'Bulk Domain Panel';

        if(!is_logged_in())
        {
          return view('admin.pages.admin-login',compact('pageTitle'));
        }
  
        $user=Auth::guard('admin')->user();

        $validator = Validator::make($request->all(), [
            'contact_name' => 'required',
            'father_name' => 'required',
            'age' => 'required',
            'email'=>'required|email|unique:admins,email,'.$user->id
        ]);
        
        if($validator->fails()){
            return response()->json(['status'=>false,'message'=>$validator->errors()->first()]);
        }

        $params=[
            'father_name'=>$request->father_name,
            'age'=>$request->age,
            'contact_name'=>$request->contact_name,
            'aff_by'=>$request->aff_by,
            'email'=>$request->email,
            'org_name'=>$request->org_name,
            'is_undertake_completed'=>1
        ];

        $update=Admin::where('id',$user->id)->update($params);

        return response()->json(['status'=>true,'message'=>'Declaration Details Saved Successfully']);

	}

    public function bulkdomainformat_pdf($id)
    {

        $user_id = Auth::guard('admin')->id();
        $admins = Admin::find($user_id);

        $domains=DB::table('users')->where('user_id',$user_id)->where('status','<',6)->get();

        $transactions=DB::table('bulk_transactions')->where('admin_id',$user_id)->orderBy('id','desc')->first();

        view()->share('admins', $admins);
        view()->share('domains', $domains);
        view()->share('transactions', $transactions);

        if ($id) {

            switch ($id) {
                case 1:
                    $view_path = 'Annexure_A';
                    $downloadname = 'Letter of Undertaking';
                    break;
                case 2:
                    $view_path = 'Annexure_B';
                    $downloadname = 'Application Letter';
                    break;
                default:
                    $view_path = 'Annexure';
                    $downloadname = 'Annexure';
            }
            
            $viewurl='admin/bulkdomain.' . $view_path;

            $pdfname=$downloadname;
            $pdf = PDF::loadView($viewurl);
            return $pdf->download($pdfname.'.pdf');

        }

        return true;
    }

    public function bulkUploadDomain(Request $request){

        $file = $request->file('file');
        
        $validator = Validator::make($request->all(), [
            'excel_file' => 'required|mimes:xlsx,xls',
        ]);
    
        $import = new DomainImport();
    
        if($validator->fails()){
            return response()->json(['status'=>false,'message'=>'Please Upload Excel File']);
        }

        Session::put('domainPeriod',$request->period);
        $rows = Excel::toCollection($import, $request->file('excel_file'))->first();
        $rowCount = $rows->count();
    
        if ($rowCount > 50) {
            return  response()->json(['status'=>false,'message'=>'Maximum 50 Domain Can be import']);
        }
        
        $userId=Auth::guard('admin')->user()->id;
        $status = DB::table('tmp_users')->where('user_id',$userId)->delete();

        // if($request->type!=2){
        // }else{
        //     $status = DB::table('tmp_users')->where('user_id',$userId)->where('')->delete();
        // }

        $insert=Excel::import(new DomainImport, $request->file('excel_file'));
          
        return  response()->json(['status'=>true,'message'=>'Data Imported Successfully']);            

    }

    public function bulkPreview(Request $request){

        $userId=Auth::guard('admin')->user()->id;

        $count = DB::table('tmp_users')->where('user_id',$userId)->where('current_status',0)->count();

        $success = DB::table('tmp_users')->where('user_id',$userId)->where('current_status',1)->count();

        return view('admin.bulkdomain.bulk-preview',['count'=>$count,'success'=>$success]);

    }

    public function IncompleteDomain(Request $request){

        $pageTitle = 'Bulk Domain Panel';

        if(!is_logged_in())
        {
          return view('admin.pages.admin-login',compact('pageTitle'));
        }
  
        $userId=Auth::guard('admin')->user()->id;

        $domain = DB::table('users')->select('domainStatus')->where('user_id',$userId)->whereIn('domainStatus',[1,2,3,4])->latest('id')->first();

        return view('admin.bulkdomain.incomplete',['domain'=>$domain,'status'=>1,'title'=>'Incomplete Domains']);

    }

    public function FinalSubmitted(Request $request){

        $pageTitle = 'Bulk Domain Panel';

        if(!is_logged_in())
        {
          return view('admin.pages.admin-login',compact('pageTitle'));
        }
  

        $userId=Auth::guard('admin')->user()->id;

        $domain=null;

        return view('admin.bulkdomain.incomplete',['status'=>5,'domain'=>$domain,'title'=>'Final Submitted Domains']);

    }
        
    public function proceedToCheckoutRegistration(Request $request){

        $pageTitle = 'Bulk Domain Panel';

        if(!is_logged_in())
        {
          return view('admin.pages.admin-login',compact('pageTitle'));
        }
  

        $userId=Auth::guard('admin')->user()->id;
        
        $count = DB::table('users')->where('user_id',$userId)->where('domainStatus',2)->count();

        if($count>0){

            $domains = DB::table('users')->where('user_id',$userId)->where('domainStatus',2)->pluck('domainName','id')->toArray();

            $domainStats = DB::table('users')
            ->where('user_id', $userId)
            ->where('domainStatus', 2)
            ->select(
                DB::raw('COUNT(*) as count'),
                DB::raw('SUM(domainPrice) as sum_domainPrice'),
                DB::raw('AVG(domainPrice) as average_domainPrice'),
                DB::raw('AVG(dnsPrice) as average_dnsPrice'),
                DB::raw('SUM(dnsPrice) as sum_dnsPrice'),
                DB::raw('AVG(domainPeriod) as domainPeriod'),
            )
            ->first();

            $domainNames = array_values($domains); 
            $domainIds = array_keys($domains);

            $miscsettings=DB::table('misc_settings')->first();

            return view('admin.bulkdomain.makeregisterpayment',['domainNames'=>$domainNames,'domainIds'=>$domainIds,'domainStats'=>$domainStats,'miscsettings'=>$miscsettings]);

        }else{

            return redirect('ernetdash');

        }

    }

    public function ManageDomain(Request $request){

        $pageTitle = 'Bulk Domain Panel';

        if(!is_logged_in())
        {
          return view('admin.pages.admin-login',compact('pageTitle'));
        }
  

        $userId=Auth::guard('admin')->user()->id;

        return view('admin.bulkdomain.manage');

    }
    
    public function bulkPreviewAjaxcall(Request $request)
	{
		 $draw = $request->get('draw');
		 $start = $request->get("start");
		 $rowperpage = $request->get("length"); 

		 $columnIndex_arr = $request->get('order');
		 $columnName_arr = $request->get('columns');
		 $order_arr = $request->get('order');
		 $search_arr = $request->get('search');

		 $columnIndex = $columnIndex_arr[0]['column']; 
		 $columnName = $columnName_arr[$columnIndex]['data']; 
		 $columnSortOrder = $order_arr[0]['dir']; 
		 $searchValue = $search_arr['value']; 

         $userId=Auth::guard('admin')->user()->id;

		 $countData = DB::table('tmp_users')->select('*')
                      ->where('current_status',1)
                      ->where('user_id',$userId);
		 
		if($searchValue != null) {
			$countData->where('domainName', 'like', '%' .$searchValue . '%');
		}
		
		$totalRecordswithFilter = $countData->count();
		$totalRecords = $totalRecordswithFilter;

		$records = $countData->skip($start)
           ->orderBy($columnName,$columnSortOrder)
		   ->take($rowperpage);
		
		$list = $records->get();

		 $data_arr = array();
		 
		 foreach($list as $sno => $record){
			$id = $record->id;
			$edit = asset('icon/edit2.png');
			$delete = asset('icon/del.png');

			$action=' <a class="dropdown-items update" href="javascript:void(0);" style="float:left" data-id="'.$id.'" ><i class="fa fa-edit fs-4"></i></a>';

			$action.= '<a class="dropdown-items delete" href="javascript:void(0);" style="margin-left:10px;float:left" data-id="'.$id.'"><i class="fa fa-trash fs-4"></i></a>';
			
			$data_arr[] = array(
			  "id" => ++$start,
			  "domain" => $record->domainName,
			  "institute" => $record->institute,
              "address" => $record->address,
			  "period" => $record->domainPeriod,
			  "email" => $record->email,
			  "Action" => $action
			);
		 }

		 $response = array(
			"draw" => intval($draw),
			"iTotalRecords" => $totalRecords,
			"iTotalDisplayRecords" => $totalRecordswithFilter,
			"aaData" => $data_arr
		 );

		 echo json_encode($response);
		 exit;
	}

    public function getTempDomain(Request $request){

        $id=$request->id;
        $data=DB::table('tmp_users')->where('id',$id)->first();
        return response()->json(['status'=>true,'data'=>$data]);            

    }

    public function bulkDomainUpdate(Request $request){

        $id=$request->id;

        $params=[
            'name'  => $request->name_of_head_of_institute,
            'institute' => $request->institute,
            'address' => $request->address,
            'phone' => $request->phone,
            'email' => $request->email,
            'gst_no' => $request->gst_no,
            'name_of_head_of_institute' => $request->name_of_head_of_institute,
            'designation_of_head_of_institute' => $request->designation_of_head_of_institute,
            'email_of_head_of_institute' => $request->email_of_head_of_institute,
            'phone_of_head_of_institute' => $request->phone_of_head_of_institute,
            'mobile_of_head_of_institute' => $request->mobile_of_head_of_institute,
            'name_of_administrative_contacts' => $request->name_of_administrative_contacts,
            'designation_of_administrative_contacts' => $request->designation_of_administrative_contacts,
            'email_of_administrative_contacts' => $request->email_of_administrative_contacts,
            'phone_of_administrative_contacts' => $request->phone_of_administrative_contacts,
            'mobile_of_administrative_contacts' => $request->mobile_of_administrative_contacts,
            'name_of_billing_details' => $request->name_of_billing_details,
            'designation_of_billing_details' => $request->designation_of_billing_details,
            'email_of_billing_details' => $request->email_of_billing_details,
            'phone_of_of_billing_details' => $request->phone_of_of_billing_details,
            'mobile_of_billing_details' => $request->mobile_of_billing_details,
            'name_of_technical_details' => $request->name_of_technical_details,
            'designation_of_technical_details' => $request->designation_of_technical_details,
            'email_of_technical_details' => $request->email_of_technical_details,
            'phone_of_technical_details' => $request->phone_of_technical_details,
            'mobile_of_of_technical_details' => $request->mobile_of_of_technical_details,
            'pincode' => $request->pincode
        ];

        $update=DB::table('tmp_users')->where('id',$id)->update($params);
          
        return  response()->json(['status'=>true,'message'=>'Data Updated Successfully']);            

    }

    public function bulkDeleteDomain(Request $request){

        $id=$request->id;

        $deleted=DB::table('tmp_users')->where('id',$id)->delete();
          
        return  response()->json(['status'=>true,'message'=>'Data Deleted Successfully']);            

    }
    
    public function downloadFailedDomain(Request $request){

        $userId=Auth::guard('admin')->user()->id;

        $data=DB::table('tmp_users')->where('user_id',$userId)->where('current_status',0)->get();
        
        $records = array(
            array(
                "S.NO.",
                "Domain Name",
                "Institute Name",
                'Reason'
            )
        );
        
        foreach ($data as  $i => $row) {

            $remarks=$row->error_remarks=="The domain has already been taken."?"Domain is already registered":"";
            
            $records[] = array(
                ++$i,
                $row->domainName,
                $row->institute,
                $remarks,
            );
        }

        $filename = "Failed Domain List-". date('d-m-Y H:i:s a ') . ".xls";
        header("Content-Type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"$filename\"");
        $show_column = false;

        foreach ($records as $record) {
            if (!$show_column) {
                echo implode("\t", array_map(function ($value) {
                    return  $value ;
                }, $record)) . "\n";
                $show_column = true;
            } else {
                echo implode("\t", $record) . "\n";
            }
        }
        exit;

    }
    
    public function bulkDomainFinalSubmit(Request $request){

        $userId=Auth::guard('admin')->user()->id;

        $domains=DB::table('tmp_users')->where('user_id',$userId)->where('current_status',1)->get();
    
        $details=DB::table('tmp_users')->where('user_id',$userId)->where('current_status',1)->first();

        if($details!=null){

            $domainExt = DB::table('domain_extension_prices')->where('domain_extension_id' ,1)->where('year' , $details->domainPeriod)->first();
            $domainPrice = $domainExt->price;
        
            $dnsExt=DB::table('ernet_name_servers_prices')->select('price')->where('years',$details->domainPeriod)->first();
            $dnsPrice = $dnsExt->price;
    
            $server = DB::table('ernet_name_servers')->first();
            $primary_name_server = $server->primary_name_server;
            $secondary_name_server = json_decode($server->secondary_name_server, true); 
    
            $secondary_name_server1 = $secondary_name_server[0];
            $secondary_name_server2 = $secondary_name_server[1];
            $secondary_name_server3 = $secondary_name_server[2];
            $secondary_name_server4 = $secondary_name_server[3];
            $secondary_name_server5 = $secondary_name_server[4];
    
            foreach($domains as $domain){
    
                $params=[
                    'dnsPrice'=>$dnsPrice,
                    'dnsPeriod'=>$domain->domainPeriod,
                    'name'  => $domain->name,
                    'domainName'=>$domain->domainName,
                    'institute' => $domain->institute,
                    'email' => $domain->email,
                    'domainStatus'=>1,
                    'domainLangID'=>2,
                    'domainPunycode' => $domain->domainPunycode,
                    'domainPeriod' => $domain->domainPeriod,
                    'password' => Hash::make($domain->domainName),
                    'status' => 1,
                    'domainPrice'=>$domainPrice,
                    'domainStatus'=>1,
                    'type'=>1,
                    'user_id'=>$userId,
                    'user_type'=>2,
                    'created_at'=>date('Y-m-d H:i:s'),
                    'updated_at'=>date('Y-m-d H:i:s')
                ];
                   
                $domainId=DB::table('users')->insertGetId($params);
    
                $stateData = DB::table('cities')->select('cities.*','regions.description as state_name')->where('cities.pincode',$domain->pincode)->join('regions','regions.id','cities.region_id')->first();
                $state =  $stateData->state_name??'';
                $city =  $stateData->name??'';
    
                $contacts=[
                    'user_id' => $domainId,
                    'state' => $state,
                    'city'  => $city,
                    'pincode' => $domain->pincode,
                    'admin_id' => $userId,
                    'gst_no'  => $domain->gst_no,
                    'address' => $domain->address,
                    'mobile' => $domain->phone,
                    'phone' => $domain->mobile_of_head_of_institute,
                    'institution_head_detail' => json_encode([
                        'name' => $domain->name_of_head_of_institute,
                        'designation' => $domain->designation_of_head_of_institute,
                        'email' => $domain->email_of_head_of_institute,
                        'phone' => $domain->phone_of_head_of_institute,
                        'mobile' => $domain->mobile_of_head_of_institute,
                    ]),
                    'administrative_detail' => json_encode([
                        'name' => $domain->name_of_administrative_contacts,
                        'designation' => $domain->designation_of_administrative_contacts,
                        'email' => $domain->email_of_administrative_contacts,
                        'phone' => $domain->phone_of_administrative_contacts,
                        'mobile' => $domain->mobile_of_administrative_contacts,
                    ]),
                    'billing_contact_detail' => json_encode([
                        'name' => $domain->name_of_billing_details,
                        'designation' => $domain->designation_of_billing_details,
                        'email' => $domain->email_of_billing_details,
                        'phone' => $domain->phone_of_of_billing_details,
                        'mobile' => $domain->mobile_of_billing_details,
                    ]),
                    'technical_detail' => json_encode([
                        'name' => $domain->name_of_technical_details,
                        'designation' => $domain->designation_of_technical_details,
                        'email' => $domain->email_of_technical_details,
                        'phone' => $domain->mobile_of_of_technical_details,
                        'mobile' => $domain->phone_of_technical_details,
                    ])
                    ];
    
                    $contactstatus= DB::table('user_contact_details')->insert($contacts);
    
                    $nameserver=[
                    'user_id' => $domainId,
                    'server_type' => 1,
                    'primary_name_server' => $primary_name_server,
                    'secondary_name_server1' => $secondary_name_server1,
                    'secondary_name_server2' => $secondary_name_server2,
                    'secondary_name_server3' => $secondary_name_server3,
                    'secondary_name_server4' => $secondary_name_server4,
                    'secondary_name_server5' => $secondary_name_server5
                    ];
    
                    $ernetDNS = DB::table('user_name_servers')->insert($nameserver);
    
            }
    
            $status = DB::table('tmp_users')->where('user_id',$userId)->delete();
    
            return  response()->json(['status'=>true,'message'=>'Data Updated Successfully']);            

        }else{

            return  response()->json(['status'=>false,'message'=>'No Domain Found']);            

        }
      
    }

    public function Domaindoc(Request $request){
		$value = [1, 2];
        $DOC = DB::table('document_category')->whereIn('id', $value)->orderBy('id','desc')->get();
		return view('admin/admins/upload_doc' , compact('DOC'));
	}

    public function Uploaddoc(Request $request){
      
        $userId=Auth::guard('admin')->user()->id;

        $ids=DB::table('users')->where('user_id',$userId)->where('domainStatus',1)->pluck('id')->toArray();

        $firstFolder = null;
        $dataID = [1, 2];

        foreach ($ids as $mainID) {

        foreach ($dataID as $id) {

        $fieldName = 'file_' . $id;
        
        if ($request->hasFile($fieldName)) {
            
            $doc = $request->file($fieldName);
            $filename = time() . $doc->getClientOriginalName();

            $firstFolder = public_path('user/docs/') . $mainID;


            if (!file_exists($firstFolder)) {
                mkdir($firstFolder, 0755, true);
            }

			$pathdata = copy($doc->getRealPath(), $firstFolder . '/' . $filename);

            if (!$pathdata) {
                return response()->json(['status' => false, 'error' => 'Failed to move the uploaded file for user ID: ' . $mainID]);
            }
         
            $oldpath = '';
            $docprevious = DB::table('user_documents')->where('user_id', $mainID)->where('document_category_id', $id)->first();

            if ($docprevious != null) {
                $oldpath = $docprevious->path;
            }

            $status = DB::table('user_documents')->updateOrInsert(
                ['user_id' => $mainID, 'document_category_id' => $id],
                [
                    'user_id' => $mainID,
                    'document_category_id' => $id,
                    'name' => pathinfo($filename, PATHINFO_FILENAME),
                    'path' => $filename,
                    'old_path' => $oldpath,
                    'status' => 1
                ]
              );


            }

          }

          $updates=DB::table('users')->where('id',$mainID)->update(['domainStatus'=>2]);

        }

        return response()->json(['status' => 'success', 'msg' => 'Documents have been uploaded successfully']);

    }
    
    public function bulkIncompleteAjaxcall(Request $request)
	{
		 $draw = $request->get('draw');
		 $start = $request->get("start");
		 $rowperpage = $request->get("length"); 

		 $columnIndex_arr = $request->get('order');
		 $columnName_arr = $request->get('columns');
		 $order_arr = $request->get('order');
		 $search_arr = $request->get('search');

		 $columnIndex = $columnIndex_arr[0]['column']; 
		 $columnName = $columnName_arr[$columnIndex]['data']; 
		 $columnSortOrder = $order_arr[0]['dir']; 
		 $searchValue = $search_arr['value']; 

         $userId=Auth::guard('admin')->user()->id;

		 $countData = DB::table('users')->select('*')
                      ->where('user_id',$userId);
		 
		if($searchValue != null) {
			$countData->where('domainName', 'like', '%' .$searchValue . '%');
		}

        if($request->status==5){
            $countData->where('domainStatus',5);
        }else{
            $countData->whereIn('domainStatus',[1,2,3,4]);
        }
		
		$totalRecordswithFilter = $countData->count();
		$totalRecords = $totalRecordswithFilter;

		$records = $countData->skip($start)
           ->orderBy($columnName,$columnSortOrder)
		   ->take($rowperpage);


		$list = $records->get();

		 $data_arr = array();
		 
		 foreach($list as $sno => $record){
			$id = $record->id;
			

            $domainName = '<a class="dropdown-items" href="' . route('view.domainData', ['id' => encrypt($id)]) . '" style="float:left;color:#000">'.$record->domainName.'</a>';

            $status='';

            $action = '<a class="dropdown-items" href="' . route('view.domainData', ['id' => encrypt($id)]) . '" style="float:left">View Details</a>';

            $url=url('ernetdash/bulkdomain/upload-documents').'/'.$record->id;

            if($record->domainStatus==1){
                $status='Pending Documents';
            }else if($record->domainStatus==2){
                $status='Payment Pending';
            }else if($record->domainStatus==3){
                $status='Document Submission Pending';
                $action = '<a class="dropdown-items" href="'.$url.'" style="float:left">Upload Documents</a>';
            }else if($record->domainStatus==4){
                $status='Final Submission Pending';
            }else{
                $status='Application Submitted';
            }

			$data_arr[] = array(
			  "id" => ++$start,
			  "domain" => $domainName,
			  "institute" => $record->institute,
              "period" => $record->domainPeriod,
			  "email" => $record->email,
			  "status" => $status,
			  "Action" => $action
			);
		 }

		 $response = array(
			"draw" => intval($draw),
			"iTotalRecords" => $totalRecords,
			"iTotalDisplayRecords" => $totalRecordswithFilter,
			"aaData" => $data_arr
		 );

		 echo json_encode($response);
		 exit;
	}

    public function bulkActiveAjaxcall(Request $request)
	{

       $draw = $request->get('draw');
       $start = $request->get('start');
       $rowperpage = $request->get('length');
       $columnIndex = $request->get('order')[0]['column'];
       $columnName = $request->get('columns')[$columnIndex]['data'];
       $searchValue = $request->get('search')['value'];
       $columnSortOrder = $request->get('order')[0]['dir'];
       
       $userId = Auth::guard('admin')->user()->id;

       $query = DB::table('users')
           ->select('id', 'domainName', 'institute', 'domainPeriod', 'email', 'domainStatus')
           ->where('domainStatus', '>', 5)
           ->where('user_id', $userId);
       
       if (!empty($searchValue)) {
           $query->where('domainName', 'like', '%' . $searchValue . '%');
       }

        $totalRecordswithFilter = $query->count();
       
        $records = $query->orderBy($columnName, $columnSortOrder)
           ->skip($start)
           ->take($rowperpage)
           ->get();
       
        $data_arr = [];
        $statuses = [
          6 => 'Active Domain',
          7 => 'Domain Hold',
          8 => 'Pending Restorable',
          9 => 'Renewal Applied'
        ];

        foreach ($records as $index => $record) {
            $action = '<a class="dropdown-items" href="' . route('view.domainData', ['id' => encrypt($record->id)]) . '" style="float:left">Manage Domain</a>';
        
            $status = $statuses[$record->domainStatus] ?? '';
        
            $data_arr[] = [
                "id" => ++$start,
                "domain" => $record->domainName,
                "institute" => $record->institute,
                "period" => $record->domainPeriod,
                "email" => $record->email,
                "status" => $status,
                "Action" => $action
            ];
        }

        $response = [
            "draw" => intval($draw),
            "iTotalRecords" => $totalRecordswithFilter,
            "iTotalDisplayRecords" => $totalRecordswithFilter,
            "aaData" => $data_arr
        ];
        
        echo json_encode($response);
        exit;

	}

    public function viewDomain(Request $request, $id){
		$id = decrypt($id);

		$user = DB::table('users')->where('id' , $id)->first();
		$user_id = $user->id;
		$user_contact_details = DB::table('user_contact_details')->where('user_id' , $user_id)->first();
		$user_name_server = DB::table('user_name_servers')->where('user_id' , $user_id)->first();

        $userdocuments=DB::table('user_documents')->select('user_documents.*','document_category.title')->where('user_id',$user_id)->join('document_category','document_category.id','user_documents.document_category_id')->get();

		return view('admin/bulkdomain/view_domain' , compact('user' , 'user_contact_details' , 'user_name_server' , 'userdocuments'));
	}

    public function createBulkBilldeskOrder(Request $request){
         
        $data=DB::table('payment_gateway_setting')->where('id',2)->first();

        $secretKey = $data->checksum_key;
        $clientId = $data->security_id;
         
        $mid = $data->merchant_id;
                
        $user=Auth::guard('admin')->user();

        $apiurl = Config::get('custom-billdesk.apiurl');
         
        $logo = Config::get('custom-billdesk.logo');

        $responseurl= "https://registry.ernet.in/handleBulkTransactions";
         
        $sdkPrimaryColor= Config::get('custom-billdesk.sdkPrimaryColor');
        $sdkAccentColor= Config::get('custom-billdesk.sdkAccentColor');
        $sdkBackgroundColor= Config::get('custom-billdesk.sdkBackgroundColor');
        $sdkBannerColor= Config::get('custom-billdesk.sdkBannerColor');

        $headers = ["alg" => "HS256", "clientid" => $clientId, "kid" => "HMAC"];

        $uniqueid=genTransID($user->id);
        $ip=$request->ip();

        $orderDate = date('Y-m-d\TH:i:sP'); 
        $payloadData = [
            "mercid" => $mid,
            "orderid" =>$uniqueid ,
            "amount" => $request->amount,
            "order_date" => $orderDate,
            "currency" => "356",
            "ru" =>$responseurl,
            "additional_info" => [
              "additional_info1" => $request->remark,
              "additional_info2" =>$user->name,
              "additional_info3" =>$request->domain_duration,
              "additional_info4"=>'Bulk Domain Registration',
              "additional_info5"=>'NA',
              "additional_info6"=>'NA',
              "additional_info7"=>'NA',
            ],
            "itemcode" => "DIRECT",
            "device" => [
                "init_channel" => "internet",
                "ip" => $ip,
                "user_agent" => "Mozilla/5.0(WindowsNT10.0;WOW64;rv:51.0)Gecko/20100101 Firefox/51.0",
                "accept_header" => "text/html",
                "fingerprintid" => "61b12c18b5d0cf901be34a23ca64bb19",
                "browser_tz" => "-330",
                "browser_color_depth" => "32",
                "browser_java_enabled" => "false",
                "browser_screen_height" => "601",
                "browser_screen_width" => "657",
                "browser_language" => "en-US",
                "browser_javascript_enabled" => "true"
            ]
        ];    
        
                 
        $traceid = uniqid();
        $currentTimestamp = time();

        $curl_payload = JWT::encode($payloadData, $secretKey, "HS256", null ,$headers);

        $curl = curl_init($apiurl);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_HTTPHEADER, [
            'Content-Type: application/jose', 
            'Accept: application/jose', 
            'BD-Traceid: ' . $traceid, 
            'BD-Timestamp: ' . $currentTimestamp,
        ]);
         
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $curl_payload);
         
        $result = curl_exec($curl);
        
        curl_close($curl);
        
        $encodedString = $result;
   
        $decoded = JWT::decode($encodedString, new Key($secretKey, 'HS256'));

        $launch_billdesk = false;

        if($decoded->status=='ACTIVE'){

            $otoken=$decoded->links[1]->headers->authorization;

            $params=[
                'unique_id'=>$traceid,
                'reference_id'=>$uniqueid,
                'transaction_type'=>$request->transaction_type,
                'request_payload'=>json_encode($payloadData),
                'request'=>json_encode($request->all()),
                'response_payload'=>json_encode($decoded),
                'total_amount'=>$request->amount,
                'admin_id'=>Auth::guard('admin')->user()->id,
                'domain_names'=>$request->domain_names,
                'domain_ids'=>$request->domain_ids,
                'period'=>$request->domain_duration,
                'created_at'=>date('Y-m-d H:i:s')
            ];
            $trans=DB::table('bulk_transactions')->insert($params);
            $launch_billdesk = true;

            return response()->json(array('status'=>'success', 'message' => 'Payment Started Successfully',
            'sdkPrimaryColor'=>$sdkPrimaryColor,'sdkAccentColor'=>$sdkAccentColor,'sdkBackgroundColor'=>$sdkBackgroundColor,'sdkBannerColor'=>$sdkBannerColor,
            'logo'=>$logo,'orderId'=>$decoded->bdorderid,'launch_billdesk'=>$launch_billdesk,'otoken'=>$otoken,'mid'=>$mid,'ru'=>$responseurl));

        }else{

            return response()->json(array('status'=>'error', 'message' => 'Billdesk Response Error','statusmsg'=>$decoded));

        }
       
        return response()->json(array('status'=>'error', 'message' => 'Can not Connect Billdesk'));

        }

        public function update_contact_details($id)
        {
            $data['id']=$id;
            $data['details']=DB::table('users')->where('id',$id)->first();
            $data['title'] = 'Domain Contact Details';
            $data['states'] = DB::table('regions')->orderBy('description')->get();
            $data['cities'] = DB::table('cities')->get();
            return view('admin.bulkdomain/edit-contact-details',$data);
        }
    
        public function domainContactDetailsList($id)
        {
            $user_id = $id;
            $data = DB::table('user_contact_details')->where('user_id','=',$user_id)->first();
            return ['status'=> true , 'data' => $data, 'message'=> 'fetched successfully'];
        }

        public function upload_documents($id)
        {
            $data['title'] = 'User Documents Upload';
            $data['id'] = $id;
            $data['user']=DB::table('users')->where('id',$id)->first();
            return view('admin.bulkdomain/upload-documents',$data);
        }
    
        public function userDocsList($id)
        {
            $user_id = $id;
            $data = DB::table('user_documents')->where('user_id','=',$user_id)->get();
            return ['status'=> true , 'data' => $data, 'message'=> 'fetched successfully'];
        }
    
        public function userDocsUpload(Request $request)
        {
            $file_format = DB::table('document_category')->where('id','=',$request->input('category_id'))->first();
            $size = 2048;
    
            $msg = [
                'file.mimes' => 'Kindly, upload pdf file only!',
                'file.max'=>'File Size should be less than 2MB'
            ];
                    
            $validator = Validator::make($request->all(), [
                'file' => ['required', 'mimes:pdf', 'max:' . $size]
            ], $msg);
    
            if ($validator->fails()) {
                return response()->json(['status'=>false ,'error'=>$validator->errors()->first()]);
            }
    
            $user_id = $request->id;
            $path = public_path('user/docs/').$user_id;
    
            if($request->hasFile('file'))
            {
                $doc = $request->file('file');
    
                $filename = time().$doc->getClientOriginalName();
        
                if (preg_match('/[\'^£$%&*}{@#~?><>,|=+¬]/', $filename))
                {
                    return response()->json(['status' => false, 'error' => 'Selected file is not uploaded, The file name should contain only alphanumeric characters and should not contain any special characters like !@#$%^&*()_- = +']);
                }
                if($doc->move($path,$filename))
                {
                    $oldpath='';
                    $docprevoius=DB::table('user_documents')->where('user_id',$user_id)->where('document_category_id',$request->input('category_id'))->first();
    
                    if($docprevoius!=null){
                       $oldpath=$docprevoius->path;
                    }
    
                    $status = DB::table('user_documents')
                        ->updateOrInsert(
                            ['user_id' => $user_id,'document_category_id' => $request->input('category_id')],
                            [
                                'user_id' => $user_id,
                                'document_category_id' => $request->input('category_id'),
                                'name' => pathinfo($filename, PATHINFO_FILENAME),
                                'path' => $filename,
                                'old_path' => $oldpath,
                                'status' => 1
                            ]
                        );
                    return response()->json(['status' => true, 'msg' => 'Document has been uploaded successfully']);
                }
                else
                {
                    return response()->json(['status' => false, 'error' => ' Document not uploaded']);
                }
            }
            else
            {
                return response()->json(['status' => false, 'error' => 'Please Upload Document']);
            }
        }

        public function user_submit_documents($id)
        {
            $user_id = $id;

            $user=DB::table('users')->where('id',$id)->first();

            $ext = DB::table('domain_extensions')->where('id',42)->first();
            $ids  = explode(",",$ext->doc_ids);
            $doc_type = DB::table('document_category')->whereIn('id',$ids)->get();
            foreach ($doc_type as $type){
    
                if($type->id!=13){
    
                $docs = DB::table('user_documents')
                    ->where('user_id','=', $user_id)
                    ->whereIn('status',[1,2])
                    ->where('document_category_id','=', $type->id)->first();
                if ($docs == null){
                    $msg = $type->title;
                    Session::flash('message', $msg.' is required');
                    Session::flash('alert-class', 'alert-danger');
                    return back();
                }
    
                }
              
            }
            $updated_date = Carbon::now();
            $user = User::find($user_id);
            if ($user->domainStatus < 6){
                $user->domainStatus = 4;
            }
            $user->document_status = 0;
            $user->updated_at = $updated_date;
            $saved=$user->save();

            return redirect()->route('view.domainData', ['id' => encrypt($id)]);
            
        }

        public function userApplicationSubmit($id)
        {
            $user_id = $id;
            $user=DB::table('users')->where('id',$id)->first();

            $ext = DB::table('domain_extensions')->where('id',42)->first();
            $ids  = explode(",",$ext->doc_ids);
            $doc_type = DB::table('document_category')->whereIn('id',$ids)->get();
            foreach ($doc_type as $type){

                if($type->id!=13){

                $docs = DB::table('user_documents')
                    ->where('user_id','=', $user_id)
                    ->where('document_category_id','=', $type->id)->first();
                if ($docs == null){
                    return ['status'=> false, 'message'=> 'Kindly upload all documents for final submit .'];
                }

                }

            }
            $updated_date = date('Y-m-d H:i:s');
            $user = User::find($user_id);
            $user->domainStatus = 5;
            $user->document_status = 0;
            $user->updated_at = $updated_date;
            $user->applicationDate = $updated_date;
            $saved=$user->save();
            return ['status'=> true];

        }

        public function handleBulkTransactions(Request $request){
            
        $data=DB::table('payment_gateway_setting')->where('id',2)->first();

        $secretKey = $data->checksum_key;

        $response = $request->transaction_response;
        $result=$response;

        try{

        $decodedresponse = JWT::decode($result, new Key($secretKey, 'HS256'));
      
        if ($decodedresponse->auth_status=='0300'){

            $trans=DB::table('bulk_transactions')->where('reference_id',$decodedresponse->orderid)->where('transaction_status','0002')->first();
            
            if($trans==null){

                Session::flash('message', 'The Payment not completed');
                Session::flash('alert-class', 'alert-success');
                return redirect()->route('incomplete.domain');

            }

            $payment_type = $trans->transaction_type;
            $user_id=$trans->admin_id;

            $status=DB::table('bulk_transactions')->where('reference_id','=',$decodedresponse->orderid)->update(
                [
                    'transaction_status'=>'0300',
                    'transaction_id'=>$decodedresponse->transactionid,
                    'response'=>json_encode($decodedresponse)
                ]
            );


            if($status){

                $trans=DB::table('bulk_transactions')->where('reference_id',$decodedresponse->orderid)->first();

                $domains=json_decode($trans->domain_ids);
        
                $totalcount=count($domains)??1;
        
                $params=[
                    'unique_id'=>$trans->unique_id,
                    'reference_id'=>$trans->reference_id,
                    'transaction_type'=>'domainRegisterWithNameServer',
                    'request_payload'=>$trans->request_payload,
                    'request'=>$trans->request,
                    'response_payload'=>$trans->response_payload,
                    'response'=>$trans->response,
                    'total_amount'=>$trans->total_amount/$totalcount,
                    'transaction_status'=>$trans->transaction_status,
                    'period'=>$trans->period,
                    'created_at'=>date('Y-m-d H:i:s'),
                    'transaction_id'=>$trans->transaction_id
                ];
        
                foreach($domains as  $key => $domain){
        
                    $params['user_id']=$domain;
                    $insert=DB::table('transactions')->insert($params);

                    $updated_date = date('Y-m-d H:i:s');

                    if($payment_type=='domainRegisterWithNameServer'){

                        $user = User::find($domain);
                        $user->domainStatus = 5;
                        $user->updated_at = $updated_date;
                        $user->save();
    
                    }
        
                }
        
            }

            Session::flash('message', 'The Payment Successfull');
            Session::flash('alert-class', 'alert-success');
            return redirect()->route('finalsubmit.domain');
        
        }

        }catch(\Throwable $e){

            Log::info($e);
            Session::flash('message','Payment Not Completed due to response invalid');
            Session::flash('alert-class', 'alert-danger');
            return redirect()->route('incomplete.domain');

        }

    }

    public function payment_history(Request $request)
    {
        return view('admin.bulkdomain.payment_history');
    }

    public function payment_history_ajaxcall(Request $request)
	{
		 $draw = $request->get('draw');
		 $start = $request->get("start");
		 $rowperpage = $request->get("length"); 

		 $columnIndex_arr = $request->get('order');
		 $columnName_arr = $request->get('columns');
		 $order_arr = $request->get('order');
		 $search_arr = $request->get('search');

		 $columnIndex = $columnIndex_arr[0]['column']; 
		 $columnName = $columnName_arr[$columnIndex]['data']; 
		 $columnSortOrder = $order_arr[0]['dir']; 
		 $searchValue = $search_arr['value']; 

         $userId=Auth::guard('admin')->user()->id;

		 $countData = DB::table('bulk_transactions')->select('*')
                      ->where('admin_id',$userId)
                      ->where('transaction_status','0300');
		 
		if($searchValue != null) {
		}
		
		$totalRecordswithFilter = $countData->count();
		$totalRecords = $totalRecordswithFilter;

		$records = $countData->skip($start)
           ->orderBy('id','desc')
		   ->take($rowperpage);
		
		$list = $records->get();

		 $data_arr = array();
		 
		 foreach($list as $sno => $record){
			$id = $record->id;
			
            $domainlist=$record->domain_names;

            $data = json_decode($domainlist, true);

            $domains='';

           foreach($data as $detail){

            $domains.=$detail;
            $domains.='<br>';

           }
            
            $data_arr[] = array(
                "id" => ++$start,
                "type" => 'Domain Registration Payment',
                "domains"=>$domains,
                "txnAmount" => $record->total_amount??0,
                "created_at" => date('d-m-Y h:i a',strtotime($record->created_at))
            );

		 }

		 $response = array(
			"draw" => intval($draw),
			"iTotalRecords" => $totalRecords,
			"iTotalDisplayRecords" => $totalRecordswithFilter,
			"aaData" => $data_arr
		 );

		 echo json_encode($response);
		 exit;
	}
    

}
