<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class HomeController extends Controller
{

    public function admin_login()
    {
        return view('admin.pages/admin-login');
    }

    public function admin_dashboard()
    {
        $data['title'] = 'Admin Dashboard';

        $role=auth()->guard('admin')->user()->role;

        if($role==1){
            return view('admin.pages/index', $data);
        }else{
            return redirect('/domain/manage');
        }

    }

    public function admin_dashboard_data()
    {
        $data['title'] = 'Admin Dashboard Data';
        return view('admin.pages/admin-dashboard-data', $data );
    }

    public function getDashboardData()
    {
        $applicationCounts = DB::table('users')
        // ->where('user_type', 1)
        ->selectRaw('
            SUM(CASE WHEN domainStatus IN (1, 2, 3, 4) AND document_status IN (0, 2) THEN 1 ELSE 0 END) as incompleteApplicationCount,
            SUM(CASE WHEN domainLangID = 2 AND domainStatus IN (6) THEN 1 ELSE 0 END) as activeApplicationCount,
            SUM(CASE WHEN domainStatus = 5 THEN 1 ELSE 0 END) as pendingApplicationCount,
            SUM(CASE WHEN domainStatus = 8 THEN 1 ELSE 0 END) as expiredApplicationCount,
            SUM(CASE WHEN domainStatus = 7 THEN 1 ELSE 0 END) as holdApplicationCount,
            SUM(CASE WHEN domainStatus = 10 AND document_status != 1 THEN 1 ELSE 0 END) as renewalApplicationCount,
            SUM(CASE WHEN domainLangID = 3 AND domainStatus = 6 THEN 1 ELSE 0 END) as hindiactiveApplicationCount,
            SUM(CASE WHEN document_status = 1 THEN 1 ELSE 0 END) as rejectedDocsCount
            ')
        ->first();

                    // SUM(CASE WHEN hard_copy = 1 AND domainStatus IN (6, 7, 8, 10) THEN 1 ELSE 0 END) AS hardcopy

    
    $deletedCount = DB::table('deleted_users')->where('status', '=', 0)
    ->whereDate('created_at','>=',Carbon::now()->subDays(5)->format('Y-m-d'))->count();
    
    $projectCounts = DB::table('projects')
    ->selectRaw('
        SUM(CASE WHEN status = 0 AND vas_type = "ewaas" THEN 1 ELSE 0 END) as waaspending,
        SUM(CASE WHEN status = 1 AND vas_type = "ewaas" THEN 1 ELSE 0 END) as waaspublished,
        SUM(CASE WHEN status = 0 AND vas_type = "elmaas" THEN 1 ELSE 0 END) as lmaaspending,
        SUM(CASE WHEN status = 1 AND vas_type = "elmaas" THEN 1 ELSE 0 END) as lmaaspublished
    ')
    ->first();

    $data = [
        'incompleteApplicationCount' => $applicationCounts->incompleteApplicationCount,
        'activeApplicationCount' => $applicationCounts->activeApplicationCount,
        'pendingApplicationCount' => $applicationCounts->pendingApplicationCount,
        'expiredApplicationCount' => $applicationCounts->expiredApplicationCount,
        'holdApplicationCount' => $applicationCounts->holdApplicationCount,
        'renewalApplicationCount' => $applicationCounts->renewalApplicationCount,
        'rejectedDocsCount'=>$applicationCounts->rejectedDocsCount,
        'hardcopy'=>0,
        'coolingperiodCount' => $deletedCount,
        'hindiactiveApplicationCount' => $applicationCounts->hindiactiveApplicationCount,
        'waaspending'=>$projectCounts->waaspending,
        'waaspublished'=>$projectCounts->waaspublished,
        'lmaaspending'=>$projectCounts->lmaaspending,
        'lmaaspublished'=>$projectCounts->lmaaspublished
    ];
    
        
    $data['zonenotcreatedcount']=DB::table('users')->where('users.domainStatus',6)->where('users.zone_file',0)->where('user_name_servers.server_type',1)->join('user_name_servers','user_name_servers.user_id','users.id')->count();

    $ernetserver='ernet.in';

    $data['activeernetdns']=DB::table('users')
    ->whereIn('users.domainStatus',[6,7,8,10])
    ->where(function($query) use ($ernetserver) {
        $query->where('primary_name_server', 'like', '%' . $ernetserver. '%')
            ->orWhere('secondary_name_server1', 'like', '%' . $ernetserver . '%');
    })
    // ->where('users.user_type',1)
    ->join('user_name_servers','user_name_servers.user_id','users.id')->count();
    
    $data['bulkdomainRegistration'] = DB::table('users')->select('user_id')
    ->join('admins','admins.id','users.user_id')
    ->whereIn('users.domainStatus',[5,6,7,8])->where('user_type',2)
    ->get()
    ->groupBy(function($data) {
        return $data->user_id;
    })->count();

    $data['bulkdomainRenewal'] = DB::table('users')->select('user_id')
    ->join('admins','admins.id','users.user_id')
    ->whereIn('users.domainStatus',[10])->where('user_type',2)
    ->get()
    ->groupBy(function($data) {
        return $data->user_id;
    })->count();

    $data['thirdparty']=DB::table('user_name_servers')
    ->where('user_name_servers.server_type',2)->join('users','users.id','user_name_servers.user_id')
    ->whereIn('users.domainStatus',[6])->count();

    return response()->json(['data'=>$data]);

    }

}
