<?php

namespace App\Http\Controllers\admin;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use DB;
use App\Models\Language;
use Illuminate\Support\Facades\Auth;
use Validator;


class MasterController extends Controller
{
    /*state and city start*/
    public function admin_add_state_city_view(Request $request)
    {
        $data['title'] = 'Add State and city';
        return view('admin.pages/master-state-city',$data);
    }
    /*state and city end*/


    /*extensions start*/
    public function admin_extensions_view(Request $request)
    {
        $data['title'] = 'Add Extensions';
        $domain_main_category_qry = DB::table('domain_main_category')->get();
        if ($domain_main_category_qry)
        {
            $data['domain_main_category']=$domain_main_category_qry;
        }
        $domain_languages_qry = DB::table('domain_languages')->where('status','active')->get();
        if ($domain_languages_qry)
        {
            $data['domain_languages']=$domain_languages_qry;
        }
        $domain_extensions_qry = DB::table('domain_extensions')->where('status','active')->orderBy('id','DESC')->get();
        if ($domain_extensions_qry)
        {
            $data['domain_extensions']=$domain_extensions_qry;
        }
        return view('admin.pages/master-extensions',$data);
    }
    public function admin_add_extensions(Request $request)
    {
        $message['status']='error';
        $message['message']='Invalid Request';
        if($request->ajax())
        {
            $created_date = date('Y-m-d H:i:s');
            $is_extension_exist = DB::table('domain_extensions')->where('main_category_id',$request->main_Category)
                                                                ->where('domain_languages_id', $request->input('languages'))
                                                                ->where('domain_extensions', $request->domain_extensions)->count();
            if ($is_extension_exist>0)
            {
                $message['status']='error';
                $message['message']='Domain Extensions Already Exists On This Category';
            }
            else
            {
                $language_id = DB::table('domain_extensions')->insertGetId([
                  'main_category_id'=>$request->main_Category,
                  'domain_languages_id'=>$request->input('languages'),
                  'domain_extensions'=>$request->domain_extensions,
                  'status'=>$request->domain_status,
                  'created_by'=>'super_admin',
                  'created_at'=> $created_date,
                ]);
                if($language_id>0)
                {
                  $message['status']='success';
                  $message['message']=' Successfully Add Domain Extensions';
                }
                else
                {
                  $message['status']='error';
                  $message['message']='Something Went Wrong Please Try again.';
                }
            }
        }
        echo json_encode($message);
    }
    public function admin_get_extensions(Request $request)
    {
        $message['status']='error';
        $message['message']='Invalid Request';
        if($request->ajax())
        {
            $get_extension_qry = DB::table('domain_extensions')->where('id',$request->extension_id)->first();
            if($get_extension_qry)
            {
              $message['status']='success';
              $message['message']=$get_extension_qry;
            }
            else
            {
              $message['status']='error';
              $message['message']='Something Went Wrong Please Try again.';
            }
        }
        echo json_encode($message);
    }

    public function admin_update_extension(Request $request)
    {
        $message['status']='error';
        $message['message']='Invalid Request';
        if($request->ajax())
        {

            $is_extension_exist = DB::table('domain_extensions')->where('main_category_id',$request->update_main_Category)
                                                                ->where('domain_languages_id', $request->update_languages)
                                                                ->where('domain_extensions', $request->update_domain_extensions)->count();
            if ($is_extension_exist>0)
            {
                $message['status']='error';
                $message['message']='Domain Extensions Already Exists On This Category';
            }
            else
            {
                $updated_date = date('Y-m-d H:i:s');
                $extension_update_qry = DB::table('domain_extensions')->where('id',$request->extension_id)->update([
                  'main_category_id'=>$request->update_main_Category,
                  'domain_languages_id'=>$request->update_languages,
                  'domain_extensions'=>$request->update_domain_extensions,
                  'status'=>$request->update_domain_status,
                  'updated_at'=> $updated_date,
                ]);
                if($extension_update_qry)
                {
                  $message['status']='success';
                  $message['message']=' Successfully Update Extension';
                }
                else
                {
                  $message['status']='error';
                  $message['message']='Something Went Wrong Please Try again.';
                }
            }
        }
        echo json_encode($message);
    }

    public function admin_delete_extension(Request $request)
    {
        $message['status']='error';
        $message['message']='Invalid Request';
        if($request->ajax())
        {
            if(!empty($request->extension_id) && $request->extension_id>0)
            {
                $deleted_domain_price = DB::table('domain_extensions')->where('id', $request->extension_id)->delete();
                if($deleted_domain_price)
                {
                  $message['status']='success';
                  $message['message']=' Successfully Delete E`xtensions name';
                }
                else
                {
                  $message['status']='error';
                  $message['message']='Something Went Wrong Please Try again.';
                }
            }
        }
        echo json_encode($message);
    }
   
    public function admin_language_view(Request $request)
    {
        $data['title'] = 'Add language';
        $get_lang_qry = DB::table('domain_languages')->get();
        if ($get_lang_qry)
        {
            $data['get_lang_data'] = $get_lang_qry;
        }
        return view('admin.pages/master-language',$data);
    }
    public function admin_add_language(Request $request)
    {
        $message['status']='error';
        $message['message']='Invalid Request';
        if($request->ajax())
        {

          $validator = Validator::make($request->all(), [
            "add_language" => 'required|regex:/^[a-zA-Z0-9& ]+$/',
        ]);

        if ($validator->fails()) {
            return response()->json(['status'=>'errors','message'=>$validator->errors()]);
        }

            $created_date = date('Y-m-d H:i:s');
            $language_id = DB::table('domain_languages')->insertGetId([
              'language_name'=>$request->add_language,
              'status'=>$request->language_status,
              'created_by'=>'super_admin',
              'created_at'=> $created_date,
            ]);
            if($language_id>0)
            {
              $message['status']='success';
              $message['message']=' Successfully Add Language';
            }
            else
            {
              $message['status']='error';
              $message['message']='Something Went Wrong Please Try again.';
            }
        }
        echo json_encode($message);
    }
    public function admin_get_language(Request $request)
    {
        $message['status']='error';
        $message['message']='Invalid Request';
        if($request->ajax())
        {
            $get_lang_qry = DB::table('domain_languages')->where('id',$request->languages_id)->first();
            if($get_lang_qry)
            {
              $message['status']='success';
              $message['message']=$get_lang_qry;
            }
            else
            {
              $message['status']='error';
              $message['message']='Something Went Wrong Please Try again.';
            }
        }
        echo json_encode($message);
    }

    public function admin_update_language(Request $request)
    {
        $message['status']='error';
        $message['message']='Invalid Request';
        if($request->ajax())
        {
            $created_date = date('Y-m-d H:i:s');
            $user_id=Auth::guard('admin')->user()->id;

            $validator = Validator::make($request->all(), [
              "update_language" => 'required|regex:/^[a-zA-Z0-9& ]+$/',
          ]);
  
          if ($validator->fails()) {
              return response()->json(['status'=>'errors','message'=>$validator->errors()]);
          }
  
            $oldstate = Language::find($request->languages_id);
            $clone = $oldstate->replicate();
      
            $params=[
              'language_name'=>$request->update_language,
              'status'=>$request->update_language_status,
              'updated_at'=> $created_date,
            ];
      
            $status = $oldstate->update($params);
      
            $newstate=$oldstate->getChanges();
            $changes = ' ID- '.$request->languages_id.' ';
      
            foreach($params as $key=> $para){
              if(isset($newstate[$key]) && isset($clone->$key)){
                   $changes .= $key.' Old Value '.$clone->$key.' New Value '.$para.' ';
              }
            }
      
            $st=Storehistory($user_id,'Language Master','Update',$changes);
            
            if($status)
            {
              $message['status']='success';
              $message['message']=' Successfully Update Language';
            }
            else
            {
              $message['status']='error';
              $message['message']='Something Went Wrong Please Try again.';
            }
        }
        echo json_encode($message);
    }

    public function admin_delete_language(Request $request)
    {
        $message['status']='error';
        $message['message']='Invalid Request';
        if($request->ajax())
        {
            if(!empty($request->languages_id) && $request->languages_id>0)
            {

                $user_id=Auth::guard('admin')->user()->id;

                $record=Language::find($request->languages_id);

				        $st=Storehistory($user_id,'Language Master','Delete',$record);

                $status = $record->delete();

                if($status)
                {
                  $message['status']='success';
                  $message['message']=' Successfully Delete languages name';
                }
                else
                {
                  $message['status']='error';
                  $message['message']='Something Went Wrong Please Try again.';
                }
            }
        }
        echo json_encode($message);
    }
    /*language end*/


    /*privileges start*/
    public function admin_add_user_privileges_view(Request $request)
    {
        $data['title'] = 'User Privileges';
        return view('admin.pages/master-user-privileges',$data);
    }
    /*privileges end*/


    /*payment gatway start*/
    public function admin_add_payment_gatway_view(Request $request)
    {
        $data['title'] = 'User Payment Gatway';
        return view('admin.pages/master-payment-gatway',$data);
    }
    /*payment gatway end*/


    /*documents start*/
    public function admin_documents_view(Request $request)
    {
        $data['title'] = 'Upload documents';
        $get_documents_qry = DB::table('document_category')->where('status','active')->get();
        if ($get_documents_qry)
        {
            $data['get_documents'] = $get_documents_qry;
        }
        return view('admin.pages/master-upload-documents',$data);
    }

    public function admin_add_document(Request $request)
    {
        $message['status']='error';
        $message['message']='Invalid Request';
        if($request->ajax())
        {
            $documentSampleName = time().'.'.$request->document_sample->extension();
            $request->document_sample->move(public_path('document_sample'), $documentSampleName);
            $created_date = date('Y-m-d H:i:s');
            $document_id = DB::table('document_category')->insertGetId([
              'title'=>$request->add_document,
              'description'=>$request->add_description,
              'required_document_sample'=>$documentSampleName,
              'created_by'=>'super_admin',
              'status'=>$request->document_status,
              'created_at'=> $created_date,
            ]);
            if($document_id>0)
            {
              $message['status']='success';
              $message['message']=' Successfully Add Document Category';
            }
            else
            {
              $message['status']='error';
              $message['message']='Something Went Wrong Please Try again.';
            }
        }
        echo json_encode($message);
    }

    public function admin_get_document(Request $request)
    {
        $message['status']='error';
        $message['message']='Invalid Request';
        if($request->ajax())
        {
            $get_document_qry = DB::table('document_category')->where('id',$request->document_id)->first();
            if($get_document_qry)
            {
              $message['status']='success';
              $message['message']=$get_document_qry;
            }
            else
            {
              $message['status']='error';
              $message['message']='Something Went Wrong Please Try again.';
            }
        }
        echo json_encode($message);
    }

    public function admin_update_document(Request $request)
    {
        $id = $request->id;
        $message['status']='error';
        $message['message']='Invalid Request';
        if($request->ajax())
        {
            if($request->update_document_sample)
            {
                $select_image_id = DB::table('document_category')->where('id',$request->document_id)->first();
                $file_name = $select_image_id->update_document_sample;
                $file_path = public_path('document_sample/'.$file_name);
                if(file_exists($file_path))
                {
                    unlink($file_path);
                    $documentSampleName = time().'.'.$request->required_document_sample->extension();
                    $request->update_document_sample->move(public_path('document_sample'), $documentSampleName);
                    $created_date = date('Y-m-d H:i:s');
                    $document_id = DB::table('document_category')->where('id', $request->document_id)->update([
                      'title'=>$request->update_document,
                      'description'=>$request->update_description,
                      'required_document_sample'=>$documentSampleName,
                      'status'=>$request->update_document_status,
                      'updated_at'=> $created_date,
                    ]);
                    if($document_id)
                    {
                      $message['status']='success';
                      $message['message']=' Successfully Add Document Category';
                    }
                    else
                    {
                      $message['status']='error';
                      $message['message']='Something Went Wrong Please Try again.';
                    }
                }
            }
            else
            {
                $select_image_id = DB::table('document_category')->where('id',$request->document_id)->first();
                $file_name = $select_image_id->required_document_sample;
                $created_date = date('Y-m-d H:i:s');
                $document_id = DB::table('document_category')->where('id', $request->document_id)->update([
                  'title'=>$request->update_document,
                  'description'=>$request->update_description,
                  'required_document_sample'=>$file_name,
                  'status'=>$request->update_document_status,
                  'updated_at'=> $created_date,
                ]);
                if($document_id)
                {
                  $message['status']='success';
                  $message['message']=' Successfully Add Document Category';
                }
                else
                {
                  $message['status']='error';
                  $message['message']='Something Went Wrong Please Try again.';
                }
            }
        }
    }

    public function admin_delete_document(Request $request)
    {
        $id = $request->id;
        $message['status']='error';
        $message['message']='Invalid Request';
        if($request->ajax())
        {
            $select_image_id = DB::table('document_category')->where('id',$request->document_id)->first();
            if ($select_image_id)
            {
              $file_name = $select_image_id->required_document_sample;
              $file_path = public_path('document_sample/'.$file_name);
              if(file_exists($file_path))
              {
                unlink($file_path);
                $delete_id = DB::table('document_category')->where('id', $request->document_id)->delete();
                if($delete_id>0)
                {
                  $message['status']='success';
                  $message['message']='Successfully Deleted';
                }
                else
                {
                  $message['status']='error';
                  $message['message']='Something Went Wrong Please Try again.';
                }
              }
            }
        }
        echo json_encode($message);
    }

    /*documents end*/
}