<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\News;
use App\Models\Offer;
use App\Models\TipOfTheDay;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\DB;

class PageManagementController extends Controller
{
    public function news_section_view(){
        $newsItems = News::all();
        return view('admin.pages.admin-home-news-section', ['newsItems' => $newsItems]);
    }
    public function add_news_section(Request $request){
        $message['status'] = 'error';
        $message['message'] = 'Invalid Request';
        if ($request->ajax()) {
            $validatedData = $request->validate([
                'description' => 'required|max:255',
                'link' => 'required|mimes:pdf',//|max:2048',
            ]);
            $news = new News();
            $news->description = $request->input('description');
            if ($request->hasFile('link')) {
                $file = $request->file('link');
                $fileName = time() . '.' . $file->getClientOriginalExtension();
                $file->move(public_path('front/assets/news_pdf'), $fileName);
                $news->link = $fileName;
            }
            $news->status = '1';
            if ($news->save()) {
                $message['status'] = 'success';
                $message['message'] = 'News added successfully';
            } else {
                $message['status'] = 'error';
                $message['message'] = 'Something went wrong. Please try again.';
            }
        }
        return response()->json($message);
    }

    public function change_news_status(Request $request){
        //dd($request->all());
        $message = [
            'status' => 'error',
            'message' => 'Invalid Request'
        ];
        if ($request->ajax()) {
            $newsId = $request->input('newsId');
            $status = $request->input('status');
            $news = News::find($newsId);
            if ($news) {
                $news->status = $status;
                if ($news->save()) {
                    $message['status'] = 'success';
                    $message['message'] = 'Status updated successfully';
                } else {
                    $message['status'] = 'error';
                    $message['message'] = 'Something went wrong. Please try again.';
                }
            }else{
                $message['message'] = 'News item not found.';
            }
        }
        return response()->json($message);
    }
    public function delete_news(Request $request){
        $message = [
            'status' => 'error',
            'message' => 'Failed to delete the news item.'
        ];
        if ($request->ajax()) {
            $newsId = $request->input('news_id');
            // Find the news item
            $news = News::find($newsId);
            if ($news) {
                $destinationPath = public_path('front/assets/news_pdf');
                if ($news->link) {
                    File::delete($destinationPath . '/' . $news->link);
                }
                $deleted=$news->delete();
                // Delete the news item
                if ($deleted) {
                    $message['status'] = 'success';
                    $message['message'] = 'News item deleted successfully.';
                } else {
                    $message['message'] = 'Failed to delete the news item. Please try again.';
                }
            } else {
                $message['message'] = 'News item not found.';
            }
        }
        return response()->json($message);
    }


    public function get_news(Request $request){
        $message = [
            'status' => 'error',
            'message' => 'Failed to fetch news item details.',
            'news' => null,
        ];

        if ($request->ajax()) {
            $newsId = $request->input('news_id');
            $news = News::find($newsId);

            if ($news) {
                $message['status'] = 'success';
                $message['news'] = $news;
            } else {
                $message['message'] = 'News item not found.';
            }
        }
        return response()->json($message);
    }


    public function updateNewsSection(Request $request){
        $message = [
            'status' => 'error',
            'message' => 'Failed to update the news item.',
        ];
        $validator = Validator::make($request->all(), [
            'description' => 'required|max:255',
        ]);
        if ($validator->fails()) {
            $errors = $validator->errors();
            $message['message'] = $errors->first();
        } else {
            $newsId = $request->input('news_id');
            $description = $request->input('description');
            $news = News::find($newsId);
            $link = $request->input('link');
            if ($request->hasFile('link')) {
                $uploadedFile = $request->file('link');
                $fileName = time() . '.' . $uploadedFile->getClientOriginalExtension();
                $destinationPath = public_path('front/assets/news_pdf');
                if ($news->link) {
                    File::delete($destinationPath . '/' . $news->link);
                }
                $uploadedFile->move($destinationPath, $fileName);
            }else {
                $fileName = $news->link;
            }
            if ($news) {
                $news->description = $description;
                $news->link = $fileName;
                $news->save();
                $message['status'] = 'success';
                $message['message'] = 'News item updated successfully.';
            } else {
                $message['message'] = 'News item not found.';
            }
        }
        return response()->json($message);
    }
    public function offer_section_view(){
        $offerItems = DB::table('offers')->get();
        return view('admin.pages.admin-home-offer-section', compact('offerItems'));
    }
    public function add_offer_section(Request $request){
        $message['status'] = 'error';
        $message['message'] = 'Invalid Request';

        if ($request->ajax()) {

            $validator = Validator::make($request->all(),[
                'title' => 'required|max:255|regex:/^[a-zA-Z0-9&,%_ ]+$/',
                'description' => 'required|max:255|regex:/^[a-zA-Z0-9&%_, ]+$/',
                'discount' => 'required|numeric',
                'exp_date' => 'required|date',
            ]);
            
            if($validator->fails())
            {
                return response()->json(array('status'=>'errors', 'message' => $validator->errors()));
            }

            $offer = new Offer(); // Replace 'News' with your actual model name
            $offer->title = $request->input('title');
            $offer->description = $request->input('description');
            $offer->discount = $request->input('discount');
            $offer->exp_date = $request->input('exp_date');
            $offer->status = '1';
            if ($offer->save()) {
                $message['status'] = 'success';
                $message['message'] = 'Offer added successfully';
            } else {
                $message['status'] = 'error';
                $message['message'] = 'Something went wrong. Please try again.';
            }
        }
        return response()->json($message);
    }

    public function change_offer_status(Request $request){
        $message = [
            'status' => 'error',
            'message' => 'Invalid Request'
        ];
        if ($request->ajax()) {
            $offerId = $request->input('offerId');
            $status = $request->input('status');
            $offer = Offer::find($offerId);
            if ($offer) {
                $offer->status = $status;
                if ($offer->save()) {
                    $message['status'] = 'success';
                    $message['message'] = 'Status updated successfully';
                } else {
                    $message['status'] = 'error';
                    $message['message'] = 'Something went wrong. Please try again.';
                }
            }else{
                $message['message'] = 'Offer item not found.';
            }
        }
        return response()->json($message);
    }
    public function delete_offer(Request $request){

        $message = [
            'status' => 'error',
            'message' => 'Failed to delete the news item.'
        ];

        if ($request->ajax()) {
            $offerId = $request->input('offerId');
            // Find the news item
            $offer = Offer::find($offerId);
            if ($offer) {
                // Delete the news item
                if ($offer->delete()) {
                    $message['status'] = 'success';
                    $message['message'] = 'Offer item deleted successfully.';
                } else {
                    $message['message'] = 'Failed to delete the offer item. Please try again.';
                }
            } else {
                $message['message'] = 'Offer item not found.';
            }
        }
        return response()->json($message);
    }

    public function get_offer(Request $request){
        $message = [
            'status' => 'error',
            'message' => 'Failed to fetch news item details.',
            'offer' => null,
        ];

        if ($request->ajax()) {
            $offerId = $request->input('offerId');
            $offer = Offer::find($offerId);
            if ($offer) {
                $message['status'] = 'success';
                $message['offer'] = $offer;
            } else {
                $message['message'] = 'Offer item not found.';
            }
        }
        return response()->json($message);
    }

    public function updateOfferSection(Request $request){
        $message = [
            'status' => 'error',
            'message' => 'Failed to update the offer item.',
        ];
        $validator = Validator::make($request->all(), [
            'title' => 'required|max:255|regex:/^[a-zA-Z0-9&,%_ ]+$/',
            'description' => 'required|max:255|regex:/^[a-zA-Z0-9&,%_ ]+$/',
            'discount' => 'required|numeric',
            'exp_date' => 'required|date',
        ]);
        if ($validator->fails()) {
            
            return response()->json(array('status'=>'errors', 'message' => $validator->errors()));

        } else {
            $offerId = $request->input('offer_id');
            $title = $request->input('title');
            $discount = $request->input('discount');
            $description = $request->input('description');
            $exp_date = $request->input('exp_date');
            $offer = Offer::find($offerId);
            if ($offer) {
                $offer->title = $title;
                $offer->discount = $discount;
                $offer->description = $description;
                $offer->exp_date = $exp_date;
                $offer->save();
                $message['status'] = 'success';
                $message['message'] = 'Offer item updated successfully.';
            } else {
                $message['message'] = 'Offer item not found.';
            }
        }
        return response()->json($message);
    }
    public function tod_section_view(){
        $todItems = TipOfTheDay::first();
        //dd($todItems);
        return view('admin.pages.admin-home-tod-section', ['todItems' => $todItems]);
    }

    public function change_tod_status(Request $request){
        $message = [
            'status' => 'error',
            'message' => 'Invalid Request'
        ];
        if ($request->ajax()) {
            $todId = $request->input('todId');
            $status = $request->input('status');
            $tod = TipOfTheDay::find($todId);
            if ($tod) {
                $tod->status = $status;
                if ($tod->save()) {
                    $message['status'] = 'success';
                    $message['message'] = 'Status updated successfully';
                } else {
                    $message['status'] = 'error';
                    $message['message'] = 'Something went wrong. Please try again.';
                }
            }else{
                $message['message'] = 'Item not found.';
            }
        }
        return response()->json($message);
    }
    public function get_tod(Request $request){
        $message = [
            'status' => 'error',
            'message' => 'Failed to fetch news item details.',
            'tod' => null,
        ];

        if ($request->ajax()) {
            $todId = $request->input('todId');
            $tod = TipOfTheDay::find($todId);
            if ($tod) {
                $message['status'] = 'success';
                $message['tod'] = $tod;
            } else {
                $message['message'] = 'Item not found.';
            }
        }
        return response()->json($message);
    }
    public function updateTodSection(Request $request){
        //dd($request->all());
        $validatedData = $request->validate([
            'title' => 'required|max:255',
            'description' => 'required|max:255',
            //'image' => 'required|image|mimes:jpeg,png,jpg|max:2048', // Adjust the image validation rules as needed
        ]);
        $tod_id = $request->input('tod_id');
        $tod = TipOfTheDay::find($tod_id);
        if (!$tod) {
            return response()->json([
                'status' => 'error',
                'message' => 'Data not found.',
            ]);
        }
        $tod->title = $validatedData['title'];
        $tod->description = $validatedData['description'];
        if ($request->hasFile('image')) {
            $uploadedFile = $request->file('image');
            $fileName = time() . '.' . $uploadedFile->getClientOriginalExtension();
            $destinationPath = public_path('front/assets/img');
            if ($tod->image) {
                File::delete($destinationPath . '/' . $tod->image);
            }
            $uploadedFile->move($destinationPath, $fileName);
        }else {
            $fileName = $tod->image;
        }
        $tod->image =$fileName;
        $tod->save();
        return response()->json([
            'status' => 'success',
            'message' => 'Offer updated successfully.',
        ]);
    }
}
