<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Mail\UserDocumentsApproved;
use App\Mail\UserDocumentsRejected;
use App\Models\User;
use App\Rules\ImageMaliciousDetectionRule;
use Carbon\Carbon;
use App\Models\EmailSetting;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;
use Validator;
use App\Library\EPP;
use App\Models\Zone;
use App\Models\DNS;
use App\Models\ServiceDiscount;
use App\Services\Formatters\BINDFormatter;
use Illuminate\Support\Facades\Storage;
// use \Mpdf\Mpdf as PDF;
use Barryvdh\DomPDF\Facade\Pdf;

use phpseclib3\Net\SFTP;
use App\Models\NameServerPrice;
use App\Models\DomainExt;
use App\Models\DomainPrice;
use App\Models\Misc;
use Dedicated\GoogleTranslate\Translator;
use App\Models\Server;
use Hash;
use Illuminate\Support\Str;
use App\Components\MailManager;

class WebSettingController extends Controller
{
    const BASEDIR = 'probind';

    const CONFIG_BASEDIR = self::BASEDIR . DIRECTORY_SEPARATOR . 'configuration';

    const ZONE_BASEDIR = self::BASEDIR . DIRECTORY_SEPARATOR . 'primary';

    public function admin_setting_view()
    {
        $data['title'] = 'Setting';
        $getSettingQry = DB::table('misc_settings')->first();
        if (!empty($getSettingQry)) {
            $data['getSettingData'] = $getSettingQry;
        } else {
            $data['getSettingData']['reactivation_price'] = '';
            $data['getSettingData']['hold_deduction_price'] = '';
            $data['getSettingData']['service_tax'] = '';
            $data['getSettingData']['dns_price'] = '';
            $data['getSettingData']['primary_dns_name'] = '';
            $data['getSettingData']['secondary_dns_name'] = '';
            $data['getSettingData']['account_number'] = '';
            $data['getSettingData']['branch_name'] = '';
            $data['getSettingData']['email'] = '';
            $data['getSettingData']['email_address_one'] = '';
            $data['getSettingData']['email_address_two'] = '';

            $data['getSettingData']['interface'] = '';
            $data['getSettingData']['hostname'] = '';
            $data['getSettingData']['port'] = '';
            $data['getSettingData']['userid'] = '';
            $data['getSettingData']['password'] = '';
            $data['getSettingData']['logging'] = '';
            $data['getSettingData']['certificatefile'] = '';
            $data['getSettingData']['certificatepassword'] = '';
            $data['getSettingData']['verifypeer'] = '';
            $data['getSettingData']['verifypeername'] = '';
            $data['getSettingData']['allowselfsigned'] = '';
            $data['getSettingData']['status'] = '';
            $data['getSettingData']['created_by'] = '';
        }
        return view('admin.pages/web-setting', $data);
    }

    public function rejectedexport1(Request $request)
    {
        $list = DB::table('users')->select('*')->where('users.document_status', 1);

        // Filters
        if (!empty($request->user_name)) {
            $list->where('users.domainName', 'LIKE', '%' . $request->user_name . '%');
        }

        if (!empty($request->institute_name)) {
            $list->where('users.institute', 'LIKE', '%' . $request->institute_name . '%');
        }

        if ($request->has('status')) {
            if ($request->status == '0') {

                $list->whereIn('users.domainStatus', [1, 2, 3, 4]);
            } elseif ($request->status == '1') {

                $list->where('users.domainStatus', 10);
            }
        }

        $data = $list->get();

        $i = 0;
        $records = array(
            array("Rejected Application List"),
            array(
                "S.NO.",
                "Domain Name",
                //"Period (in years)",
                'Institute Name',
                'Last Updated Date',
                'Domain Status'
            )
        );

        if ($data->isEmpty()) {
            return response()->json(['message' => 'No records found for the given filters.']);
        }

        foreach ($data as $row) {
            if ($row->domainStatus <= 4 && $row->document_status == 1) {
                $status = 'Doc Rejected - Registration Application';
            } elseif ($row->domainStatus == 10 && $row->document_status == 1) {
                $status = 'Doc Rejected - Renewal Application';
            } else {
                $status = 'Other';
            }

            $records[] = array(
                ++$i,
                $row->domainName,
                //$row->domainPeriod,
                $row->institute,
                date('d/m/Y', strtotime($row->created_at)),
                $status
            );
        }

        // Excel export
        $filename = "Rejected Application List-" . date('d-m-Y H:i:s a ') . ".xls";
        header("Content-Type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"$filename\"");

        foreach ($records as $record) {
            echo implode("\t", $record) . "\n";
        }

        exit;
    }

    public function activedomainexport(Request $request)
    {
        $domainStatus = $request->input('domainStatus');


        if (!in_array($domainStatus, [6, 7])) {
            return response()->json(['message' => 'Invalid domain status.']);
        }


        $list = DB::table('users')
            ->join('user_contact_details as ucd', 'ucd.user_id', '=', 'users.id')
            ->select('users.*', 'ucd.state')
            ->where('users.domainStatus', $domainStatus)
            ->where('users.domainLangId', 2);


        if (!empty($request->user_name)) {
            $list->where('users.domainName', 'LIKE', '%' . $request->user_name . '%');
        }

        if (!empty($request->institute_name)) {
            $list->where('users.institute', 'LIKE', '%' . $request->institute_name . '%');
        }

        if (!empty($request->state)) {
            $list->where('ucd.state', $request->state);
        }
        if ($request->has('domainLangIds') && ! empty($request->domainLangIds)) {
            $list->where('users.domainLangId',  $request->domainLangIds);
        }


        $data = $list->get();

        if ($data->isEmpty()) {
            return response()->json(['message' => 'No records found for the given filters.']);
        }


        $statusText = $domainStatus == 6 ? 'Active Domain' : 'Hold Domain';
        $filename = $statusText . " List-" . date('d-m-Y H:i:s a') . ".xls";

        $records = array(
            array($statusText . " List"),
            array(
                "S.NO.",
                "Domain Name",
                "Institute Name",
                "State",
                "Last Updated Date",
                "Domain Status"
            )
        );

        $i = 0;
        foreach ($data as $row) {
            $records[] = array(
                ++$i,
                $row->domainName,
                $row->institute,
                $row->state,
                date('d/m/Y', strtotime($row->created_at)),
                $statusText
            );
        }


        header("Content-Type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"$filename\"");

        $show_column = false;
        foreach ($records as $record) {
            if (!$show_column) {
                echo implode("\t", array_map('trim', $record)) . "\n";
                $show_column = true;
            } else {
                echo implode("\t", array_map('trim', $record)) . "\n";
            }
        }

        exit;
    }

    public function admin_add_settings2(Request $request)
    {
        $message['status'] = 'error';
        $message['message'] = 'Invalid Request';
        if ($request->ajax()) {
            $created_date = date('Y-m-d H:i:s');

            $user_id = Auth::guard('admin')->user()->id;

            $oldrecord = Misc::find(1);

            $clone = $oldrecord->replicate();

            $params = [
                'reactivation_price' => $request->reactivation_price,
                'hold_deduction_price' => $request->hold_deduction_price,
                'service_tax' => $request->service_tax,
                'email_address_one' => $request->email_address_one,
                'email_address_two' => $request->email_address_two,
                'email_address_optional' => $request->email_address_optional,
                'hold_domain_period' => $request->hold_domain_period,
                'restorable_domain_period' => $request->restorable_domain_period,
                'hold_domain_reminder_period' => $request->hold_domain_reminder_period,
                'restorable_domain_reminder_period' => $request->restorable_domain_reminder_period,
                'updated_at' => $created_date,
                'ewaas_free' => $request->ewaas_free,
                'ewaas_pergb' => $request->ewaas_pergb,
                'elmaas_free' => $request->elmaas_free,
                'elmaas_pergb' => $request->elmaas_pergb
            ];

            $status = $oldrecord->update($params);

            $newrecord = $oldrecord->getChanges();
            $changes = ' ';

            foreach ($params as $key => $para) {
                if (isset($newrecord[$key]) && isset($clone->$key)) {
                    $changes .= $key . ' Old Value ' . $clone->$key . ' New Value ' . $para . ' ';
                }
            }

            if ($changes != '') {
                $st = Storehistory($user_id, 'Misc. Settings', 'Update', $changes);
            }


            if ($status) {
                $message['status'] = 'success';
                $message['message'] = ' Setting has been updated successfully';
            } else {
                $message['status'] = 'error';
                $message['message'] = 'Something Went Wrong Please Try again.';
            }
        }
        echo json_encode($message);
    }

    public function admin_add_settings(Request $request)
    {
        $message['status'] = 'error';
        $message['message'] = 'Invalid Request';
        if ($request->ajax()) {
            $created_date = date('Y-m-d H:i:s');

            $user_id = Auth::guard('admin')->user()->id;

            $oldrecord = Misc::find(1);

            $clone = $oldrecord->replicate();

            $params = [
                'reactivation_price' => $request->reactivation_price,
                'hold_deduction_price' => $request->hold_deduction_price,
                'service_tax' => $request->service_tax,
                'email_address_one' => $request->email_address_one,
                'email_address_two' => $request->email_address_two,
                'email_address_optional' => $request->email_address_optional,
                'hold_domain_period' => $request->hold_domain_period,
                'restorable_domain_period' => $request->restorable_domain_period,
                'hold_domain_reminder_period' => $request->hold_domain_reminder_period,
                'restorable_domain_reminder_period' => $request->restorable_domain_reminder_period,
                'updated_at' => $created_date,
                'ewaas_free' => $request->ewaas_free,
                'ewaas_pergb' => $request->ewaas_pergb,
                'elmaas_free' => $request->elmaas_free,
                'elmaas_pergb' => $request->elmaas_pergb,
                'bulk_dns_discount' => $request->bulk_dns_discount,
                'bulk_domain_discount' => $request->bulk_domain_discount
            ];

            $status = $oldrecord->update($params);

            $newrecord = $oldrecord->getChanges();
            $changes = ' ';

            foreach ($params as $key => $para) {
                if (isset($newrecord[$key]) && isset($clone->$key)) {
                    $changes .= $key . ' Old Value ' . $clone->$key . ' New Value ' . $para . ' ';
                }
            }

            if ($changes != '') {
                $st = Storehistory($user_id, 'Misc. Settings', 'Update', $changes);
            }


            if ($status) {
                $message['status'] = 'success';
                $message['message'] = ' Setting has been updated successfully';
            } else {
                $message['status'] = 'error';
                $message['message'] = 'Something Went Wrong Please Try again.';
            }
        }
        echo json_encode($message);
    }

    public function extension_prices_ajaxcall(Request $request)
    {
        $draw = $request->get('draw');
        $start = $request->get("start");
        $rowperpage = $request->get("length");

        $columnIndex_arr = $request->get('order');
        $columnName_arr = $request->get('columns');
        $order_arr = $request->get('order');
        $search_arr = $request->get('search');

        $columnIndex = $columnIndex_arr[0]['column'];
        $columnName = $columnName_arr[$columnIndex]['data'];
        $columnSortOrder = $order_arr[0]['dir'];
        $searchValue = $search_arr['value'];

        $countData = DB::table('domain_extension_prices')->select('count(*) as allcount');

        if ($searchValue != null) {
            $countData->where('domain_extension_prices.year', 'like', '%' . $searchValue . '%');
        }


        $totalRecordswithFilter = $countData->count();
        $totalRecords = $totalRecordswithFilter;
        $records =
            DB::table('domain_extension_prices')->select('domain_extension_prices.*')
            ->skip($start)
            ->take($rowperpage)
            ->orderBy('domain_extension_prices.domain_extension_id', 'asc')
            ->orderBy('domain_extension_prices.year', 'asc');

        if ($searchValue != null) {
            $records->where('domain_extension_prices.year', 'like', '%' . $searchValue . '%');
        }

        $list = $records->get();

        $data_arr = array();

        foreach ($list as $sno => $record) {
            $id = $record->id;
            $code = '<a href="javascript:void(0);" style="border-bottom:dashed 1px #0088cc" class="view" data-id="' . $id . '">' . $id . '</a>';
            $edit = asset('icon/edit2.png');
            $delete = asset('icon/del.png');

            $action = '';

            $action = ' <a class="dropdown-items update" href="javascript:void(0);" style="float:left" data-id="' . $id . '"><i class="fa fa-edit fs-4"></i></a>
            <a class="dropdown-items delete-dns-price" href="javascript:void(0);" style="margin-left:10px;float:left" data-id="' . $id . '"><i class="fa fa-trash fs-4"></i></a>';

            $data_arr[] = array(
                "id" => ++$start,
                "ext" => $record->domain_extension_id == 2 ? "Hindi" : "English",
                "year" => $record->year,
                "price" => $record->price,
                "renewal_charge" => $record->renewal_charge,
                "Action" => $action
            );
        }

        $response = array(
            "draw" => intval($draw),
            "iTotalRecords" => $totalRecords,
            "iTotalDisplayRecords" => $totalRecordswithFilter,
            "aaData" => $data_arr
        );

        echo json_encode($response);
        exit;
    }


    public function admin_add_setting_byemail(Request $request)
    {

        $message['status'] = 'success';
        $message['message'] = 'Invalid Request';

        $created_date = date('Y-m-d H:i:s');

        $product_id = DB::table('misc_settings')->updateOrInsert(
            [
                'id' => 1,
            ],
            [
                'email_90days' => $request->email_90days,
                'email_60days' => $request->email_60days,
                'email_45days' => $request->email_45days,
                'email_30days' => $request->email_30days,
                'email_15days' => $request->email_15days,
                'email_7days' => $request->email_7days,
                'email_hold' => $request->email_hold,
                'email_restorable' => $request->email_restorable,
                'email_delete' => $request->email_delete,
                'email_registered' => $request->email_registered,
                'email_renewed' => $request->email_renewed,
                'email_clarification' => $request->email_clarification,
                'email_approved' => $request->email_approved,
                'email_nameserver' => $request->email_nameserver,
                'reminder_fresh_final' => $request->reminder_fresh_final,
                'delete_payment_pending' => $request->delete_payment_pending,
                'pending_restore_reminders' => $request->pending_restore_reminders,
                'domain_hold_reminders' => $request->domain_hold_reminders,
                'doc_rejection_reminders' => $request->doc_rejection_reminders,
                'reminder_mail' => $request->reminder_mail,
                'deleted_mail' => $request->deleted_mail,
                'renewal_application_mail' => $request->renewal_application_mail
            ]
        );
        if ($product_id > 0) {
            $message['status'] = 'success';
            $message['message'] = ' Setting has been updated successfully';
        } else {
            $message['status'] = 'success';
            $message['message'] = 'Something Went Wrong Please Try again.';
        }

        echo json_encode($message);
    }

    public function admin_dns_details_view()
    {
        $data['title'] = 'DNS Details';
        $getSettingQry = DB::table('ernet_name_servers')->first();
        $dnsPrice = DB::table('ernet_name_servers_prices')->where('ernet_name_server_id', '=', $getSettingQry->id)->orderBy('years', 'asc')->get();
        if (!empty($getSettingQry)) {
            $data['getDNSData'] = $getSettingQry;
            $data['getDNSPrice'] = $dnsPrice;
        } else {
            $data['getDNSData']['primary_name_server'] = '';
            $data['getDNSData']['secondary_name_server'] = '';
        }
        return view('admin.pages/dns-setting', $data);
    }
    public function admin_dns_details_add(Request $request)
    {
        $message['status'] = 'error';
        $message['message'] = 'Invalid Request';

        $validator = Validator::make($request->all(), [
            'primary_name_server' => 'required|regex:/^[a-zA-Z0-9.]+$/',
        ]);
        if ($validator->fails()) {
            $message['status'] = 'error';
            $message['message'] = 'Invalid Value.';
        } else {

            if ($request->ajax()) {
                $created_date = date('Y-m-d H:i:s');

                $oldrecord = DNS::find(1);
                $clone = $oldrecord->replicate();
                $user_id = Auth::guard('admin')->user()->id;
                $params = [
                    "primary_name_server" => $request->input('primary_name_server'),
                    "secondary_name_server" => json_encode($request->input('secondary_name_server')),
                    'updated_at' => $created_date,
                ];

                $status = $oldrecord->update($params);

                $newrecord = $oldrecord->getChanges();
                $changes = '';

                foreach ($params as $key => $para) {
                    if (isset($newrecord[$key]) && isset($clone->$key)) {
                        $changes .= $key . ' Old Value ' . $clone->$key . ' New Value ' . $para . ' ';
                    }
                }

                if ($changes != '') {
                    $st = Storehistory($user_id, 'DNS Name Server', 'Update', $changes);
                }

                if ($status) {
                    $message['status'] = 'success';
                    $message['message'] = ' Successfully';
                } else {
                    $message['status'] = 'error';
                    $message['message'] = 'Invalid Value.';
                }
            }
        }

        echo json_encode($message);
    }
    public function admin_dns_price_add(Request $request)
    {
        // $validator = Validator::make($request->all(), [
        //     'years' => 'required|numeric|unique:ernet_name_servers_prices',
        //     'price' => 'required|numeric',
        //     'vas_price' => 'required|numeric',
        //     'lmaas_price' => 'required|numeric'
        // ]);
        // if ($validator->fails()) {
        //     return response()->json(['status' => false, 'error' => $validator->errors()->first()]);
        // }
        // $message['status'] = 'error';
        // $message['message'] = 'Invalid Request';
        // if ($request->ajax()) {
        //     $ernet_server = DB::table('ernet_name_servers')->first();
        //     if ($ernet_server == null) {
        //         $message['message'] = 'Add Server Name First';
        //         return $message;
        //     }

        //     $created_date = date('Y-m-d H:i:s');
        //     $data = [
        //         "years" => $request->input('years'),
        //         "price" => $request->input('price'),
        //         "vas_price" => $request->input('vas_price'),
        //         "lmaas_price" => $request->lmaas_price,
        //         "ernet_name_server_id" => $ernet_server->id,
        //         'updated_at' => $created_date,
        //     ];
        //     $status = DB::table('ernet_name_servers_prices')
        //         ->updateOrInsert(
        //             ['years' => $request->input('years')],
        //             $data
        //         );
        //     if ($status) {
        //         $message['status'] = 'success';
        //         $message['message'] = ' Successfully';
        //     } else {
        //         $message['status'] = 'error';
        //         $message['message'] = 'Something Went Wrong Please Try again.';
        //     }
        // }
        // echo json_encode($message);

        $validator = Validator::make($request->all(), [
            'years' => 'required|numeric|unique:ernet_name_servers_prices',
            'price' => 'required|numeric',
            'vas_price' => 'required|numeric',
            'lmaas_price' => 'required|numeric'
        ]);
        if ($validator->fails()) {
            return response()->json(['status' => false, 'error' => $validator->errors()->first()]);
        }
        $message['status'] = 'error';
        $message['message'] = 'Invalid Request';
        if ($request->ajax()) {
            $ernet_server = DB::table('ernet_name_servers')->first();
            if ($ernet_server == null) {
                $message['message'] = 'Add Server Name First';
                return $message;
            }

            $created_date = date('Y-m-d H:i:s');
            $data = [
                "years" => $request->input('years'),
                "price" => $request->input('price'),
                "vas_price" => $request->input('vas_price'),
                "lmaas_price" => $request->lmaas_price,
                "ernet_name_server_id" => $ernet_server->id,
                'updated_at' => $created_date,
                'name_servers_price_renewal_charge' => $request->input('dns_charge'),
                'ewaas_price_renewal_charge' => $request->input('waas_charge'),
                'lmaas_price_renewal_charge' => $request->input('lmaas_charge'),
            ];
            $status = DB::table('ernet_name_servers_prices')
                ->updateOrInsert(
                    ['years' => $request->input('years')],
                    $data
                );
            if ($status) {
                $message['status'] = 'success';
                $message['message'] = ' Successfully';
            } else {
                $message['status'] = 'error';
                $message['message'] = 'Something Went Wrong Please Try again.';
            }
        }
        echo json_encode($message);
    }
    public function admin_dns_price_update(Request $request)
    {

        // $validator = Validator::make($request->all(), [
        //     'years' => 'required|numeric',
        //     'price' => 'required|numeric',
        //     'vas_price' => 'required|numeric',
        //     'lmaas_price' => 'required|numeric'
        // ]);
        // if ($validator->fails()) {
        //     return response()->json(['status' => false, 'error' => $validator->errors()->first()]);
        // }

        // $message['status'] = 'error';
        // $message['message'] = 'Invalid Request';
        // if ($request->ajax()) {
        //     $created_date = date('Y-m-d H:i:s');
        //     $oldrecord = NameServerPrice::find($request->input('price_id'));
        //     $clone = $oldrecord->replicate();
        //     $user_id = Auth::guard('admin')->user()->id;

        //     $params = [
        //         "years" => $request->input('years'),
        //         "price" => $request->input('price'),
        //         "vas_price" => $request->input('vas_price'),
        //         "lmaas_price" => $request->lmaas_price,
        //         'updated_at' => $created_date,
        //     ];

        //     $status = $oldrecord->update($params);

        //     $newrecord = $oldrecord->getChanges();
        //     $changes = 'ID-' . $request->input('price_id') . ' ';

        //     foreach ($params as $key => $para) {
        //         if (isset($newrecord[$key]) && isset($clone->$key)) {
        //             $changes .= $key . ' Old Value ' . $clone->$key . ' New Value ' . $para . ' ';
        //         }
        //     }

        //     if ($changes != '') {
        //         $st = Storehistory($user_id, 'Name Server Prices', 'Update', $changes);
        //     }

        //     if ($status) {
        //         $message['status'] = 'success';
        //         $message['message'] = ' Successfully';
        //     } else {
        //         $message['status'] = 'error';
        //         $message['message'] = 'Something Went Wrong Please Try again.';
        //     }
        // }
        // echo json_encode($message);

        $validator = Validator::make($request->all(), [
            'years' => 'required|numeric',
            'price_id' => 'required|numeric|exists:ernet_name_servers_prices,id',
            'price' => 'required|numeric',
            'vas_price' => 'required|numeric',
            'lmaas_price' => 'required|numeric',
            'r_dns_charge' => 'required|numeric',
            'r_waas_charge' => 'required|numeric',
            'r_lmaas_charge' => 'required|numeric',
        ]);

        if ($validator->fails()) {
            return response()->json(['status' => false, 'error' => $validator->errors()->first()]);
        }

        $message = [
            'status' => 'error',
            'message' => 'Invalid Request'
        ];

        if ($request->ajax()) {
            $created_date = now();
            $oldrecord = NameServerPrice::find($request->input('price_id'));

            if (!$oldrecord) {
                return response()->json([
                    'status' => 'error',
                    'message' => 'Record not found.'
                ]);
            }

            $clone = $oldrecord->replicate();
            $user_id = Auth::guard('admin')->user()->id;

            $params = [
                "years" => $request->input('years'),
                "price" => $request->input('price'),
                "vas_price" => $request->input('vas_price'),
                "lmaas_price" => $request->input('lmaas_price'),
                'updated_at' => $created_date,
                'name_servers_price_renewal_charge' => $request->input('r_dns_charge'),
                'ewaas_price_renewal_charge' => $request->input('r_waas_charge'),
                'lmaas_price_renewal_charge' => $request->input('r_lmaas_charge'),
            ];

            $status = $oldrecord->update($params);


            $newrecord = $oldrecord->getChanges();
            $changes = 'ID-' . $request->input('price_id') . ' ';

            foreach ($params as $key => $para) {
                if (isset($newrecord[$key]) && isset($clone->$key)) {
                    $changes .= $key . ' Old Value: ' . $clone->$key . ' New Value: ' . $para . '. ';
                }
            }

            if (!empty($changes)) {
                Storehistory($user_id, 'Name Server Prices', 'Update', $changes);
            }

            if ($status) {
                $message['status'] = 'success';
                $message['message'] = 'Updated Successfully';
            } else {
                $message['status'] = 'error';
                $message['message'] = 'Something Went Wrong. Please Try Again.';
            }
        }

        return response()->json($message);
    }
    public function admin_get_price_data(Request $request)
    {
        $data['status'] = 'error';
        $data['price'] = '';
        $price =  DB::table('ernet_name_servers_prices')->where('id', '=', $request->input('price_id'))->first();
        if ($price != null) {
            $data['status'] = 'success';
            $data['price'] = $price;
        }
        return $data;
    }
    public function admin_dns_price_delete(Request $request)
    {
        $message['status'] = 'error';
        $message['message'] = 'Invalid Request';

        if (!empty($request->price_id) && $request->price_id > 0) {

            $user_id = Auth::guard('admin')->user()->id;

            $record = NameServerPrice::find($request->price_id);

            $st = Storehistory($user_id, 'Name Server Price', 'Delete', $record);

            $status = $record->delete();

            if ($status) {
                $message['status'] = 'success';
                $message['message'] = ' Successfully Delete Domain Price';
            } else {
                $message['status'] = 'error';
                $message['message'] = 'Something Went Wrong Please Try again.';
            }
        }
        echo json_encode($message);
    }

    public function admin_domain_price_setting_view()
    {
        $data['title'] = 'Price Setting';
        $data['domain_extensions'] = DB::table('domain_extensions')->get();
        $data['domain_extension_prices'] = DB::table('domain_extension_prices')->select('domain_extension_prices.*', 'domain_extensions.domain_extension')
            ->join('domain_extensions', 'domain_extension_prices.domain_extension_id', '=', 'domain_extensions.id')
            ->orderBy('domain_extension_prices.domain_extension_id', 'desc')
            ->get();

        return view('admin.pages/domain-extension-price-setting', $data);
    }

    public function admin_add_domain_price_setting(Request $request)
    {
        $message['status'] = 'error';
        $message['message'] = 'Invalid Request';
        if ($request->ajax()) {

            $validator = Validator::make($request->all(), [
                "years" => 'required|numeric',
                "price" => 'required|numeric',
            ]);

            if ($validator->fails()) {
                return response()->json(['status' => 'errors', 'message' => $validator->errors()]);
            }

            $created_date = date('Y-m-d H:i:s');
            if ($request->input('price_id') != null) {

                $user_id = Auth::guard('admin')->user()->id;

                $oldrecord = DomainPrice::find($request->input('price_id'));
                $clone = $oldrecord->replicate();

                $params = [
                    'year' => $request->input('years'),
                    'price' => $request->input('price'),
                    'renewal_charge' => $request->input('renewal_charge'),
                    'updated_at' => $created_date,
                    'domain_extension_id' => $request->input('domain_extension')
                ];

                $status = $oldrecord->update($params);

                $newrecord = $oldrecord->getChanges();
                $changes = 'ID- ' . $request->input('price_id') . ' ';

                foreach ($params as $key => $para) {
                    if (isset($newrecord[$key]) && isset($clone->$key)) {
                        $changes .= $key . ' Old Value ' . $clone->$key . ' New Value ' . $para . ' ';
                    }
                }

                if ($changes != '') {
                    $st = Storehistory($user_id, 'Domain Extension Prices', 'Update', $changes);
                }
            } else {
                $status = DB::table('domain_extension_prices')
                    ->updateOrInsert(
                        [
                            'id' => $request->input('price_id'),
                        ],
                        [
                            'year' => $request->input('years'),
                            'price' => $request->input('price'),
                            'renewal_charge' => $request->input('renewal_charge'),
                            'updated_at' => $created_date,
                            'domain_extension_id' => $request->input('domain_extension')
                        ]
                    );
            }
            if ($status) {
                $message['status'] = 'success';
                $message['message'] = ' Successfully';
            } else {
                $message['status'] = 'error';
                $message['message'] = 'Something Went Wrong Please Try again.';
            }
        }
        echo json_encode($message);
    }


    public function admin_get_domain_price(Request $request)
    {
        $domain_price_id = $request->input('price_id');
        if (!empty($domain_price_id) && $domain_price_id > 0) {
            $message['status'] = 'error';
            $message['message'] = 'Invalid Request';
            if ($request->ajax()) {
                $get_domain_price_qry = DB::table('domain_extension_prices')->where('id', $domain_price_id)->first();
                if (!empty($get_domain_price_qry)) {
                    $message['price'] = $get_domain_price_qry;
                    $message['status'] = 'success';
                } else {
                    $message['status'] = 'error';
                    $message['message'] = 'Something Went Wrong Please Try again.';
                }
            }
            echo json_encode($message);
        }
    }

    public function admin_delete_domain_price(Request $request)
    {
        if ($request->ajax()) {
            if (!empty($request->domain_price_id) && $request->domain_price_id > 0) {


                $user_id = Auth::guard('admin')->user()->id;

                $record = DomainPrice::find($request->domain_price_id);

                $st = Storehistory($user_id, 'Domain Extension Prices', 'Delete', $record);

                $status = $record->delete();

                if ($status) {
                    $message['status'] = 'success';
                    $message['message'] = ' Successfully Delete Domain Price';
                } else {
                    $message['status'] = 'error';
                    $message['message'] = 'Something Went Wrong Please Try again.';
                }
            }
        }
        echo json_encode($message);
    }

    public function admin_domain_extension_view()
    {
        $data['title'] = 'Domain Extension';
        $get_domain_main_data_qry = DB::table('domain_main_category')->get();
        $get_domain_languages_data_qry = DB::table('domain_languages')->get();
        $get_domain_doc_data_qry = DB::table('document_category')->get();

        $domain_extension_data_qry = DB::table('domain_extensions')->orderBy('id', 'desc')->get();
        $data['get_domain_main_data'] = $get_domain_main_data_qry;
        $data['get_domain_languages_data'] = $get_domain_languages_data_qry;
        $data['domain_extension_data'] = $domain_extension_data_qry;
        $data['get_domain_doc_data'] = $get_domain_doc_data_qry;

        return view('admin.pages/domain-extensions', $data);
    }

    public function add_domain_ext()
    {

        $get_domain_main_data_qry = DB::table('domain_main_category')->get();
        $get_domain_languages_data_qry = DB::table('domain_languages')->get();
        $get_domain_doc_data_qry = DB::table('document_category')->get();

        $data['get_domain_main_data'] = $get_domain_main_data_qry;
        $data['get_domain_languages_data'] = $get_domain_languages_data_qry;
        $data['get_domain_doc_data'] = $get_domain_doc_data_qry;

        return view('admin.pages/add-domain', $data);
    }

    public function domain_ext_data(Request $request)
    {

        $id = $request->id;
        $departmentObj = DB::table('domain_extensions')->where('id', $id)->first();

        return response()->json(array('status' => 'success', 'data' => $departmentObj));
    }

    public function edit_domain_ext($id)
    {

        $get_domain_main_data_qry = DB::table('domain_main_category')->get();
        $get_domain_languages_data_qry = DB::table('domain_languages')->get();
        $get_domain_doc_data_qry = DB::table('document_category')->get();
        $dom_exts = DB::table('domain_extensions')->where('id', $id)->first();


        $data['id'] = $id;
        $data['get_domain_main_data'] = $get_domain_main_data_qry;
        $data['get_domain_languages_data'] = $get_domain_languages_data_qry;
        $data['get_domain_doc_data'] = $get_domain_doc_data_qry;
        $data['dom_exts'] = $dom_exts;

        return view('admin.pages/edit-domain', $data);
    }

    public function domain_ext(Request $request)
    {

        try {
            if ($request->isMethod('post')) {
                $params = $request->all();

                $allow = $request->allow_ids;
                $main = $request->main;
                $doc = $request->doc_ids;

                $new_array = [];

                $itemArray = array();
                $allowArray = array();
                $mainArray = array();

                foreach ($doc as $key =>  $value) {
                    $itemArray[] = $value;
                }

                foreach ($allow as $key =>  $value) {
                    $allowArray[] = $value;
                }

                foreach ($main as $key =>  $value) {
                    $mainArray[] = $value;
                }

                $new_array['doc_ids'] = $itemArray;
                $new_array['allow'] = $allowArray;
                $new_array['maindatory'] = $mainArray;

                $params = [
                    'domain_main_category_id' => $request->main_category,
                    'domain_language_id' => $request->regional_languages,
                    'domain_extension' => $request->domain_extensions,
                    'status' => $request->domain_status,
                    'doc_ids' => json_encode($new_array)
                ];

                $status = DB::table('domain_extensions')->insert($params);

                if ($status) {
                    return response()->json(array('status' => 'success'));
                }

                return response()->json(array('status' => 'error', 'error' => 'Something Wrong'));
            }

            return redirect('home')->with('error', 'Not valid');
        } catch (\Throwable $e) {
            $error = $e->getMessage() . ', File Path = ' . $e->getFile() . ', Line Number = ' . $e->getLine();
            return response()->json(array('status' => 'exceptionError', 'error' => $error));
        }
    }

    public function admin_add_domain_extension(Request $request)
    {
        $message['status'] = 'error';
        $message['message'] = 'Invalid Request';

        if ($request->ajax()) {
            $extension_id = 0;

            $docid = ($request->input('doc_ids') != null) ? implode(',', $request->input('doc_ids')) : '';

            $validator = Validator::make($request->all(), [
                "main_category" => 'required|numeric',
                "regional_languages" => 'required|numeric',
                "domain_extensions" => 'required',
            ]);
            if ($validator->fails()) {
                return response()->json(['status' => 'errors', 'message' => $validator->errors()]);
            }

            if ($request->has('ext_id')) {

                $extension_id = ($request->input('ext_id') != null) ? $request->input('ext_id') : 0;

                $user_id = Auth::guard('admin')->user()->id;

                $oldrecord = DomainExt::find($extension_id);
                $clone = $oldrecord->replicate();

                $params = [
                    'domain_main_category_id' => $request->main_category,
                    'domain_language_id' => $request->regional_languages,
                    'domain_extension' => $request->domain_extensions,
                    'status' => $request->domain_status,
                    'doc_ids' => $docid
                ];

                $status = $oldrecord->update($params);

                $newrecord = $oldrecord->getChanges();
                $changes = 'ID- ' . $extension_id . ' ';

                foreach ($params as $key => $para) {
                    if (isset($newrecord[$key]) && isset($clone->$key)) {
                        $changes .= $key . ' Old Value ' . $clone->$key . ' New Value ' . $para . ' ';
                    }
                }

                if ($changes != '') {
                    $st = Storehistory($user_id, 'Domain Extension', 'Update', $changes);
                }
            } else {


                $status = DB::table('domain_extensions')
                    ->insert(
                        [
                            'domain_main_category_id' => $request->main_category,
                            'domain_language_id' => $request->regional_languages,
                            'domain_extension' => $request->domain_extensions,
                            'status' => $request->domain_status,
                            'doc_ids' => $docid
                        ]
                    );
            }

            if ($status) {
                $message['status'] = 'success';
                $message['message'] = ' Successfully';
            } else {
                $message['status'] = 'error';
                $message['message'] = 'Something Went Wrong Please Try again.';
            }
        }
        echo json_encode($message);
    }

    public function admin_get_domain_extension_data(Request $request)
    {
        $id = $request->id;

        if ($id > 0) {
            $message['status'] = 'error';
            $message['message'] = 'Invalid Request';
            if ($request->ajax()) {
                $qry = DB::table('domain_extensions')->where('id', $id)->first();
                $paids = explode(',', $qry->doc_ids);

                $qry->domain_main_category_list = DB::table('domain_main_category')->get();
                $qry->domain_languages_list = DB::table('domain_languages')->get();
                if ($qry) {
                    $message['status'] = 'success';
                    $message['message'] = $qry;
                    $message['pa'] = $paids;
                } else {
                    $message['status'] = 'error';
                    $message['message'] = 'Something Went Wrong Please Try again.';
                }
            }
            echo json_encode($message);
        }
    }

    public function admin_delete_domain_extension_data(Request $request)
    {
        $message['status'] = 'error';
        $message['message'] = 'Invalid Request';
        if ($request->ajax()) {
            if (!empty($request->domain_cat_id) && $request->domain_cat_id > 0) {

                $user_id = Auth::guard('admin')->user()->id;

                $record = DomainExt::find($request->domain_cat_id);

                $st = Storehistory($user_id, 'Domain Extension', 'Delete', $record);

                $status = $record->delete();

                if ($status) {
                    $message['status'] = 'success';
                    $message['message'] = ' Successfully Delete';
                } else {
                    $message['status'] = 'error';
                    $message['message'] = 'Something Went Wrong Please Try again.';
                }
            }
        }
        echo json_encode($message);
    }

    public function admin_user_view()
    {
        $data['title'] = 'Admin Users';
        $get_admin_privilege_qry = DB::table('admin_type')->where('status', 'active')->get();
        $get_admin_user_list_qry = DB::table('admin_privilege')->where('status', 'active')->select('id', 'name', 'user_name', 'email', 'roal')->orderBy('id', 'asc')->get();
        if ($get_admin_privilege_qry) {
            $data['get_admin_privilege_data'] = $get_admin_privilege_qry;
        }
        if ($get_admin_user_list_qry) {
            $data['admin_user_list_data'] = $get_admin_user_list_qry;
        }
        return view('admin.pages/admin-user', $data);
    }

    public function admin_user(Request $request)
    {
        $message['status'] = 'error';
        $message['message'] = 'Invalid Request';
        if ($request->ajax()) {
            $created_date = date('Y-m-d H:i:s');
            $product_id = DB::table('admin_privilege')->insertGetId([
                'name' => $request->add_name,
                'user_name' => $request->add_user_name,
                'password' => encrypt($request->add_user_password),
                'email' => $request->add_user_email,
                'roal' => $request->add_user_role,
                'status' => 'active',
                'created_by' => 'super_admin',
                'created_at' => $created_date,
            ]);
            if ($product_id > 0) {
                $message['status'] = 'success';
                $message['message'] = ' Successfully';
            } else {
                $message['status'] = 'error';
                $message['message'] = 'Something Went Wrong Please Try again.';
            }
        }
        echo json_encode($message);
    }

    public function admin_get_user_privilege(Request $request)
    {
        $privilege_id = $request->privilege_id;
        if (!empty($privilege_id) && $privilege_id > 0) {
            $message['status'] = 'error';
            $message['message'] = 'Invalid Request';
            if ($request->ajax()) {
                $admin_privilege_qry = DB::table('admin_privilege')->where('id', $privilege_id)->first();
                if (!empty($admin_privilege_qry)) {
                    $data['privilege'] = $admin_privilege_qry;
                    $message['status'] = 'success';
                    $message['message'] = $data;
                } else {
                    $message['status'] = 'error';
                    $message['message'] = 'Something Went Wrong Please Try again.';
                }
            }
            echo json_encode($message);
        }
    }

    public function admin_upadate_user_privilege(Request $request)
    {
        $message['status'] = 'error';
        $message['message'] = 'Invalid Request';
        if ($request->ajax()) {
            if ($request->update_user_id > 0) {
                $updated_date = date('Y-m-d H:i:s');
                $affected_domain_price = DB::table('admin_privilege')->where('id', $request->update_user_id)->update([
                    /*'options->enabled' => $request->,*/
                    'name' => $request->update_name,
                    'user_name' => $request->update_user_name,
                    'email' => $request->update_user_email,
                    'roal' => $request->update_user_role,
                    'updated_at' => $updated_date,
                ]);
                if ($affected_domain_price) {
                    $message['status'] = 'success';
                    $message['message'] = ' Successfully Update Privilege';
                } else {
                    $message['status'] = 'error';
                    $message['message'] = 'Something Went Wrong Please Try again.';
                }
            } else {
                $message['status'] = 'error';
                $message['message'] = 'Something Went Wrong Please Try again.';
            }
        }
        echo json_encode($message);
    }

    public function admin_delete_user_privilege(Request $request)
    {
        $message['status'] = 'error';
        $message['message'] = 'Invalid Request';
        if ($request->ajax()) {
            if (!empty($request->privilege_id) && $request->privilege_id > 0) {
                $deleted_domain_price = DB::table('admin_privilege')->where('id', $request->privilege_id)->delete();
                if ($deleted_domain_price) {
                    $message['status'] = 'success';
                    $message['message'] = ' Successfully Delete';
                } else {
                    $message['status'] = 'error';
                    $message['message'] = 'Something Went Wrong Please Try again.';
                }
            }
        }
        echo json_encode($message);
    }

    public function admin_find_users_details_view_old(Request $request)
    {

        $data['title'] = 'Find Users Details';
        #$data['domainStatus']=8;
        $data['domainStatus'] = '';
        $Query = DB::table('users');
        if ($request->has('name') && ! empty($request->name)) {
            $Query->where('users.name', 'LIKE', '%' . $request->name . '%');
        }
        if ($request->has('user_name') && ! empty($request->user_name)) {
            $Query->where('users.domainName', 'LIKE', '%' . $request->user_name . '%');
        }
        if ($request->has('institute_name') && ! empty($request->institute_name)) {
            $Query->where('users.institute', 'LIKE', '%' . $request->institute_name . '%');
        }
        if ($request->has('domainLangID') && ! empty($request->domainLangID)) {
            $Query->where('users.domainLangID',  $request->domainLangID);
        }
        if ($request->has('status') && ! empty($request->status)) {
            $Query->where('users.status', $request->status);
        }
        if ($request->has('lang') && ! empty($request->lang)) {
            $lang = DB::table('domain_languages')->where('lang_code', $request->lang)->first();
            $Query->where('users.domainLangID', $lang->id);
        }
        if ($request->has('domainStatus') && ! empty($request->domainStatus)) {
            if ($request->domainStatus == 2) {
                $Query->whereIn('users.domainStatus', [1, 2, 3, 4]);
                $Query->where('users.clarify', 0);
            } elseif ($request->domainStatus == 6) {
                $Query->whereIn('users.domainStatus', [6, 10]);
            } else {
                $Query->where('users.domainStatus', $request->domainStatus);
            }
            $data['domainStatus'] = $request->domainStatus;
        }

        if ($request->has('domainStatu') && ! empty($request->domainStatu)) {
            if ($request->domainStatu == 2) {
                $Query->whereIn('users.domainStatus', [1, 2, 3, 4]);
                $Query->where('users.clarify', 0);
            } elseif ($request->domainStatu == 6) {
                $Query->whereIn('users.domainStatus', [6, 10]);
            } else {
                $Query->where('users.domainStatus', $request->domainStatu);
            }
        }

        if ($request->creation_start_date != '' && $request->creation_end_date != '') {
            $start_date = Carbon::parse($request->creation_start_date);
            $end_date = Carbon::parse($request->creation_end_date);
            $Query->whereBetween('users.created_at', [$start_date->format('Y-m-d') . " 00:00:00", $end_date->format('Y-m-d') . " 23:59:59"]);
        }
        $data['creation_start_date'] = $request->creation_start_date;
        $data['creation_end_date'] = $request->creation_end_date;

        if ($request->expiry_start_date != '' && $request->expiry_end_date != '') {
            $start_date = Carbon::parse($request->expiry_start_date);
            $end_date = Carbon::parse($request->expiry_end_date);
            $Query->whereBetween('users.domainExpiryDate', [$start_date->format('Y-m-d') . " 00:00:00", $end_date->format('Y-m-d') . " 23:59:59"]);
        }
        $data['expiry_start_date'] = $request->expiry_start_date;
        $data['expiry_end_date'] = $request->expiry_end_date;

        $pagetext = 'Find Domain';

        if ($request->has('domaintext') && ! empty($request->domaintext)) {
            $pagetext = $request->domaintext;
        }

        if ($request->has('domaintext') && $request->domaintext == 'Rejected') {
            $data['domaintext'] = 'Rejected';
        }

        if ($request->has('domaintext') && $request->domaintext == 'No Zone Record') {
            $pagetext = 'Pending ERNET DNS Records';
            $Query->where('users.zone_file', 0)
                ->where('user_name_servers.server_type', 1)->join('user_name_servers', 'user_name_servers.user_id', 'users.id')
                ->select('users.*', 'user_name_servers.server_type', 'user_name_servers.user_id');
        }

        if ($request->has('domaintext') && $request->domaintext == 'Active ERNET DNS') {
            $pagetext = 'Active ERNET DNS';
            $Query
                ->whereIn('users.domainStatus', [6, 7, 8, 10])
                ->where('user_name_servers.server_type', 1)->join('user_name_servers', 'user_name_servers.user_id', 'users.id')
                ->select('users.*', 'user_name_servers.server_type', 'user_name_servers.user_id');
        }

        if ($request->has('domaintext') && $request->domaintext == 'Without DNS') {
            $pagetext = 'Without DNS';
            $Query->where('user_name_servers.server_type', '')->join('user_name_servers', 'user_name_servers.user_id', 'users.id');
        }

        if ($request->has('domaintext') && $request->domaintext == 'Cooling Period') {

            $pagetext = 'Cooling Period List';
            $Query->whereRaw('DATEDIFF(CURRENT_DATE, DomainExpiryDate) > 69')
                ->whereRaw('DATEDIFF(CURRENT_DATE, DomainExpiryDate) < 75')
                ->select('*');
        }

        $Query->orderBy('users.id', 'desc');

        $data['domaintext'] = $pagetext;

        $users = $Query->limit(100)->get();

        foreach ($users as $user) {
            $userdocuments = DB::table('user_documents')->select('user_documents.*', 'document_category.title')->where('user_id', $user->id)->join('document_category', 'document_category.id', '=', 'user_documents.document_category_id')->get();
            $user->is_doc_approved = 3;
            $user->pending_doc = 0;
            foreach ($userdocuments as $doc) {
                if ($doc->status == 0) {
                    $user->is_doc_approved = 0;
                    $user->pending_doc  = DB::table('user_documents')->where('user_id', $user->id)->where('status', '=', 0)->count();
                    break;
                } elseif ($doc->status == 1) {
                    $user->is_doc_approved = 1;
                    break;
                } else {
                    $user->is_doc_approved = 2;
                }
            }
        }


        $data['users_data'] = $users;

        return view('admin.pages/admin-find-users-details', $data);
    }

    public function admin_find_users_details_view(Request $request)
    {

        $pagetext = 'Find Domain';
        $data['domainStatus'] = '';
        $data['langId'] = '';
        $data['hardcopy'] = 0;

        $data['states'] = DB::table('regions')->select('description')->distinct()->orderBy('description')->get();

        if ($request->has('domainStatus') && ! empty($request->domainStatus)) {
            $data['domainStatus'] = $request->domainStatus;
        }

        if ($request->has('domainLangID') && ! empty($request->domainLangID)) {
            $data['langId'] = $request->domainLangID;
        }

        if ($request->has('HardCopy') && ! empty($request->HardCopy)) {
            $data['hardcopy'] = $request->HardCopy;
        }

        if ($request->has('domaintext') && ! empty($request->domaintext)) {
            $pagetext = $request->domaintext;
        } else {

            $data['domaintext'] = $pagetext;

            return view('admin.pages/ajaxfinduserdetails', $data);
        }


        $data['domaintext'] = $pagetext;


        if ($request->domainStatus == 2 || $request->domainStatus == 5) {

            return view('admin.pages/pendingcreation', $data);
        } else {

            return view('admin.pages/ajaxfinduserdetails', $data);
        }
    }


    public function finduser_ajaxcall(Request $request)
    {

        $draw = $request->get('draw');
        $start = $request->get("start");
        $rowperpage = $request->get("length");

        $columnIndex_arr = $request->get('order');
        $columnName_arr = $request->get('columns');
        $order_arr = $request->get('order');
        $search_arr = $request->get('search');

        $columnIndex = $columnIndex_arr[0]['column'];
        $columnName = $columnName_arr[$columnIndex]['data'];
        $columnSortOrder = $order_arr[0]['dir'];
        $searchValue = $search_arr['value'];

        $records = DB::table('users')
            ->join('user_contact_details as ucd', 'ucd.user_id', '=', 'users.id')
            ->select('users.*', 'users.id as user_id');

        // $records = DB::table('users')
        //     ->join('user_contact_details as ucd', 'ucd.user_id', '=', 'users.id');

        //$records->where('users.user_type', 1);

        if ($request->has('name') && ! empty($request->name)) {
            $records->where('users.name', 'LIKE', '%' . $request->name . '%');
        }
        if ($request->has('user_name') && ! empty($request->user_name)) {
            $records->where(function ($query) use ($request) {
                $query->where('users.domainName', 'LIKE', '%' . $request->user_name . '%')
                    ->orWhere('users.domainPunyCode', 'LIKE', '%' . $request->user_name . '%');
            });

            //  $records->where('users.domainName', 'LIKE','%'. $request->user_name.'%');
        }
        if ($request->has('institute_name') && ! empty($request->institute_name)) {
            $records->where('users.institute', 'LIKE', '%' . $request->institute_name . '%');
        }




        if ($request->has('state') && !empty($request->state)) {
            $records->where('ucd.state', $request->state);
        }
        if ($request->has('domainLangId') && ! empty($request->domainLangId)) {
            $records->where('users.domainLangId',  $request->domainLangId);
        }

        if ($request->has('domainLangIds') && ! empty($request->domainLangIds)) {
            $records->where('users.domainLangId',  $request->domainLangIds);
        }

        if ($request->has('status') && ! empty($request->status)) {
            $records->where('users.status', $request->status);
        }

        if ($request->has('domainStatus') && ! empty($request->domainStatus)) {
            if ($request->domainStatus == 2) {
                $records->whereIn('users.domainStatus', [1, 2, 3, 4]);

                $records->where('users.clarify', 0);

                // } elseif ($request->domainStatus == 6  && $request->domaintext != 'Active ERNET DNS') {
                //     $records->whereIn('users.domainStatus', [6, 10]);

            } elseif ($request->domainStatus == 6  && $request->domaintext == 'Active ERNET DNS') {
                $records->whereIn('users.domainStatus', [6, 7, 8, 10]);
            } elseif ($request->domainStatus == 10) {
                $records->whereIn('users.domainStatus', [10])
                    ->where('users.document_status', '!=', 1);
            } else {
                $records->where('users.domainStatus', $request->domainStatus);
            }
        }

        if ($request->has('domainStatu') && ! empty($request->domainStatu)) {
            if ($request->domainStatu == 2) {
                $records->whereIn('users.domainStatus', [1, 2, 3, 4]);
                $records->where('users.clarify', 0);
            } elseif ($request->domainStatu == 6) {
                $records->whereIn('users.domainStatus', [6, 10]);
            } elseif ($request->domainStatu == 10) {
                $records->whereIn('users.domainStatus', [10])
                    ->where('users.document_status', '!=', 1);
            } else {
                $records->where('users.domainStatus', $request->domainStatu);
            }
        }

        if ($request->hardcopy == 1) {


            $records->whereIn('users.domainStatus', [6, 7, 8, 10]);
            $records->where('hard_copy', 1);
        }




        if ($request->from_date != '' && $request->to_date != '') {

            if ($request->from_date != null) {
                $start_date = Carbon::parse($request->from_date)->format('Y-m-d H:i:s');

                if ($request->from_date == $request->to_date) {
                    $records->whereDate('users.applicationDate', '=', $start_date);
                } else {
                    $records->where('users.applicationDate', '>=', $start_date);
                }
            }

            if ($request->to_date != null) {
                $end_date = Carbon::parse($request->to_date)->endOfDay()->format('Y-m-d H:i:s');

                if ($request->from_date == $request->to_date) {
                    $end_date = Carbon::parse($request->to_date)->endOfDay()->format('Y-m-d');
                    $records->whereDate('users.applicationDate', '=', $end_date);
                } else {
                    $records->where('users.applicationDate', '<=', $end_date);
                }
            }
        }



        if ($request->expiry_start_date != '' && $request->expiry_end_date != '') {

            if ($request->expiry_start_date != null) {
                $start_date = Carbon::parse($request->expiry_start_date)->format('Y-m-d H:i:s');

                if ($request->expiry_start_date == $request->expiry_end_date) {
                    $records->whereDate('users.domainExpiryDate', '=', $start_date);
                } else {
                    $records->where('users.domainExpiryDate', '>=', $start_date);
                }
            }

            if ($request->expiry_end_date != null) {
                $end_date = Carbon::parse($request->expiry_end_date)->endOfDay()->format('Y-m-d H:i:s');

                if ($request->expiry_start_date == $request->expiry_end_date) {
                    $end_date = Carbon::parse($request->expiry_end_date)->endOfDay()->format('Y-m-d');
                    $records->whereDate('users.domainExpiryDate', '=', $end_date);
                } else {
                    $records->where('users.domainExpiryDate', '<=', $end_date);
                }
            }
        }


        if ($request->has('domaintext') && $request->domaintext == 'No Zone Record') {
            $records->where('users.zone_file', 0)
                ->where('user_name_servers.server_type', 1)->join('user_name_servers', 'user_name_servers.user_id', 'users.id')
                ->select('users.*', 'user_name_servers.server_type', 'user_name_servers.user_id');
        }

        if ($request->has('domaintext') && $request->domaintext == 'Active ERNET DNS') {
            $ernetserver = 'ernet.in';

            $records->where(function ($query) use ($ernetserver) {
                $query->where('user_name_servers.primary_name_server', 'like', '%' . $ernetserver . '%')
                    ->orWhere('user_name_servers.secondary_name_server1', 'like', '%' . $ernetserver . '%');
            })
                ->join('user_name_servers', 'user_name_servers.user_id', 'users.id')
                ->select('users.*', 'user_name_servers.server_type', 'user_name_servers.user_id');
        }

        if ($request->has('domaintext') && $request->domaintext == 'Without DNS') {
            $records->where('user_name_servers.server_type', '')->join('user_name_servers', 'user_name_servers.user_id', 'users.id');
        }

        $count = $records->distinct('users.id')->count();

        $records->skip($start)->take($rowperpage);
        $records->orderBy('users.id', $columnSortOrder);

        // Get the final result
        $list = $records->get();
        $data_arr = array();

        foreach ($list as $sno => $record) {
            // dd($list);
            $action = '';

            $phone = DB::table('user_contact_details')->where('user_id', $record->id)->first();

            $ph = '';

            if ($phone != null) {
                $ph = $phone->phone ?? '';
            }
            if ($record->applicationDate == Null || $record->applicationDate == '' || $record->applicationDate == '0000-00-00 00:00:00') {
                $appdate = 'NA';
            } else {
                $appdate = Carbon::parse($record->applicationDate)->format('d/m/Y');
            }

            $lastdate = '';
            if ($record->domainStatus == 7) {
                $lastdate = Carbon::parse($record->domainExpiryDate)->format('d/m/Y');
            } elseif ($record->updated_at == Null || $record->updated_at == '' || $record->updated_at == '0000-00-00 00:00:00') {
                $lastdate = 'NA';
            } else {
                $lastdate = Carbon::parse($record->updated_at)->format('d/m/Y');
            }

            $expdate = '';

            if ($record->domainExpiryDate == Null || $record->domainExpiryDate == '' || $record->domainExpiryDate == '0000-00-00 00:00:00') {
                $expdate = 'NA';
            } else {
                $expdate = Carbon::parse($record->domainExpiryDate)->format('d/m/Y');
            }

            $status = '';
            if ($record->domainStatus <= 4  && $record->document_status != 1) {
                $status = 'Incomplete Application';
            } elseif ($record->domainStatus <= 4 && $record->document_status == 1) {
                $status = 'Doc Rejected - <br> Registration Application';
            } elseif ($record->domainStatus == 5) {
                $status = 'Pending Domain Creation';
            } elseif ($record->domainStatus == 6) {
                $status = 'Active Domain';
            } elseif ($record->domainStatus == 7) {
                $status = 'Hold Domain';
            } elseif ($record->domainStatus == 8) {
                $status = 'Pending Restorable';
            } elseif ($record->domainStatus == 11) {
                $status = 'Pending Restorable';
            } elseif ($record->domainStatus == 10 && $record->document_status == 1) {
                $status = 'Doc Rejected - <br> Renewal Application';
            } elseif ($record->domainStatus == 10 && $record->document_status != 1) {
                $status = 'Renewal Application';
            }

            $detailurl = url('ernetdash/admin-users-details') . '/' . base64_encode($record->user_id);

            $action .= '<a class="btn btn-outline-primary mx-2" data-toggle="tooltip" data-placement="top"
                title="Edit" href="' . $detailurl . '"> <i class="fa fa-edit"></i></a>';

            $action .= '<a class="delete_admin btn btn-danger text-white mx-2" data-toggle="tooltip" data-placement="top"
                title="Delete" href="javascript:void(0)" data-id="' . $record->user_id . '"><i class="fa fa-trash"></i> </a>';

            if ($record->domainStatus == 6) {
                $action .= '<a href="javascript:void(0)" style="color:#fff;" class="mx-2 hold_button btn btn-danger" data-id="' . $record->user_id . '">Hold</a>';
            }

            if ($record->domainStatus == 7) {
                $action .= '<a href="javascript:void(0)" style="color:#fff;" class="mx-2 unhold_button btn btn-danger" data-id="' . $record->user_id . '">Unhold</a>';
            }

            $action .= '<br><a href="javascript:void(0)" style="color:#fff;" class="mx-2 my-2 change_passwordbutton btn btn-primary" data-id="' . $record->user_id . '">Reset Password</a>';


            $data_arr[] = array(
                "id" => ++$start,
                "domainName" => $record->domainName,
                "inst" => $record->institute . '<br>' . $ph,
                "appdate" => $appdate,
                "lastdate" => $lastdate,
                "expdate" => $expdate,
                "status" => $status,
                "Action" => $action,
            );
        }

        $response = array(
            "draw" => intval($draw),
            "iTotalRecords" => $count,
            "iTotalDisplayRecords" => $count,
            "aaData" => $data_arr
        );

        echo json_encode($response);
        exit;
    }


    public function pendingcreation_ajaxcall(Request $request)
    {

        $draw = $request->get('draw');
        $start = $request->get("start");
        $rowperpage = $request->get("length");

        $columnIndex_arr = $request->get('order');
        $columnName_arr = $request->get('columns');
        $order_arr = $request->get('order');
        $search_arr = $request->get('search');

        $columnIndex = $columnIndex_arr[0]['column'];
        $columnName = $columnName_arr[$columnIndex]['data'];
        $columnSortOrder = $order_arr[0]['dir'];
        $searchValue = $search_arr['value'];

        $records = DB::table('users');

        $records->where('users.user_type', 1);

        if ($request->has('name') && ! empty($request->name)) {
            $records->where('users.name', 'LIKE', '%' . $request->name . '%');
        }
        if ($request->has('user_name') && ! empty($request->user_name)) {
            $records->where('users.domainName', 'LIKE', '%' . $request->user_name . '%');
        }
        if ($request->has('institute_name') && ! empty($request->institute_name)) {
            $records->where('users.institute', 'LIKE', '%' . $request->institute_name . '%');
        }
        if ($request->has('domainLangId') && ! empty($request->domainLangId)) {
            $records->where('users.domainLangId',  $request->domainLangId);
        }
        if ($request->has('status') && ! empty($request->status)) {
            $records->where('users.status', $request->status);
        }
        if ($request->has('paymentStatus') && $request->paymentStatus !== '') {
            if ($request->paymentStatus == '3') {

                $records->whereIn('users.domainStatus', [3, 4]);
            } elseif ($request->paymentStatus == '0') {

                $records->where('users.domainStatus', '<=', 2);
            }
        }

        if ($request->has('domainStatus') && ! empty($request->domainStatus)) {
            if ($request->domainStatus == 2) {
                $records->whereIn('users.domainStatus', [1, 2, 3, 4]);
                $records->whereIn('document_status', [0, 2]);
            } elseif ($request->domainStatus == 6) {
                $records->whereIn('users.domainStatus', [6, 10]);
            } else {
                $records->where('users.domainStatus', $request->domainStatus);
            }
        }

        if ($request->has('domainStatu') && ! empty($request->domainStatu)) {
            if ($request->domainStatu == 2) {
                $records->whereIn('users.domainStatus', [1, 2, 3, 4]);
                $records->whereIn('document_status', [0, 2]);
            } elseif ($request->domainStatu == 6) {
                $records->whereIn('users.domainStatus', [6, 10]);
            } else {
                $records->where('users.domainStatus', $request->domainStatu);
            }
        }


        if ($request->from_date != '' && $request->to_date != '') {

            if ($request->from_date != null) {
                $start_date = Carbon::parse($request->from_date)->format('Y-m-d H:i:s');

                if ($request->from_date == $request->to_date) {
                    $records->whereDate('users.applicationDate', '=', $start_date);
                } else {
                    $records->where('users.applicationDate', '>=', $start_date);
                }
            }

            if ($request->to_date != null) {
                $end_date = Carbon::parse($request->to_date)->endOfDay()->format('Y-m-d H:i:s');

                if ($request->from_date == $request->to_date) {
                    $end_date = Carbon::parse($request->to_date)->endOfDay()->format('Y-m-d');
                    $records->whereDate('users.applicationDate', '=', $end_date);
                } else {
                    $records->where('users.applicationDate', '<=', $end_date);
                }
            }
        }



        if ($request->expiry_start_date != '' && $request->expiry_end_date != '') {

            if ($request->expiry_start_date != null) {
                $start_date = Carbon::parse($request->expiry_start_date)->format('Y-m-d H:i:s');

                if ($request->expiry_start_date == $request->expiry_end_date) {
                    $records->whereDate('users.domainExpiryDate', '=', $start_date);
                } else {
                    $records->where('users.domainExpiryDate', '>=', $start_date);
                }
            }

            if ($request->expiry_end_date != null) {
                $end_date = Carbon::parse($request->expiry_end_date)->endOfDay()->format('Y-m-d H:i:s');

                if ($request->expiry_start_date == $request->expiry_end_date) {
                    $end_date = Carbon::parse($request->expiry_end_date)->endOfDay()->format('Y-m-d');
                    $records->whereDate('users.domainExpiryDate', '=', $end_date);
                } else {
                    $records->where('users.domainExpiryDate', '<=', $end_date);
                }
            }
        }



        $count = $records->count();

        $list = $records->skip($start)
            ->take($rowperpage)
            ->orderBy($columnName, $columnSortOrder)
            ->get();

        //dd($list);


        $data_arr = array();

        foreach ($list as $sno => $record) {

            $action = '';

            $phone = DB::table('user_contact_details')->where('user_id', $record->id)->first();

            if ($record->applicationDate == Null) {
                $appdate = 'NA';
            } else {
                $appdate = Carbon::parse($record->applicationDate)->format('d/m/Y');
            }

            $lastdate = '';
            if ($record->updated_at == Null) {
                $lastdate = 'NA';
            } else {
                $lastdate = Carbon::parse($record->updated_at)->format('d/m/Y');
            }

            $status = '';

            if ($record->domainStatus <= 4) {
                $status = 'Incomplete Application';
            } elseif ($record->domainStatus == 5) {
                $status = 'Pending Domain Creation';
            } elseif ($record->domainStatus == 6) {
                $status = 'Active Domain';
            } elseif ($record->domainStatus == 7) {
                $status = 'Hold Domain';
            } elseif ($record->domainStatus == 8) {
                $status = 'Pending Restorable';
            } elseif ($record->domainStatus == 11) {
                $status = 'Pending Restorable';
            } elseif ($record->domainStatus == 10) {
                $status = 'Renewal Application';
            }

            $detailurl = url('ernetdash/admin-users-details') . '/' . base64_encode($record->id);

            $action .= '<a class="btn btn-outline-primary mx-2" data-toggle="tooltip" data-placement="top"
           title="Edit" href="' . $detailurl . '"> <i class="fa fa-edit"></i></a>';

            $action .= '<a class="delete_admin btn btn-danger text-white mx-2" data-toggle="tooltip" data-placement="top"
           title="Delete" href="javascript:void(0)" data-id="' . $record->id . '"><i class="fa fa-trash"></i> </a>';

            $userdocuments = DB::table('user_documents')->select('user_documents.*', 'document_category.title')->where('user_id', $record->id)->join('document_category', 'document_category.id', '=', 'user_documents.document_category_id')->get();
            $is_doc_approved = 3;
            $pending_doc = 0;
            foreach ($userdocuments as $doc) {
                if ($doc->status == 0) {
                    $is_doc_approved = 0;
                    $pending_doc  = DB::table('user_documents')->where('user_id', $record->id)->where('status', '=', 0)->count();
                    break;
                } elseif ($doc->status == 1) {
                    $is_doc_approved = 1;
                    break;
                } else {
                    $is_doc_approved = 2;
                }
            }

            $docstatus = '';

            $docurl = url('ernetdash/admin-users-details-doc') . '/' . base64_encode($record->id);

            if ($is_doc_approved == 0) {

                $docstatus .= '<a class="btn btn-outline-danger" href="' . $docurl . '"> Clarification Required (' . $pending_doc . ') </a>';
            } elseif ($is_doc_approved == 1) {

                if ($record->applicationDate != "") {
                    $docstatus .= '<a class="btn btn-outline-info" href="' . $docurl . '"> Pending Approval </a>';
                } else {
                    $docstatus .= ' <a class="btn btn-outline-warning" href="javascript:void(0)">Final Submission Pending </a>';
                }
            } elseif ($is_doc_approved == 2) {
                $docstatus .= '<a class="btn btn-outline-success" href="' . $docurl . '"> Document Approved </a>';
            } else {
                $docstatus .= ' <a class="btn btn-outline-danger" href="javascript:void(0)"> Not Uploaded </a>';
            }

            $data_arr[] = array(
                "id" => ++$start,
                "domainName" => $record->domainName,
                "inst" => $record->institute . '<br> <br>' . $record->email,
                "applicationDate" => $appdate,
                "updated_at" => $lastdate,
                "status" => $status,
                "Action" => $action,
                "docstatus" => $docstatus,
            );
        }

        $response = array(
            "draw" => intval($draw),
            "iTotalRecords" => $count,
            "iTotalDisplayRecords" => $count,
            "aaData" => $data_arr
        );

        echo json_encode($response);
        exit;
    }




    public function save_ernet_dns_record(Request $request)
    {
        try {
            $zone = Zone::where('user_id', $request->user_id)->first();

            $name = $request->input('name');

            if ($request->input('name') == null || $request->input('name') == '@' || $request->input('name') == '') {
                $name = $zone->domain;
            }

            $data = [
                'zone_id' => $zone->id,
                "user_id" => $request->user_id,
                "type" => $request->input('type'),
                "name" => $name,
                "data" => $request->input('data'),
                "ttl" => ($request->input('ttl')) ? $request->input('ttl') : '3600',
                "priority" => $request->input('priority'),
                "weight" => $request->input('weight'),
                "port" => $request->input('port'),
                "service" => $request->input('service'),
                "protocol" => $request->input('protocol'),
            ];
            DB::table('user_name_server_records')
                ->updateOrInsert(
                    ['id' => $request->input('id')],
                    $data
                );

            $zone = Zone::where('user_id', $request->user_id)->first();
            // $this->createzone($zone);
            return ['status' => true, 'msg' => 'Record has been updated Successfully'];
        } catch (Throwable $e) {
            return ['status' => false, 'msg' => $e->getMessage()];
        }
    }

    public function rejected_ajaxcall(Request $request)
    {

        $draw = $request->get('draw');
        $start = $request->get("start");
        $rowperpage = $request->get("length");
        $columnIndex_arr = $request->get('order');
        $columnName_arr = $request->get('columns');
        $order_arr = $request->get('order');
        $search_arr = $request->get('search');
        $columnIndex = $columnIndex_arr[0]['column'];
        $columnName = $columnName_arr[$columnIndex]['data'];
        $columnSortOrder = $order_arr[0]['dir'];
        $searchValue = $search_arr['value'];

        $records = DB::table('users')->where('users.document_status', '=', 1);

        if ($request->has('name') && ! empty($request->name)) {
            $records->where('users.name', 'LIKE', '%' . $request->name . '%');
        }
        if ($request->has('user_name') && ! empty($request->user_name)) {
            $records->where('users.domainName', 'LIKE', '%' . $request->user_name . '%');
        }
        if ($request->has('institute_name') && ! empty($request->institute_name)) {
            $records->where('users.institute', 'LIKE', '%' . $request->institute_name . '%');
        }
        if ($request->has('domainLangID') && ! empty($request->domainLangID)) {
            $records->where('users.domainLangID',  $request->domainLangID);
        }
        if ($request->has('status')) {
            if ($request->status == '0') {

                $records->whereIn('users.domainStatus', [1, 2, 3, 4]);
            } elseif ($request->status == '1') {

                $records->where('users.domainStatus', 10);
            }
        }


        if ($request->has('lang') && ! empty($request->lang)) {
            $lang = DB::table('domain_languages')->where('lang_code', $request->lang)->first();
            $records->where('users.domainLangID', $lang->id);
        }
        if ($request->has('domainStatus') && ! empty($request->domainStatus)) {
            if ($request->domainStatus == 2) {
                $records->whereIn('users.domainStatus', [1, 2, 3, 4]);
            } elseif ($request->domainStatus == 6) {
                $records->whereIn('users.domainStatus', [6, 10]);
            } else {
                $records->where('users.domainStatus', $request->domainStatus);
            }
        }



        if ($request->from_date != '' && $request->end_date != '') {

            if ($request->from_date != null) {
                $start_date = Carbon::parse($request->from_date)->format('Y-m-d H:i:s');

                if ($request->from_date == $request->end_date) {
                    $records->whereDate('users.updated_at', '=', $start_date);
                } else {
                    $records->where('users.updated_at', '>=', $start_date);
                }
            }

            if ($request->end_date != null) {
                $end_date = Carbon::parse($request->end_date)->endOfDay()->format('Y-m-d H:i:s');

                if ($request->from_date == $request->end_date) {
                    $end_date = Carbon::parse($request->end_date)->endOfDay()->format('Y-m-d');
                    $records->whereDate('users.updated_at', '=', $end_date);
                } else {
                    $records->where('users.updated_at', '<=', $end_date);
                }
            }
        }

        if ($request->has('domaintext') && ! empty($request->domaintext)) {
            $pagetext = $request->domaintext;
        }


        $count = $records->count();

        $list = $records
            ->skip($start)
            ->take($rowperpage);

        if ($columnName == 'domain') {
            $list->orderBy('domainName', $columnSortOrder);
        } else if ($columnName == 'status') {
            $list->orderBy('domainStatus', $columnSortOrder);
        }

        $rec = $list->get();

        $data_arr = array();

        foreach ($rec as $sno => $record) {


            $action = '';

            $appdate = 'NA';

            if ($record->updated_at == Null) {
                $appdate = 'NA';
            } else {
                $appdate = Carbon::parse($record->updated_at)->format('d/m/Y');
            }

            $detailurl = url('ernetdash/admin-users-details') . '/' . base64_encode($record->id);

            $action .= '<a class="btn btn-outline-primary mx-2" data-toggle="tooltip" data-placement="top"
            title="Edit" href="' . $detailurl . '"> <i class="fa fa-edit"></i></a>';

            $action .= '<a class="delete_admin btn btn-danger text-white mx-2" data-toggle="tooltip" data-placement="top"
            title="Delete" href="javascript:void(0)" data-id="' . $record->id . '"><i class="fa fa-trash"></i> </a>';


            $status = '';

            if ($record->domainStatus <= 4) {
                $status = 'Registration Application';
            } elseif ($record->domainStatus == 10) {
                $status = 'Renewal Application';
            }

            $pending_doc  = DB::table('user_documents')->where('user_id', $record->id)->where('status', '=', 0)->count();

            $docstatus = '';

            $docurl = url('ernetdash/admin-users-details-doc') . '/' . base64_encode($record->id);

            $docstatus .= '<a class="btn btn-outline-danger" href="' . $docurl . '"> Clarification Required (' . $pending_doc . ') </a>';


            $data_arr[] = array(
                "id" => ++$start,
                "domain" => $record->domainName,
                "inst" => $record->institute,
                "last" => $appdate,
                "action" => $action,
                "status" => $status,
                "docstatus" => $docstatus,
            );
        }

        $response = array(
            "draw" => intval($draw),
            "iTotalRecords" => $count,
            "iTotalDisplayRecords" => $count,
            "aaData" => $data_arr
        );

        echo json_encode($response);
        exit;
    }

    public function admin_find_users_details_view_rejected_doc(Request $request)
    {
        $data['domaintext'] = 'Rejected';
        return view('admin.pages/admin-find-users-details-rejected-doc', $data);
    }


    public function admin_find_users_details_cooling_period_view(Request $request)
    {

        $data['title'] = 'Find Domain Details';
        $data['domainStatus'] = '';

        $Query = DB::table('deleted_users')
            ->select('deleted_users.*', 'user_contact_details.address as user_address', 'user_contact_details.phone as user_mobile', 'user_contact_details.prefix_phone as user_phone')
            ->join('user_contact_details', 'user_contact_details.user_id', 'deleted_users.user_id')
            ->whereDate('deleted_users.created_at', '>=', Carbon::now()->subDays(5)->format('Y-m-d'))
            ->where('deleted_users.status', 0);

        if ($request->has('name') && ! empty($request->name)) {
            $Query->where('deleted_users.name', 'LIKE', '%' . $request->name . '%');
        }
        if ($request->has('user_name') && ! empty($request->user_name)) {
            $Query->where('deleted_users.domainName', 'LIKE', '%' . $request->user_name . '%');
        }
        if ($request->has('institute_name') && ! empty($request->institute_name)) {
            $Query->where('deleted_users.institute', 'LIKE', '%' . $request->institute_name . '%');
        }
        if ($request->has('domainLangID') && ! empty($request->domainLangID)) {
            // $lang = DB::table('domain_languages')->where('lang_code',$request->domainLangID)->first();
            $Query->where('deleted_users.domainLangID',  $request->domainLangID);
        }
        if ($request->has('status') && ! empty($request->status)) {
            $Query->where('deleted_users.status', $request->status);
        }
        if ($request->has('lang') && ! empty($request->lang)) {
            $lang = DB::table('domain_languages')->where('lang_code', $request->lang)->first();
            $Query->where('deleted_users.domainLangID', $lang->id);
        }
        if ($request->has('domainStatus') && ! empty($request->domainStatus)) {
            if ($request->domainStatus == 2) {
                $Query->whereIn('deleted_users.domainStatus', [1, 2, 3, 4]);
                $Query->where('deleted_users.clarify', 0);
            } elseif ($request->domainStatus == 6) {
                $Query->whereIn('deleted_users.domainStatus', [6, 10]);
            } else {
                $Query->where('deleted_users.domainStatus', $request->domainStatus);
            }
            $data['domainStatus'] = $request->domainStatus;
        }


        if ($request->creation_start_date != '' && $request->creation_end_date != '') {
            $start_date = Carbon::parse($request->creation_start_date);
            $end_date = Carbon::parse($request->creation_end_date);
            $Query->whereBetween('deleted_users.created_at', [$start_date->format('Y-m-d') . " 00:00:00", $end_date->format('Y-m-d') . " 23:59:59"]);
        }
        $data['creation_start_date'] = $request->creation_start_date;
        $data['creation_end_date'] = $request->creation_end_date;

        if ($request->expiry_start_date != '' && $request->expiry_end_date != '') {
            $start_date = Carbon::parse($request->expiry_start_date);
            $end_date = Carbon::parse($request->expiry_end_date);
            $Query->whereBetween('deleted_users.domainExpiryDate', [$start_date->format('Y-m-d') . " 00:00:00", $end_date->format('Y-m-d') . " 23:59:59"]);
        }
        $data['expiry_start_date'] = $request->expiry_start_date;
        $data['expiry_end_date'] = $request->expiry_end_date;


        $Query->orderBy('deleted_users.id', 'desc');

        $users = $Query->get();

        $data['users_data'] = $users;
        return view('admin.pages/admin-find-users-details-cooling-period', $data);
    }



    public function admin_deleted_users_details_view(Request $request)
    {
        $data['title'] = '';

        $pagetext = 'Deleted Users Detail List';

        if ($request->has('domaintext') && ! empty($request->domaintext)) {
            $pagetext = $request->domaintext;
        }

        $data['domaintext'] = $pagetext;

        return view('admin.pages/admin-deleted-users-details', $data);
    }

    public function deletedusers_ajaxcall(Request $request)
    {


        $draw = $request->get('draw');
        $start = $request->get("start");
        $rowperpage = $request->get("length");

        $columnIndex_arr = $request->get('order');
        $columnName_arr = $request->get('columns');
        $order_arr = $request->get('order');
        $search_arr = $request->get('search');

        $columnIndex = $columnIndex_arr[0]['column'];
        $columnName = $columnName_arr[$columnIndex]['data'];
        $columnSortOrder = $order_arr[0]['dir'];
        $searchValue = $search_arr['value'];

        $deletedBy = $request->get('deleted_by');
        $data_arr = [];
        $count = 0;






        if ($deletedBy == '3') {

            $threeDaysAgo = Carbon::now()->subDays(3);
            $records = DB::table('inc_deleted_users');

            if (!empty($request->name)) {
                $records->where('name', 'LIKE', '%' . $request->name . '%');
            }
            if (!empty($request->user_name)) {
                $records->where('domainName', 'LIKE', '%' . $request->user_name . '%');
            }
            if (!empty($request->institute_name)) {
                $records->where('institute', 'LIKE', '%' . $request->institute_name . '%');
            }



            $list = $records->skip($start)->take($rowperpage)->orderBy('inc_deleted_users.id', 'desc')->get();



            foreach ($list as $record) {
                $appdate = $record->deleted_at ? Carbon::parse($record->deleted_at)->format('d/m/Y') : 'NA';

                $action = '<a href="javascript:void(0)" style="color:#fff;" data-status="2" class="mx-2 inc_restore_button btn btn-primary" data-id="' . $record->user_id . '" >Restore</a>';


                $view = '<a class="" data-toggle="tooltip" data-placement="top" title="View More" href="' . route('admin.incdeletedusers-details-view', ['id' => base64_encode($record->user_id)]) . '">' . $record->domainName . '</a>';



                $data_arr[] = [
                    "id" => ++$start,
                    "app" => $record->name,
                    "domain" => $view,
                    "inst" => $record->institute,
                    "appdate" => 'N/A',
                    "exp" => 'N/A',
                    "del" => $appdate,
                    "duration" => 'N/A',
                    "action" => $action,
                ];
            }
        } else {

            $records = DB::table('deleted_users');

            if (!empty($request->name)) {
                $records->where('name', 'LIKE', '%' . $request->name . '%');
            }
            if (!empty($request->user_name)) {
                $records->where('domainName', 'LIKE', '%' . $request->user_name . '%');
            }
            if (!empty($request->institute_name)) {
                $records->where('institute', 'LIKE', '%' . $request->institute_name . '%');
            }
            if (!empty($request->status)) {
                $records->where('status', 0);
            }
            if (!empty($request->is_active)) {
                $records->where('is_active', $request->is_active);
            }
            if (!empty($request->deleted_by)) {
                $records->where('deleted_by', '=', $request->deleted_by);
            }


            if (!empty($request->from_date)) {
                $start_date = Carbon::parse($request->from_date)->startOfDay();

                if ($request->from_date == $request->end_date) {
                    $records->whereDate('created_at', '=', $start_date->format('Y-m-d'));
                } else {
                    $records->where('created_at', '>=', $start_date->format('Y-m-d H:i:s'));
                }
            }

            if (!empty($request->end_date)) {
                $end_date = Carbon::parse($request->end_date)->endOfDay();

                if ($request->from_date == $request->end_date) {
                    $records->whereDate('created_at', '=', $end_date->format('Y-m-d'));
                } else {
                    $records->where('created_at', '<=', $end_date->format('Y-m-d H:i:s'));
                }
            }

            $count = $records->count();

            $list = $records->skip($start)->take($rowperpage)->orderBy('deleted_users.id', 'desc')->get();

            foreach ($list as $record) {
                $appdate = $record->domainCreationDate
                    ? Carbon::parse($record->domainCreationDate)->format('d/m/Y')
                    : 'NA';

                $expdate = $record->domainExpiryDate
                    ? Carbon::parse($record->domainExpiryDate)->format('d/m/Y')
                    : '';

                $deldate = $record->created_at
                    ? Carbon::parse($record->created_at)->format('d/m/Y')
                    : ($record->domainExpiryDate
                        ? Carbon::parse($record->domainExpiryDate)->format('d/m/Y')
                        : 'NA');

                // $action = '<a href="javascript:void(0)" style="color:#fff;" data-status="1" class="mx-2 restore_button btn btn-danger" data-id="' . $record->user_id . '" >Hold</a>';
                // $action .= '<a href="javascript:void(0)" style="color:#fff;" data-status="2" class="mx-2 restore_button btn btn-primary" data-id="' . $record->user_id . '" >Restore</a>';


                $action = '<a href="javascript:void(0)" style="color:#fff;" data-status="2" class="mx-2 restore_button btn btn-primary" data-id="' . $record->user_id . '" >Restore</a>';







                $view = '<a class="" data-toggle="tooltip" data-placement="top" title="View More" href="' . route('admin.deletedusers-details-view', ['id' => base64_encode($record->user_id)]) . '">' . $record->domainName . '</a>';

                $duration = ($record->domainCreationDate && $record->domainExpiryDate)
                    ? Carbon::parse($record->domainCreationDate)->diffInYears(Carbon::parse($record->domainExpiryDate))
                    : 'N/A';

                $data_arr[] = [
                    "id" => ++$start,
                    "app" => $record->name,
                    "domain" => $view,
                    "inst" => $record->institute,
                    "appdate" => $appdate,
                    "exp" => $expdate,
                    "del" => $deldate,
                    "duration" => $duration,
                    "action" => $action,
                ];
            }
        }

        //dd($list);

        $incDeletedCount = DB::table('inc_deleted_users')->count();
        $totalCount = $count + $incDeletedCount;


        $response = [
            "draw" => intval($draw),
            "iTotalRecords" => $totalCount,
            "iTotalDisplayRecords" => $totalCount,
            "aaData" => $data_arr
        ];

        echo json_encode($response);
        exit;
    }


    public function deletedusersOld_ajaxcall(Request $request)
    {

        $draw = $request->get('draw');
        $start = $request->get("start");
        $rowperpage = $request->get("length");
        $columnIndex_arr = $request->get('order');
        $columnName_arr = $request->get('columns');
        $order_arr = $request->get('order');
        $search_arr = $request->get('search');
        $columnIndex = $columnIndex_arr[0]['column'];
        $columnName = $columnName_arr[$columnIndex]['data'];
        $columnSortOrder = $order_arr[0]['dir'];
        $searchValue = $search_arr['value'];

        $records = DB::table('deleted_users');
        if ($request->has('name') && ! empty($request->name)) {
            $records->where('name', 'LIKE', '%' . $request->name . '%');
        }
        if ($request->has('user_name') && ! empty($request->user_name)) {
            $records->where('domainName', 'LIKE', '%' . $request->user_name . '%');
        }
        if ($request->has('institute_name') && ! empty($request->institute_name)) {
            $records->where('institute', 'LIKE', '%' . $request->institute_name . '%');
        }
        if ($request->has('status') && ! empty($request->status)) {
            $records->where('status', 0);
        }

        if ($request->has('is_active') && ! empty($request->is_active)) {
            $records->where('is_active', $request->is_active);
        }

        $pagetext = 'Deleted Users Detail List';

        if ($request->has('deleted_by') && ! empty($request->deleted_by)) {
            $records->where('deleted_by', '=', $request->deleted_by);
        }

        if ($request->from_date != null) {
            $start_date = Carbon::parse($request->from_date)->format('Y-m-d H:i:s');
            if ($request->from_date == $request->end_date) {
                $records->whereDate('created_at', '=', $start_date);
            } else {
                $records->where('created_at', '>=', $start_date);
            }
        }

        if ($request->end_date != null) {
            $end_date = Carbon::parse($request->end_date)->endOfDay()->format('Y-m-d H:i:s');
            if ($request->from_date == $request->end_date) {
                $end_date = Carbon::parse($request->end_date)->endOfDay()->format('Y-m-d');
                $records->whereDate('created_at', '=', $end_date);
            } else {
                $records->where('created_at', '<=', $end_date);
            }
        }

        $count = $records->count();

        $list = $records->skip($start)
            ->take($rowperpage)
            ->orderBy('deleted_users.id', 'desc')
            ->get();


        $data_arr = array();

        foreach ($list as $sno => $record) {

            $action = '';

            if ($record->domainCreationDate == Null) {
                $appdate = 'NA';
            } else {
                $appdate = Carbon::parse($record->domainCreationDate)->format('d/m/Y');
            }

            $expdate = '';
            $expdate = $record->domainExpiryDate != null ? Carbon::parse($record->domainExpiryDate)->format('d/m/Y') : '';

            $deldate = $record->created_at != null ? Carbon::parse($record->created_at)->format('d/m/Y') : Carbon::parse($record->domainExpiryDate)->format('d/m/Y');


            $expdate2 = $record->domainExpiryDate != null ? Carbon::parse($record->domainExpiryDate)->format('Y-m-d') : '';

            $dat = "2023-11-15";
            $dat2 = "2023-04-01";


            $action .= '<a href="javascript:void(0)" style="color:#fff;" data-status="1" class="mx-2 restore_button btn btn-danger" data-id="' . $record->user_id . '" >Hold</a>';
            $action .= '<a href="javascript:void(0)" style="color:#fff;" data-status="2" class="mx-2 restore_button btn btn-primary" data-id="' . $record->user_id . '" >Restore</a>';

            $view = '<a class="" data-toggle="tooltip" data-placement="top" title="View More" href="' . route('admin.deletedusers-details-view', ['id' => base64_encode($record->user_id)]) . '">' . $record->domainName . '</a>';


            $domainCreationDate = Carbon::parse($record->domainCreationDate);
            $domainExpiryDate = Carbon::parse($record->domainExpiryDate);

            $diffInYears = $domainCreationDate->diffInYears($domainExpiryDate);


            $data_arr[] = array(
                "id" => ++$start,
                "app" => $record->name,
                "domain" => $view,
                "inst" => $record->institute,
                "appdate" => $appdate,
                "exp" => $expdate,
                "del" => $deldate,
                "duration" => $diffInYears,
                "action" => $action,
            );
        }

        $response = array(
            "draw" => intval($draw),
            "iTotalRecords" => $count,
            "iTotalDisplayRecords" => $count,
            "aaData" => $data_arr
        );

        echo json_encode($response);
        exit;
    }

    public function view_mx_records($id)
    {
        $id = base64_decode($id);
        $user = User::find($id);
        $data['title'] = 'User DNS Records';
        $data['domain'] = $user;
        $data['records'] = DB::table('user_name_server_records')->where('user_id', '=', $id)->get();
        return view('admin.pages.user-dns-records', $data);
    }

    public function movedomainFromDelete(Request $request)
    {

        $id = $request->id;

        $status = 1;
        $dates = '2024-01-15 18:59:00';

        $user = DB::table('deleted_users')
            ->where('user_id', $id)->first();

        if ($user == null) {

            return response()->json(array('errors' => 'erorr', 'message' => 'Domain Not Found '));
        } else {

            // $epp = new EPP();

            // $res = $epp->domainInfo($user->domainName);

            // $dom = new \DOMDocument();
            // $dom->loadXML($res);

            // $xpath = new \DOMXPath($dom);
            // $xpath->registerNamespace('domain', 'urn:ietf:params:xml:ns:domain-1.0');

            // $formateddate='';

            // $exDateElements = $xpath->query('//domain:exDate');

            // if ($exDateElements->length > 0) {
            //     $exDateValue = $exDateElements->item(0)->nodeValue;
            //     $formateddate=date('Y-m-d H:i:s',strtotime($exDateValue));
            // }else{

            //     return response()->json(array('status'=>'erorr', 'message' => 'Domain Not Found on nixi'));

            // }


            $password = Hash::make('Ernet@123');


            DB::table('users')->insert([
                'id' => $user->user_id,
                'name' => $user->name,
                'father_name' => $user->father_name,
                'age' => $user->age,
                'domainName' => $user->domainName,
                'domainPunycode' => idn_to_ascii($user->domainName),
                'domainLangID' => $user->domainLangID,
                'domainExtensionID' => $user->domainExtensionID,
                'email' => $user->email,
                'email_verified_at' => $user->email_verified_at,
                'password' => $password,
                'institute' => $user->institute,
                'board' => $user->board,
                'designation' => $user->designation,
                'domainPeriod' => $user->domainPeriod,
                'domainPrice' => $user->domainPrice,
                'domainStatus' => 1,
                'domainCreationDate' => $user->domainCreationDate,
                'domainExpiryDate' => $user->domainExpiryDate,
                'renew_years' => 0,
                'document_status' => 0,
                'status' => 1,
                'ewaas_extragb' => Auth::guard('admin')->user()->id
            ]);


            $titlefromadmin = getmisc();

            $del = DB::table('deleted_users')->where('user_id', $id)->delete();

            return response()->json(array('status' => 'success', 'message' => 'Suceess'));
        }
    }

    public function update_domain_renewal_status(Request $request)
    {

        $user = User::find($request->id);

        $epp = new EPP();

        $expiryDate = Carbon::parse($user->domainExpiryDate);
        $currentDate = Carbon::now();

        if ($currentDate->diffInDays($expiryDate) >= 40) {

            $futureDate = $expiryDate->addDays(40);

            $orderDate = $futureDate->format('Y-m-d\TH:i:s\.0\Z');

            $currentDateTime = Carbon::now('Asia/Kolkata');

            $outputDateTime = $currentDateTime->format('Y-m-d\TH:i:s\.0\Z');

            $epp->domainRestoreRequest($user->domainName);

            $epp->domainRestoreReport($user->domainName, $orderDate, $outputDateTime);
        }

        $domainNixi = $epp->domainInfo($user->domainName);

        $finalRenewYears = $user->renew_years;

        $eppjson = xmlConverter($domainNixi);

        $expdate = $eppjson['epp']['response']['resData']['domain:infData'];

        $maindate = $expdate['domain:exDate'];

        $finalexp = Carbon::parse($maindate)->format('Y-m-d');
        $currentdate = Carbon::parse($user->domainExpiryDate)->format('Y-m-d');

        if ($finalexp > $currentdate) {
            $finalRenewYears = $user->renew_years - 1;
        }

        $resf = Carbon::parse($maindate)->addYears($finalRenewYears)->format('Y-m-d H:i:s');

        $epp->domainStatusUpdate($user->domainName, 'clientHold', 'rem');

        $resultMessage = '';

        if ($finalRenewYears == 0) {

            $resultcode = '1000';
            $resultMessage = 'Command completed successfully';
            $res = '';
        } else {

            $res = $epp->renewdomain($user->domainName, $finalexp, $finalRenewYears);
            $xmlresult = simplexml_load_string($res);
            $resultAttributes = $xmlresult->response->result->attributes();
            $resultcode = (string) $resultAttributes['code'];
            $resultMessage = (string) $xmlresult->response->result->msg;
        }

        if ($resultcode == '1000' && $resultMessage == 'Command completed successfully') {

            $params = [
                'domainExpiryDate' => $resf,
                'domainPeriod' => $finalRenewYears,
                'domainStatus' => 6,
                'updated_at' => date('Y-m-d H:i:s'),
                'renew_years' => '0',
                'type' => 2,
                'hard_copy' => 1
            ];

            $update = DB::table('users')->where('id', $request->id)->update($params);

            $insert = DB::table('domain_trails')->insert(['user_id' => $request->id, 'status' => 1, 'created_at' => date('Y-m-d H:i:s')]);

            $titlefromadmin = getmisc();
            $data['content'] = $titlefromadmin->email_renewed;
            $data['email'] = $user->email;
            $data['extradata'] = '';
            $data['name'] = $user->name;
            $data['subject'] = 'Your domain (' . $user->domainName . ') has been renewed successfully';
            $data['link'] = '';

            $data['ccMails'] = getCCMail($user->id);

            $users = DB::table('users')->where('id', $user->id)->first();
            $transactions = DB::table('transactions')->where('user_id', $users->id)->where('transaction_status', '0300')->orderBy('id', 'DESC')->limit(1)->get();
            $user_detail = DB::table('user_contact_details')->where('user_id', $user->id)->first();
            $data2 = DB::table('transactions')->where('user_id', $user->id)->latest('id')->first();

            view()->share('data', $data2);
            view()->share('user', $users);
            view()->share('transactions', $transactions);
            view()->share('user_detail', $user_detail);

            $pdf = Pdf::loadView('document.inv');

            $pdfContent = $pdf->output();

            $data['attachments'] = [
                $pdfContent
            ];

            $view = 'admin.email.DomainRegistered';

            $mailer = MailManager::getInstance();

            $status = $mailer->mailSender($view, $data);

            $authuser = Auth::guard('admin')->user();
            $activity = ['user_id' => $authuser->id, 'user_type' => 2, 'user_name' => $authuser->name, 'domainName' => $user->domainName, 'status' => 'Domain Renewed', 'ip_address' => $request->ip()];
            handleActivity($activity);

            return response()->json(array('status' => 'success', 'message' => $res));
        } else {

            return response()->json(array('status' => 'erorr', 'message' => $resultMessage));
        }

        return response()->json(array('status' => 'erorr', 'message' => 'Something Error'));
    }


    //neelu july 10








    public function update_all_renewals(Request $request)
    {
        $user = User::find($request->id);
        if (!$user) {
            return response()->json(['status' => 'error', 'message' => 'User not found']);
        }

        $renewalData = DB::table('transactions')
            ->where('user_id', $user->id)
            ->where('transaction_type', 'domainRenewal')
            ->orderByDesc('id')
            ->value('request');

        if (!$renewalData) {
            return response()->json(['status' => 'error', 'message' => 'Renewal data not found']);
        }

        $requestData = is_string($renewalData) ? json_decode($renewalData, true) : $renewalData;
        $updates = [];
        $updates_domainStatus = [];

        // Domain
        if (!empty($requestData['checkboxdomain']) && $requestData['checkboxdomain'] == 'checkDomain') {
            try {

                $epp = new EPP();
                // dd( $epp);
                $expiryDate = Carbon::parse($user->domainExpiryDate);
                $currentDate = Carbon::now();
                if ($currentDate->diffInDays($expiryDate) >= 40) {
                    $futureDate = $expiryDate->addDays(40);
                    $orderDate = $futureDate->format('Y-m-d\TH:i:s\.0\Z');
                    $currentDateTime = Carbon::now('Asia/Kolkata');
                    $outputDateTime = $currentDateTime->format('Y-m-d\TH:i:s\.0\Z');
                    $epp->domainRestoreRequest($user->domainName);
                    $epp->domainRestoreReport($user->domainName, $orderDate, $outputDateTime);
                }

                $domainNixi = $epp->domainInfo($user->domainName);

                $finalRenewYears = $user->renew_years;
                $eppjson = xmlConverter($domainNixi);
                $expdate = $eppjson['epp']['response']['resData']['domain:infData'];
                $maindate = $expdate['domain:exDate'];
                $finalexp = Carbon::parse($maindate)->format('Y-m-d');
                $currentdate = Carbon::parse($user->domainExpiryDate)->format('Y-m-d');
                if ($finalexp > $currentdate) {
                    $finalRenewYears = $user->renew_years - 1;
                }
                $resf = Carbon::parse($maindate)->addYears($finalRenewYears)->format('Y-m-d H:i:s');
                // dd(  $resf);
                $epp->domainStatusUpdate($user->domainName, 'clientHold', 'rem');
                $resultMessage = '';
                if ($finalRenewYears == 0) {

                    $resultcode = '1000';
                    $resultMessage = 'Command completed successfully';
                    $res = '';
                } else {

                    $res = $epp->renewdomain($user->domainName, $finalexp, $finalRenewYears);
                    // dd( $res);
                    $xmlresult = simplexml_load_string($res);
                    $resultAttributes = $xmlresult->response->result->attributes();
                    $resultcode = (string) $resultAttributes['code'];
                    $resultMessage = (string) $xmlresult->response->result->msg;
                }
                if ($resultcode == '1000' && $resultMessage == 'Command completed successfully') {
                    $params = [
                        'domainExpiryDate' => $resf,
                        'domainPeriod' => $finalRenewYears,
                        'domainStatus' => 10,
                        'updated_at' => date('Y-m-d H:i:s'),
                        'renew_years' => '0',
                        'type' => 2,
                        'hard_copy' => 1
                    ];
                    $update = DB::table('users')->where('id', $request->id)->update($params);
                    $insert = DB::table('domain_trails')->insert(['user_id' => $request->id, 'status' => 1, 'created_at' => date('Y-m-d H:i:s')]);
                    $titlefromadmin = getmisc();
                    $data['content'] = $titlefromadmin->email_renewed;
                    $data['email'] = $user->email;
                    $data['extradata'] = '';
                    $data['name'] = $user->name;
                    $data['subject'] = 'Your domain (' . $user->domainName . ') has been renewed successfully';
                    $data['link'] = '';

                    $data['ccMails'] = getCCMail($user->id);

                    $users = DB::table('users')->where('id', $user->id)->first();
                    $transactions = DB::table('transactions')->where('user_id', $users->id)->where('transaction_status', '0300')->orderBy('id', 'DESC')->limit(1)->get();
                    $user_detail = DB::table('user_contact_details')->where('user_id', $user->id)->first();
                    $data2 = DB::table('transactions')->where('user_id', $user->id)->latest('id')->first();

                    view()->share('data', $data2);
                    view()->share('user', $users);
                    view()->share('transactions', $transactions);
                    view()->share('user_detail', $user_detail);

                    $pdf = Pdf::loadView('document.inv');

                    $pdfContent = $pdf->output();

                    $data['attachments'] = [
                        $pdfContent
                    ];

                    $view = 'admin.email.DomainRegistered';

                    $mailer = MailManager::getInstance();

                    $status = $mailer->mailSender($view, $data);

                    $authuser = Auth::guard('admin')->user();
                    $activity = ['user_id' => $authuser->id, 'user_type' => 2, 'user_name' => $authuser->name, 'domainName' => $user->domainName, 'status' => 'Domain Renewed', 'ip_address' => $request->ip()];
                    handleActivity($activity);

                    return response()->json(array('status' => 'success', 'message' => $res));
                } else {

                    return response()->json(array('status' => 'erorr', 'message' => $resultMessage));
                }
                //update_all_renewals
                $date = Carbon::createFromFormat('d/m/Y', $requestData['domainExpiryDateOld']);
                $newExpiry = $date->addYears($requestData['domain_year'] ?? 1)->format('Y-m-d');
                $user->domainExpiryDate = $newExpiry;
                $user->domainPeriod = $requestData['domain_year'] ?? 1;
                $user->domainPrice = $requestData['domain_price_total'] ?? 0;
                $updates[] = 'Domain';
                $updates_domainStatus[] = 'Domain';
            } catch (\Exception $e) {

            }
        }

        // DNS
        if (!empty($requestData['checkboxDomainName']) && $requestData['checkboxDomainName'] == 'checkDNS') {
            try {
                $date = Carbon::createFromFormat('d/m/Y', $requestData['DNS_expiry_date']);
                $newExpiry = $date->addYears($requestData['dns_year'] ?? 1)->format('Y-m-d');
                $user->dnsExpiryDate = $newExpiry;
                $user->dnsPeriod = $requestData['dns_year'] ?? 1;
                $user->dnsPrice = $requestData['domain_name_server_price_total'] ?? 0;
                $updates[] = 'DNS';
                $updates_domainStatus[] = 'DNS';
            } catch (\Exception $e) {
            }
        }

        // Lmaas
        if (!empty($requestData['checkboxLmaas'])) {
            try {
                $date = Carbon::createFromFormat('d/m/Y', $requestData['lmaas_expiry_date']);
                $newExpiry = $date->addYears($requestData['lmaas_year'] ?? 1)->format('Y-m-d');
                $user->lmaas_ExpiryDate = $newExpiry;
                $user->lmaas_Period = $requestData['lmaas_year'] ?? 1;
                $user->lmaasPrice = $requestData['lmaas_temp_server_price_total'] ?? 0;
                $updates[] = 'Lmaas';
                $updates_domainStatus[] = 'Lmaas';
            } catch (\Exception $e) {
            }
        }

        // Ewaas
        if (!empty($requestData['checkboxEwaas'])) {
            try {
                $date = Carbon::createFromFormat('d/m/Y', $requestData['ewaas_expiry_date']);
                $newExpiry = $date->addYears($requestData['ewaas_year'] ?? 1)->format('Y-m-d');
                $user->EwaasExpiryDate = $newExpiry;
                $user->EwaasPeriod = $requestData['ewaas_year'] ?? 1;
                $user->ewaasPrice = $requestData['ewaas_temp_server_price_total'] ?? 0;
                $updates[] = 'Ewaas';
                $updates_domainStatus[] = 'Ewaas';
            } catch (\Exception $e) {
            }
        }


        if (!empty($updates)) {
            $user->renewal_status = 0;
        }
        if (!empty($updates)) {
            $user->domainStatus = 6;
        }



        $user->save();

        return response()->json([
            'status' => 'success',
            'message' => implode(', ', $updates) . ' renewed successfully.',
        ]);
    }


    // 19 july
    // public function update_all_renewals(Request $request)
    // {


    //   $user = User::find($request->id);
    //     if (!$user) {
    //         return response()->json(['status' => 'error', 'message' => 'User not found']);
    //     }

    //     $renewalData = DB::table('transactions')
    //         ->where('user_id', $user->id)
    //         ->where('transaction_type', 'domainRenewal')
    //         ->orderByDesc('id')
    //         ->value('request');

    //     if (!$renewalData) {
    //         return response()->json(['status' => 'error', 'message' => 'Renewal data not found']);
    //     }

    //     $requestData = is_string($renewalData) ? json_decode($renewalData, true) : $renewalData;
    //     $updates = [];
    //     $updates_domainStatus = [];

    //     // DOMAIN RENEWAL
    //     if (!empty($requestData['checkboxdomain']) && $requestData['checkboxdomain'] == 'checkDomain') {
    //         try {
    //             // Original expiry
    //             $date = Carbon::createFromFormat('d/m/Y', $requestData['domainExpiryDateOld']);
    //             $finalRenewYears = $requestData['domain_year'] ?? 1;
    //             $newExpiry = $date->copy()->addYears($finalRenewYears)->format('Y-m-d');

    //             // EPP Integration
    //             $epp = new EPP();

    //             $expiryDate = Carbon::parse($user->domainExpiryDate);
    //             $currentDate = Carbon::now();

    //             if ($currentDate->diffInDays($expiryDate) >= 40) {
    //                 $futureDate = $expiryDate->addDays(40);
    //                 $orderDate = $futureDate->format('Y-m-d\TH:i:s\.0\Z');
    //                 $outputDateTime = Carbon::now('Asia/Kolkata')->format('Y-m-d\TH:i:s\.0\Z');

    //                 $epp->domainRestoreRequest($user->domainName);
    //                 $epp->domainRestoreReport($user->domainName, $orderDate, $outputDateTime);
    //             }

    //             $domainNixi = $epp->domainInfo($user->domainName);
    //             $eppjson = xmlConverter($domainNixi);

    //             $maindate = $eppjson['epp']['response']['resData']['domain:infData']['domain:exDate'];
    //             $finalexp = Carbon::parse($maindate)->format('Y-m-d');
    //             $currentdate = Carbon::parse($user->domainExpiryDate)->format('Y-m-d');

    //             if ($finalexp > $currentdate) {
    //                 $finalRenewYears -= 1;
    //             }

    //             $resf = Carbon::parse($maindate)->addYears($finalRenewYears)->format('Y-m-d H:i:s');
    //             $epp->domainStatusUpdate($user->domainName, 'clientHold', 'rem');

    //             $res = $epp->renewdomain($user->domainName, $finalexp, $finalRenewYears);
    //             $xmlresult = simplexml_load_string($res);
    //             $resultAttributes = $xmlresult->response->result->attributes();
    //             $resultcode = (string) $resultAttributes['code'];
    //             $resultMessage = (string) $xmlresult->response->result->msg;

    //             if ($resultcode == '1000' && $resultMessage == 'Command completed successfully') {
    //                 DB::table('domain_trails')->insert([
    //                     'user_id' => $user->id,
    //                     'status' => 1,
    //                     'created_at' => now()
    //                 ]);

    //                 $user->domainExpiryDate = $resf;
    //                 $user->domainPeriod = $finalRenewYears;
    //                 $user->domainStatus = 6;
    //                 $user->renew_years = 0;
    //                 $user->domainPrice = $requestData['domain_price_total'] ?? 0;

    //                 $updates[] = 'Domain';
    //                 $updates_domainStatus[] = 'Domain';
    //             } else {
    //                 return response()->json(['status' => 'error', 'message' => $resultMessage]);
    //             }

    //         } catch (\Exception $e) {
    //             return response()->json(['status' => 'error', 'message' => 'Domain renewal failed: ' . $e->getMessage()]);
    //         }
    //     }











    //     // DNS
    //     if (!empty($requestData['checkboxDomainName']) && $requestData['checkboxDomainName'] == 'checkDNS') {
    //         try {
    //             $date = Carbon::createFromFormat('d/m/Y', $requestData['DNS_expiry_date']);
    //             $newExpiry = $date->addYears($requestData['dns_year'] ?? 1)->format('Y-m-d');
    //             $user->dnsExpiryDate = $newExpiry;
    //             $user->dnsPeriod = $requestData['dns_year'] ?? 1;
    //             $user->dnsPrice = $requestData['domain_name_server_price_total'] ?? 0;
    //             $updates[] = 'DNS';
    //               $updates_domainStatus[] = 'DNS';
    //         } catch (\Exception $e) {}
    //     }

    //     // Lmaas
    //     if (!empty($requestData['checkboxLmaas'])) {
    //         try {
    //             $date = Carbon::createFromFormat('d/m/Y', $requestData['lmaas_expiry_date']);
    //             $newExpiry = $date->addYears($requestData['lmaas_year'] ?? 1)->format('Y-m-d');
    //             $user->lmaas_ExpiryDate = $newExpiry;
    //             $user->lmaas_Period = $requestData['lmaas_year'] ?? 1;
    //             $user->lmaasPrice = $requestData['lmaas_temp_server_price_total'] ?? 0;
    //             $updates[] = 'Lmaas';
    //               $updates_domainStatus[] = 'Lmaas';
    //         } catch (\Exception $e) {}
    //     }

    //     // Ewaas
    //     if (!empty($requestData['checkboxEwaas'])) {
    //         try {
    //             $date = Carbon::createFromFormat('d/m/Y', $requestData['ewaas_expiry_date']);
    //             $newExpiry = $date->addYears($requestData['ewaas_year'] ?? 1)->format('Y-m-d');
    //             $user->EwaasExpiryDate = $newExpiry;
    //             $user->EwaasPeriod = $requestData['ewaas_year'] ?? 1;
    //             $user->ewaasPrice = $requestData['ewaas_temp_server_price_total'] ?? 0;
    //             $updates[] = 'Ewaas';
    //               $updates_domainStatus[] = 'Ewaas';
    //         } catch (\Exception $e) {}
    //     }


    //     if (!empty($updates)) {
    //         $user->renewal_status = 0;
    //     }
    //       if (!empty($updates)) {
    //         $user->domainStatus = 6;
    //     }



    //     $user->save();

    //     return response()->json([
    //         'status' => 'success',
    //         'message' => implode(', ', $updates) . ' renewed successfully.',
    //     ]);
    // }





    // public function admin_users_details_view($id)
    // {
    //     $id=base64_decode($id);
    //     $data['user'] = DB::table('users')->where('id','=',$id)->first();
    //     $data['user_contact_details'] = DB::table('user_contact_details')->where('user_id','=',$id)->first();
    //     $data['user_name_server'] = DB::table('user_name_servers')->where('user_id','=',$id)->first();
    //     $data['payment'] = DB::table('transactions')->where('user_id','=',$id)->where('transaction_status','0300')->latest('created_at')->first();
    //     $data['user_documents'] = DB::table('user_documents')->where('user_id','=',$id)->get();
    //     $userdocuments = DB::table('user_documents')->select('user_documents.*','document_category.title')->where('user_id',$id)->join('document_category','document_category.id','user_documents.document_category_id')->get();
    //     $data['title'] = 'Users Details';
    //     $data['userdocuments'] = $userdocuments;
    //     $data['lastpayment'] = DB::table('transactions')->where('user_id','=',$id)->where('transaction_status','0300')->latest('created_at')->first();

    //     $is_approved = 1;
    //     foreach ($userdocuments as $doc){
    //         if ($doc->status == 1 || $doc->status == 0){
    //             $is_approved = 0;
    //             break;
    //         }else{
    //             $is_approved = 2;
    //         }

    //     }

    //     $data['is_approved'] = $is_approved;
    //     return view('admin.pages/admin-user-details',$data);
    // }


    // neelu july 10

    public function admin_users_details_view($id)
    {
        $id = base64_decode($id);

        $user = DB::table('users')->where('id', '=', $id)->first();
        $user_contact_details = DB::table('user_contact_details')->where('user_id', '=', $id)->first();
        $user_name_server = DB::table('user_name_servers')->where('user_id', '=', $id)->first();
        $payment = DB::table('transactions')->where('user_id', '=', $id)->where('transaction_status', '0300')->latest('created_at')->first();
        $user_documents = DB::table('user_documents')->where('user_id', '=', $id)->get();
        $userdocuments = DB::table('user_documents')
            ->select('user_documents.*', 'document_category.title')
            ->where('user_id', $id)
            ->join('document_category', 'document_category.id', '=', 'user_documents.document_category_id')
            ->get();
        $lastpayment = DB::table('transactions')->where('user_id', '=', $id)->where('transaction_status', '0300')->latest('created_at')->first();
        $title = 'Users Details';

        $is_approved = 1;
        foreach ($userdocuments as $doc) {
            if ($doc->status == 1 || $doc->status == 0) {
                $is_approved = 0;
                break;
            } else {
                $is_approved = 2;
            }
        }

        // $transaction_id = $user->renewal_transactions_id;
        // $renewal_transaction_data = DB::table('transactions')->where('id', $transaction_id)->first();
        // // $renewal_data = $renewal_transaction_data->request;
        // $renewal_data = json_decode($renewal_transaction_data->request, true); 

        // $transaction_type = $renewal_transaction_data->transaction_type;



        $renewal_data = [];
        $transaction_type = null;

        if (!empty($user) && $user->renewal_transactions_id) {
            $transaction_id = $user->renewal_transactions_id;
            $renewal_transaction_data = DB::table('transactions')->where('id', $transaction_id)->first();

            if ($renewal_transaction_data) {
                $renewal_data = json_decode($renewal_transaction_data->request, true);
                $transaction_type = $renewal_transaction_data->transaction_type;
            }
        }

        return view('admin.pages.admin-user-details', compact(
            'user',
            'user_contact_details',
            'user_name_server',
            'payment',
            'user_documents',
            'userdocuments',
            'lastpayment',
            'title',
            'is_approved',
            'renewal_data',
            'transaction_type'
        ));
    }






    public function admin_users_details_view_deleted($id)
    {
        $id = base64_decode($id);
        $data['user'] = DB::table('deleted_users')->where('user_id', '=', $id)->first();
        $data['user_contact_details'] = DB::table('user_contact_details')->where('user_id', '=', $id)->first();
        $data['user_name_server'] = DB::table('user_name_servers')->where('user_id', '=', $id)->first();
        $data['payment'] = DB::table('transactions')->where('user_id', '=', $id)->where('transaction_status', '0300')->latest('created_at')->first();
        $data['user_documents'] = DB::table('user_documents')->where('user_id', '=', $id)->get();
        $userdocuments = DB::table('user_documents')->select('user_documents.*', 'document_category.title')->where('user_id', $id)->join('document_category', 'document_category.id', 'user_documents.document_category_id')->get();
        $data['title'] = 'Users Details';
        $data['userdocuments'] = $userdocuments;
        $data['lastpayment'] = DB::table('transactions')->where('user_id', '=', $id)->where('transaction_status', '0300')->latest('created_at')->first();

        $is_approved = 1;
        foreach ($userdocuments as $doc) {
            if ($doc->status == 1 || $doc->status == 0) {
                $is_approved = 0;
                break;
            } else {
                $is_approved = 2;
            }
        }

        $data['is_approved'] = $is_approved;
        return view('admin.pages/admin-del-user-details', $data);
    }

    public function admin_users_details_view_doc($id)
    {
        $id = base64_decode($id);
        $data['title'] = 'Users Details';
        $userdata = DB::table('users')->where('id', $id)->first();
        $userdocuments = DB::table('user_documents')->select('user_documents.*', 'document_category.title')->where('user_id', $id)->join('document_category', 'document_category.id', 'user_documents.document_category_id')->get();
        $data['userdocuments'] = $userdocuments;
        $data['user_id'] = $id;
        $data['userdata'] = $userdata;
        return view('admin.pages/admin-user-details-doc', $data);
    }

    public function admin_users_details_view_rejected_doc($id)
    {
        $data['title'] = 'Users Details';
        $data['user_contact_details'] = DB::table('user_contact_details')->where('user_id', '=', $id)->first();
        $data['user_name_server'] = DB::table('user_name_servers')->where('user_id', '=', $id)->first();
        $data['user_documents'] = DB::table('user_documents')->where('user_id', '=', $id)->get();
        $userdocuments = DB::table('user_documents')->select('user_documents.*', 'document_category.title')->where('user_id', $id)->join('document_category', 'document_category.id', 'user_documents.document_category_id')->get();
        $data['userdocuments'] = $userdocuments;

        $is_approved = 1;
        foreach ($userdocuments as $doc) {
            if ($doc->status == 1 || $doc->status == 0) {
                $is_approved = 0;
                break;
            } else {
                $is_approved = 2;
            }
        }
        $data['is_approved'] = $is_approved;
        return view('admin.pages/admin-user-details-rejected-doc', $data);
    }

    public function user_dns_edit($id)
    {
        $data['title'] = 'Users Name Server Update';
        $user_dns = DB::table('user_name_servers')->where('id', '=', $id)->first();
        $user = DB::table('users')->where('id', '=', $user_dns->user_id)->first();
        $data['ernet_name_server'] = DB::table('ernet_name_servers')->where('status', '=', 1)->first();
        $data['ernet_name_server_prices'] = DB::table('ernet_name_servers_prices')->where('ernet_name_server_id', '=', $data['ernet_name_server']->id)->orderBy('years', 'asc')->get();
        $data['user_name_server'] = $user_dns;
        $data['dns_security_extension'] = DB::table('dns_security-extension')->where('user_dns_server_id', '=', $user_dns->id)->get();
        $data['user'] = $user;
        $data['dnscount'] = DB::table('dns_security-extension')->where('user_dns_server_id', '=', $user_dns->id)->count();
        $data['algos'] = DB::table('algo_master')->get();
        return view('admin.pages.user-dns-edit', $data);
    }

    public function updateUserDnsNameServer(Request $request)
    {
        $type = 0;
        try {
            $user_id = $request->input('user_id');
            $request->validate([
                'primary_name_server' => 'required',
            ]);
            $data = [
                "user_id" => $user_id,
                "server_type" => 2,
                "primary_name_server" => $request->input('primary_name_server'),
                "primary_name_server_ip" => ($request->input('primary_name_server_ip') == null) ? '' : implode('.', $request->input('primary_name_server_ip')),
                "secondary_name_server1" => $request->input('secondary_name_server1'),
                "secondary_name_server2" => $request->input('secondary_name_server2'),
                "secondary_name_server3" => $request->input('secondary_name_server3'),
                "secondary_name_server4" =>  $request->input('secondary_name_server4'),
                "secondary_name_server5" => $request->input('secondary_name_server5'),
                "ernet_name_server_duration_year" => null,
                "enable_dnsse_no" => $request->enable_dnsse,
                "secondary_name_server1_ip" => ($request->input('secondary_name_server1_ip') == null) ? '' : implode('.', $request->input('secondary_name_server1_ip')),
                "secondary_name_server2_ip" => ($request->input('secondary_name_server2_ip') == null) ? '' : implode('.', $request->input('secondary_name_server2_ip')),
                "secondary_name_server3_ip" => ($request->input('secondary_name_server3_ip') == null) ? '' : implode('.', $request->input('secondary_name_server3_ip')),
                "secondary_name_server4_ip" => ($request->input('secondary_name_server4_ip') == null) ? '' : implode('.', $request->input('secondary_name_server4_ip')),
                "secondary_name_server5_ip" => ($request->input('secondary_name_server5_ip') == null) ? '' : implode('.', $request->input('secondary_name_server5_ip')),
                "primary_name_server_ip6" => ($request->input('primary_name_server_ip6') == null) ? '' : implode(':', $request->input('primary_name_server_ip6')),
                "secondary_name_server1_ip6" => ($request->input('secondary_name_server1_ip6') == null) ? '' : implode(':', $request->input('secondary_name_server1_ip6')),
                "secondary_name_server2_ip6" => ($request->input('secondary_name_server2_ip6') == null) ? '' : implode(':', $request->input('secondary_name_server2_ip6')),
                "secondary_name_server3_ip6" => ($request->input('secondary_name_server3_ip6') == null) ? '' : implode(':', $request->input('secondary_name_server3_ip6')),
                "secondary_name_server4_ip6" => ($request->input('secondary_name_server4_ip6') == null) ? '' : implode(':', $request->input('secondary_name_server4_ip6')),
                "secondary_name_server5_ip6" => ($request->input('secondary_name_server5_ip6') == null) ? '' : implode(':', $request->input('secondary_name_server5_ip6'))
            ];

            $user_dns = DB::table('user_name_servers')->where('user_id', '=', $user_id)->first();
            if ($user_dns == null) {
                $dns_id = DB::table('user_name_servers')
                    ->insertGetId(
                        $data
                    );
                if ($request->input('enable_dnsse') == 'yes') {

                    if ($request->input('dnsse') != null) {

                        foreach ($request->input('dnsse') as $dnssec) {
                            $dnssec['user_dns_server_id'] = $dns_id;
                            DB::table('dns_security-extension')->insert($dnssec);
                        }
                    }
                }
            } else {
                DB::table('user_name_servers')
                    ->updateOrInsert(
                        ['user_id' => $user_id],
                        $data
                    );


                DB::table('dns_security-extension')->where('user_dns_server_id', $user_dns->id)->delete();

                $dns_id = $user_dns->id;
                if ($request->input('enable_dnsse') == 'yes') {

                    if ($request->input('dnsse') != null) {

                        foreach ($request->input('dnsse') as $dnssec) {
                            $dnssec['user_dns_server_id'] = $user_dns->id;
                            DB::table('dns_security-extension')->insert($dnssec);
                        }
                    }
                }

                $namserver = DB::table('user_name_servers')->where('user_id', $user_id)->first();

                $savedns = [
                    $namserver->primary_name_server,
                    $namserver->secondary_name_server1,
                ];

                $paramscreate = [
                    'ns1' => [
                        'host' => $namserver->primary_name_server,
                        'ip4' => $namserver->primary_name_server_ip,
                        'ip6' => $namserver->primary_name_server_ip6,
                    ],
                    'ns2' => [
                        'host' => $namserver->secondary_name_server1,
                        'ip4' => $namserver->secondary_name_server1_ip,
                        'ip6' => $namserver->secondary_name_server1_ip6,
                    ],
                ];

                if ($namserver->secondary_name_server2 != null) {
                    $paramscreate['ns3'] = [
                        'host' => $namserver->secondary_name_server2,
                        'ip4' => $namserver->secondary_name_server2_ip,
                        'ip6' => $namserver->secondary_name_server2_ip6,
                    ];
                    array_push($savedns, $namserver->secondary_name_server2);
                }

                if ($namserver->secondary_name_server3 != null) {
                    $paramscreate['ns4'] = [
                        'host' => $namserver->secondary_name_server3,
                        'ip4' => $namserver->secondary_name_server3_ip,
                        'ip6' => $namserver->secondary_name_server3_ip6,
                    ];
                    array_push($savedns, $namserver->secondary_name_server3);
                }

                if ($namserver->secondary_name_server4 != null) {
                    $paramscreate['ns5'] = [
                        'host' => $namserver->secondary_name_server4,
                        'ip4' => $namserver->secondary_name_server4_ip,
                        'ip6' => $namserver->secondary_name_server4_ip6,
                    ];
                    array_push($savedns, $namserver->secondary_name_server4);
                }

                if ($namserver->secondary_name_server5 != null) {
                    $paramscreate['ns6'] = [
                        'host' => $namserver->secondary_name_server5,
                        'ip4' => $namserver->secondary_name_server5_ip,
                        'ip6' => $namserver->secondary_name_server5_ip6,
                    ];
                    array_push($savedns, $namserver->secondary_name_server5);
                }

                $epp = new EPP();

                $user = User::find($user_id);

                $respone = $epp->domainInfo($user->domainName);

                $xml = new \SimpleXMLElement($respone);

                $xml->registerXPathNamespace('domain', 'urn:ietf:params:xml:ns:domain-1.0');


                $xmlElement = new \SimpleXMLElement($respone);
                $xmlElement->registerXPathNamespace('secDNS', 'urn:ietf:params:xml:ns:secDNS-1.1');

                $dsDataArray = [];
                $dsDataElements = $xmlElement->xpath('//secDNS:dsData');

                if ($dsDataElements != null) {
                    foreach ($dsDataElements as $dsDataElement) {
                        $dsDataArray[] = [
                            'keyTag' => (string) $dsDataElement->children('secDNS', true)->keyTag,
                            'alg' => (string) $dsDataElement->children('secDNS', true)->alg,
                            'digestType' => (string) $dsDataElement->children('secDNS', true)->digestType,
                            'digest' => (string) $dsDataElement->children('secDNS', true)->digest
                        ];
                    }
                    $res = $epp->domainremDNSSEC($user->domainName, $dsDataArray);
                }

                $nameservers = $xml->xpath('//domain:hostObj');


                $remNSD = array();
                foreach ($nameservers as $nameserver) {
                    $remNSD[] = (string) $nameserver;
                }

                $res = $epp->domainupdateNameServerLatest($user->domainName, $paramscreate, $savedns, $remNSD);


                $dsdtaas = DB::table('dns_security-extension')->where('user_dns_server_id', $namserver->id)->get();


                $addDsData = [];

                if ($dsdtaas != null) {
                    foreach ($dsdtaas as $name) {
                        if ($name->key_tag != null || $name->key_tag != '') {
                            $addDsData[] = [
                                'keyTag' => $name->key_tag,
                                'alg' => $name->algorithm,
                                'digestType' => $name->digest_type,
                                'digest' => $name->digest,
                            ];
                        }
                    }
                }

                $res = $epp->domainupdateDNSSEC($user->domainName, $addDsData);
            }
            $type = 2;
            $updated_date = date('Y-m-d H:i:s');
            $user = User::find($user_id);
            $user->updated_at = $updated_date;
            $user->save();

            return ['status' => true, 'server_type' => $type, 'msg' => 'updated successfully'];
        } catch (Throwable $e) {
            return ['status' => false, 'server_type' => $type, 'msg' => $e->getMessage()];
        }
    }

    public function admin_update_name_server_view()
    {
        $data['title'] = 'Users Details';
        return view('admin.pages/admin-update-name-server', $data);
    }

    public function admin_update_doc(Request $request)
    {
        try {
            if ($request->isMethod('post')) {
                $params = $request->all();

                $type = $request->statusid;


                if ($type == 1) {

                    $is_rejected = true;
                    $user_info = '';
                    $DocRemark = [];
                    $ReplaceFile = [];
                    foreach ($request->id as $key => $docid) {
                        $doc = DB::table('user_documents')->where('id', '=', $docid)->first();
                        $user_info = User::find($doc->user_id);

                        $params = [
                            'status' => $request->status[$key],
                            'remarks' => $request->remarks[$key],
                        ];

                        if (isset($request->replace_file[$key])) {

                            $path = public_path('user/docs/') . $doc->user_id;
                            $doc_file = $request->file('replace_file')[$key];


                            $filename = time() . $doc_file->getClientOriginalName();

                            $doc_file->move($path, $filename);

                            $params['path'] = $filename;
                            $params['name'] = $filename;
                        }

                        if ($request->status[$key] == 0) {
                            if ($request->remarks[$key] == '') {
                                return response()->json(array('status' => false, 'message' => 'remark mandatory for rejected document'));
                            }
                            $is_rejected = false;
                            $docdata = DB::table('user_documents')->where('id', $docid)->first();
                            $DocRemark[] = DB::table('document_category')->where('id', $docdata->document_category_id)->first()->title . ' : ' . $request->remarks[$key];
                        }


                        $update = DB::table('user_documents')->where('id', $docid)->update($params);
                        $status = true;
                    }
                    if ($status) {
                        if ($user_info->email != null) {
                            if ($is_rejected) {
                                $statusD = $user_info->domainStatus == 10 ? "10" : "5";
                                $updated_date = date('Y-m-d H:i:s');
                                $user = User::find($user_info->id);
                                //    $user->domainStatus = $statusD;
                                $user->clarify = 0;
                                $user->document_status = 2;
                                $user->updated_at = $updated_date;
                                $user->doc_clarification_date = null;
                                $user->save();

                                $titlefromadmin = getmisc();
                                $data['content'] = $titlefromadmin->email_approved;
                                $data['subject'] = 'All Documents are approved that were submitted for domain ' . $user_info->domainName;
                                $data['email'] = $user_info->email;
                                $data['name'] = $user_info->name;

                                $view = 'front.email.user-document-approved';

                                $authuser = Auth::guard('admin')->user();
                                $activity = ['user_id' => $authuser->id, 'user_type' => 2, 'user_name' => $authuser->name, 'domainName' => $user_info->domainName, 'status' => 'Document Approved', 'ip_address' => $request->ip()];
                                handleActivity($activity);
                            } else {
                                $data = [];

                                $statusD = $user_info->domainStatus == 10 ? "10" : "4";
                                $updated_date = date('Y-m-d H:i:s');
                                $user = User::find($user_info->id);
                                $user->domainStatus = $statusD;
                                $user->clarify = 1;
                                $user->document_status = 1;
                                $user->updated_at = $updated_date;
                                $user->doc_clarification_date = now();
                                $user->save();

                                $titlefromadmin = getmisc();
                                $data['content'] = $titlefromadmin->email_clarification;
                                $data['subject'] = 'Clarification Required in ERNET Application for Domain (' . $user_info->domainName . ') Registration';
                                $data['email'] = $user_info->email;
                                $data['name'] = $user_info->name;
                                $data['docs'] = $DocRemark;
                                $data['ccMails'] = getCCMail($user_info->id);

                                $view = 'front.email.user-document-rejected';

                                $mailer = MailManager::getInstance();

                                $status = $mailer->mailSender($view, $data);

                                $authuser = Auth::guard('admin')->user();
                                $activity = ['user_id' => $authuser->id, 'user_type' => 2, 'user_name' => $authuser->name, 'domainName' => $user_info->domainName, 'status' => 'Clarification Raised on Document', 'ip_address' => $request->ip()];
                                handleActivity($activity);
                            }
                        }
                        return response()->json(array('status' => 'success', 'id' => $docid));
                    }


                    return response()->json(array('status' => 'error', 'error' => 'Something Wrong'));
                } else {


                    foreach ($request->id as $key => $docid) {

                        $doc = DB::table('user_documents')->where('id', '=', $docid)->first();

                        if (isset($request->replace_file[$key])) {

                            $path = public_path('user/docs/') . $doc->user_id;
                            $doc_file = $request->file('replace_file')[$key];

                            $filename = time() . $doc_file->getClientOriginalName();

                            $doc_file->move($path, $filename);

                            $params = [];

                            $params['path'] = $filename;
                            $params['name'] = $filename;
                            $update = DB::table('user_documents')->where('id', $docid)->update($params);
                        }
                    }

                    return response()->json(array('status' => 'success', 'id' => 'Done'));
                }
            }
        } catch (\Throwable $e) {
            $error = $e->getMessage() . ', File Path = ' . $e->getFile() . ', Line Number = ' . $e->getLine();
            return response()->json(array('status' => 'exceptionError', 'error' => $error));
        }
    }

    public function updateuserdocument(Request $request)
    {
        try {
            if ($request->isMethod('post')) {
                $params = $request->all();

                $domain = User::find($request->user_id);

                foreach ($request->id as $key => $docid) {

                    if (isset($request->document[$key])) {

                        $path = public_path('user/docs/') . $request->user_id;
                        $doc_file = $request->file('document')[$key];

                        $filename = time() . $doc_file->getClientOriginalName();

                        $doc_file->move($path, $filename);

                        $params = [];

                        $params['path'] = $filename;
                        $params['name'] = $filename;
                        $params['status'] = 1;
                        $update = DB::table('user_documents')->where('id', $docid)->update($params);
                    }
                }

                $rejectedcount = DB::table('user_documents')->where('user_id', $domain->id)->where('status', 0)->count();

                if ($rejectedcount == 0) {

                    if ($domain->domainStatus == 4) {

                        $update = User::where('id', $domain->id)->update(['document_status' => 0, 'domainStatus' => 5]);
                    } else if ($domain->domainStatus == 10) {

                        $update = User::where('id', $domain->id)->update(['document_status' => 0]);
                    }
                }

                return response()->json(array('status' => 'success', 'message' => 'Updated Successfully'));
            }

            return response()->json(array('status' => 'error', 'message' => 'Failed to Change Document'));
        } catch (\Throwable $e) {
            $error = $e->getMessage() . ', File Path = ' . $e->getFile() . ', Line Number = ' . $e->getLine();
            return response()->json(array('status' => 'exceptionError', 'error' => $error));
        }
    }


    public function userPayment()
    {
        return view('admin/pages/admin-user-payment-list');
    }
    public function ajaxcallPayment(Request $request)
    {
        $draw = $request->get('draw');
        $start = $request->get("start");
        $rowperpage = $request->get("length");

        $columnIndex_arr = $request->get('order');
        $columnName_arr = $request->get('columns');
        $order_arr = $request->get('order');
        $search_arr = $request->get('search');

        $columnIndex = $columnIndex_arr[0]['column'];
        $columnName = $columnName_arr[$columnIndex]['data'];
        $columnSortOrder = $order_arr[0]['dir'];
        $searchValue = $search_arr['value'];

        $countData = DB::table('transactions')->select('count(*) as allcount')
            ->where('transaction_status', '0300');

        if ($searchValue != null) {
            $countData->where('response_payload', 'like', '%' . $searchValue . '%');
        }

        $totalRecordswithFilter = $countData->count();
        $totalRecords = $totalRecordswithFilter;
        $records = DB::table('transactions')->select('*')
            ->where('transaction_status', '0300')
            ->skip($start)
            ->take($rowperpage);

        if ($columnName == 'id') {
            $records->orderBy($columnName, $columnSortOrder);
        }

        if ($searchValue != null) {
            $records->where('response_payload', 'like', '%' . $searchValue . '%');
        }

        $list = $records->get();
        $data_arr = array();

        foreach ($list as $sno => $record) {
            if ($record->response_payload) {
                $id = $record->id;
                $additionalInfo1 = json_decode($record->response_payload)->AdditionalInfo1;
                $txnAmount = ltrim(json_decode($record->response_payload)->TxnAmount, 0);
                $additionalInfo2 = json_decode($record->response_payload)->AdditionalInfo2;
                $created_at = Carbon::parse($record->created_at)->format('d-m-Y');
                $data_arr[] = array(
                    "id" => ++$start,
                    "additionalInfo1" => $additionalInfo1,
                    "txnAmount" => $txnAmount,
                    "additionalInfo2" => $additionalInfo2,
                    "created_at" => $created_at
                );
            }
        }
        $response = array(
            "draw" => intval($draw),
            "iTotalRecords" => $totalRecords,
            "iTotalDisplayRecords" => $totalRecordswithFilter,
            "aaData" => $data_arr
        );

        echo json_encode($response);
        exit;
    }

    public function checkzonedata()
    {

        $zone = Zone::where('domain', 'domainindia.ac.in ')->first();

        $this->createzone($zone);
    }
    public function registerUserDomain(Request $request)
    {
        try {
            $request->validate([
                'user_id' => 'required'
            ]);
            $user_id = $request->input('user_id');

            $checktransaction = DB::table('transactions')
                ->where('transaction_status', '0300')
                ->whereIn('transaction_type', ['domainRegister', 'domainRegisterWithNameServer'])
                ->where('user_id', $user_id)
                ->count();


            if ($checktransaction == 0) {
                $update = DB::table('users')->where('id', $user_id)->update(['domainStatus' => 1, 'document_status' => 0, 'domainExpiryDate' => null]);
                $docupdate = DB::table('user_documents')->where('user_id', $user_id)->update(['status' => 1]);
                return response()->json(array('status' => false, 'msg' => 'Payment not received'));
            }

            $namserver = DB::table('user_name_servers')->where('user_id', $user_id)->first();

            $updated_date = date('Y-m-d H:i:s');
            $user = User::find($user_id);




            if ($namserver != null) {

                if ($namserver->server_type == 1) {
                    $status = DB::table('zones')
                        ->updateOrInsert(
                            ['user_id' => $user_id],
                            [
                                'server' => $namserver->primary_name_server,
                                'user_id' => $user_id,
                                'domain' => $user->domainPunycode,
                                'reverse_zone' => 1,
                                'custom_settings' => 0,
                                'refresh' => 0,
                                'retry' => 7200,
                                'expire' => 3628800,
                                'negative_ttl' => 0,
                                'default_ttl' => 0,
                                'updated_at' => $updated_date
                            ]
                        );

                    $zone = Zone::where('domain', $user->domainPunycode)->first();
                }
            }

            $data = [];

            $epp = new EPP();

            $domainName = $user->domainPunycode;

            $period = $user->domainPeriod;
            $langs = $user->domainLangID;

            $domainId = $user->id;

            $str = 'abcdefghijklmnopqrstuvwxyz123456789';
            $shuffled = str_shuffle($str);
            $password = Str::substr($shuffled, 0, 8);

            if ($langs == 3) {
                $eppdomainresult = $epp->create_hindidomain($user->domainName, $period, $user->email, $password, $user_id);
            } else {
                $eppdomainresult = $epp->create_domain_v2($domainName, $period, $user->email, $password, $user_id);
            }

            $xmlresult = simplexml_load_string($eppdomainresult);

            $resultAttributes = $xmlresult->response->result->attributes();

            $resultcode = (string) $resultAttributes['code'];

            $resultMessage = (string) $xmlresult->response->result->msg;

            if ($resultcode == '1000' && $resultMessage == 'Command completed successfully') {

                if ($namserver != null) {

                    if ($namserver->server_type != 3) {

                        $paramscreate = [
                            'ns1' => [
                                'host' => $namserver->primary_name_server,
                                'ip4' => $namserver->primary_name_server_ip,
                                'ip6' => $namserver->primary_name_server_ip6,
                            ],
                            'ns2' => [
                                'host' => $namserver->secondary_name_server1,
                                'ip4' => $namserver->secondary_name_server1_ip,
                                'ip6' => $namserver->secondary_name_server1_ip6,
                            ],
                        ];

                        if ($namserver->secondary_name_server2 != null) {
                            $paramscreate['ns3'] = [
                                'host' => $namserver->secondary_name_server2,
                                'ip4' => $namserver->secondary_name_server2_ip,
                                'ip6' => $namserver->secondary_name_server2_ip6,
                            ];
                        }

                        if ($namserver->secondary_name_server3 != null) {
                            $paramscreate['ns4'] = [
                                'host' => $namserver->secondary_name_server3,
                                'ip4' => $namserver->secondary_name_server3_ip,
                                'ip6' => $namserver->secondary_name_server3_ip6,
                            ];
                        }

                        if ($namserver->secondary_name_server4 != null) {
                            $paramscreate['ns5'] = [
                                'host' => $namserver->secondary_name_server4,
                                'ip4' => $namserver->secondary_name_server4_ip,
                                'ip6' => $namserver->secondary_name_server4_ip6,
                            ];
                        }

                        if ($namserver->secondary_name_server5 != null) {
                            $paramscreate['ns6'] = [
                                'host' => $namserver->secondary_name_server5,
                                'ip4' => $namserver->secondary_name_server5_ip,
                                'ip6' => $namserver->secondary_name_server5_ip6,
                            ];
                        }

                        $respone = $epp->domainaddNameServer($domainName, $paramscreate);

                        $dsdtaas = DB::table('dns_security-extension')->where('user_dns_server_id', $namserver->id)->get();

                        $addDsData = [];

                        foreach ($dsdtaas as $name) {
                            if ($name->key_tag != null || $name->key_tag != '') {
                                $addDsData[] = [
                                    'keyTag' => $name->key_tag,
                                    'alg' => $name->algorithm,
                                    'digestType' => $name->digest_type == 'SHA1' ? "1" : '',
                                    'digest' => $name->digest,
                                ];
                            }
                        }

                        $res = $epp->domainupdateDNSSEC($domainName, $addDsData);
                    }
                }



                $transactionsData = DB::table('transactions')
                    ->where('transaction_status', '0300')
                    ->where('user_id', $user_id)
                    ->whereIn('transaction_type', ['domainRegister', 'domainRegisterWithNameServer'])
                    ->orderByDesc('id')
                    ->value('request');

                if ($transactionsData) {
                    $decodedData = json_decode($transactionsData, true); // decode the string directly
                    $dnsDate = $decodedData['dns_duration'];
                }


                $user->domainCreationDate = Carbon::now();
                $user->domainExpiryDate = Carbon::now()->addYears($user->domainPeriod ?? 1);
                $user->dnsExpiryDate = Carbon::now()->addYears($dnsDate ?? 1);
                $user->domainStatus = 6;
                $user->updated_at = $updated_date;
                $user->save();

                $user = DB::table('users')->where('id', $user_id)->first();

                $view_path = 'inv';
                $downloadname = 'invoice';


                $titlefromadmin = getmisc();
                $data['content'] = 'Your domain (' . $user->domainName . ') has been registered successfully for  ' . $user->domainPeriod . ' years.
                    Hard copy of Letter of Undertaking should be submitted within 10 days.';
                $data['email'] = $user->email;

                $data['extradata'] = '';

                if ($namserver->server_type == 1) {
                    $data['extradata'] = 'Please Upload the zone details on ERNET India Portal within 15 days';
                }

                $data['name'] = $user->name;
                $data['subject'] = 'Your domain (' . $user->domainName . ') has been registered successfully';
                $data['ccMails'] = getCCMail($user_id);

                $users = DB::table('users')->where('id', $user_id)->first();

                $transactions = DB::table('transactions')->where('user_id', $user_id)->where('transaction_status', '0300')->orderBy('id', 'DESC')->limit(1)->get();

                $user_detail = DB::table('user_contact_details')->where('user_id', $user_id)->first();
                $data2 = DB::table('transactions')->where('user_id', $user_id)->latest('id')->first();

                view()->share('data', $data2);
                view()->share('user', $users);
                view()->share('transactions', $transactions);
                view()->share('user_detail', $user_detail);

                $pdf = Pdf::loadView('document.inv');

                $pdfContent = $pdf->output();

                $data['attachments'] = [
                    $pdfContent
                ];


                $view = 'admin.email.DomainRegistered';

                $mailer = MailManager::getInstance();

                $status = $mailer->mailSender($view, $data);

                $authuser = Auth::guard('admin')->user();
                $activity = ['user_id' => $authuser->id, 'user_type' => 2, 'user_name' => $authuser->name, 'domainName' => $user->domainName, 'status' => 'Domain Registered', 'ip_address' => $request->ip()];
                handleActivity($activity);

                return ['status' => true, 'msg' => 'Domain Registered Successfully'];
            } else {

                $resultm = $resultMessage == 'Object exists' ? "Domain Already exists" : $resultMessage;
                return response()->json(array('status' => false, 'msg' => $resultm));
            }
        } catch (\Throwable $e) {
            $error = $e->getMessage() . ', File Path = ' . $e->getFile() . ', Line Number = ' . $e->getLine();
            return response()->json(array('status' => false, 'msg' => $error));
        }
    }

    public function registerUserDomainOld(Request $request)
    {
        try {

            $request->validate([
                'user_id' => 'required'
            ]);

            $user_id = $request->input('user_id');

            $checktransaction = DB::table('transactions')
                ->where('transaction_status', '0300')
                ->whereIn('transaction_type', ['domainRegister', 'domainRegisterWithNameServer'])
                ->where('user_id', $user_id)
                ->count();

            if ($checktransaction == 0) {
                $update = DB::table('users')->where('id', $user_id)->update(['domainStatus' => 1, 'document_status' => 0, 'domainExpiryDate' => null]);
                $docupdate = DB::table('user_documents')->where('user_id', $user_id)->update(['status' => 1]);
                return response()->json(array('status' => false, 'msg' => 'Payment not received'));
            }

            $namserver = DB::table('user_name_servers')->where('user_id', $user_id)->first();

            $updated_date = date('Y-m-d H:i:s');
            $user = User::find($user_id);

            if ($namserver != null) {

                if ($namserver->server_type == 1) {
                    $status = DB::table('zones')
                        ->updateOrInsert(
                            ['user_id' => $user_id],
                            [
                                'server' => $namserver->primary_name_server,
                                'user_id' => $user_id,
                                'domain' => $user->domainPunycode,
                                'reverse_zone' => 1,
                                'custom_settings' => 0,
                                'refresh' => 0,
                                'retry' => 7200,
                                'expire' => 3628800,
                                'negative_ttl' => 0,
                                'default_ttl' => 0,
                                'updated_at' => $updated_date
                            ]
                        );

                    $zone = Zone::where('domain', $user->domainPunycode)->first();
                }
            }

            $data = [];

            $epp = new EPP();

            $domainName = $user->domainPunycode;

            $period = $user->domainPeriod;
            $langs = $user->domainLangID;

            $domainId = $user->id;

            $str = 'abcdefghijklmnopqrstuvwxyz123456789';
            $shuffled = str_shuffle($str);
            $password = Str::substr($shuffled, 0, 8);

            if ($langs == 3) {
                $eppdomainresult = $epp->create_hindidomain($user->domainName, $period, $user->email, $password, $domainId);
            } else {
                $eppdomainresult = $epp->create_domain($domainName, $period, $user->email, $password, $domainId);
            }

            $xmlresult = simplexml_load_string($eppdomainresult);

            $resultAttributes = $xmlresult->response->result->attributes();

            $resultcode = (string) $resultAttributes['code'];

            $resultMessage = (string) $xmlresult->response->result->msg;

            if ($resultcode == '1000' && $resultMessage == 'Command completed successfully') {

                if ($namserver != null) {

                    if ($namserver->server_type != 3) {

                        $paramscreate = [
                            'ns1' => [
                                'host' => $namserver->primary_name_server,
                                'ip4' => $namserver->primary_name_server_ip,
                                'ip6' => $namserver->primary_name_server_ip6,
                            ],
                            'ns2' => [
                                'host' => $namserver->secondary_name_server1,
                                'ip4' => $namserver->secondary_name_server1_ip,
                                'ip6' => $namserver->secondary_name_server1_ip6,
                            ],
                        ];

                        if ($namserver->secondary_name_server2 != null) {
                            $paramscreate['ns3'] = [
                                'host' => $namserver->secondary_name_server2,
                                'ip4' => $namserver->secondary_name_server2_ip,
                                'ip6' => $namserver->secondary_name_server2_ip6,
                            ];
                        }

                        if ($namserver->secondary_name_server3 != null) {
                            $paramscreate['ns4'] = [
                                'host' => $namserver->secondary_name_server3,
                                'ip4' => $namserver->secondary_name_server3_ip,
                                'ip6' => $namserver->secondary_name_server3_ip6,
                            ];
                        }

                        if ($namserver->secondary_name_server4 != null) {
                            $paramscreate['ns5'] = [
                                'host' => $namserver->secondary_name_server4,
                                'ip4' => $namserver->secondary_name_server4_ip,
                                'ip6' => $namserver->secondary_name_server4_ip6,
                            ];
                        }

                        if ($namserver->secondary_name_server5 != null) {
                            $paramscreate['ns6'] = [
                                'host' => $namserver->secondary_name_server5,
                                'ip4' => $namserver->secondary_name_server5_ip,
                                'ip6' => $namserver->secondary_name_server5_ip6,
                            ];
                        }

                        $respone = $epp->domainaddNameServer($domainName, $paramscreate);

                        $dsdtaas = DB::table('dns_security-extension')->where('user_dns_server_id', $namserver->id)->get();

                        $addDsData = [];

                        foreach ($dsdtaas as $name) {
                            if ($name->key_tag != null || $name->key_tag != '') {
                                $addDsData[] = [
                                    'keyTag' => $name->key_tag,
                                    'alg' => $name->algorithm,
                                    'digestType' => $name->digest_type == 'SHA1' ? "1" : '',
                                    'digest' => $name->digest,
                                ];
                            }
                        }

                        $res = $epp->domainupdateDNSSEC($domainName, $addDsData);
                    }
                }

                $user->domainCreationDate = Carbon::now();
                $user->domainExpiryDate = Carbon::now()->addYears($user->domainPeriod ?? 1);
                $user->domainStatus = 6;
                $user->updated_at = $updated_date;
                $user->save();

                $user = DB::table('users')->where('id', $user_id)->first();

                $view_path = 'inv';
                $downloadname = 'invoice';


                $titlefromadmin = getmisc();
                $data['content'] = 'Your domain (' . $user->domainName . ') has been registered successfully for  ' . $user->domainPeriod . ' years.
                    Hard copy of Letter of Undertaking should be submitted within 10 days.';
                $data['email'] = $user->email;

                $data['extradata'] = '';

                if ($namserver->server_type == 1) {
                    $data['extradata'] = 'Please Upload the zone details on ERNET India Portal within 15 days';
                }

                $data['name'] = $user->name;
                $data['subject'] = 'Your domain (' . $user->domainName . ') has been registered successfully';
                $data['ccMails'] = getCCMail($user_id);

                $users = DB::table('users')->where('id', $user_id)->first();
                $transactions = DB::table('transactions')->where('user_id', $user_id)->where('transaction_status', '0300')->orderBy('id', 'DESC')->limit(1)->get();
                $user_detail = DB::table('user_contact_details')->where('user_id', $user_id)->first();
                $data2 = DB::table('transactions')->where('user_id', $user_id)->latest('id')->first();

                view()->share('data', $data2);
                view()->share('user', $users);
                view()->share('transactions', $transactions);
                view()->share('user_detail', $user_detail);

                $pdf = Pdf::loadView('document.inv');

                $pdfContent = $pdf->output();

                $data['attachments'] = [
                    $pdfContent
                ];


                $view = 'admin.email.DomainRegistered';

                $mailer = MailManager::getInstance();

                $status = $mailer->mailSender($view, $data);

                $authuser = Auth::guard('admin')->user();
                $activity = ['user_id' => $authuser->id, 'user_type' => 2, 'user_name' => $authuser->name, 'domainName' => $user->domainName, 'status' => 'Domain Registered', 'ip_address' => $request->ip()];
                handleActivity($activity);

                return ['status' => true, 'msg' => 'Domain Registered Successfully'];
            } else {

                $resultm = $resultMessage == 'Object exists' ? "Domain Already exists" : $resultMessage;
                return response()->json(array('status' => false, 'msg' => $resultm));
            }
        } catch (\Throwable $e) {
            $error = $e->getMessage() . ', File Path = ' . $e->getFile() . ', Line Number = ' . $e->getLine();
            return response()->json(array('status' => false, 'msg' => $error));
        }
    }

    private function createzone(Zone $zone)
    {
        $zone->increaseSerialNumber();
        $content = BINDFormatter::getZoneFileContent($zone);
        $path = self::ZONE_BASEDIR . DIRECTORY_SEPARATOR . $zone->domain;

        try {

            $destinationFileName = $zone->domain;

            $destinationFileName1 = $zone->domain;

            $destinationServer1 = '202.41.64.251';
            $destinationUsername1 = 'root';
            $destinationPassword1 = '54_n5dTe!V2';
            $destinationFolder1 = '/var/zones/primary';

            $sftp1 = new SFTP($destinationServer1, '2232');

            if (!$sftp1->login($destinationUsername1, $destinationPassword1)) {
                throw new \Exception('SFTP login failed');
            }

            if (!$sftp1->chdir($destinationFolder1)) {
                throw new \Exception('Failed to change directory on the destination server');
            }

            if ($sftp1->file_exists($destinationFileName1)) {
                if (!$sftp1->delete($destinationFileName1)) {
                    throw new \Exception('Failed to delete the existing file on the destination server');
                }
            }

            if (!$sftp1->put($destinationFileName1, $content)) {

                $sftp1->disconnect();

                $destinationServer = '202.41.64.252';
                $destinationUsername = 'root';
                $destinationPassword = 'y1BA8=W5@eK';
                $destinationFolder = '/var/zones/primary';

                $sftp = new SFTP($destinationServer, '2232');

                if (!$sftp->login($destinationUsername, $destinationPassword)) {
                    throw new \Exception('SFTP login failed');
                }

                if (!$sftp->chdir($destinationFolder)) {
                    throw new \Exception('Failed to change directory on the destination server');
                }

                if ($sftp->file_exists($destinationFileName)) {
                    if (!$sftp->delete($destinationFileName)) {
                        throw new \Exception('Failed to delete the existing file on the destination server');
                    }
                }

                if (!$sftp->put($destinationFileName, $content)) {
                    throw new \Exception('Failed to transfer the file to the destination server');
                }

                $sftp->disconnect();
            }

            $sftp1->disconnect();
        } catch (\Exception $e) {
        }
    }

    private function zoneconfig()
    {

        $servers = Server::withPushCapability()->get();

        if (true === $servers->isEmpty()) {
            return true;
        }

        $pushedWithErrors = false;
        foreach ($servers as $i => $server) {

            if (false === $this->handleServer($server) && (false === $pushedWithErrors)) {
                $pushedWithErrors = true;
            }
        }

        return ! $pushedWithErrors;
    }

    private function handleServer(Server $server): bool
    {
        $status = $this->generateConfigFileForServer($server);

        return true;
    }

    private function generateConfigFileForServer(Server $server)
    {
        $path = self::CONFIG_BASEDIR . DIRECTORY_SEPARATOR . $server->hostname . '.conf';
        $contents = BINDFormatter::getConfigurationFileContent($server);
        Storage::put($path, $contents, 'private');

        try {

            $destinationFileName1 = $server->hostname . '.conf';

            $destinationServer1 = '202.41.64.251';
            $destinationUsername1 = 'root';
            $destinationPassword1 = '54_n5dTe!V2';
            $destinationFolder1 = '/var/zones/configuration/';

            $sftp1 = new SFTP($destinationServer1, '2232');

            if (!$sftp1->login($destinationUsername1, $destinationPassword1)) {
                throw new \Exception('SFTP login failed');
            }

            if (!$sftp1->chdir($destinationFolder1)) {
                throw new \Exception('Failed to change directory on the destination server');
            }

            if ($sftp1->file_exists($destinationFileName1)) {
                if (!$sftp1->delete($destinationFileName1)) {
                    throw new \Exception('Failed to transfer the file to the destination server');
                }
            }

            if (!$sftp->put($destinationFileName1, $contents)) {
                throw new \Exception('Failed to transfer the file to the destination server');
            }

            $sftp1->disconnect();
        } catch (\Exception $e) {
        }

        return $path;
    }

    public function emailSettingView(Request $request)
    {
        $emailItems = EmailSetting::first();
        return view('admin.pages.admin-email-setting', ['emailItems' => $emailItems]);
    }

    public function changeEmailSettingStatus(Request $request)
    {
        $message = [
            'status' => 'error',
            'message' => 'Invalid Request'
        ];
        if ($request->ajax()) {
            $todId = $request->input('todId');
            $status = $request->input('status');
            $tod = EmailSetting::find($todId);
            if ($tod) {
                $tod->status = $status;
                if ($tod->save()) {
                    $message['status'] = 'success';
                    $message['message'] = 'Status updated successfully';
                } else {
                    $message['status'] = 'error';
                    $message['message'] = 'Something went wrong. Please try again.';
                }
            } else {
                $message['message'] = 'Item not found.';
            }
        }
        return response()->json($message);
    }

    public function updateEmailSetting(Request $request)
    {
        $validatedData = $request->validate([
            'host_name' => 'required|max:255',
            'port_number' => 'required|numeric|min:0|max:65535',
            'username' => 'required|max:255',
            'password' => 'required|max:255',
            'from_address' => 'required|email|max:255',
            'from_name' => 'required|max:255',
        ]);
        $tod_id = $request->input('tod_id');
        $tod = EmailSetting::find($tod_id);
        if (!$tod) {
            return response()->json([
                'status' => 'error',
                'message' => 'Data not found.',
            ]);
        }
        $tod->host_name = $validatedData['host_name'];
        $tod->port_number = $validatedData['port_number'];
        $tod->username = $validatedData['username'];
        $tod->password = $validatedData['password'];
        $tod->from_address = $validatedData['from_address'];
        $tod->from_name = $validatedData['from_name'];
        $tod->save();
        return response()->json([
            'status' => 'success',
            'message' => 'Email Variables updated successfully.',
        ]);
    }
    public function userInvoice(Request $request)
    {


        $data = DB::table('transactions')->where('user_id', $request->id)->where('transaction_status', '0300')->latest('id')->first();
        $user = DB::table('users')->where('id', $data->user_id)->first();
        $user_detail = DB::table('user_contact_details')->where('user_id', $data->user_id)->first();
        $transactions = DB::table('transactions')->where('user_id', $user->id)->where('transaction_status', '0300')->orderBy('id', 'DESC')->limit(1)->get();

        return view('document.invoice', compact('user', 'data', 'transactions', 'user_detail'));
    }

    public function userParticularInvoice(Request $request)
    {

        $data = DB::table('transactions')->where('id', $request->id)->latest('id')->first();
        $user = DB::table('users')->where('id', $data->user_id)->first();
        $user_detail = DB::table('user_contact_details')->where('user_id', $data->user_id)->first();
        $transactions = DB::table('transactions')->where('id', $request->id)->orderBy('id', 'DESC')->limit(1)->get();

        return view('document.invoice', compact('user', 'data', 'transactions', 'user_detail'));
    }

    public function delete_domain(Request $request)
    {

        $user = User::find($request->id);

        if ($user->domainStatus >= 6) {

            $epp = new EPP();
            $res = $epp->deletedomain($user->domainName);
        }

        $titlefromadmin = getmisc();

        $data['email'] = $user->email;
        $data['name'] = $user->name;
        $data['remarks'] = $request->delete_remarks;
        $data['subject'] = 'Your Domain (' . $user->domainName . ') has been Deleted';
        $data['content'] = '
        This is to inform you that your appliction with domain (' . $user->domainName . ') has been deleted by admin due to incomplete or inappropriate details. 
        Kindly, re-apply on the ERNET India portal.
        ';

        $data['ccMails'] = getCCMail($user->id);

        $view = 'front.email.domainadmindelete';

        $mailer = MailManager::getInstance();

        $status = $mailer->mailSender($view, $data);

        if ($user->domainStatus >= 3) {

            $user_id = $user->id;
            $path = public_path('user/docs/') . $user_id;

            $deleteion_request = '';

            if ($request->hasFile('deleteion_request')) {
                $doc = $request->file('deleteion_request');

                $filename = time() . $doc->getClientOriginalName();

                if ($doc->move($path, $filename)) {
                    $deleteion_request = $filename;
                }
            }

            DB::table('deleted_users')->insert([
                'name' => $user->name,
                'father_name' => $user->father_name,
                'age' => $user->age,
                'domainName' => $user->domainName,
                'domainPunycode' => $user->domainPunycode,
                'domainLangID' => $user->domainLangID,
                'domainExtensionID' => $user->domainExtensionID,
                'email' => $user->email,
                'email_verified_at' => $user->email_verified_at,
                'institute' => $user->institute,
                'board' => $user->board,
                'designation' => $user->designation,
                'domainPeriod' => $user->domainPeriod,
                'domainPrice' => $user->domainPrice,
                'domainStatus' => $user->domainStatus,
                'domainCreationDate' => $user->domainCreationDate,
                'domainExpiryDate' => $user->domainExpiryDate,
                'renew_years' => $user->renew_years,
                'remarks' => $request->delete_remarks,
                'deleted_by' => 2,
                'status' => 1,
                'temp_status' => 0,
                'user_id' => $user->id,
                'deleteion_request' => $deleteion_request
            ]);
        }


        $update = $user->delete();

        if ($update) {
            return response()->json(array('status' => 'success', 'message' => 'Deleted Successfully'));
        }

        return response()->json(array('errors' => 'erorr', 'message' => 'Something Error'));
    }
    public function editDomain(Request $request)
    {

        if ($request->isMethod('post')) {
            if ($request->id != '' || $request->id != Null) {

                $extension = DB::table('domain_extensions')->where('id', '=', $request->extension)->first();

                $domainName = $request->newdomain;

                $domainames = $request->newdomain . '.' . $extension->domain_extension;

                if ($extension->domain_language_id != 2) {

                    $lang_data = DB::table('domain_languages')->where('id', '=', $extension->domain_language_id)->first();
                    $translator = new Translator();
                    $result = $translator->setSourceLang('en')
                        ->setTargetLang($lang_data->lang_code)
                        ->translate($domainName);
                    $domainames = $result . '.' . $extension->domain_extension;
                }

                $epp = new EPP();
                $dname = $domainames;
                $res = $epp->checkDomainAvailability($dname);

                $dom = new \DOMDocument();
                $dom->loadXML($res);

                $availability = $dom->getElementsByTagNameNS('urn:ietf:params:xml:ns:domain-1.0', 'cd')->item(0)->getElementsByTagName('name')->item(0)->getAttribute('avail');

                $availability = 1;
                if (DB::table('users')->where('domainName', '=', $dname)->count() == 0 && $availability == '1') {

                    $transactionDtl = DB::table('transactions')->where('user_id', $request->id)->where('transaction_status', '0300')->first();
                    if ($transactionDtl) {
                        $revisedTbl = DB::table('revised_domain')->insert([
                            'unique_id' => $transactionDtl->unique_id,
                            'reference_id' => $transactionDtl->reference_id,
                            'transaction_id' => $transactionDtl->transaction_id,
                            'transaction_status' => $transactionDtl->transaction_status,
                            'transaction_type' => $transactionDtl->transaction_type,
                            'request_payload' => $transactionDtl->request_payload,
                            'response_payload' => $transactionDtl->response_payload,
                            'response_format' => $transactionDtl->response_format,
                            'user_id' => $transactionDtl->user_id,
                        ]);
                    }

                    DB::table('users')->where('id', $request->id)->update([
                        'domainName' => $domainames,
                        "domainPunycode" => idn_to_ascii($domainames),
                    ]);
                    DB::table('user_name_server_records')->where('user_id', $request->id)->update([
                        'name' => idn_to_ascii($domainames),
                    ]);
                    DB::table('transactions')->where('user_id', $request->id)->update([
                        'revised_status' => "revised",
                    ]);

                    $userdata = DB::table('users')->where('id', $request->id)->first();

                    $data['ccMails'] = getCCMail($userdata->id);

                    $data['email'] = $userdata->email;
                    $data['name'] = $userdata->name;
                    $data['title'] = "Your Domain name has been changed to " . $request->newdomain . '.' . $extension->domain_extension;

                    $data['content'] = "This is to update you that your Domain name has been changed to " . $request->newdomain . '.' . $extension->domain_extension;

                    Mail::send('front.email.editdomain', $data, function ($message) use ($data) {
                        $message->to($data["email"], $data["name"])
                            ->cc($data["ccMails"])
                            ->subject($data["title"]);
                    });

                    return response()->json(array('status' => 'success', 'message' => 'Domain updated Successfully'));
                } else {

                    return response()->json(array('status' => 'error', 'message' => 'Domain Not Available'));
                }
            } else {
                return response()->json(array('status' => 'error', 'message' => 'Something went wrong'));
            }
        }
    }
    public function sendInvoice(Request $request)
    {
        try {

            $user_id = $request->input('id');

            $users = DB::table('users')->where('id', $user_id)->first();
            $transactions = DB::table('transactions')->where('user_id', $users->id)->where('transaction_status', '0300')->orderBy('id', 'DESC')->limit(1)->get();
            $user_detail = DB::table('user_contact_details')->where('user_id', $user_id)->first();
            $data2 = DB::table('transactions')->where('user_id', $user_id)->latest('id')->first();

            view()->share('data', $data2);
            view()->share('user', $users);
            view()->share('transactions', $transactions);
            view()->share('user_detail', $user_detail);

            $view_path = 'inv';
            $downloadname = 'invoice';

            $titlefromadmin = getmisc();
            $data['content'] = 'Sharing invoice for (' . $users->domainName . ')';
            $data['email'] = $users->email;
            $data['extradata'] = '';
            $data['name'] = $users->name;
            $data['subject'] = 'Sharing invoice for (' . $users->domainName . ')';
            $pdf_name = 'invoice.pdf';
            $data['link'] = '';

            $pdf = Pdf::loadView('document.inv');

            $pdfContent = $pdf->output();

            $data['attachments'] = [
                $pdfContent
            ];

            $data['ccMails'] = getCCMail($users->id);

            $view = 'admin.email.DomainRegistered';

            $mailer = MailManager::getInstance();

            $status = $mailer->mailSender($view, $data);

            return response()->json(array('status' => 'success', 'message' => $status));
        } catch (\Throwable $e) {
            $error = $e->getMessage();
            return response()->json(array('status' => true, 'msg' => $error));
        }
    }

    public function admin_incusers_details_view_deleted($id)
    {


        $id = base64_decode($id);
        $data['payment'] = DB::table('transactions')->where('user_id', '=', $id)->where('transaction_status', '0300')->latest('created_at')->first();
        $user_contact_details = DB::table('user_contact_details')
            ->where('user_id', '=', $id)
            ->first();
        $data['user_name_server'] = DB::table('user_name_servers')->where('user_id', '=', $id)->first();
        $user_data = DB::table('inc_deleted_users')
            ->where('user_id', '=', $id)
            ->first();
        $data['title'] = 'Users Details';
        $data['user_documents'] = DB::table('user_documents')->where('user_id', '=', $id)->get();
        $userdocuments = DB::table('user_documents')->select('user_documents.*', 'document_category.title')->where('user_id', $id)->join('document_category', 'document_category.id', 'user_documents.document_category_id')->get();
        $data['lastpayment'] = DB::table('transactions')->where('user_id', '=', $id)->where('transaction_status', '0300')->latest('created_at')->first();

        // dd($user_contact_details);

        return view('admin.pages.pages.inc-del-user', [
            'user_contact_details' => $user_contact_details,
            'lastpayment' =>  $data['lastpayment'],
            'user_data' => $user_data,
            'payment' => $data['payment'],
            'user_name_server' => $data['user_name_server'],
            'user_documents' => $data['user_documents'],
            'userdocuments' => $userdocuments,
            'title' => 'Users Details',
        ]);
    }

    public function restoreFromIncDeletedUsers(Request $request)
    {
        $id = $request->id;

        $user = DB::table('inc_deleted_users')->where('user_id', $id)->first();

        if ($user == null) {
            return response()->json([
                'errors' => 'error',
                'message' => 'User not found in inc_deleted_users'
            ]);
        }

        $password = Hash::make('Ernet@123');

        DB::table('users')->insert([
            'id' => $user->user_id,
            'name' => $user->name,
            'father_name' => $user->father_name,
            'age' => $user->age,
            'domainName' => $user->domainName,
            'domainPunycode' => idn_to_ascii($user->domainName),
            'domainLangID' => $user->domainLangID,
            'domainExtensionID' => $user->domainExtensionID,
            'email' => $user->email,
            'email_verified_at' => $user->email_verified_at,
            'password' => $password,
            'institute' => $user->institute,
            'board' => $user->board,
            'designation' => $user->designation,
            'domainPeriod' => $user->domainPeriod,
            'domainPrice' => $user->domainPrice,
            'domainStatus' =>  $user->domainStatus,
            'renew_years' => $user->renew_years ?? 0,

            'status' =>  $user->status,
            'domainExpiryDate' => $user->domainExpiryDate,
            'domainCreationDate' => $user->domainCreationDate,


            'ewaas_extragb' => Auth::guard('admin')->user()->id,
            'created_at' => $user->original_created_at,
            'updated_at' => now(),
        ]);



        DB::table('user_documents')->where('user_id', $id)->update(['deleted_status' => 0]);
        DB::table('transactions')->where('user_id', $id)->update(['deleted_status' => 0]);
        DB::table('user_contact_details')->where('user_id', $id)->update(['deleted_status' => 0]);

        DB::table('inc_deleted_users')->where('user_id', $id)->delete();

        return response()->json([
            'status' => 'success',
            'message' => 'Restored from inc_deleted_users'
        ]);
    }




    public function service_discount_ajaxcall(Request $request)
    {
        $draw = $request->get('draw');
        $start = $request->get("start");
        $rowperpage = $request->get("length");

        $columnIndex_arr = $request->get('order');
        $columnName_arr = $request->get('columns');
        $order_arr = $request->get('order');
        $search_arr = $request->get('search');

        $columnIndex = $columnIndex_arr[0]['column'];
        $columnName = $columnName_arr[$columnIndex]['data'];
        $columnSortOrder = $order_arr[0]['dir'];
        $searchValue = $search_arr['value'];

        $totalRecords = ServiceDiscount::select('count(*) as allcount')->count();
        $totalRecordswithFilter = ServiceDiscount::select('count(*) as allcount')
            ->where(function ($query) use ($searchValue) {
                $query->where('period', 'like', '%' . $searchValue . '%')
                    ->orWhere('services', 'like', '%' . $searchValue . '%')
                    ->orWhere('discount', 'like', '%' . $searchValue . '%');
            })
            ->count();

        $records = ServiceDiscount::orderBy($columnName, $columnSortOrder)
            ->where(function ($query) use ($searchValue) {
                $query->where('period', 'like', '%' . $searchValue . '%')
                    ->orWhere('services', 'like', '%' . $searchValue . '%')
                    ->orWhere('discount', 'like', '%' . $searchValue . '%');
            })
            ->skip($start)
            ->take($rowperpage)
            ->get();

        $data_arr = array();
        foreach ($records as $record) {
            $services = explode(',', $record->services);
            $servicesHtml = '';
            foreach ($services as $service) {
                $servicesHtml .= '<span class="badge bg-label-primary me-1">' . ucfirst($service) . '</span>';
            }

            $data_arr[] = array(
                "id" => $record->id,
                "period" => $record->period . ' Year' . ($record->period > 1 ? 's' : ''),
                "services" => $servicesHtml,
                "discount" => $record->discount . '%',
                "action" => '<button class="btn btn-sm btn-primary edit-discount" data-id="' . $record->id . '">Edit</button>' .
                    '<button class="btn btn-sm btn-danger delete-discount ms-2" data-id="' . $record->id . '">Delete</button>'
            );
        }

        $response = array(
            "draw" => intval($draw),
            "iTotalRecords" => $totalRecords,
            "iTotalDisplayRecords" => $totalRecordswithFilter,
            "aaData" => $data_arr
        );

        return response()->json($response);
    }

    public function service_discount_store(Request $request)
    {
        $request->validate([
            'period' => 'required|integer|between:1,10',
            'services' => 'required|array',
            'discount' => 'required|numeric|between:0,100'
        ]);

        try {
            $discount = new ServiceDiscount();
            $discount->period = $request->period;
            $discount->services = implode(',', $request->services);
            $discount->discount = $request->discount;
            $discount->save();

            return response()->json([
                'status' => 'success',
                'message' => 'Discount added successfully'
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'status' => 'error',
                'message' => 'Failed to add discount: ' . $e->getMessage()
            ]);
        }
    }

    public function service_discount_edit(Request $request)
    {
        $discount = ServiceDiscount::find($request->id);

        if (!$discount) {
            return response()->json([
                'status' => 'error',
                'message' => 'Discount not found'
            ]);
        }

        return response()->json([
            'status' => 'success',
            'discount' => $discount
        ]);
    }

    public function service_discount_update(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'discount_id' => 'required|exists:service_discounts,id',
            'period' => 'required|integer|between:1,10',
            'services' => 'required|array',
            'discount' => 'required|numeric|between:0,100'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => 'error',
                'message' => 'Validation failed',
                'errors' => $validator->errors()
            ], 422);
        }

        try {
            $discount = ServiceDiscount::find($request->discount_id);
            $discount->period = $request->period;
            $discount->services = implode(',', $request->services);
            $discount->discount = $request->discount;
            $discount->save();

            return response()->json([
                'status' => 'success',
                'message' => 'Discount updated successfully'
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'status' => 'error',
                'message' => 'Failed to update discount: ' . $e->getMessage()
            ], 500);
        }
    }

    public function service_discount_destroy(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'id' => 'required|exists:service_discounts,id'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => 'error',
                'message' => 'Invalid discount ID'
            ], 422);
        }

        try {
            $discount = ServiceDiscount::find($request->id);
            $discount->delete();

            return response()->json([
                'status' => 'success',
                'message' => 'Discount deleted successfully'
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'status' => 'error',
                'message' => 'Failed to delete discount: ' . $e->getMessage()
            ], 500);
        }
    }
}
