<?php

namespace App\Http\Controllers\admin\master;

use App\Http\Controllers\Controller;
use App\Models\State;
use App\Providers\RouteServiceProvider;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Auth, Validator, Redirect;
use App\Models\Discount;
use App\Components\DiscountManager;
use Illuminate\Http\Request;
use DB;
class DiscountController extends Controller
{
    public function __construct()
    {
    }
	
	public function index() 
	{
        $exts=DB::table('domain_extensions')->get();
		return view('admin/discount/index',['exts'=>$exts]);
    }
	
	public function save(Request $request)
	{
		try
		{
			if($request->isMethod('post'))
			{
				$params = $request->all();
				$messages = [
					'max' => 'Description should not be greater than 50 characters.',
				];
				$validator = Validator::make($params,[
					'name' =>'required|max:50|unique:discounts,name',
                    'discount'=>'required',
                    'start_date'=>'required',
                    'end_date'=>'required'
				], $messages);
				
				if($validator->fails())
				{
					return response()->json(array('status'=>'errors', 'message' => $validator->errors()));
				}

                $departmentObj = DiscountManager::getInstance();
				
                $params=[
                    'name' => $request->name,
                    'discount'=>$request->discount,
                    'start_date' => $request->start_date,
                    'end_date'=>$request->end_date,
                    'extension'=>$request->extension== null? '': implode(',',$request->extension),
                    'status'=>$request->status
                ];

				$status = $departmentObj->create($params);
				
				if($status)
				{
					return response()->json(array('status'=>'success'));
				}
				
				return response()->json(array('status'=>'error', 'error' => 'Something Wrong'));
			}
		
			return redirect('home')->with('error', 'Not valid');
		}
		catch (\Throwable $e)
		{
			$error = $e->getMessage().', File Path = '.$e->getFile().', Line Number = '.$e->getLine();
			return response()->json(array('status'=>'exceptionError','error'=>$error));
		}
	}
	
	public function update(Request $request)
	{
		try
		{
			$params = $request->all();
			$messages = [
				'max' => 'Description should not be greater than 50 characters.',
			];
			$validator = Validator::make($params,[
                'name' =>'required|max:50|unique:discounts,name,'.$request->id,
                'discount'=>'required',
                'start_date'=>'required',
                'end_date'=>'required'
			], $messages);
			
			if($validator->fails())
			{
				return response()->json(array('status'=>'errors', 'message' => $validator->errors()));
			}

			$id = $request->id;
			$departmentObj = DiscountManager::getInstance();

            $params=[
                'name' => $request->name,
                'discount'=>$request->discount,
                'start_date' => $request->start_date,
                'end_date'=>$request->end_date,
                'extension'=>$request->extension== null? '': implode(',',$request->extension),
                'status'=>$request->status
            ];

			$status = $departmentObj->updateById($id, $params);
			
			if($status)
			{
				return response()->json(array('status'=>'success', 'message' => 'Successfully Update.'));
			}
			
			return response()->json(array('status'=>'error', 'message' => 'Something went wrong please try again.'));
		}
		catch (\Throwable $e)
		{
			$error = $e->getMessage().', File Path = '.$e->getFile().', Line Number = '.$e->getLine();
			return response()->json(array('status'=>'exceptionError','erorr'=>$error));
		}
	}
	
	public function deleteById(Request $request)
	{
		try
		{
			$id = $request->id;
			$departmentObj = DiscountManager::getInstance();
			$department = $departmentObj->getDiscountById($id);
			
			if($department == null)
			{
				return response()->json(array('status'=>'error', 'message' => 'Record not found.'));
			}
			
			$status = $departmentObj->deleteById($id);
			
			if($status)
			{
				return response()->json(array('status'=>'success', 'message' => 'Successfully Delete.'));
			}
			
			return response()->json(array('status'=>'error', 'message' => 'Something went wrong please try again.'));
		}
		catch (\Throwable $e)
		{
			$error = $e->getMessage().', File Path = '.$e->getFile().', Line Number = '.$e->getLine();
			return response()->json(array('status'=>'exceptionError'));
		}
	}
	
	public function get(Request $request)
	{
		$id = $request->id;
		$departmentObj = DiscountManager::getInstance();
		$department = $departmentObj->getDiscountById($id);
		if($department == null)
		{
			return response()->json(array('status'=>'error', 'message' => 'Record not found.'));
		}
		
        if($department->extension > 0) {
			$extdata = explode(',',$department->extension);
        }
		return response()->json(array('status'=>'success', 'data' => $department,'extdata'=>$extdata));
		
	}
	
	public function ajaxcall(Request $request)
	{
		 ## Read value
		 $draw = $request->get('draw');
		 $start = $request->get("start");
		 $rowperpage = $request->get("length"); 

		 $columnIndex_arr = $request->get('order');
		 $columnName_arr = $request->get('columns');
		 $order_arr = $request->get('order');
		 $search_arr = $request->get('search');

		 $columnIndex = $columnIndex_arr[0]['column']; 
		 $columnName = $columnName_arr[$columnIndex]['data'];
		 $columnSortOrder = $order_arr[0]['dir']; 
		 $searchValue = $search_arr['value']; 

		 $countData = Discount::select('count(*) as allcount');		 
		if($searchValue != null) {
			$countData->where('discounts.name', 'like', '%' .$searchValue . '%');
		}
		
		$totalRecordswithFilter = $countData->count();
		$totalRecords = $totalRecordswithFilter;
		$records = Discount::select('discounts.*')
         ->skip($start)
		 ->take($rowperpage)
         ->orderBy('discounts.id',$columnSortOrder); ;
		   
			if($searchValue != null) {
				$records->where('discounts.name', 'like', '%' .$searchValue . '%');
			}

		$list = $records->get();

		 $data_arr = array();
		 
		 foreach($list as $sno => $record){
			$id = $record->id;
			$code = '<a href="javascript:void(0);" style="" class="view" data-id="'.$id.'">'.$record->name.'</a>';
			$edit = asset('icon/edit2.png');
			$delete = asset('icon/del.png');

			$action='';

			$userid=Auth::guard('admin')->user()->id;

			$edit=$del=true;
			$priv=getUserHasRoleProgram($userid,10);

			if($priv!=null){
				$edit=$priv->modify_priv==1 ?true:false;
				$del=$priv->del_priv==1 ?true:false;
			}

			if($edit){
				$action.=' <a class="dropdown-items update" href="javascript:void(0);" style="float:left" data-id="'.$id.'" ><i class="fa fa-edit fs-4"></i></a>';
			}

			if($del){
				$action.= '<a class="dropdown-items delete" href="javascript:void(0);" style="margin-left:10px;float:left" data-id="'.$id.'"><i class="fa fa-trash fs-4 text-danger"></i></a>';
			}

			// $action = ' <a class="dropdown-items update" href="javascript:void(0);" style="float:left" data-id="'.$id.'" ><i class="fa fa-edit fs-4"></i></a>
            // <a class="dropdown-items delete" href="javascript:void(0);" style="margin-left:10px;float:left" data-id="'.$id.'"><i class="fa fa-trash fs-4"></i></a>';
			
			$data_arr[] = array(
			  "id" => ++$start,
			  "code" => $code,
			  "extension" => $record->discount,
              "status"=>$record->status==1?"Active":"Deactive",
			  "Action" => $action
			);
		 }

		 $response = array(
			"draw" => intval($draw),
			"iTotalRecords" => $totalRecords,
			"iTotalDisplayRecords" => $totalRecordswithFilter,
			"aaData" => $data_arr
		 );

		 echo json_encode($response);
		 exit;
	}
	
}
