<?php

namespace App\Http\Controllers\admin\master;

use App\Http\Controllers\Controller;
use App\Models\Module;
use App\Providers\RouteServiceProvider;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Auth, Validator, Redirect;
use App\Models\Program;
use App\Components\ProgramManager;
use Illuminate\Http\Request;
class ProgramController extends Controller
{
    public function __construct()
    {
    }
	
	public function index() 
	{
        $regions=Module::all();
		return view('admin/program/index',['modules'=>$regions]);
    }
	
	public function save(Request $request)
	{
		try
		{
			if($request->isMethod('post'))
			{
				$params = $request->all();
				$messages = [
					'max' => 'Description should not be greater than 50 characters.',
				];
				$validator = Validator::make($params,[
					'description' =>'required|max:50|unique:programs,description',
                    'module_id'=>'required',
                    'status'=>'required'
				], $messages);
				
				if($validator->fails())
				{
					return response()->json(array('status'=>'errors', 'message' => $validator->errors()));
				}

                $departmentObj = ProgramManager::getInstance();
				
				$status = $departmentObj->create(['description' => $request->description,'module_id'=>$request->module_id, 'created_by'=>'super-admin', 'status'=>$request->status]);
				
				if($status)
				{
					return response()->json(array('status'=>'success'));
				}
				
				return response()->json(array('status'=>'error', 'error' => 'Something Wrong'));
			}
		
			return redirect('home')->with('error', 'Not valid');
		}
		catch (\Throwable $e)
		{
			$error = $e->getMessage().', File Path = '.$e->getFile().', Line Number = '.$e->getLine();
			return response()->json(array('status'=>'exceptionError','error'=>$error));
		}
	}
	
	public function update(Request $request)
	{
		try
		{
			$params = $request->all();
			$messages = [
				'max' => 'Description should not be greater than 50 characters.',
			];
			$validator = Validator::make($params,[
				'description' =>'required|max:50',
                    'module_id'=>'required',
                    'status'=>'required'
			], $messages);
			
			if($validator->fails())
			{
				return response()->json(array('status'=>'errors', 'message' => $validator->errors()));
			}

			$id = $request->id;
			$departmentObj = ProgramManager::getInstance();
			$status = $departmentObj->updateById($id, ['description' => $request->description,'module_id'=>$request->module_id, 'created_by'=>'super-admin', 'status'=>$request->status]);
			
			if($status)
			{
				return response()->json(array('status'=>'success', 'message' => 'Successfully Update.'));
			}
			
			return response()->json(array('status'=>'error', 'message' => 'Something went wrong please try again.'));
		}
		catch (\Throwable $e)
		{
			$error = $e->getMessage().', File Path = '.$e->getFile().', Line Number = '.$e->getLine();
			return response()->json(array('status'=>'exceptionError','erorr'=>$error));
		}
	}
	
	public function deleteById(Request $request)
	{
		try
		{
			$id = $request->id;
			$departmentObj = ProgramManager::getInstance();
			$department = $departmentObj->getProgramById($id);
			
			if($department == null)
			{
				return response()->json(array('status'=>'error', 'message' => 'Record not found.'));
			}
			
			$status = $departmentObj->deleteById($id);
			
			if($status)
			{
				return response()->json(array('status'=>'success', 'message' => 'Successfully Delete.'));
			}
			
			return response()->json(array('status'=>'error', 'message' => 'Something went wrong please try again.'));
		}
		catch (\Throwable $e)
		{
			$error = $e->getMessage().', File Path = '.$e->getFile().', Line Number = '.$e->getLine();
			return response()->json(array('status'=>'exceptionError'));
		}
	}
	
	public function get(Request $request)
	{
		$id = $request->id;
		$departmentObj = ProgramManager::getInstance();
		$department = $departmentObj->getProgramById($id);
		if($department == null)
		{
			return response()->json(array('status'=>'error', 'message' => 'Record not found.'));
		}
		
		return response()->json(array('status'=>'success', 'data' => $department));
		
	}
	
	public function ajaxcall(Request $request)
	{
		 ## Read value
		 $draw = $request->get('draw');
		 $start = $request->get("start");
		 $rowperpage = $request->get("length"); 

		 $columnIndex_arr = $request->get('order');
		 $columnName_arr = $request->get('columns');
		 $order_arr = $request->get('order');
		 $search_arr = $request->get('search');

		 $columnIndex = $columnIndex_arr[0]['column']; 
		 $columnName = $columnName_arr[$columnIndex]['data'];
		 $columnSortOrder = $order_arr[0]['dir']; 
		 $searchValue = $search_arr['value']; 

		 $countData = Program::select('count(*) as allcount')
           ->join('modules','modules.id','programs.module_id');
		 
		if($searchValue != null) {
			$countData->where('description', 'like', '%' .$searchValue . '%');
		}

		if($request->module_id!=null){
			$countData->where('programs.module_id', 'like', '%' .$request->module_id . '%');
		}
		
		$totalRecordswithFilter = $countData->count();
		$totalRecords = $totalRecordswithFilter;
		 $records = Program::select('programs.*','modules.menu')
           ->join('modules','modules.id','programs.module_id')
		   ->skip($start)
		   ->take($rowperpage);
		   
			if($columnName == 'id') {
			   $records->orderBy($columnName,$columnSortOrder);
			}
			
			if($searchValue != null) {
				$records->where('description', 'like', '%' .$searchValue . '%');
			}
			
		if($request->module_id!=null){
			$records->where('programs.module_id', 'like', '%' .$request->module_id . '%');
		}
		
		$list = $records->get();

		 $data_arr = array();
		 
		 foreach($list as $sno => $record){
			$id = $record->id;
			$code = '<a href="javascript:void(0);" style="border-bottom:dashed 1px #0088cc" class="view" data-id="'.$id.'">'.$id.'</a>';
			$description = $record->description;
			$edit = asset('icon/edit2.png');
			$delete = asset('icon/del.png');

			$action='';

			$userid=Auth::guard('admin')->user()->id;

			$edit=$del=true;
			$priv=getUserHasRoleProgram($userid,4);

			if($priv!=null){
				$edit=$priv->modify_priv==1 ?true:false;
				$del=$priv->del_priv==1 ?true:false;
			}

			if($edit){
				$action.=' <a class="dropdown-items update" href="javascript:void(0);" style="float:left" data-id="'.$id.'" ><i class="fa fa-edit fs-4"></i></a>';
			}

			// if($del){
			// 	$action.= '<a class="dropdown-items delete" href="javascript:void(0);" style="margin-left:10px;float:left" data-id="'.$id.'"><i class="fa fa-trash fs-4"></i></a>';
			// }

			// $action = ' <a class="dropdown-items update" href="javascript:void(0);" style="float:left" data-id="'.$id.'" ><i class="fa fa-edit fs-4"></i></a>';
            // <a class="dropdown-items delete" href="javascript:void(0);" style="margin-left:10px;float:left" data-id="'.$id.'"><i class="fa fa-trash fs-4"></i></a>';
			
			$data_arr[] = array(
			  "id" => ++$start,
			  "description" => $description,
              "module"=>$record->menu,
			  "Action" => $action
			);
		 }

		 $response = array(
			"draw" => intval($draw),
			"iTotalRecords" => $totalRecords,
			"iTotalDisplayRecords" => $totalRecordswithFilter,
			"aaData" => $data_arr
		 );

		 echo json_encode($response);
		 exit;
	}
	
	private function exceptionHandling($error)
	{
				
	}
	
}
 