<?php

namespace App\Http\Controllers\admin\master;

use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Auth, Validator, Redirect;
use App\Models\State;
use App\Components\StateManager;
use Illuminate\Http\Request;
class StateController extends Controller
{
    public function __construct()
    {
    }

	
	public function index() 
	{
		return view('admin/region/index');
	}
	
	public function save(Request $request)
	{
		try
		{
			if($request->isMethod('post'))
			{
				$params = $request->all();
				$messages = [
					'max' => 'Description should not be greater than 50 characters.',
				];
				$validator = Validator::make($params,[
					'description' =>'required|max:50|unique:regions,description|regex:/^[a-zA-Z0-9& ]+$/',
				], $messages);
				
				if($validator->fails())
				{
					return response()->json(array('status'=>'errors', 'message' => $validator->errors()));
				}
				$description = $request->description;
				$departmentObj = StateManager::getInstance();
				               
				$status = $departmentObj->create(['description' => $description]);
				
				if($status)
				{
					return response()->json(array('status'=>'success'));
				}
				
				return response()->json(array('status'=>'error', 'error' => 'Something Wrong'));
			}
		
			return redirect('home')->with('error', 'Not valid');
		}
		catch (\Throwable $e)
		{
			$error = $e->getMessage().', File Path = '.$e->getFile().', Line Number = '.$e->getLine();
			return response()->json(array('status'=>'exceptionError','data'=>$error));
		}
	}
	
	public function update(Request $request)
	{
		try
		{
			$params = $request->all();
			$messages = [
				'max' => 'Description should not be greater than 50 characters.',
			];
			$validator = Validator::make($params,[
				'description' =>'required|max:50|regex:/^[a-zA-Z0-9& ]+$/',
			], $messages);
			
			if($validator->fails())
			{
				return response()->json(array('status'=>'errors', 'message' => $validator->errors()));
			}
			$id = $request->id;
			$description = $request->description;
			$departmentObj = StateManager::getInstance();
		
			$user_id=Auth::guard('admin')->user()->id;

			$oldstate = State::find($request->id);
			$clone = $oldstate->replicate();

			$params=[
				'description' => $description
			];

			$status = $oldstate->update($params);

			$newstate=$oldstate->getChanges();
			$changes = ' ID- '.$request->id.' ';

			foreach($params as $key=> $para){
				if(isset($newstate[$key]) && isset($clone->$key)){
					   $changes .= $key.' Old Value '.$clone->$key.' New Value '.$para.' ';
				}
			}

			$st=Storehistory($user_id,'State Master','Update',$changes);

			
			if($status)
			{
				return response()->json(array('status'=>'success', 'message' => 'Successfully Update.'));
			}
			
			return response()->json(array('status'=>'error', 'message' => 'Something went wrong please try again.'));
		}
		catch (\Throwable $e)
		{
			$error = $e->getMessage().', File Path = '.$e->getFile().', Line Number = '.$e->getLine();
			return response()->json(array('status'=>'exceptionError'));
		}
	}
	
	public function deleteById(Request $request)
	{
		try
		{
			$id = $request->id;
			$departmentObj = StateManager::getInstance();
			$department = $departmentObj->getStateById($id);
			
			if($department == null)
			{
				return response()->json(array('status'=>'error', 'message' => 'Record not found.'));
			}
			
			$status = $departmentObj->deleteById($id);
			
			if($status)
			{
				$user_id=Auth::guard('admin')->user()->id;
				$st=Storehistory($user_id,'State Master','Delete',$department);

				return response()->json(array('status'=>'success', 'message' => 'Successfully Delete.'));
			}
			
			return response()->json(array('status'=>'error', 'message' => 'Something went wrong please try again.'));
		}
		catch (\Throwable $e)
		{
			$error = $e->getMessage().', File Path = '.$e->getFile().', Line Number = '.$e->getLine();
			return response()->json(array('status'=>'exceptionError','error'=>$error));
		}
	}
	
	public function get(Request $request)
	{
		
		$id = $request->id;
		$departmentObj = State::find($id);
		
		return response()->json(array('status'=>'success', 'data' =>$departmentObj ));
		
	}
	
	public function ajaxcall(Request $request)
	{
		 ## Read value
		 $draw = $request->get('draw');
		 $start = $request->get("start");
		 $rowperpage = $request->get("length"); // Rows display per page

		 $columnIndex_arr = $request->get('order');
		 $columnName_arr = $request->get('columns');
		 $order_arr = $request->get('order');
		 $search_arr = $request->get('search');

		 $columnIndex = $columnIndex_arr[0]['column']; // Column index
		 $columnName = $columnName_arr[$columnIndex]['data']; // Column name
		 $columnSortOrder = $order_arr[0]['dir']; // asc or desc
		 $searchValue = $search_arr['value']; // Search value

		 $countData = State::select('count(*) as allcount');
		 
		if($searchValue != null) {
			$countData->where('description', 'like', '%' .$searchValue . '%');
		}
		
		$totalRecordswithFilter = $countData->count();
		$totalRecords = $totalRecordswithFilter;
		 $records = State::select('*')
		   ->skip($start)
		   ->take($rowperpage);
		   
			if($columnName == 'id') {
			   $records->orderBy($columnName,$columnSortOrder);
			}
			
			if($searchValue != null) {
				$records->where('description', 'like', '%' .$searchValue . '%');
			}
		
		$list = $records->get();

		 $data_arr = array();
		 
		 foreach($list as $sno => $record){
			$id = $record->id;
			$code = '<a href="javascript:void(0);" style="border-bottom:dashed 1px #0088cc" class="view" data-id="'.$id.'">'.$id.'</a>';
			$description = $record->description;
			$edit = asset('icon/edit2.png');
			$delete = asset('icon/del.png');

			$action='';

			$userid=Auth::guard('admin')->user()->id;

			$edit=$del=true;
			$priv=getUserHasRoleProgram($userid,1);

			if($priv!=null){
				$edit=$priv->modify_priv==1 ?true:false;
				$del=$priv->del_priv==1 ?true:false;
			}

			if($edit){
				$action.=' <a class="dropdown-items update" href="javascript:void(0);" style="float:left" data-id="'.$id.'" ><i class="fa fa-edit fs-4"></i></a>';
			}

			if($del){
				$action.= '<a class="dropdown-items delete" href="javascript:void(0);" style="margin-left:10px;float:left" data-id="'.$id.'"><i class="fa fa-trash fs-4"></i></a>';
			}
			
			$data_arr[] = array(
			  "id" => ++$start,
			  "code" => $code,
			  "description" => $description,
			  "Action" => $action
			);
		 }

		 $response = array(
			"draw" => intval($draw),
			"iTotalRecords" => $totalRecords,
			"iTotalDisplayRecords" => $totalRecordswithFilter,
			"aaData" => $data_arr
		 );

		 echo json_encode($response);
		 exit;
	}
	
	private function exceptionHandling($error)
	{
			$obj = \App\Components\AuditReportManager::getInstance();
			$data = array('name' => "State Master", 'data' => $error, 'user_id' => Auth::user()->id);
			$obj->save($data);		
	}
	
}