<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Cache\RateLimiter;
use Illuminate\Http\Request;
// use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Response;

class CustomThrottleMiddleware
{
    protected $limiter;

    public function __construct(RateLimiter $limiter)
    {
        $this->limiter = $limiter;
    }

    public function handle(Request $request, Closure $next, $maxAttempts = 3, $decayMinutes = 5)
    {
        $key = $this->resolveRequestSignature($request);

    if ($this->limiter->tooManyAttempts($key, $maxAttempts)) {
        $retryAfter = $this->limiter->availableIn($key);

        return Response::json([
            'status' => 'error',
            'message' => 'Too many login attempts. Please try again later.',
            'retry_after' => $retryAfter,
        ], 429);
    }

    $this->limiter->hit($key, $decayMinutes * 60);

    return $next($request);
    
    }

    protected function resolveRequestSignature($request)
    {
        return sha1(
            $request->method() .
            '|' . $request->server('SERVER_NAME') .
            '|' . $request->path() .
            '|' . $request->ip()
        );
    }
}
