<?php

namespace App\Imports;

use Illuminate\Support\Facades\Hash;
use Maatwebsite\Excel\Concerns\ToModel;
use DB,Auth;
use Session;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\SkipsOnError;
use Maatwebsite\Excel\Concerns\SkipsEmptyRows;
use Illuminate\Support\Collection;
use Carbon\Carbon;
use Illuminate\Support\Facades\Validator;
use Maatwebsite\Excel\Concerns\WithLimit;
use Log;
use App\Library\EPP;

class DomainImport implements ToCollection, WithHeadingRow, SkipsOnError, SkipsEmptyRows
{
    /**
    * @param Collection $collection
    */
    public function collection(Collection $rows)
    {
        $userId=Auth::guard('admin')->user()->id;

        $period=Session::get('domainPeriod');
        $DomainPrice=0;
        $extensionmain=0;

        foreach ($rows as  $key => $row) { 
            $validator = $this->getvalidatorinstance($row->toArray());

            $params=[
				'user_id' => $userId,
				'name'  => $row['name_of_head_of_institute']??'',
				'domainName' => trim($row['domain'])??'',
				'domainPunycode' => trim($row['domain'])??'',
				'institute' => $row['institute_name']??'',
				'address' => $row['address']??'',
				'domainLangID' => 2,
				'domainPeriod' => $period,
				'domainPrice' => $DomainPrice,
				'domainExtensionID' => $extensionmain,
				'phone' => $row['phone']??'',
				'email' => $row['email']??'',
				'status' => 1,
                'gst_no' => $row['gst_no']??'',
                'name_of_head_of_institute' => $row['name_of_head_of_institute']??'',
                'designation_of_head_of_institute' => $row['designation_of_head_of_institute']??'',
                'email_of_head_of_institute' => $row['email_of_head_of_institute']??'',
                'phone_of_head_of_institute' => $row['phone_of_head_of_institute']??'',
                'mobile_of_head_of_institute' => $row['mobile_of_head_of_institute']??'',
                'name_of_administrative_contacts' => $row['name_of_administrative_contacts']??'',
                'designation_of_administrative_contacts' => $row['designation_of_administrative_contacts']??'',
                'email_of_administrative_contacts' => $row['email_of_administrative_contacts']??'',
                'phone_of_administrative_contacts' => $row['phone_of_administrative_contacts']??'',
                'mobile_of_administrative_contacts' => $row['mobile_of_administrative_contacts']??'',
                'name_of_billing_details' => $row['name_of_billing_details']??'',
                'designation_of_billing_details' => $row['designation_of_billing_details']??'',
                'email_of_billing_details' => $row['email_of_billing_details']??'',
                'phone_of_of_billing_details' => $row['phone_of_of_billing_details']??'',
                'mobile_of_billing_details' => $row['mobile_of_billing_details']??'',
                'name_of_technical_details' => $row['name_of_technical_details']??'',
                'designation_of_technical_details' => $row['designation_of_technical_details']??'',
                'email_of_technical_details' => $row['email_of_technical_details']??'',
                'phone_of_technical_details' => $row['phone_of_technical_details']??'',
                'mobile_of_of_technical_details' => $row['mobile_of_of_technical_details']??'',
                'pincode' => $row['pincode']??''
			];

            $checkNixi=$this->checkNixi(trim($row['domain']));

            \Log::info(trim($row['domain']));
            \Log::info($checkNixi);
            
            if ($validator->fails()  ||  !$checkNixi) {
    
                if($validator->fails()){
                    $error=$validator->errors()->first();
                }else{
                    $error='Domain has already been taken';
                }

                $params['error_remarks']=$error;

                $params['current_status']=0;

                $status = DB::table('tmp_users')->insert($params);

            }else{

                $params['current_status']=1;

                $status = DB::table('tmp_users')->insert($params);

            }
            
        }
    }

    private function getvalidatorinstance($row)
    {
                
        $rules = [
            'domain' => 'required|unique:users,domainName|unique:tmp_users,domainName',
            'name_of_head_of_institute' => 'required',
            'institute_name'=>'required',
            'designation_of_head_of_institute' => 'required',
            'email_of_head_of_institute' => 'required',
            'mobile_of_head_of_institute' => 'required',
            'name_of_administrative_contacts' => 'required',
            'designation_of_administrative_contacts' => 'required',
            'email_of_administrative_contacts' => 'required',
            'mobile_of_administrative_contacts' => 'required',
            'name_of_billing_details' => 'required',
            'designation_of_billing_details' => 'required',
            'email_of_billing_details' => 'required',
            'mobile_of_billing_details' => 'required',
            'name_of_technical_details' => 'required',
            'designation_of_technical_details' => 'required',
            'email_of_technical_details' => 'required',
            'pincode' => 'required|digits:6'
        ];        

        $message=[];

        $validator = Validator::make($row, $rules, $message);
        
        return $validator;
       
    }

    public function onError(\Throwable $e)
    {

    }

    public function checkNixi($domainName){

        $epp=new EPP();
        $res=$epp->checkDomainAvailability($domainName);

        $dom = new \DOMDocument();
        $dom->loadXML($res);

        $availability = $dom->getElementsByTagNameNS('urn:ietf:params:xml:ns:domain-1.0', 'cd')->item(0)->getElementsByTagName('name')->item(0)->getAttribute('avail');
        
        if ($availability == '1'){
            return true;
        }

        return false;

    }

}
