<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class DeletedApplicationMail extends Mailable implements ShouldQueue
{
    use Queueable, SerializesModels;

    public $user;
    public $content;

    public function __construct($user, $content)
    {
        $this->user = is_array($user) ? (object) $user : $user;
        $this->content = $content;
    }

    public function build()
    {
        return $this->subject('Domain Deleted Due to Incomplete Application')
            ->view('emails.deleted')
            ->with([
                'user' => $this->user,
                'content' => $this->content,
            ]);
    }
}
