<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class ReminderMail extends Mailable implements ShouldQueue
{
    use Queueable, SerializesModels;

    public $user;
    public $content;

    public function __construct($user, $content)
    {
        $this->user = is_array($user) ? (object) $user : $user;
        $this->content = $content;
    }

    public function build()
    {
        return $this->subject('Reminder-Incomplete Registration of Domain on ERNET India Portal')
            ->view('emails.reminder')
            ->with([
                'user' => $this->user,
                'content' => $this->content,
            ]);
    }
}
