<?php


class Epp
{

    var $socket;

    public function __construct()
    {
    }


    private $_connected = false;

    function connect($host, $port = 700, $timeout = 1, $ssl = true)
    {
        if ($this->_connected)
            return true;
        $target = sprintf('%s://%s', ($ssl === true ? 'ssl' : 'tcp'), $host);
        $socket = fsockopen($target, $port, $errno, $errstr, $timeout);
        if (!$socket) {
            return new PEAR_Error("Error connecting to $target: $errstr (code $errno)");
        } else {
            $this->socket = $socket;
            $this->_connected = true;
            return $this->getFrame();
        }
    }


    function getFrame()
    {
        if (feof($this->socket))
            return new PEAR_Error("Connection appears to have closed.");
        $hdr = @fread($this->socket, 4);
        if (empty($hdr)) {
            return new PEAR_Error("Error reading from server: $php_errormsg");
        } else {
            $unpacked = unpack('N', $hdr);
            $answer = fread($this->socket, ($unpacked[1] - 4));
            return $answer;
        }
    }

    function sendFrame($xml)
    {
        return @fwrite($this->socket, pack('N', (strlen($xml) + 4)) . $xml);
    }

    function disconnect()
    {
        return @fclose($this->socket);
    }

}

?>
