<?php
use App\Models\Module;
use App\Models\Privilege;
use App\Models\Program;

  function get_guard()
  {
    if(Auth::guard('admin')->check())
    {
      return "admin";
    }
    else
    {
      return false;
    }
  }

  


   

   
   function runCommand($xml, $function, $log = false)
  {
      // Add timeout and retry logic for Hindi domains
      $maxRetries = 3;
      $retryCount = 0;
      
      while ($retryCount < $maxRetries) {
          try {
              // Your existing EPP connection and command execution code
              $response = $this->executeEppCommand($xml);
              
              if ($response && $this->isValidEppResponse($response)) {
                  return $response;
              }
              
              throw new \Exception('Invalid EPP response received');
              
          } catch (\Exception $e) {
              $retryCount++;
              
              if ($retryCount >= $maxRetries) {
                  throw new \Exception("EPP command failed after {$maxRetries} attempts: " . $e->getMessage());
              }
              
              // Wait before retry (exponential backoff)
              sleep(pow(2, $retryCount));
          }
      }
  }

  function xmlConverter($contents, $get_attributes = 1, $priority = "tag"){

    $type = $tag = "";
    $level = 0;
    $parser = xml_parser_create("");
    xml_parser_set_option($parser, XML_OPTION_TARGET_ENCODING, "UTF-8");
    xml_parser_set_option($parser, XML_OPTION_CASE_FOLDING, 0);
    xml_parser_set_option($parser, XML_OPTION_SKIP_WHITE, 1);
    xml_parse_into_struct($parser, trim($contents), $xml_values);
    xml_parser_free($parser);
    if (!$xml_values) {
        return null;
    }
    $xml_array = [];
    $parents = [];
    $opened_tags = [];
    $arr = [];
    $current = &$xml_array;
    $repeated_tag_index = [];
    foreach ($xml_values as $data) {
        unset($attributes);
        unset($value);
        extract($data);
        $result = [];
        $attributes_data = [];
        if (isset($value)) {
            if ($priority === "tag") {
                $result = $value;
            } else {
                $result["value"] = $value;
            }
        }
        if (isset($attributes) && $get_attributes) {
            foreach ($attributes as $attr => $val) {
                if ($priority === "tag") {
                    $attributes_data[$attr] = $val;
                } else {
                    $result["attr"][$attr] = $val;
                }
            }
        }
        if ($type === "open") {
            $parent[$level - 1] = &$current;
            if (!is_array($current) || !in_array($tag, array_keys($current))) {
                $current[$tag] = $result;
                if ($attributes_data) {
                    $current[$tag . "_attr"] = $attributes_data;
                }
                $repeated_tag_index[$tag . "_" . $level] = 1;
                $current = &$current[$tag];
            } else {
                if (isset($current[$tag][0])) {
                    $current[$tag][$repeated_tag_index[$tag . "_" . $level]] = $result;
                    $repeated_tag_index[$tag . "_" . $level]++;
                } else {
                    $current[$tag] = [$current[$tag], $result];
                    $repeated_tag_index[$tag . "_" . $level] = 2;
                    if (isset($current[$tag . "_attr"])) {
                        $current[$tag]["0_attr"] = $current[$tag . "_attr"];
                        unset($current[$tag . "_attr"]);
                    }
                }
                $last_item_index = $repeated_tag_index[$tag . "_" . $level] - 1;
                $current = &$current[$tag][$last_item_index];
            }
        } else {
            if ($type === "complete") {
                if (!isset($current[$tag])) {
                    $current[$tag] = $result;
                    $repeated_tag_index[$tag . "_" . $level] = 1;
                    if ($priority === "tag" && $attributes_data) {
                        $current[$tag . "_attr"] = $attributes_data;
                    }
                } else {
                    if (isset($current[$tag][0]) && is_array($current[$tag])) {
                        $current[$tag][$repeated_tag_index[$tag . "_" . $level]] = $result;
                        if ($priority === "tag" && $get_attributes && $attributes_data) {
                            $current[$tag][$repeated_tag_index[$tag . "_" . $level] . "_attr"] = $attributes_data;
                        }
                        $repeated_tag_index[$tag . "_" . $level]++;
                    } else {
                        $current[$tag] = [$current[$tag], $result];
                        $repeated_tag_index[$tag . "_" . $level] = 1;
                        if ($priority === "tag" && $get_attributes) {
                            if (isset($current[$tag . "_attr"])) {
                                $current[$tag]["0_attr"] = $current[$tag . "_attr"];
                                unset($current[$tag . "_attr"]);
                            }
                            if ($attributes_data) {
                                $current[$tag][$repeated_tag_index[$tag . "_" . $level] . "_attr"] = $attributes_data;
                            }
                        }
                        $repeated_tag_index[$tag . "_" . $level]++;
                    }
                }
            } else {
                if ($type === "close") {
                    $current = &$parent[$level - 1];
                }
            }
        }
    }
    return $xml_array;

  }


  function get_domain_main_extension_name($id){
     $data=DB::table('domain_main_category')->select('domain_category_name')->where('id',$id)->first();
     return $data->domain_category_name;
  }


  function getCCMail($id){

    $usercontact = DB::table('user_contact_details')->select('*')->where('user_id', $id)->first();

    if ($usercontact) {
        $head = $usercontact->institution_head_detail ? json_decode($usercontact->institution_head_detail) : null;
        $admin = $usercontact->administrative_detail ? json_decode($usercontact->administrative_detail) : null;
        $billing = $usercontact->billing_contact_detail ? json_decode($usercontact->billing_contact_detail) : null;
        $technical = $usercontact->technical_detail ? json_decode($usercontact->technical_detail) : null;
    
        $array = [
            $head->email ?? 'admin@registry.ernet.in',
            $admin->email ?? 'admin@registry.ernet.in',
            $billing->email ?? 'admin@registry.ernet.in',
            $technical->email ?? 'admin@registry.ernet.in'
        ];
    
        return $array;
    }
    
    return [];

  }

  function getModules(){

    return Module::all();

  }

  function getPrograms(){

    return Program::all();

  }

  function is_logged_in()
  {
    if(get_guard()==='admin')
    {
      $admin = Auth::guard('admin')->user();
      if($admin->status==1)
      {
        return $admin->id;
      }
      else
      {
        return false;
      }
    }
    else
    {
      return false;
    }
  }

  function is_admin()
  {
    if(get_guard()==='admin')
    {
      $admin = Auth::guard('admin')->admin();
      if($admin->role=='sadmin' && $admin->status==1)
      {
        return $admin->id;
      }
      else
      {
        return false;
      }
    }
    else
    {
      return false;
    }
  }

  function getUserHasRole($userId)
  {
    return Privilege::where('user_id', $userId)->get();
  }

    function getUserHasRoleProgram($userId,$program)
  {
    return Privilege::where('user_id', $userId)->where('program_id',$program)->first();
  }

function get_domain_main_category_name($id)
{
  if ($id>0)
  {
    $qry = DB::table('domain_main_category')->select('domain_category_name')->where('id',$id)->first();
    if ($qry)
    {
      return $qry->domain_category_name;
    }
  }
}

function get_languages_name($id)
{
  if ($id>0)
  {
    $qry = DB::table('domain_languages')->select('language_name')->where('id',$id)->first();
    if ($qry)
    {
      return $qry->language_name;
    }
  }
}
function get_domain_extension($id)
{
  if ($id>0)
  {
    $qry = DB::table('domain_extensions')->select('domain_extensions')->where('id',$id)->first();
    if ($qry)
    {
      return $qry->domain_extensions;
    }
  }
}


function getmisc(){
  $qry = DB::table('misc_settings')->first();
  return $qry;
}
function getdiscount(){
  $qry = DB::table('offers')->where('status','1')->first();
  return $qry;
}

function getGst()
{

    $qry = DB::table('misc_settings')->first();
    if ($qry)
    {
        return $qry->service_tax;
    }
}

function get_heading_name($id)
{
  if ($id>0)
  {
    $qry = DB::table('programs')->select('description')->where('id',$id)->first();
    if ($qry)
    {
      return $qry->description;
    }
  }
}

function Storehistory($user_id,$program,$mode,$desc){

  $store = DB::table('history_reports')->insert(
    [
      'user_id'=>$user_id,
      'name'=>$program,
      'data'=>$desc,
      'mode'=>$mode,
    ]
  );

  return true;

}


function copyFolderViaFtp($sourceServer, $sourceUsername, $sourcePassword, $sourceFolderPath, $destinationServer, $destinationUsername, $destinationPassword, $destinationFolderPath) {
  // Connect to the source FTP server
  $sourceFtp = ftp_connect('202.141.18.52');
  if (!$sourceFtp) {
      echo "Failed to connect to the source FTP server.";
      return;
  }
  
  if (!ftp_login($sourceFtp, $sourceUsername, $sourcePassword)) {
      echo "Failed to log in to the source FTP server.";
      ftp_close($sourceFtp);
      return;
  }

  // Connect to the destination FTP server
  $destinationFtp = ftp_connect($destinationServer);
  if (!$destinationFtp) {
      echo "Failed to connect to the destination FTP server.";
      ftp_close($sourceFtp);
      return;
  }

  if (!ftp_login($destinationFtp, $destinationUsername, $destinationPassword)) {
      echo "Failed to log in to the destination FTP server.";
      ftp_close($sourceFtp);
      ftp_close($destinationFtp);
      return;
  }

  // Create the destination directory if it doesn't exist
  if (!ftp_is_dir($destinationFtp, $destinationFolderPath)) {
      ftp_mkdir($destinationFtp, $destinationFolderPath);
  }

  // Get the list of files and directories in the source folder
  $files = ftp_nlist($sourceFtp, $sourceFolderPath);

  foreach ($files as $file) {
      // Get the file or directory name
      $filename = basename($file);

      // Build the source and destination paths
      $sourcePath = $sourceFolderPath . '/' . $filename;
      $destinationPath = $destinationFolderPath . '/' . $filename;

      if (ftp_is_dir($sourceFtp, $sourcePath)) {
          // If it's a directory, recursively copy the subdirectory
          copyFolderViaFtp($sourceServer, $sourceUsername, $sourcePassword, $sourcePath, $destinationServer, $destinationUsername, $destinationPassword, $destinationPath);
      } else {
          // If it's a file, transfer the file
          if (!ftp_get($sourceFtp, 'local_temp_file', $sourcePath, FTP_BINARY)) {
              echo "Failed to download file: $sourcePath";
              continue;
          }

          if (!ftp_put($destinationFtp, $destinationPath, 'local_temp_file', FTP_BINARY)) {
              echo "Failed to upload file: $destinationPath";
          }
          unlink('local_temp_file');
      }
  }

  // Close FTP connections
  ftp_close($sourceFtp);
  ftp_close($destinationFtp);
}


function seconds2human($ss) {
  $s = $ss%60;
  $m = floor(($ss%3600)/60);
  $h = floor(($ss%86400)/3600);
  $d = floor(($ss%2592000)/86400);
  $M = floor($ss/2592000);

  $time = '';
  if($M > 0)
  {
    return "$M months, $d days, $h hours, $m minutes, $s seconds";
  } 
  else if($d > 0)
  {
    return "$d days, $h hours, $m minutes, $s seconds";
  }
  else if($h > 0)
  {
    return "$h hours, $m minutes, $s seconds";
  }
  else if($m > 0)
  {
    return "$m minutes, $s seconds";
  }
  else if($s > 0)
  {
    return "$s seconds";
  }
  
}

 function seconds2humanApi($ss) {
  $s = $ss%60;
  $m = floor(($ss%3600)/60);
  $h = floor(($ss%86400)/3600);
  $d = floor(($ss%2592000)/86400);
  $M = floor($ss/2592000);

  $time = '';
  if($M > 0)
  {
    return "$M months, $d days, $h hours, $m minutes, $s seconds";
  } 
  else if($d > 0)
  {
    return "$d days, $h hours, $m minutes, $s seconds";
  }
  else if($h > 0)
  {
    return "$h hours, $m minutes, $s seconds";
  }
  else if($m > 0)
  {
    return "$m minutes, $s seconds";
  }
  else if($s > 0)
  {
    return "$s seconds";
  }
  
}


function numberToWord($num = '')
{
    $num = (string) $num;

    if (strpos($num, '.') !== false) {
        list($integerPart, $decimalPart) = explode('.', $num, 2);
        $integerPartWords = numberToWords((int) $integerPart);
        $decimalPartWords = numberToWords((int) $decimalPart);
        return $integerPartWords . ' and ' . $decimalPartWords . ' paise only';
    }

    $num = (int) $num;

    if ($num && is_numeric($num)) {
        $words = array();

        $num = str_replace(array(',', ' '), '', trim($num));

        $list1 = array('', 'one', 'two', 'three', 'four', 'five', 'six', 'seven', 'eight', 'nine', 'ten', 'eleven', 'twelve', 'thirteen', 'fourteen', 'fifteen', 'sixteen', 'seventeen', 'eighteen', 'nineteen');

        $list2 = array('', 'ten', 'twenty', 'thirty', 'forty', 'fifty', 'sixty', 'seventy', 'eighty', 'ninety', 'hundred');

        $list3 = array('', 'thousand', 'million', 'billion', 'trillion', 'quadrillion', 'quintillion', 'sextillion', 'septillion', 'octillion', 'nonillion', 'decillion', 'undecillion', 'duodecillion', 'tredecillion', 'quattuordecillion', 'quindecillion', 'sexdecillion', 'septendecillion', 'octodecillion', 'novemdecillion', 'vigintillion');

        $num_length = strlen($num);
        $levels = (int) (($num_length + 2) / 3);
        $max_length = $levels * 3;
        $num = substr('00' . $num, -$max_length);
        $num_levels = str_split($num, 3);

        foreach ($num_levels as $num_part) {
            $levels--;
            $hundreds = (int) ($num_part / 100);
            $hundreds = ($hundreds ? ' ' . $list1[$hundreds] . ' Hundred' . ($hundreds == 1 ? '' : '') . ' ' : '');
            $tens = (int) ($num_part % 100);
            $singles = '';

            if ($tens < 20) {
                $tens = ($tens ? ' ' . $list1[$tens] . ' ' : '');
            } else {
                $tens = (int) ($tens / 10);
                $tens = ' ' . $list2[$tens] . ' ';
                $singles = (int) ($num_part % 10);
                $singles = ' ' . $list1[$singles] . ' ';
            }
            $words[] = $hundreds . $tens . $singles . (($levels && (int) ($num_part)) ? ' ' . $list3[$levels] . ' ' : '');
        }
        $commas = count($words);
        if ($commas > 1) {
            $commas = $commas - 1;
        }

        $words = implode(', ', $words);

        $words = trim(str_replace(' ,', ',', ucwords($words)), ', ');
        if ($commas) {
            $words = str_replace(',', ' and', $words);
        }

        return $words . ' only';
    } elseif (!($num)) {
        return 'Zero';
    }

    return '';
}

function numberToWords($num)
{
    $words = array();

    $list1 = array('', 'one', 'two', 'three', 'four', 'five', 'six', 'seven', 'eight', 'nine', 'ten', 'eleven', 'twelve', 'thirteen', 'fourteen', 'fifteen', 'sixteen', 'seventeen', 'eighteen', 'nineteen');

    $list2 = array('', 'ten', 'twenty', 'thirty', 'forty', 'fifty', 'sixty', 'seventy', 'eighty', 'ninety', 'hundred');

    $list3 = array('', 'thousand', 'million', 'billion', 'trillion', 'quadrillion', 'quintillion', 'sextillion', 'septillion', 'octillion', 'nonillion', 'decillion', 'undecillion', 'duodecillion', 'tredecillion', 'quattuordecillion', 'quindecillion', 'sexdecillion', 'septendecillion', 'octodecillion', 'novemdecillion', 'vigintillion');

    $num_length = strlen($num);
    $levels = (int) (($num_length + 2) / 3);
    $max_length = $levels * 3;
    $num = substr('00' . $num, -$max_length);
    $num_levels = str_split($num, 3);

    foreach ($num_levels as $num_part) {
        $levels--;
        $hundreds = (int) ($num_part / 100);
        $hundreds = ($hundreds ? ' ' . $list1[$hundreds] . ' Hundred' . ($hundreds == 1 ? '' : '') . ' ' : '');
        $tens = (int) ($num_part % 100);
        $singles = '';

        if ($tens < 20) {
            $tens = ($tens ? ' ' . $list1[$tens] . ' ' : '');
        } else {
            $tens = (int) ($tens / 10);
            $tens = ' ' . $list2[$tens] . ' ';
            $singles = (int) ($num_part % 10);
            $singles = ' ' . $list1[$singles] . ' ';
        }
        $words[] = $hundreds . $tens . $singles . (($levels && (int) ($num_part)) ? ' ' . $list3[$levels] . ' ' : '');
    }
    $commas = count($words);
    if ($commas > 1) {
        $commas = $commas - 1;
    }

    $words = implode(', ', $words);

    $words = trim(str_replace(' ,', ',', ucwords($words)), ', ');
    if ($commas) {
        $words = str_replace(',', ' and', $words);
    }

    return $words;
}


function notification($token,$payload,$title,$message){
$server_key="AAAA8AkRJeQ:APA91bF0Wa2sJV2gvfm0h9aodB5aC2rnSRhvNc2NP-AN9zwD7Pv6ortjoWoFhH6TALc3U5Hd3X1o7mcTntoKmM-tTPjTvTsl3aDv0oKds5bgTaD5WccO-VkqDuz7Swq3acpe7FM3x2Sp";
$url="https://fcm.googleapis.com/fcm/send";
$fields = array(
            'registration_ids' => $token,
            'notification' => array(
                'body' => $message,
                'title' => $title,
                'icon' => 'myicon',
                'sound' => 'default',
                "android_channel_id" => "ping_channel"
            ),
            'data'=>array(
				'content'=>array(
                    'title'=>$title,
                    'status' => 'notification',
					'largeIcon'=>"https://intileotech.info/new-portal/public/images/app_logo.png",
					'payload'=>$payload,
				),
				'Android'=>array(
					'content'=>array(
						'title'=>$title,
						'payload'=>$payload,
					),
				),
				'iOS'=>array(
					'content'=>array(
						'title'=>$title,
						'payload'=>$payload,
					),
				),

            )
        );
    $headers = array(
        'Content-Type:application/json',
      'Authorization:key='.$server_key
    );

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));

    $result = curl_exec($ch);

}

function genTransID($user_id){
  $year=date('y');
  $day=date('d');
  $month=strtoupper(date('M'));
  
  $dt = new DateTime();
  
  return 'ERNET'.$user_id.$dt->getTimestamp();
  
}



function callSMTP() {

  $data=DB::table('payment_gateway_setting')->where('id',2)->first();

  if($data) {
   
   $mail = [
    'secretkey'=>$data->checksum_key,
    'merchantId'=>$data->merchant_id,
    'clientId'=>$data->security_id,
    'apiurl'=>'https://uat1.billdesk.com/u2/payments/ve1_2/orders/create',
    'responseurl'=>"{{url('/billdeskresponse')}}",
    'sdkPrimaryColor'=>'#69068a',
    'sdkAccentColor'=>'#cf5df5',
    'sdkBackgroundColor'=>'#7cd6fc',
    'sdkBannerColor'=>'#bef6fa',
    'logo'=>'data:image/png;base64,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' 
  ];
  
  config(['mail.mailers.smtp' => $mail]);
  return true;
  
  }
   return false;
  
}

function handleActivity($data){

  $store = DB::table('application_activity_log')->insert(
    [
      'user_id'=>$data['user_id']??0,
      'user_type'=>$data['user_type']??1,
      'user_name'=>$data['user_name']??'',
      'domainName'=>$data['domainName']??'',
      'status'=>$data['status']??'',
      'status_code'=>$data['status_code']??0,
      'remarks'=>$data['remarks']??'',
      'ip_address'=>$data['ip_address']??'',
      'description'=>$data['description']??'',
      'created_at'=>date('Y-m-d H:i:s'),
      'updated_at'=>date('Y-m-d H:i:s')
    ]
  );

  return true;

}

?>