@extends('layouts.AdminLayout')

@section('content')

<?php

$action='';

$userid=Auth::guard('admin')->user()->id;

$edit=$del=$add=true;
$priv=getUserHasRoleProgram($userid,7);

if($priv!=null){
    $add=$priv->add_priv==1 ?true:false;
}
$head_name = get_heading_name(7);
   if($head_name!=null){
       $heading_name= $head_name;
   }else
   {
      $heading_name="Payment Gateway List";
   }

?>

<div class="content-wrapper">

<div class="container-xxl flex-grow-1 container-p-y">
    <h4 class="fw-bold py-3 mb-2">{{$heading_name}}</h4>

		<div class="card">
			<div style="padding:20px">

					<div class="table-responsive text-nowrap">
						@if (Session::has('success'))
						   <div class="alert alert-success">{{ Session::get('success') }}</div>
						@endif

						@if (Session::has('error'))
						   <div class="alert alert-danger">{{ Session::get('error') }}</div>
						@endif


						<table class="table table-striped table-bordered dataTable no-footer" id="dataTable" width="100%" cellspacing="0">
							<thead class="table-secondary">
								<tr>
                                <th>S.No.</th>
                                <th>Payment Gateway Name</th>
								<th>Merchant Id</th>
                                <th>Secret Key</th>
                                <th>Client Id</th>
								<th>Action</th>
								</tr>
							</thead>

							<tbody>

							</tbody>
						</table>
					</div>

                    <div class="demo-inline-spacing">
                         <br>
						 <!-- @if($add)
                        <button type="button" class="btn btn-primary addbutton ">Add</button>
						@endif -->
						<br><br>
                </div>
			</div>
		</div>

        <div class="card mt-3">

        <div class=" createform d-none">
            <div class="card cblack">

                <div class="card-body">

                    <form method="post" id="departmentForm">
                        {!! csrf_field() !!}

                        <div class="form-group mb-3">
                            <label for="" class=" font-layout">Payment Gateway Name <span class="inputlabelmedetory text-err"></span></label>
                            <input type="text" name="payment_gateway" id="payment_gateway" class="form-control" placeholder="Enter payment gateway Name">
                        </div>

                      <div class="form-group mb-3">
                        <label for="" class=" font-layout">Merchant Id <span class="inputlabelmedetory text-err"></span></label>
                        <input type="text" name="merchant_id" id="merchant_id" class="form-control" placeholder="Enter merchant id">
                      </div>
                      <div class="form-group mb-3">
                        <label for="" class=" font-layout">Client Id <span class="inputlabelmedetory text-err"></span></label>
                        <input type="text" name="security_id" id="security_id" class="form-control" placeholder="Enter security id">
                      </div>
                      <div class="form-group mb-3">
                        <label for="" class=" font-layout">Secret Key <span class="inputlabelmedetory text-err"></span></label>
                        <input type="text" name="checksum_key" id="checksum_key" class="form-control" placeholder="Enter checksum key">
                      </div>

                    <div class="demo-inline-spacing">
                            <br>
                            <button type="submit" class="btn btn-primary submit ">Submit</button>
                            <button type="button" class="btn btn-danger cancelbutton ">Cancel</button>
                            <br><br>
                    </div>

                    </form>
                </div>
            </div>
        </div>


        <div class="updateform d-none">
					<div class="card cblack">
						<!-- <h4 class="fw-bold font-weight-bold card-header headingtext font-layout">{{ __('Region Details Data Update') }}</h4> -->

						<div class="card-body">

							<form method="post" id="updateDesignationForm" action="#">
								{!! csrf_field() !!}
								<input type="hidden" name="id" id="id" />
								<br>
                               
								<div class="form-group mb-3">
                            <label for="" class=" font-layout">Payment Gateway Name <span class="inputlabelmedetory text-err"></span></label>
                            <input type="text" name="payment_gateway" id="" class="payment_gateway form-control" placeholder="Enter payment gateway Name" readonly>
                        </div>

                      <div class="form-group mb-3">
                        <label for="" class=" font-layout">Merchant Id <span class="inputlabelmedetory text-err"></span></label>
                        <input type="text" name="merchant_id" id="" class="merchant_id form-control" placeholder="Enter merchant id">
                      </div>
                      <div class="form-group mb-3">
                        <label for="" class=" font-layout">Client Id <span class="inputlabelmedetory text-err"></span></label>
                        <input type="text" name="security_id" id="" class="security_id form-control" placeholder="Enter security id">
                      </div>
                      <div class="form-group mb-3">
                        <label for="" class=" font-layout">Secret Key <span class="inputlabelmedetory text-err"></span></label>
                        <input type="text" name="checksum_key" id="" class="checksum_key form-control" placeholder="Enter checksum key">
                      </div>


							<div class="demo-inline-spacing">
                                    <br>
									<button type="submit" class="btn btn-primary submit">Update</button>
									<button type="button" class="btn btn-danger cancelbutton">Cancel</button>
									<br><br>
							</div>


							</form>

						</div>
					</div>

				</div>
</div>


@endsection
@section("js")
	<script type="text/javascript">

		$(document).ready(function() {
			var _ = $('body');
			var createRecord = 'Are you sure you want to save the record?';
			var updateRecord = 'Are you sure you want to modify this record?';
			var deleteRecord = 'Are you sure you want to delete this record?';

			var table = $('#dataTable').DataTable({
				processing: true,
				serverSide: true,
				ajax: "{{route('gateway.ajaxcall')}}",
				columns: [
					{ data: 'id' },
                    { data: 'payment_gateway',orderable:false},
                    { data: 'merchant_id',orderable:false},
					{ data: 'checksum_key',orderable:false},
					{ data: 'security_id',orderable:false},
					{ data: 'Action',orderable:false },
				]
			});
			$('body').on('click', '.delete', function() {
				var id = $(this).attr('data-id');
				if (confirm(deleteRecord)) {
					$('.viewform').addClass('d-none');
					$('.updateform').addClass('d-none');
					$('.createform').addClass('d-none');
					$.ajaxSetup({
						headers: {
							'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
						}
					});

					$.ajax({
						url: "{{route('gateway.delete')}}",
						dataType : "json",
						type: "post",
						data : {'id':id},
						success : function(response) {
                            $('#payment_gateway').val('');
                            $('#transaction_url').val('');
                            $('#merchant_id').val('');
                            $('#security_id').val('');
							$('#checksum_key').val('');
							if(response.status == 'success') {
								table.ajax.reload();
							} else if(response.status == 'error') {
								alert(response.message);
							}
							else if(response.status == 'exceptionError')
							{
								CommonManager.forcelogout();
							}
						},
					});

				}
				return false;
			});



			$('body').on('submit', '#departmentForm', function(e) {
                e.preventDefault();
				var current = $(this);
				if (confirm(createRecord)) {
					$('.submit', current).attr('disabled', 'disabled');

                    var payment_gateway = $('#payment_gateway', current).val();
					var transaction_url = $('#transaction_url', current).val();
                    var merchant_id = $('#merchant_id', current).val();
                    var security_id = $('#security_id', current).val();
                    var checksum_key = $('#checksum_key', current).val();

                    $('.payment_gateway_error').remove();
					if(payment_gateway == '') {
						$('#payment_gateway').after('<span class="payment_gateway_error" style="color:red">Please Enter Payment Gateway name.</span>');
						$('.submit').removeAttr('disabled');
						return false;
					}

					$('.transaction_url_error').remove();
					if(transaction_url == '') {
						$('#transaction_url').after('<span class="transaction_url_error" style="color:red">Please Enter transaction url.</span>');
						$('.submit').removeAttr('disabled');
						return false;
					}
                    $('.merchant_id_error').remove();
                    if(merchant_id == '') {
						$('#merchant_id').after('<span class="merchant_id_error" style="color:red">Please Enter merchant id.</span>');
						$('.submit').removeAttr('disabled');
						return false;
					}
                    $('.security_id_error').remove();
                    if(security_id == '') {
						$('#security_id').after('<span class="security_id_error" style="color:red">Please Enter security id.</span>');
						$('.submit').removeAttr('disabled');
						return false;
					}
                    $('.checksum_key_error').remove();
                    if(checksum_key == '') {
						$('#checksum_key').after('<span class="checksum_key_error" style="color:red">Please Enter checksum key.</span>');
						$('.submit').removeAttr('disabled');
						return false;
					}

					var data = current.serialize();
					$.ajax({
						url: "{{route('gateway.save')}}",
						dataType : "json",
						type: "post",
						data : data,
						success : function(response) {

							$('.submit').removeAttr('disabled');

							if(response.status == 'success') {
                                $('#payment_gateway').val('');
								$('#transaction_url').val('');
                                $('#merchant_id').val('');
                                $('#security_id').val('');
                                $('#checksum_key').val('');
								table.ajax.reload();
								$('.updateform').addClass('d-none');
								$('.createform').addClass('d-none');
								$('.viewform').addClass('d-none');
							} else if(response.status == 'errors') {

								$.each(response.message, function(i, message) {
									$('#'+i).after('<span class="Description_error" style="color:red">'+message+'</span>');
								});

							} else if(response.status == 'error') {
								$('#description').after('<span class="Description_error" style="color:red">'+response.error+'</span>');
							}
							else if(response.status == 'exceptionError')
							{
								CommonManager.forcelogout();
							}
						},
					});
					return false;
				}
				return false;
			});

			$('body').on('submit', '#updateDesignationForm', function(e) {
                e.preventDefault();
			var current = $(this);
			if (confirm(updateRecord)) {
				$('.submit', current).attr('disabled', 'disabled');
				var payment_gateway = $('#updatepayment_gateway', current).val();
				var transaction_url = $('#updatetransaction_url', current).val();
                var merchant_id = $('#updatemerchant_id', current).val();
                var security_id = $('#updatesecurity_id', current).val();
                var checksum_key = $('#updatechecksum_key', current).val();

				$('.payment_gateway_error').remove();
				if(payment_gateway == '') {
					$('#updatepayment_gateway').after('<span class="payment_gateway_error" style="color:red">Please enter Payment Gateway name.</span>');
					$('.submit').removeAttr('disabled');
					return false;
				}

				$('.transaction_url_error').remove();
				if(transaction_url == '') {
					$('#updatetransaction_url').after('<span class="transaction_url_error" style="color:red">Please enter transaction url.</span>');
					$('.submit').removeAttr('disabled');
					return false;
				}
                $('.merchant_id_error').remove();
				if(merchant_id == '') {
					$('#updatemerchant_id').after('<span class="merchant_id_error" style="color:red">Please enter merchant id.</span>');
					$('.submit').removeAttr('disabled');
					return false;
				}
                $('.security_id_error').remove();
				if(security_id == '') {
					$('#updatesecurity_id').after('<span class="security_id_error" style="color:red">Please enter security id.</span>');
					$('.submit').removeAttr('disabled');
					return false;
				}
                $('.checksum_key_error').remove();
				if(checksum_key == '') {
					$('#updatechecksum_key').after('<span class="checksum_key_error" style="color:red">Please enter checksum key.</span>');
					$('.submit').removeAttr('disabled');
					return false;
				}
				$('.err').remove();
				var data = current.serialize();
				$.ajax({
					url:"{{route('gateway.update')}}",
					dataType : "json",
					type: "post",
					data : data,
					success : function(response) {

						$('.submit').removeAttr('disabled');

						if(response.status == 'success') {
                            $('#payment_gateway').val('');
							$('#transaction_url').val('');
                            $('#merchant_id').val('');
                            $('#security_id').val('');
                            $('#checksum_key').val('');
							table.ajax.reload();

							$('.updateform').addClass('d-none');
							$('.createform').addClass('d-none');
							$('.viewform').addClass('d-none');

						} else if(response.status == 'errors') {

							$.each(response.message, function(i, message) {
								$('.'+i).after('<span id="Description_error" class="err" style="color:red">'+message+'</span>');
							});

						} else if(response.status == 'error') {
							$('#updateDescription').after('<span class="Description_error err" style="color:red">'+response.message+'</span>');
						}
						else if(response.status == 'exceptionError')
						{
							CommonManager.forcelogout();
						}
					},
				});
				return false;
			}
			return false;
		});
		

			$('body').on('click', '.update', function() {
				var id = $(this).attr('data-id');
				$('#code').val('');
				$.ajax({
					url: "{{ route('gateway.regionid') }}",
					dataType : "json",
					type: "get",
					data : {'id':id},
					success : function(response) {

						if(response.status == 'success') {

							$('.createform').addClass('d-none');
							$('.viewform').addClass('d-none');
							$('.updateform').removeClass('d-none');
							$('#id').val(response.data.id);
                            $('.payment_gateway').val(response.data.payment_gateway);
                            $('.merchant_id').val(response.data.merchant_id);
                            $('.security_id').val(response.data.security_id);
                            $('.checksum_key').val(response.data.checksum_key);

						} else if(response.status == 'error') {
							alert(response.message);
						}

					},
				});

			});

			$('body').on('click', '.addbutton', function() {
				$('.createform').removeClass('d-none');
				$('.updateform').addClass('d-none');
				$('.viewform').addClass('d-none');
			});

			$('body').on('click', '.cancelbutton', function() {
				$('.createform').addClass('d-none');
				$('.updateform').addClass('d-none');
				$('.viewform').addClass('d-none');
			});

		});
	</script>

@endsection



