@extends('layouts.AdminLayout')

@section('content')

<?php

$action='';

$userid=Auth::guard('admin')->user()->id;

$edit=$del=$add=true;
$priv=getUserHasRoleProgram($userid,19);

if($priv!=null){
    $edit=$priv->modify_priv==1 ?true:false;
    $del=$priv->del_priv==1 ?true:false;
    $add=$priv->add_priv==1 ?true:false;
}
$head_name = get_heading_name(19);
   if($head_name!=null){
       $heading_name= $head_name;
   }else
   {
      $heading_name="Admin Users";
   }

?>


<div class="content-wrapper">

<div class="container-xxl flex-grow-1 container-p-y">
    <h4 class="fw-bold py-3 mb-2">{{$heading_name}}</h4>
			
		<div class="card">
			<div style="padding:20px">	
				
					<div class="table-responsive text-nowrap">
						@if (Session::has('success'))
						   <div class="alert alert-success">{{ Session::get('success') }}</div>
						@endif
						
						@if (Session::has('error'))
						   <div class="alert alert-danger">{{ Session::get('error') }}</div>
						@endif
						
						<table class="table table-striped table-bordered dataTable no-footer" id="dataTable" width="100%" cellspacing="0">
							<thead class="table-secondary">
								<tr>
                                <th>S.No.</th>
								<th>User ID</th>
								<th>Name</th>
                                <th>Email</th>
                                <th>Status</th>
								<th>Action</th>
								</tr>
							</thead>
						   
							<tbody>
								
							</tbody>
						</table>
					</div>
					
                    <div class="demo-inline-spacing">
                         <br>
						@if($add)
                        <button type="button" class="btn btn-primary addbutton">Add</button>
						@endif
						<br><br>
                </div>
			</div>
		</div>

        <div class="card mt-3">
				
        <div class="createform d-none">
            <div class="card cblack">

                <div class="card-body">
                    
                    <form method="post" id="departmentForm">
                        {!! csrf_field() !!}

                     
<div class="row">

<div class="col-sm-6">

<div class="form-group mb-2">
 <label for="" class="font-layout">User ID<span class="inputlabelmedetory text-err"></span></label>
 <input type="text" name="user_id" id="user_id" class="form-control specialcharuser" placeholder=""  onKeyPress="if(this.value.length==15) return false;">
</div>

</div>


<div class="col-sm-6">

<div class="form-group mb-2">
 <label for="" class=" font-layout">Name<span class="inputlabelmedetory text-err"></span></label>
 <input type="text" name="name" id="name" class="form-control specialchar" placeholder="" onKeyPress="if(this.value.length==40) return false;">
</div>

</div>

                        
                       
                       <div class="col-sm-6 ">

                      <div class="form-group mb-2">
                        <label for="" class="font-layout">Email<span class="inputlabelmedetory text-err"></span></label>
                        <input type="text" name="email" id="email" class="form-control specialcharemail" placeholder="" onKeyPress="if(this.value.length==40) return false;">
                      </div>

                       </div>

                       <div class="col-sm-6">

                      <div class="form-group mb-2">
                        <label for="" class=" font-layout">Mobile<span class="inputlabelmedetory text-err"></span></label>
                        <input type="number" name="mobile" id="mobile" class="form-control" placeholder="" onKeyPress="if(this.value.length==10) return false;">
                      </div>

                      </div>


<div class="col-sm-6">

<div class="form-group mb-2">
  <label for="" class=" font-layout">Password<span class="inputlabelmedetory text-err"></span></label>
  <input type="password" name="password" id="password" class="form-control" placeholder="">
</div>

</div>

<div class="col-sm-6">

<div class="form-group">
  <label for="">Status</label>
  <select class="form-control" name="status" id="status">
   <option value="">Select Status</option>
    <option value="1">Active</option>
    <option value="2">Deactive</option>
  </select>
</div>

</div>


</div>

                    <div class="demo-inline-spacing">
                            <br>
                            <button type="submit" class="btn btn-primary submit ">Submit</button>
                            <button type="button" class="btn btn-danger cancelbutton ">Cancel</button>
                            <br><br>
                    </div>
                     
                    </form>
                </div>
            </div>
        </div>


        <div class="updateform d-none">
					<div class="card cblack">
						<!-- <h4 class="fw-bold font-weight-bold card-header headingtext font-layout">{{ __('Region Details Data Update') }}</h4> -->

						<div class="card-body">
							
							<form method="post" id="updateDesignationForm" action="#">
								{!! csrf_field() !!}
								<input type="hidden" name="id" id="id" />
								
<div class="row">

<div class="col-sm-6">

<div class="form-group mb-2">
<label for="" class="font-layout">User ID<span class="inputlabelmedetory text-err"></span></label>
<input type="text" name="user_id" id="" class="user_id form-control specialcharuser" placeholder="Enter User ID" onKeyPress="if(this.value.length==15) return false;" disabled>
</div>

</div>


<div class="col-sm-6">

<div class="form-group mb-2">
<label for="" class=" font-layout">Name<span class="inputlabelmedetory text-err"></span></label>
<input type="text" name="name" id="" class="name form-control specialchar" placeholder="" onKeyPress="if(this.value.length==40) return false;">
</div>

</div>



<div class="col-sm-6 ">

<div class="form-group mb-2">
<label for="" class="font-layout">Email<span class="inputlabelmedetory text-err"></span></label>
<input type="text" name="email" id="" class="email form-control specialcharemail" placeholder="" onKeyPress="if(this.value.length==40) return false;">
</div>

</div>

<div class="col-sm-6">

<div class="form-group mb-2">
<label for="" class=" font-layout">Mobile<span class="inputlabelmedetory text-err"></span></label>
<input type="text" name="mobile" id="" class="mobile form-control" placeholder="" onKeyPress="if(this.value.length==10) return false;">
</div>

</div>


<div class="col-sm-6">

<div class="form-group">
  <label for="">Status</label>
  <select class="status form-control" name="status" id="">
   <option value="">Select Status</option>
    <option value="1">Active</option>
    <option value="2">Deactive</option>
  </select>
</div>

</div>

</div>
								
                               
							<div class="demo-inline-spacing">
                                    <br>
									<button type="submit" class="btn btn-primary submit">Update</button>
									<button type="button" class="btn btn-danger cancelbutton">Cancel</button>
									<br><br>
							</div>
							 
							  
							</form>
							
						</div>
					</div>
				
				</div>
        
                <div class="viewform d-none">
					<div class="card cblack">
						<!-- <h4 class="fw-bold font-weight-bold card-header headingtext font-layout">{{ __('Region Details') }}</h4> -->
						<div class="card-body">
							<form>
								

                            <div class="row">

<div class="col-sm-6">

<div class="form-group mb-2">
<label for="" class="font-layout">User ID<span class="inputlabelmedetory text-err"></span></label>
<input type="text" name="user_id" id="" class="user_id1 form-control" placeholder="Enter User ID" disabled>
</div>

</div>


<div class="col-sm-6">

<div class="form-group mb-2">
<label for="" class=" font-layout">Name<span class="inputlabelmedetory text-err"></span></label>
<input type="text" name="name" id="" class="name1 form-control" placeholder="" disabled>
</div>

</div>



<div class="col-sm-6 ">

<div class="form-group mb-2">
<label for="" class="font-layout">Email<span class="inputlabelmedetory text-err"></span></label>
<input type="text" name="email" id="" class="email1 form-control" placeholder="" disabled>
</div>

</div>

<div class="col-sm-6">

<div class="form-group mb-2">
<label for="" class=" font-layout">Mobile<span class="inputlabelmedetory text-err"></span></label>
<input type="text" name="mobile" id="" class="mobile1 form-control" placeholder="" disabled>
</div>

</div>


<div class="col-sm-6">

<div class="form-group">
  <label for="">Status</label>
  <select class="status1 form-control" name="status" id="" disabled>
   <option value="">Select Status</option>
    <option value="1">Active</option>
    <option value="2">Deactive</option>
  </select>
</div>

</div>

</div>

							  <br>
							  <button type="button" class="btn btn-danger cancelbutton ">Cancel</button>
							</form>
						</div>
					</div>
	</div>
</div>


@endsection
@section("js")
	<script type="text/javascript">
		
		$(document).ready(function() {
			var _ = $('body');
			var createRecord = 'Are you sure you want to save the record?';
			var updateRecord = 'Are you sure you want to modify this record?';
			var deleteRecord = 'Are you sure you want to delete this record?';
			
			var table = $('#dataTable').DataTable({
				processing: true,
				serverSide: true,
				ajax: "{{route('admins.ajaxcall')}}",
				columns: [
					{ data: 'id' },
					{ data: 'user_id',orderable:false },
					{ data: 'name',orderable:false},
                    { data: 'email',orderable:false},
                    { data: 'status',orderable:false},
					{ data: 'Action',orderable:false },
				]
			});

$('.specialchar').on('keypress',function(e){

var regex=new RegExp("^[a-zA-Z0-9. ]");
var key=String.fromCharCode(!e.charCode ? e.which :e.charCode);
if(!regex.test(key)){
    e.preventDefault();
    return false;
}

});
	
$('.specialcharemail').on('keypress',function(e){

var regex=new RegExp("^[a-zA-Z0-9@.]");
var key=String.fromCharCode(!e.charCode ? e.which :e.charCode);
if(!regex.test(key)){
    e.preventDefault();
    return false;
}

});


			
			
			$('body').on('click', '.delete', function() {

				var id = $(this).attr('data-id');
				if (confirm(deleteRecord)) {
					$('.viewform').addClass('d-none');
					$('.updateform').addClass('d-none');
					$('.createform').addClass('d-none');
					$.ajaxSetup({
						headers: {
							'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
						}
					});
					
					$.ajax({
						url: "{{route('admins.delete')}}",
						dataType : "json",
						type: "post",
						data : {'id':id},
						success : function(response) {
							$('#description').val('');
							$('.description').val('');
							if(response.status == 'success') {
								
								table.ajax.reload();
								
							} else if(response.status == 'error') {
								
								alert(response.message);
								
							} 
							else if(response.status == 'exceptionError')
							{
								CommonManager.forcelogout();
							}
						},
					});
					
				}
				return false;
			});


$('.specialcharuser').on('keypress',function(e){

var regex=new RegExp("^[a-zA-Z0-9]");
var key=String.fromCharCode(!e.charCode ? e.which :e.charCode);
if(!regex.test(key)){
    e.preventDefault();
    return false;
}

});
			
			
			$('body').on('submit', '#departmentForm', function(e) {
				$('.Description_error').remove();
                e.preventDefault();
				var current = $(this);
				if (confirm(createRecord)) {
					$('.submit', current).attr('disabled', 'disabled');
					
					var data = current.serialize();
					$.ajax({
						url: "{{route('admins.save')}}",
						dataType : "json",
						type: "post",
						data : data,
						success : function(response) {
							
							$('.submit').removeAttr('disabled');
							
							if(response.status == 'success') {
                                $('#user_id').val('');
								table.ajax.reload();
								$('.updateform').addClass('d-none');
								$('.createform').addClass('d-none');
								$('.viewform').addClass('d-none');
							} else if(response.status == 'errors') {
								
								$.each(response.message, function(i, message) {
									$('#'+i).after('<span class="Description_error" style="color:red">'+message+'</span>');
								});
								
							} else if(response.status == 'error') {
								$('#description').after('<span class="Description_error" style="color:red">'+response.error+'</span>');
							}
							else if(response.status == 'exceptionError')
							{
							}
						},
					});
					return false;
				}
				return false;
			});
			
			$('body').on('submit', '#updateDesignationForm', function(e) {
				$('.Description_error').remove();

                e.preventDefault();
			var current = $(this);
			if (confirm(updateRecord)) {
				$('.submit', current).attr('disabled', 'disabled');
			
				$('.err').remove();
				var data = current.serialize();
				$.ajax({
					url:"{{route('admins.update')}}",
					dataType : "json",
					type: "post",
					data : data,
					success : function(response) {
						
						$('.submit').removeAttr('disabled');
						
						if(response.status == 'success') {
							$('#description').val('');
							$('.description').val('');
							table.ajax.reload();
							
							$('.updateform').addClass('d-none');
							$('.createform').addClass('d-none');
							$('.viewform').addClass('d-none');
							
						} else if(response.status == 'errors') {
							
							$.each(response.message, function(i, message) {
								$('#updateDescription').after('<span id="Description_error" class="err" style="color:red">'+message+'</span>');
							});
							
						} else if(response.status == 'error') {
							$('#updateDescription').after('<span class="Description_error err" style="color:red">'+response.message+'</span>');
						}
						else if(response.status == 'exceptionError')
						{
						}
					},
				});
				return false;
			}
			return false;
		});
			$('body').on('click', '.view', function() {
				var id = $(this).attr('data-id');
				$('.viewform').removeClass('d-none');
				$('.updateform').addClass('d-none');
				$('.createform').addClass('d-none');
				$.ajax({
					url: "{{ route('admins.adminsid') }}",
					dataType : "json",
					type: "get",
					data : {'id':id},
					success : function(response) {
						
						if(response.status == 'success') {
						
                            $('.user_id1').val(response.data.username);
							$('.email1').val(response.data.email);
                            $('.mobile1').val(response.data.mobile);
                            $('.status1 option[value="'+response.data.status+'"]').prop('selected', true);
							$('.name1').val(response.data.name);

						} else if(response.status == 'error') {
							
							alert(response.message);
							
						}
						
					},
				});
			});
			
			$('body').on('click', '.update', function() {
				var id = $(this).attr('data-id');
				$('#code').val('');
				$.ajax({
					url: "{{ route('admins.adminsid') }}",
					dataType : "json",
					type: "get",
					data : {'id':id},
					success : function(response) {
						
						if(response.status == 'success') {
							
							$('.createform').addClass('d-none');
							$('.viewform').addClass('d-none');
							$('.updateform').removeClass('d-none');
							$('#id').val(response.data.id);
							$('.user_id').val(response.data.username);
							$('.email').val(response.data.email);
                            $('.mobile').val(response.data.mobile);
                            $('.status option[value="'+response.data.status+'"]').prop('selected', true);
							$('.name').val(response.data.name);

						} else if(response.status == 'error') {
							alert(response.message);						
						}
						
					},
				});
				
			});
			
			$('body').on('click', '.addbutton', function() {
				$('.createform').removeClass('d-none');
				$('.updateform').addClass('d-none');
				$('.viewform').addClass('d-none');
			});
			
			$('body').on('click', '.cancelbutton', function() {
				$('.createform').addClass('d-none');
				$('.updateform').addClass('d-none');
				$('.viewform').addClass('d-none');
			});
			
		});
	</script>

@endsection



