@extends('layouts.AdminLayout')

@section('content')


<div class="content-wrapper">

<div class="container-xxl flex-grow-1 container-p-y">
    <h4 class="fw-bold py-3 mb-2">Upload Domain Documents</h4>
   
		<div class="card">
			<div style="padding:20px" class="card-body">	
				
					<div class="table-responsive text-nowrap">
						@if (Session::has('success'))
						   <div class="alert alert-success">{{ Session::get('success') }}</div>
						@endif
						
						@if (Session::has('error'))
						   <div class="alert alert-danger">{{ Session::get('error') }}</div>
						@endif

                      
                        <form  method="POST" id="updateDesignationForm" class="submitdocdata" enctype="multipart/form-data">
    @csrf

    <b>Note: </b>
    <p><b>
    Kindly, upload the following documents that are common for all the uploaded domains.
    </b></p>

    <!-- <a href="https://registry.ernet.in/download-documents">Documents Format</a> -->

    
    <table class="table table-striped table-bordered dataTable no-footer" id="" width="100%" cellspacing="0">
                       
    <thead class="table-secondary">
        <tr>
            <th>File Name</th>
            <th>File Upload</th>
        </tr>
    </thead>
    <tbody>

    @foreach($DOC as $key => $val)
    <tr>
        <td><input type="text" value="{{$val->id}}" name="category" hidden>{{$val->title}} <strong style="color:red">*</strong>
        <a href="{{url('ernetdash/bulkdomainformat_pdf/'.$val->id)}}" class="mx-4"> {{($val->description!=null)?$val->description:'	download format'}}
        <i class="fa fa-download" aria-hidden="true"></i> </a>
       </td>

        <td>
            <label for="file_{{$val->id}}" class="btn btn-primary">
                <input type="file" name="file_{{$val->id}}" id="file_{{$val->id}}" class="file-input" accept=".pdf" required>
                <span id="error-message-file_{{$val->id}}" class="error-message"></span>
            </label>
        </td>
    </tr>
    @endforeach

    

    </tbody>
</table>

<button class="btn btn-primary submitform mt-3" type="submit">Submit</button>

</form>
					</div>

                    <div>
         </div>
					
                   
		</div>


@endsection

@section("js")

<script>
        $(document).ready(function(){

            $('body').on('submit', '#updateDesignationForm', function(e) {
                e.preventDefault();
                Swal.fire({
                        title: "Please wait...",
                        html: "Processing ..."
                })
                Swal.showLoading();
                var formData = new FormData($('.submitdocdata')[0]);
                
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });

                $.ajax({
                    url: "{{ route('doc.upload') }}",
                    type: "POST",
                    data: formData,
                    processData: false, 
                    contentType: false, 
                    success: function(response){
                        
                        if(response.status === "success"){

                            Swal.fire({
                            title: "Success!",
                            text: 'Documents Uploaded Successfully',
                            icon: "success"
                            });

                            window.location.href = "{{route('incomplete.domain')}}";

                        } else {
                            
                            Swal.fire({
                            title: "Error!",
                            text: 'Please Upload Documents',
                            icon: "error"
                            });

                        }
                    },
                    error: function(){
                        
                               
                        Swal.fire({
                            title: "Error!",
                            text: 'Please Upload Documents',
                            icon: "error"
                        });


                    }
                });
            });
        });
    </script>


@endsection



