

@extends('layouts.AdminLayout')

@section('content')


<?php

$action='';

$userid=Auth::guard('admin')->user()->id;

$edit=$del=$add=true;
$priv=getUserHasRoleProgram($userid,21);

if($priv!=null){
    $edit=$priv->modify_priv==1 ?true:false;
    $del=$priv->del_priv==1 ?true:false;
    $add=$priv->add_priv==1 ?true:false;
}
$head_name = get_heading_name(21);
   if($head_name!=null){
       $heading_name= $head_name;
   }else
   {
      $heading_name="Institution Details";
   }

?>

<div class="content-wrapper">

<div class="container-xxl flex-grow-1 container-p-y">
    <h4 class="fw-bold py-3 mb-2">{{$heading_name}}</h4>
			
		<div class="card">
			<div style="padding:20px">	
			<div class="col-sm-3">
			<div class="form-group mt-1 mb-4">
			<label for="">Board</label>
			<select class="board_id form-control" name="" id="" >
				<option value="">All Boards</option>
				@foreach($boards as $Board)
				<option value="{{$Board->id}}">{{$Board->description}}</option>
				@endforeach
			</select>
			</div>
			</div>
					<div class="table-responsive">
						@if (Session::has('success'))
						   <div class="alert alert-success">{{ Session::get('success') }}</div>
						@endif
						
						@if (Session::has('error'))
						   <div class="alert alert-danger">{{ Session::get('error') }}</div>
						@endif
						
						<table class="table table-striped table-bordered dataTable no-footer" id="dataTable" width="100%" cellspacing="0">
							<thead class="table-secondary">
								<tr>
                                <th>S.No.</th>
								<th>Affilation No.</th>
								<th>Board</th>
                                <th>School</th>
                                <th>Address</th>
                                <th>Action</th>
								</tr>
							</thead>
						   
							<tbody>
								
							</tbody>
						</table>
					</div>
					
                    <div class="demo-inline-spacing">
                        <br>
						@if($add)
                        <button type="button" class="btn btn-primary addbutton">Add</button>
                        <!-- <button type="button" class="btn btn-success importbutton">Import</button> -->
						@endif
						<br><br>
                </div>
			</div>
		</div>

<div class="card mt-3">
				
<div class="createform d-none">
            
<div class="card cblack">

<div class="card-body">
                    
<form method="post" id="departmentForm">

{!! csrf_field() !!}
           
<div class="row">

<div class="col-sm-6">

<div class="form-group mb-2">
 <label for="" class="font-layout">Affilation No.<span class="inputlabelmedetory text-err"></span></label>
 <input type="number" name="aff_no" id="aff_no" class="form-control" placeholder="" onKeyPress="if(this.value.length==15) return false;">
</div>

</div>

<div class="col-sm-6">

<div class="form-group">
  <label for="">Board</label>
  <select class="form-control" name="board" id="board">
   <option value="">Select Board</option>
    @foreach($boards as $board)
    <option value="{{$board->id}}">{{$board->description}}</option>
    @endforeach
  </select>
</div>

</div>       
                       
                       <div class="col-sm-6 ">

                      <div class="form-group mb-2">
                        <label for="" class="font-layout">School Name<span class="inputlabelmedetory text-err"></span></label>
                        <input type="text" name="school_name" id="school_name" class="form-control specialcharuser" placeholder="" onKeyPress="if(this.value.length==30) return false;">
                      </div>

                       </div>

                       <div class="col-sm-6">

                      <div class="form-group mb-2">
                        <label for="" class=" font-layout">Pincode<span class="inputlabelmedetory text-err"></span></label>
                        <input type="number" name="pincode" id="pincode" class="form-control" placeholder="" onKeyPress="if(this.value.length==6) return false;">
                      </div>

                      </div>


<div class="col-sm-6">

<div class="form-group">
  <div class="form-group">
    <label for="">Address</label>
    <textarea class="form-control specialcharuser" name="address" id="address" rows="2" onKeyPress="if(this.value.length==50) return false;"></textarea>
  </div>
</div>

</div>

<div class="col-sm-6">

<div class="form-group">
  <label for="">State</label>
  <select class="form-control" name="state" id="state">
   <option value="">Select State</option>
    @foreach($states as $state)
    <option value="{{$state->id}}">{{$state->description}}</option>
    @endforeach
  </select>
</div>

</div>

</div>

                    <div class="demo-inline-spacing">
                            <br>
                            <button type="submit" class="btn btn-primary submit ">Submit</button>
                            <button type="button" class="btn btn-danger cancelbutton ">Cancel</button>
                            <br><br>
                    </div>
                     
                    </form>
                </div>
            </div>
        </div>


<div class="updateform d-none">

<div class="card cblack">

<div class="card-body">
							
<form method="post" id="updateDesignationForm" action="#">
								
{!! csrf_field() !!}

<input type="hidden" name="id" id="id" />
								
<div class="row">

<div class="col-sm-6">

<div class="form-group mb-2">
 <label for="" class="font-layout">Affilation No.<span class="inputlabelmedetory text-err"></span></label>
 <input type="number" name="aff_no" id="" class="aff_no form-control" placeholder="" onKeyPress="if(this.value.length==15) return false;">
</div>

</div>


<div class="col-sm-6">

<div class="form-group">
  <label for="">Board</label>
  <select class="form-control board" name="board" id="">
   <option value="">Select Board</option>
    @foreach($boards as $board)
    <option value="{{$board->id}}">{{$board->description}}</option>
    @endforeach
  </select>
</div>

</div>


                        
                       
                       <div class="col-sm-6 ">

                      <div class="form-group mb-2">
                        <label for="" class="font-layout">School Name<span class="inputlabelmedetory text-err"></span></label>
                        <input type="text" name="school_name" id="" class="school_name form-control specialcharuser" placeholder="" onKeyPress="if(this.value.length==30) return false;">
                      </div>

                       </div>

                       <div class="col-sm-6">

                      <div class="form-group mb-2">
                        <label for="" class=" font-layout">Pincode<span class="inputlabelmedetory text-err"></span></label>
                        <input type="number" name="pincode" id="" class="pincode form-control" placeholder="" onKeyPress="if(this.value.length==6) return false;">
                      </div>

                      </div>


<div class="col-sm-6">

<div class="form-group">
  <div class="form-group">
    <label for="">Address</label>
    <textarea class="address form-control specialcharuser" name="address" id="" rows="2" onKeyPress="if(this.value.length==50) return false;"></textarea>
  </div>
</div>

</div>

<div class="col-sm-6">

<div class="form-group">
  <label for="">State</label>
  <select class="form-control state" name="state" id="">
   <option value="">Select State</option>
    @foreach($states as $state)
    <option value="{{$state->id}}">{{$state->description}}</option>
    @endforeach
  </select>
</div>

</div>


</div>
								
                               
							<div class="demo-inline-spacing">
                                    <br>
									<button type="submit" class="btn btn-primary submit">Update</button>
									<button type="button" class="btn btn-danger cancelbutton">Cancel</button>
									<br><br>
							</div>
							 
							  
							</form>
							
						</div>
					</div>
				
				</div>


<div class="importform d-none">

<div class="card cblack">

<div class="card-body">
            

<form method="post" action="{{route('boards.import')}}" enctype="multipart/form-data">
@csrf



<div class="form-group mb-3">
<label for="">Import File<span class="inputlabelmedetory"></span></label>
<input type="file" name="file" id="file" class="form-control" >
</div>


              <button type="submit" class="btn btn-primary submit" >Import</button>
              <button type="button" class="btn btn-danger cancelbutton" >Cancel</button>

</form>

</div>
 </div>

</div>
        
<div class="viewform d-none">
					
<div class="card cblack">

<div class="card-body">

<form>

<div class="row">


</div>

							  <br>
							  <button type="button" class="btn btn-danger cancelbutton ">Cancel</button>
							</form>
						</div>
					</div>
	</div>
</div>


@endsection
@section("js")

<link href="{{ asset('vendor/datatables/dataTables.bootstrap4.min.css') }}" rel="stylesheet">

<script src="{{ asset('vendor/datatables/jquery.dataTables.min.js') }}"></script>
<script src="{{ asset('vendor/datatables/dataTables.bootstrap4.min.js') }}"></script>

	<script type="text/javascript">
		
		$(document).ready(function() {
			var _ = $('body');
			var createRecord = 'Are you sure you want to save the record?';
			var updateRecord = 'Are you sure you want to modify this record?';
			var deleteRecord = 'Are you sure you want to delete this record?';

$('.specialcharuser').on('keypress',function(e){

var regex=new RegExp("^[a-zA-Z0-9&,. ]");
var key=String.fromCharCode(!e.charCode ? e.which :e.charCode);
if(!regex.test(key)){
    e.preventDefault();
    return false;
}

});
            
			
			var table = $('#dataTable').DataTable({
				processing: true,
				serverSide: true,
				ajax: {
					url: "{{ route('boards.ajaxcall') }}",
					type: "GET",
					datatype: "json",
					data: function(d) {
						d.board_id = $('.board_id').val();
					}
				},
				columns: [
					{ data: 'id' },
					{ data: 'aff_no',orderable:false },
					{ data: 'board',orderable:false},
                    { data: 'school',orderable:false},
                    { data: 'address',orderable:false},
                    { data: 'action',orderable:false}
				]
			});
			$('body').on('change', '.board_id', function() {
				table.ajax.reload();
		    });
			$('body').on('click', '.delete', function() {

				var id = $(this).attr('data-id');
				if (confirm(deleteRecord)) {
					$('.viewform').addClass('d-none');
					$('.updateform').addClass('d-none');
					$('.createform').addClass('d-none');
                    $('.importform').addClass('d-none');

					$.ajaxSetup({
						headers: {
							'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
						}
					});
					
					$.ajax({
						url: "{{route('boards.delete')}}",
						dataType : "json",
						type: "post",
						data : {'id':id},
						success : function(response) {
							$('#description').val('');
							$('.description').val('');
							if(response.status == 'success') {
								table.ajax.reload();
							} else if(response.status == 'error') {
								alert(response.message);
							} 
							else if(response.status == 'exceptionError')
							{
								CommonManager.forcelogout();
							}
						},
					});
					
				}
				return false;
			});

			
			
			$('body').on('submit', '#departmentForm', function(e) {
                e.preventDefault();
				var current = $(this);
				if (confirm(createRecord)) {
					$('.submit', current).attr('disabled', 'disabled');
					var data = current.serialize();
					$.ajax({
						url: "{{route('boards.save')}}",
						dataType : "json",
						type: "post",
						data : data,
						success : function(response) {
							
							$('.submit').removeAttr('disabled');
							
							if(response.status == 'success') {
								table.ajax.reload();
								$('.updateform').addClass('d-none');
								$('.createform').addClass('d-none');
								$('.viewform').addClass('d-none');
                                $('.importform').addClass('d-none');

							} else if(response.status == 'errors') {
								
								$.each(response.message, function(i, message) {
									$('#'+i).after('<span class="Description_error" style="color:red">'+message+'</span>');
								});
								
							} else if(response.status == 'error') {
								$('#description').after('<span class="Description_error" style="color:red">'+response.error+'</span>');
							}
							else if(response.status == 'exceptionError')
							{
							}
						},
					});
					return false;
				}
				return false;
			});
			
			$('body').on('submit', '#updateDesignationForm', function(e) {
            e.preventDefault();
			var current = $(this);
			if (confirm(updateRecord)) {
				$('.submit', current).attr('disabled', 'disabled');
				$('.err').remove();
				var data = current.serialize();
				$.ajax({
					url:"{{route('boards.update')}}",
					dataType : "json",
					type: "post",
					data : data,
					success : function(response) {
						
						$('.submit').removeAttr('disabled');
						
						if(response.status == 'success') {
							table.ajax.reload();
							$('.updateform').addClass('d-none');
							$('.createform').addClass('d-none');
							$('.viewform').addClass('d-none');
                            $('.importform').addClass('d-none');

						} else if(response.status == 'errors') {
							
							$.each(response.message, function(i, message) {
								$('.'+i).after('<span id="Description_error" class="err" style="color:red">'+message+'</span>');
							});
							
						} else if(response.status == 'error') {
							$('#updateDescription').after('<span class="Description_error err" style="color:red">'+response.message+'</span>');
						}
						else if(response.status == 'exceptionError')
						{
						}
					},
				});
				return false;
			}
			return false;
		});
			$('body').on('click', '.view', function() {
				var id = $(this).attr('data-id');
				$('.viewform').removeClass('d-none');
				$('.updateform').addClass('d-none');
				$('.createform').addClass('d-none');
                $('.importform').addClass('d-none');

				$.ajax({
					url: "{{ route('boards.boardsid') }}",
					dataType : "json",
					type: "get",
					data : {'id':id},
					success : function(response) {
						
						if(response.status == 'success') {
						
                            $('.user_id1').val(response.data.username);
							$('.email1').val(response.data.email);
                            $('.mobile1').val(response.data.mobile);
                            $('.status1 option[value="'+response.data.status+'"]').prop('selected', true);
							$('.name1').val(response.data.name);

						} else if(response.status == 'error') {
							
							alert(response.message);
							
						}
						
					},
				});
			});
			
			$('body').on('click', '.update', function() {
				var id = $(this).attr('data-id');
				$('#code').val('');
				$.ajax({
					url: "{{ route('boards.boardsid') }}",
					dataType : "json",
					type: "get",
					data : {'id':id},
					success : function(response) {
						
						if(response.status == 'success') {
							
							$('.createform').addClass('d-none');
							$('.viewform').addClass('d-none');
							$('.updateform').removeClass('d-none');
                            $('.importform').addClass('d-none');

							$('#id').val(response.data.id);
							$('.address').val(response.data.address);
							$('.aff_no').val(response.data.aff_no);
                            $('.school_name').val(response.data.school_name);
                            $('.status option[value="'+response.data.status+'"]').prop('selected', true);
							$('.pincode').val(response.data.pincode);
                            $('.state option[value="'+response.data.state+'"]').prop('selected', true);
                            $('.board option[value="'+response.data.board+'"]').prop('selected', true);

						} else if(response.status == 'error') {
							alert(response.message);						
						}
						
					},
				});
				
			});
			
			$('body').on('click', '.addbutton', function() {
				$('.createform').removeClass('d-none');
				$('.updateform').addClass('d-none');
				$('.viewform').addClass('d-none');
                $('.importform').addClass('d-none');
			});

            $('body').on('click', '.importbutton', function() {
				$('.createform').addClass('d-none');
				$('.updateform').addClass('d-none');
				$('.viewform').addClass('d-none');
                $('.importform').removeClass('d-none');
			});

			$('body').on('click', '.cancelbutton', function() {
				$('.createform').addClass('d-none');
				$('.updateform').addClass('d-none');
				$('.viewform').addClass('d-none');
                $('.importform').addClass('d-none');
			});
			
		});
	</script>

@endsection



