<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Letter of Undertaking for Multiple Domain Name Registration</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
        }
        h1 {
            text-align: center;
            text-decoration: underline;
        }

        ol,li{
            margin:10px;
            padding:10px;
        }

        p {
            text-align: justify;
            line-height: 1.6;
        }
        .signature {
            margin-top: 50px;
            text-align: left;
        }
        .address {
            margin-top: 30px;
        }
    </style>
</head>
<body>

    <div style="text-align:center;align-items:center;justify-content:center">
    <h3>Annexure -'D'</h3>
    <h4>Letter of Undertaking for Multiple Domain Name (Bulk Domain) registration <br>
    <span>(On Rs.100/- Non-Judicial Stamp Paper)</span><br>
    <span><b>(Applicable to all Educational/Academic Institutions)</b></span>
    </h4>
    </div>

    <p style="float:right">Dated: {{date('d-m-Y')}}</p>

    <br><br><br>

    <p>I, <b>{{$admins->contact_name}}</b> (name), son/daughter of <b>{{$admins->father_name}}</b> aged <b>{{$admins->age}}</b> hereby undertake that I am working / associated with <b>{{$admins->org_name}}</b> (Name of the academic institution) as <b>{{$admins->designation}}</b> Designation.</p>

    <p>I undertake that I am the authorized signatory/ or head of <b>{{$admins->org_name}}</b> (Name & Address of the academic institution applying for multiple domain names) and authorized to undertake, sign and execute any instrument essential and incidental to obtain the following domain names for the following respective Institutes:</p>

    <table border="1">
        <tr style="font-size:13px">
            <th>S.No.</th>
            <th>Domain Name</th>
            <th>Name and Address of the Institute</th>
            <th>Affiliated by <br> (AICTE/UGC/Board/University/ Central/State Govt.)</th>
        </tr>

        @foreach($domains as $i=> $domain)
        <tr>
            <td>{{$i+1}}</td>
            <td>{{$domain->domainName}}</td>
            <td>{{$domain->institute}}</td>
            <td>{{$domain->board}}</td>
        </tr>
        @endforeach

    </table>

    <p>I, hereby undertake on behalf of all the institutes for which I am applying above said multiple domain names under edu.in / ac.in / res.in, will abide by all the terms & conditions of ERNET India. I also certify and undertake the following:</p>

    <ol>
        <li>That the institutes for which bulk domain name registration is being done are involved in academic/educational/research activities and shall be using domain name registered by ERNET India for bonafide academic/educational and or research purpose only and not for any other purpose.</li>
        <li>That all the contact details including head (like Chancellor/VC/Principal/Head Master/Director etc), of the above said institutes viz. Admin details, billing details and Technical details provided in the `online registration form` are accurate and correct and will keep them updated.</li>
        <li>That to the best of our knowledge, the registration of the domain names will not infringe upon or otherwise violate the rights of any third party. It shall be the responsibility of the <b>{{$admins->org_name}}</b>.(Name Institution/ Organization doing bulk registration) to ensure compliance of this norms and ERNET India shall not be held responsible or liable in case of any violation in any manner whatsoever of this norms at any time.</li>
        <li>That <b>{{$admins->org_name}}</b> (Name Institution/ Organization) registering the domain names solely for the lawful purposes and will not use for any illegal activities or any activities prohibited by law of the land and in case of default of any law or a provision/proviso thereof will be liable for punishment/penalty as per the provisions contained therein.</li>
        <li>That <b>{{$admins->org_name}}</b> (Name Institution/ Organization) will not use the domain names in violation of any applicable laws or regulations not limited to provisions of the IT Act of Government of India but any law or rules or notifications applicable from time to time.</li>
        <li>That ownership of the content uploaded on the website using the above said domain names will be of the concerned institute. ERNET India will not be responsible for the website content.</li>
        <li>That no illegal, offensive (including but not limited to material that is sexually explicit content or which promotes racism, bigotry, hatred or physical harm), deceptive, misleading, abusive, indecent, harassing, blasphemous, defamatory, libelous, obscene, pornographic, pedophilic or menacing; ethnically objectionable, disparaging content will be uploaded on the website using the applied domain names (mentioned above).</li>
        <li>That no content will be uploaded that is objectionable or otherwise unlawful in any manner whatsoever; or which consists of or contains software viruses, political campaigning, commercial solicitation, chain letters, mass mailings or any "spam".</li>
        <li>That no content will be uploaded that infringes upon or violates any third party's rights including, but not limited to, intellectual property rights, rights of privacy (including without limitation unauthorized disclosure of a person's name, e-mail address, physical address or phone number) or rights of publicity.</li>
        <li>That ERNET India will not be responsible for any hacking of any of the institute's website and redirection to any fraudulent activity like gaming site, bank website, any website having financial/payment.</li>
        <li>It shall be responsibility of the <b>{{$admins->org_name}}</b> (Name of the organization applying for multiple domain name registration) to update the contact details of each institute as and when required.</li>
        <li>Updation of contact details, DNS records, renewal of domain names will be done by <b>{{$admins->org_name}}</b> (Name of the organization applying for multiple domain name registration) online using User ID and Password provided by ERNET India, failing which ERNET India will not be held liable for any issue like non-functional of domain etc arising due to it.</li>
        <li>That all the institutions for which domain name registration has been applied, are functioning as per the UGC Guidelines and/or AICTE/ and or Government (Central or State) norms and / or University norms and the office bearers/ Management abide by it (applicable to all institutions including private and autonomous institutions/Colleges/Universities).</li>
        <li>That in future, if any dispute arises regarding any of the above said domain names, ERNET India will not be held responsible in any manner whatsoever for any ownership of domain or institute. None from institution/organization shall make ERNET India a party in the court and in such a situation, ERNET India reserves the right to take suitable action including suspension/freezing of that domain name etc.</li>
        <li>That (Name of the Institute applying for multiple domain name registration) indemnify ERNET India, its management and officers against any and all costs, liabilities, losses, and expenses (including, but not limited to, legal expenses) arising out of any claim, suit, action or proceeding for any act(s) and/or omissions of the Institution.</li>
        <li>That I agree to terms & conditions mentioned in the ERNET India’s Domain registration website/portal.</li>
    </ol>

    <div class="signature">
        <p>Yours sincerely,</p>
        <p>(Sign & Stamp of Head/Authorized Signatory of the Institute/organization applying for bulk domain registration)</p>
        <p>Full Name : <b>{{$admins->contact_name}}</b></p>
        <p>Address :  <b>{{$admins->address??''}}</b></p>
        <p>Mobile : <b>{{$admins->mobile}}</b></p>
        <p>Email : <b>{{$admins->email}}</b></p>
    </div>

    <div class="address">
        <p>To</p>
        <p>ERNET India</p>
        <p>(Ministry of Electronics & IT, Govt of India)</p>
        <p>5th Floor, Block I, A Wing DMRC IT Park</p>
        <p>Shastri Park, New Delhi 110053</p>
    </div>
</body>
</html>
