<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Application Letter for Bulk Domain Registration</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
        }
        h1, h2 {
            text-align: center;
            text-decoration: underline;
        }
        p {
            text-align: justify;
            line-height: 1.6;
        }
        .signature {
            margin-top: 50px;
            text-align: left;
        }
        .address {
            margin-top: 30px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
        }
        table, th, td {
            border: 1px solid black;
        }
        th, td {
            padding: 8px;
            text-align: left;
        }
    </style>
</head>
<body>
  
    <div style="text-align:center;align-items:center;justify-content:center">

    <h3>Annexure - C</h3>
    <h4>Application Letter for Registration of Multiple Domains by Single Entity (Bulk Domain Registration)<br>
    <span><strong>(To be given on letterhead of the institute duly signed and stamped by head of the institute)</strong></span>
    </h4>

    </div>

    <p style="float:right">Dated: {{date('d-m-Y')}}</p>

    <div class="address">
        <p>To,<br>
        ERNET India</br>
        5th Floor, Block- I, A Wing</br>
        DMRC IT Park, Shastri Park,</br>
        New Delhi 110053</p>
    </div>

    <p>Subject: Application for registration/renewal of <b>{{count($domains)}}</b> no. of Domain Names for <b>{{$admins->org_name}}</b> (Name of the organization/institute applying for bulk domain names registration/renewal)</p>

    <p>I, <b>{{$admins->contact_name}}</b> (name), <b>{{$admins->designation}}</b> (Designation) as head of <b>{{$admins->org_name}}</b> (Name & Address of the academic institution applying for bulk domain registration) do hereby agree for and on behalf of the management of the <b>{{$admins->org_name}}</b> that I will abide by the terms and conditions of ERNET for registering/renewing of following domain names:</p>

    <table>
        <thead>
            <tr>
                <th>S.No.</th>
                <th>Domain Name</th>
                <th>Institute Name</th>
            </tr>
        </thead>
        <tbody>

            @foreach($domains as $i => $domain)
            <tr>
                <td>{{$i+1}}</td>
                <td>{{$domain->domainName}}</td>
                <td>{{$domain->institute}}</td>
            </tr>
            @endforeach
            
        </tbody>
    </table>

    <p>I do hereby authorize the following person, working in the institute, to act on behalf of (<b>{{$admins->org_name}}</b> applying for bulk domain registration) for handling all the activities related to above said domain names:</p>

    <p>
        Name:<b>{{$admins->contact_name}}</b> <br>
        Adhar No:<br>
        Designation:<b>{{$admins->designation}}</b><br>
        Signature of authorized person: <br>
        Phone: <b>{{$admins->mobile}}</b><br>
        Email: <b>{{$admins->email}}</b><br>
    </p>

    <p>Further, it is to inform that online registration/renewal form has been filled and uploaded required documents. Payment has also been made through Internet banking/ or NEFT/ IMPS (tick whichever is applicable) on <b>{{date('d-m-Y',strtotime($transactions->created_at??''))}}</b> (date) of Rs <b>{{$transactions->total_amount??''}}</b>. for registering/renewing above said domain names for <b>{{$transactions->period??''}}</b>. (no. of year(s)). The scanned documents uploaded in online form are correct and true copy of originals.</p>

    <p>Therefore, ERNET India is requested to register/renew above said domain names for <b>{{$admins->org_name}}</b> (name of academic institution applying for multiple/bulk domain registration).</p>

    <div class="signature">
        <p>Yours sincerely,</p>
        <p>Signature</p>
        <p>(Name and Address of the Head of the Institute with sign and stamp)  <b>{{$admins->contact_name}}</b> </p>
        <p>Email: <b>{{$admins->email}}</b></p>
        <p>Mobile No.: <b>{{$admins->mobile}}</b></p>
    </div>
</body>
</html>
