@extends('layouts.AdminLayout')
@section('content')


<style>

.inputlabelmedetory{
    color:red !important
}

</style>
    <div class="content-wrapper">
        <div class="container-xxl flex-grow-1 container-p-y">
            <h4 class="fw-bold py-3 mb-2">Uploaded Domain Preview</h4>
            <div class="card">
                <div style="padding:20px">
                    <div class="table-responsive text-nowrap">
                        @if (Session::has('success'))
                            <div class="alert alert-success">{{ Session::get('success') }}</div>
                        @endif
                        @if (Session::has('error'))
                            <div class="alert alert-danger">{{ Session::get('error') }}</div>
                        @endif
                        <table class="table table-striped table-bordered dataTable no-footer" id="dataTable" width="100%"
                            cellspacing="0">
                            <thead class="table-secondary">
                                <tr>
                                    <th>S.No.</th>
                                    <th>Domain Name</th>
                                    <th>Institute Name</th>
                                    <th>Address</th>
                                    <th>Period</th>
                                    <th>Email</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>
               
                <div class="col-md-12 mb-3 text-right mx-4 createform">

        
<a  href="{{route('downloadFailedDomain')}}" style="color:blue">Download List of Invalid  Domains</a>



@if($success>0)
<button type="button" class="btn btn-success mx-5 viewform" style="float:right" id="final_submit">Final Submit</button>
@endif

<a href="{{route('upload.domain',['upload'=>2])}}" class="btn btn-primary mx-5 viewform" style="float:right">Reupload Domain</a>


</div>


            </div>

</div>




        </div>

        

      


        <div class="updateform d-none mx-4 mb-4">
                    <div class="card cblack">
                        <div class="card-body">
                            <form method="post" id="updateDesignationForm" action="#">
                                {!! csrf_field() !!}
                                <div class="row">
                                    <input type="hidden" id="id" name="id" hidden>
                                    <div class="col-sm-6 p-1">
                                        <div class="form-group mb-2">
                                            <label for="" class="text-dark font-weight-bold">Domain Name<span
                                                    class="inputlabelmedetory text-err">*</span></label>
                                            <input type="text" name="domainName" id="domainName"
                                                class="name form-control specialchar" placeholder="" disabled>
                                        </div>
                                    </div>
                                    <div class="col-sm-6 p-1">
                                        <div class="form-group mb-2">
                                            <label for="" class=" font-layout font-weight-bold">Institute Name<span
                                                    class="inputlabelmedetory text-err">*</span></label>
                                            <input type="text" name="institute" id="institute" class="form-control"
                                                placeholder="" required>
                                        </div>
                                    </div>
                                    <div class="col-sm-6 p-1">
                                        <div class="form-group mb-2">
                                            <label for="" class=" font-layout font-weight-bold">Address<span
                                                    class="inputlabelmedetory text-err">*</span></label>
                                            <input type="text" name="address" id="address" class="form-control"
                                                placeholder="" required>
                                        </div>
                                    </div>
                                    <div class="col-sm-6 p-1">
                                        <div class="form-group mb-2">
                                            <label for="" class=" font-layout font-weight-bold">Email<span
                                                    class="inputlabelmedetory text-err">*</span></label>
                                            <input type="email" name="email" id="email" class="form-control"
                                                placeholder="" required>
                                        </div>
                                    </div>
                                    <div class="col-sm-6 p-1">
                                        <div class="form-group mb-2">
                                            <label for="" class=" font-layout font-weight-bold">Phone<span
                                                    class="inputlabelmedetory text-err"></span></label>
                                            <input type="text" name="phone" id="phone" class="form-control"
                                                placeholder="" onKeyPress="if(this.value.length==10) return false;">
                                        </div>
                                    </div>
                                    <div class="col-sm-6 p-1">
                                        <div class="form-group mb-2">
                                            <label for="" class=" font-layout font-weight-bold">GST No.<span
                                                    class="inputlabelmedetory text-err"></span></label>
                                            <input type="text" name="gst_no" id="gst_no" class="form-control"
                                                placeholder="">
                                        </div>
                                    </div>
                                    <div class="col-sm-6 p-1">
                                        <div class="form-group mb-2">
                                            <label for="" class=" font-layout font-weight-bold">Pincode<span
                                                    class="inputlabelmedetory text-err">*</span></label>
                                            <input type="text" name="pincode" id="pincode" class="form-control"
                                                placeholder="" required onKeyPress="if(this.value.length==6) return false;">
                                        </div>
                                    </div>
                                    <div class="row p-3">
                                        <div class="col-sm-6">
                                            <div class="card">
                                                <div class="card-body">
                                                    <h5 class="card-title text-primary font-weight-bold">Details of Head of
                                                        Institution</h5>
                                                    <div class="col-sm-12 p-2">
                                                        <div class="form-group ">
                                                            <label for="" class="font-layout">Name<span
                                                                    class="inputlabelmedetory text-err">*</span></label>
                                                            <input type="text" name="name_of_head_of_institute"
                                                                id="name_of_head_of_institute" class="form-control"
                                                                placeholder="" required>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-12 p-2">
                                                        <div class="form-group">
                                                            <label for="" class=" font-layout">Designation<span
                                                                    class="inputlabelmedetory text-err">*</span></label>
                                                            <input type="text" name="designation_of_head_of_institute"
                                                                id="designation_of_head_of_institute" class="form-control"
                                                                placeholder="" required>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-12 p-2">
                                                        <div class="form-group">
                                                            <label for="" class=" font-layout">Email<span
                                                                    class="inputlabelmedetory text-err">*</span></label>
                                                            <input type="email" name="email_of_head_of_institute"
                                                                id="email_of_head_of_institute" class="form-control"
                                                                placeholder="" required>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-12 p-2">
                                                        <div class="form-group">
                                                            <label for="" class=" font-layout">Phone<span
                                                                    class="inputlabelmedetory text-err"></span></label>
                                                            <input type="text" name="phone_of_head_of_institute"
                                                                id="phone_of_head_of_institute" class="form-control"
                                                                placeholder="" onKeyPress="if(this.value.length==10) return false;">
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-12 p-2">
                                                        <div class="form-group">
                                                            <label for="" class=" font-layout">Mobile<span
                                                                    class="inputlabelmedetory text-err">*</span></label>
                                                            <input type="text" name="mobile_of_head_of_institute"
                                                                id="mobile_of_head_of_institute" class="form-control"
                                                                placeholder="" required  onKeyPress="if(this.value.length==10) return false;">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="card">
                                                <div class="card-body">
                                                    <h5 class="card-title text-primary font-weight-bold">Administrative
                                                        Contact Details</h5>
                                                    <div class="col-sm-12 p-2">
                                                        <div class="form-group ">
                                                            <label for="" class=" font-layout">Name<span
                                                                    class="inputlabelmedetory text-err">*</span></label>
                                                            <input type="text" name="name_of_administrative_contacts"
                                                                id="name_of_administrative_contacts" class="form-control"
                                                                placeholder="" required>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-12 p-2">
                                                        <div class="form-group">
                                                            <label for="" class=" font-layout">Designation<span
                                                                    class="inputlabelmedetory text-err">*</span></label>
                                                            <input type="text"
                                                                name="designation_of_administrative_contacts"
                                                                id="designation_of_administrative_contacts"
                                                                class="form-control" placeholder="" required>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-12 p-2">
                                                        <div class="form-group">
                                                            <label for="" class=" font-layout">Email<span
                                                                    class="inputlabelmedetory text-err">*</span></label>
                                                            <input type="email" name="email_of_administrative_contacts"
                                                                id="email_of_administrative_contacts" class="form-control"
                                                                placeholder="" required>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-12 p-2">
                                                        <div class="form-group">
                                                            <label for="" class=" font-layout">Phone<span
                                                                    class="inputlabelmedetory text-err"></span></label>
                                                            <input type="text" name="phone_of_administrative_contacts"
                                                                id="phone_of_administrative_contacts" class="form-control"
                                                                placeholder="" onKeyPress="if(this.value.length==10) return false;">
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-12 p-2">
                                                        <div class="form-group">
                                                            <label for="" class="font-layout">Mobile<span
                                                                    class="inputlabelmedetory text-err"></span></label>
                                                            <input type="text" name="mobile_of_administrative_contacts"
                                                                id="mobile_of_administrative_contacts"
                                                                class="form-control" placeholder="" required onKeyPress="if(this.value.length==10) return false;">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <br>
                                    <br>
                                    <div class="row p-3">
                                        <div class="col-sm-6">
                                            <div class="card">
                                                <div class="card-body">
                                                    <h5 class="card-title text-primary font-weight-bold">Billing Contact
                                                        Details </h5>
                                                    <div class="col-sm-12 p-2">
                                                        <div class="form-group ">
                                                            <label for="" class=" font-layout">Name<span
                                                                    class="inputlabelmedetory text-err">*</span></label>
                                                            <input type="text" name="name_of_billing_details"
                                                                id="name_of_billing_details" class="form-control"
                                                                placeholder="" required>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-12 p-2">
                                                        <div class="form-group">
                                                            <label for="" class=" font-layout">Designation<span
                                                                    class="inputlabelmedetory text-err">*</span></label>
                                                            <input type="text" name="designation_of_billing_details"
                                                                id="designation_of_billing_details" class="form-control"
                                                                placeholder="" required>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-12 p-2">
                                                        <div class="form-group">
                                                            <label for="" class=" font-layout">Email<span
                                                                    class="inputlabelmedetory text-err"></span></label>
                                                            <input type="email" name="email_of_billing_details"
                                                                id="email_of_billing_details" class="form-control"
                                                                placeholder="" required>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-12 p-2">
                                                        <div class="form-group">
                                                            <label for="" class=" font-layout">Phone<span
                                                                    class="inputlabelmedetory text-err"></span></label>
                                                            <input type="text" name="phone_of_of_billing_details"
                                                                id="phone_of_of_billing_details" class="form-control"
                                                                placeholder="" onKeyPress="if(this.value.length==10) return false;">
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-12 p-2">
                                                        <div class="form-group">
                                                            <label for="" class=" font-layout">Mobile<span
                                                                    class="inputlabelmedetory text-err">*</span></label>
                                                            <input type="text" name="mobile_of_billing_details"
                                                                id="mobile_of_billing_details" class="form-control"
                                                                placeholder="" onKeyPress="if(this.value.length==10) return false;" required>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="card">
                                                <div class="card-body">
                                                    <h5 class="card-title text-primary font-weight-bold">Technical Contact
                                                        Details</h5>
                                                    <div class="col-sm-12 p-2">
                                                        <div class="form-group ">
                                                            <label for="" class=" font-layout">Name<span
                                                                    class="inputlabelmedetory text-err">*</span></label>
                                                            <input type="text" name="name_of_technical_details"
                                                                id="name_of_technical_details" class="form-control"
                                                                placeholder="" required>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-12 p-2">
                                                        <div class="form-group">
                                                            <label for="" class=" font-layout">Designation<span
                                                                    class="inputlabelmedetory text-err">*</span></label>
                                                            <input type="text" name="designation_of_technical_details"
                                                                id="designation_of_technical_details" class="form-control"
                                                                placeholder="" required>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-12 p-2">
                                                        <div class="form-group">
                                                            <label for="" class=" font-layout">Email<span
                                                                    class="inputlabelmedetory text-err">*</span></label>
                                                            <input type="email" name="email_of_technical_details"
                                                                id="email_of_technical_details" class="form-control"
                                                                placeholder="" required>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-12 p-2">
                                                        <div class="form-group">
                                                            <label for="" class=" font-layout">Phone<span
                                                                    class="inputlabelmedetory text-err"></span></label>
                                                            <input type="text" name="phone_of_technical_details"
                                                                id="phone_of_technical_details" class="form-control"
                                                                placeholder="" onKeyPress="if(this.value.length==10) return false;">
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-12 p-2">
                                                        <div class="form-group">
                                                            <label for="" class=" font-layout">Mobile<span
                                                                    class="inputlabelmedetory text-err">*</span></label>
                                                            <input type="text" name="mobile_of_of_technical_details"
                                                                id="mobile_of_of_technical_details" class="form-control"
                                                                placeholder="" required onKeyPress="if(this.value.length==10) return false;">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="" style="float:right">
                                                <br>
                                                <button type="submit" class="btn btn-primary submit">Update</button>
                                                <button type="button" class="btn btn-danger cancelbutton">Cancel</button>
                                                <br><br>
                                            </div>
                            </form>
                        </div>
                    </div>
                    
                </div>

</div>
    @endsection
    @section('js')
        <script type="text/javascript">
            $(document).ready(function() {

                
                var count="{{$count}}";

                if(count>0){

                    Swal.fire({
                            title: "Error!",
                            text: `${count} Domain failed to upload as they already exist`,
                            icon: "error"
                    });

                }
               
                var table = $('#dataTable').DataTable({
                    processing: true,
                    serverSide: true,
                    ajax: "{{ route('bulkpreview.ajaxcall') }}",
                    pageLength: 50,
                    columns: [{
                            data: 'id'
                        },
                        {
                            data: 'domain',
                            orderable: false
                        },
                        {
                            data: 'institute',
                            orderable: false
                        },
                        {
                            data: 'address',
                            orderable: false
                        },
                        {
                            data: 'period',
                            orderable: false
                        },
                        {
                            data: 'email',
                            orderable: false
                        },
                        {
                            data: 'Action',
                            orderable: false
                        },
                    ]
                });

                $('body').on('click', '#final_submit', function() {

        Swal.fire({
          title: 'Confirmation',
          text: 'Are you sure you want to Upload multiple domains ?',
          icon: 'warning',
          showCancelButton: true,
          confirmButtonText: 'Confirm',
          cancelButtonText: 'Cancel'
        }).then((result) => {
          if (result.isConfirmed) {

                    Swal.fire({
                        title: "Please wait...",
                        html: "Processing ..."
                    })
                    Swal.showLoading();
                    
                        $('.updateform').addClass('d-none');
                        $.ajaxSetup({
                            headers: {
                                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                            }
                        });

                        $.ajax({
                            url: "{{ route('bulkDomainFinalSubmit') }}",
                            dataType: "json",
                            type: "post",
                            data: {
                            },
                            success: function(response) {
                              
                            if (response.status == true) {

                          Swal.fire({
                            title: "Success!",
                            text: 'Domain Saved Successfully',
                            icon: "success"
                          });

                          var redirectUrl = "{{ route('doc.domain') }}";
                          window.location.href = redirectUrl;

                                } else {

Swal.fire({
    title: "Error!",
    text: response.message,
    icon: "error",
    showCancelButton: false,
    confirmButtonText: "OK"
}).then((result) => {
    if (result.isConfirmed) {
        var redirectUrl = "{{ route('upload.domain') }}";
        window.location.href = redirectUrl;
    }
});

                                }
                            },
                        });

          } else {

          }
        
});
                      

                    // }

                
                });


                $('body').on('click', '.delete', function() {

                    var id = $(this).attr('data-id');
                    if (confirm("Are you sure you want to remove this domain?")) {
                        $('.updateform').addClass('d-none');
                        $.ajaxSetup({
                            headers: {
                                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                            }
                        });

                        $.ajax({
                            url: "{{ route('bulkDeleteDomain') }}",
                            dataType: "json",
                            type: "post",
                            data: {
                                'id': id
                            },
                            success: function(response) {
                                $('#description').val('');
                                $('.description').val('');
                                if (response.status == true) {

                                    table.ajax.reload();

                          Swal.fire({
                            title: "Success!",
                            text: 'Domain Deleted Successfully',
                            icon: "success"
                          });

                                } else {

                                    alert(response.message);

                                }
                            },
                        });

                    }
                    return false;
                });


                $('body').on('submit', '#updateDesignationForm', function(e) {
                        e.preventDefault();
                        var current = $(this);
                        var data = current.serialize();
                        $.ajax({
                            url: "{{ route('bulkDomainUpdate') }}",
                            dataType: "json",
                            type: "post",
                            data: data,
                            success: function(response) {

                                if (response.status) {
                                   
                                    table.ajax.reload();

                                    $('.updateform').addClass('d-none');
                                    $('.createform').removeClass('d-none');
                                    $('.viewform').removeClass('d-none');

                                } else {
                                    alert(response.message);
                                }
                            },
                        });
                    return false;
                });


                $('body').on('click', '.update', function() {
                    var id = $(this).attr('data-id');
                    $('#code').val('');
                    $.ajax({
                        url: "{{ route('getTempDomain') }}",
                        dataType: "json",
                        type: "get",
                        data: {
                            'id': id
                        },
                        success: function(response) {

                            if (response.status == true) {

                                $('.createform').addClass('d-none');
                                $('.viewform').addClass('d-none');
                                $('.updateform').removeClass('d-none');
                                $('#id').val(response.data.id);
                                $('#domainName').val(response.data.domainName);
                                $('#email').val(response.data.email);
                                $('#phone').val(response.data.phone);

                                $('#institute').val(response.data.institute);
                                $('#address').val(response.data.address);
                                $('#gst_no').val(response.data.gst_no);

                                $('#name_of_head_of_institute').val(response.data
                                    .name_of_head_of_institute);
                                $('#designation_of_head_of_institute').val(response.data
                                    .designation_of_head_of_institute);
                                $('#email_of_head_of_institute').val(response.data
                                    .email_of_head_of_institute);
                                $('#phone_of_head_of_institute').val(response.data
                                    .phone_of_head_of_institute);
                                $('#mobile_of_head_of_institute').val(response.data
                                    .mobile_of_head_of_institute);
                                $('#name_of_administrative_contacts').val(response.data
                                    .name_of_administrative_contacts);
                                $('#designation_of_administrative_contacts').val(response.data
                                    .designation_of_administrative_contacts);
                                $('#email_of_administrative_contacts').val(response.data
                                    .email_of_administrative_contacts);
                                $('#phone_of_administrative_contacts').val(response.data
                                    .phone_of_administrative_contacts);
                                $('#mobile_of_administrative_contacts').val(response.data
                                    .mobile_of_administrative_contacts);
                                $('#name_of_billing_details').val(response.data
                                    .name_of_billing_details);
                                $('#designation_of_billing_details').val(response.data
                                    .designation_of_billing_details);
                                $('#email_of_billing_details').val(response.data
                                    .email_of_billing_details);
                                $('#phone_of_of_billing_details').val(response.data
                                    .phone_of_of_billing_details);
                                $('#mobile_of_billing_details').val(response.data
                                    .mobile_of_billing_details);
                                $('#name_of_technical_details').val(response.data
                                    .name_of_technical_details);
                                $('#designation_of_technical_details').val(response.data
                                    .designation_of_technical_details);
                                $('#email_of_technical_details').val(response.data
                                    .email_of_technical_details);
                                $('#phone_of_technical_details').val(response.data
                                    .phone_of_technical_details);
                                $('#mobile_of_of_technical_details').val(response.data
                                    .mobile_of_of_technical_details);
                                $('#pincode').val(response.data.pincode);


                            } else if (response.status == 'error') {
                                alert(response.message);
                            }

                        },
                    });

                });

                $('body').on('click', '.addbutton', function() {
                    $('.createform').removeClass('d-none');
                    $('.updateform').addClass('d-none');
                    $('.viewform').addClass('d-none');
                });

                $('body').on('click', '.cancelbutton', function() {
                    $('.updateform').addClass('d-none');
                    $('.createform').removeClass('d-none');
                    $('.viewform').removeClass('d-none');

                });

            });
        </script>
    @endsection
