@extends('layouts.AdminLayout')
@section('content')
    <div class="content-wrapper">
        <div class="container-xxl flex-grow-1 container-p-y">
            <h4 class="fw-bold py-3 mb-2">{{$title}}</h4>
            <div class="card">
                <div style="padding:20px">
                    <div class="table-responsive text-nowrap">
                        @if (Session::has('success'))
                            <div class="alert alert-success">{{ Session::get('success') }}</div>
                        @endif
                        @if (Session::has('error'))
                            <div class="alert alert-danger">{{ Session::get('error') }}</div>
                        @endif
                        <table class="table table-striped table-bordered dataTable no-footer" id="dataTable" width="100%"
                            cellspacing="0">
                            <thead class="table-secondary">
                                <tr>
                                    <th>S.No.</th>
                                    <th>Domain Name</th>
                                    <th>Institute Name</th>
                                    <th>Period</th>
                                    <th>Email</th>
                                    <th>Domain Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>

                       
                    </div>
                </div>
                
                
                <div class="row my-4 justify-content-end">

                <div class="col-md-3" style="float:right">

                @if($domain!=null && $domain->domainStatus==1)

                <a href="{{ route('doc.domain') }}" class="btn btn-warning mx-4" style="float:right">Upload Documents</a>

                @endif

                @if($domain!=null && $domain->domainStatus==2)

                <a href="{{route('proceedToCheckoutRegistration')}}" class="btn btn-success mx-4" style="float:right">Make Payment</a>

                @endif

                
                </div>

            </div>

               
            </div>


</div>

        </div>

</div>
    @endsection
    @section('js')

    
<script>
       
       @if(session('message'))
                     
            Swal.fire({
                icon: 'success',
                title: 'Success!',
                text: '{{ session('message') }}',
                customClass: {
                    container: 'alert-container'
                }
            });


        @endif

</script>


        <script type="text/javascript">

            $(document).ready(function() {

                var status="{{$status}}";
                
                var table = $('#dataTable').DataTable({
                    processing: true,
				    serverSide: true,
				    "ajax": {
                    "url": "{{route('bulkincomplete.ajaxcall')}}",
                    "type": "GET",
                    "datatype": "json",
					"data": function(d){
                        d.status = status;
					  }
                    },
                    // ajax: "{{ route('bulkincomplete.ajaxcall') }}",
                    pageLength: 50,
                    columns: [{
                            data: 'id'
                        },
                        {
                            data: 'domain',
                            orderable: false
                        },
                        {
                            data: 'institute',
                            orderable: false
                        },
                        {
                            data: 'period',
                            orderable: false
                        },
                        {
                            data: 'email',
                            orderable: false
                        },
                        {
                            data: 'status',
                            orderable: false
                        },
                        {
                            data: 'Action',
                            orderable: false
                        },
                    ]
                });

                $('body').on('click', '#final_submit', function() {

                    if (confirm("Are you sure you want to save ?")) {

                        Swal.fire({
                        title: "Please wait...",
                        html: "Processing ..."
                    })
                    Swal.showLoading();
                    
                        $('.updateform').addClass('d-none');
                        $.ajaxSetup({
                            headers: {
                                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                            }
                        });

                        $.ajax({
                            url: "{{ route('bulkDomainFinalSubmit') }}",
                            dataType: "json",
                            type: "post",
                            data: {
                                'id': ''
                            },
                            success: function(response) {
                              
                            if (response.status == true) {

                          Swal.fire({
                            title: "Success!",
                            text: 'Domain Saved Successfully',
                            icon: "success"
                          });

                          var redirectUrl = "{{ route('doc.domain') }}";
                          window.location.href = redirectUrl;

                                } else {

                                    alert(response.message);

                                }
                            },
                        });

                    }

                
                });


              

                $('body').on('submit', '#updateDesignationForm', function(e) {
                        e.preventDefault();
                        var current = $(this);
                        var data = current.serialize();
                        $.ajax({
                            url: "{{ route('bulkDomainUpdate') }}",
                            dataType: "json",
                            type: "post",
                            data: data,
                            success: function(response) {

                                if (response.status) {
                                   
                                    table.ajax.reload();

                                    $('.updateform').addClass('d-none');
                                    $('.createform').addClass('d-none');
                                    $('.viewform').addClass('d-none');

                                } else {
                                    alert(response.message);
                                }
                            },
                        });
                    return false;
                });


                $('body').on('click', '.update', function() {
                    var id = $(this).attr('data-id');
                    $('#code').val('');
                    $.ajax({
                        url: "{{ route('getTempDomain') }}",
                        dataType: "json",
                        type: "get",
                        data: {
                            'id': id
                        },
                        success: function(response) {

                            if (response.status == true) {

                                $('.createform').addClass('d-none');
                                $('.viewform').addClass('d-none');
                                $('.updateform').removeClass('d-none');
                                $('#id').val(response.data.id);
                                $('#domainName').val(response.data.domainName);
                                $('#email').val(response.data.email);
                                $('#phone').val(response.data.phone);

                                $('#institute').val(response.data.institute);
                                $('#address').val(response.data.address);
                                $('#gst_no').val(response.data.gst_no);

                                $('#name_of_head_of_institute').val(response.data
                                    .name_of_head_of_institute);
                                $('#designation_of_head_of_institute').val(response.data
                                    .designation_of_head_of_institute);
                                $('#email_of_head_of_institute').val(response.data
                                    .email_of_head_of_institute);
                                $('#phone_of_head_of_institute').val(response.data
                                    .phone_of_head_of_institute);
                                $('#mobile_of_head_of_institute').val(response.data
                                    .mobile_of_head_of_institute);
                                $('#name_of_administrative_contacts').val(response.data
                                    .name_of_administrative_contacts);
                                $('#designation_of_administrative_contacts').val(response.data
                                    .designation_of_administrative_contacts);
                                $('#email_of_administrative_contacts').val(response.data
                                    .email_of_administrative_contacts);
                                $('#phone_of_administrative_contacts').val(response.data
                                    .phone_of_administrative_contacts);
                                $('#mobile_of_administrative_contacts').val(response.data
                                    .mobile_of_administrative_contacts);
                                $('#name_of_billing_details').val(response.data
                                    .name_of_billing_details);
                                $('#designation_of_billing_details').val(response.data
                                    .designation_of_billing_details);
                                $('#email_of_billing_details').val(response.data
                                    .email_of_billing_details);
                                $('#phone_of_of_billing_details').val(response.data
                                    .phone_of_of_billing_details);
                                $('#mobile_of_billing_details').val(response.data
                                    .mobile_of_billing_details);
                                $('#name_of_technical_details').val(response.data
                                    .name_of_technical_details);
                                $('#designation_of_technical_details').val(response.data
                                    .designation_of_technical_details);
                                $('#email_of_technical_details').val(response.data
                                    .email_of_technical_details);
                                $('#phone_of_technical_details').val(response.data
                                    .phone_of_technical_details);
                                $('#mobile_of_of_technical_details').val(response.data
                                    .mobile_of_of_technical_details);
                                $('#pincode').val(response.data.pincode);


                            } else if (response.status == 'error') {
                                alert(response.message);
                            }

                        },
                    });

                });

                $('body').on('click', '.addbutton', function() {
                    $('.createform').removeClass('d-none');
                    $('.updateform').addClass('d-none');
                    $('.viewform').addClass('d-none');
                });

                $('body').on('click', '.cancelbutton', function() {
                    $('.createform').addClass('d-none');
                    $('.updateform').addClass('d-none');
                    $('.viewform').addClass('d-none');
                });

                

            });
        </script>
    @endsection
