@extends('layouts.AdminLayout')
@section('content')

<link href="https://pay.billdesk.com/jssdk/v1/dist/billdesksdk/billdesksdk.css"rel="stylesheet">

<style>

.list-group-item{
    color:black !important;
}

</style>

<div class="content-wrapper">
<section class="h-100 h-custom" style="">
  <div class="container py-5 h-100">
    <div class="row d-flex justify-content-center align-items-center h-100">
      <div class="col-lg-10 col-xl-8">
        <div class="card rounded-3">

          <img src="{{asset('assets/img/domain_name_banner.png')}}" class="w-100" style="border-top-left-radius: .3rem; border-top-right-radius: .3rem;">
           
          <div class="card-body p-4 p-md-5">
            <h4 class="mb-4 pb-2 pb-md-0 px-md-2 text-center fw-600">Domain Checkout Page</h4>
                
                <form method="post" id="editdomainform">
                      @csrf

                      @php

                      $taxes=json_encode(getmisc()->service_tax);

                      $domaindisamt = ($domainStats->sum_domainPrice*$miscsettings->bulk_domain_discount)/100;

                      $singledomaindis=$domainStats->average_domainPrice*$miscsettings->bulk_domain_discount/100;

                      $perdomaindistamt = $domainStats->average_domainPrice - $singledomaindis;

                      $domainamt=$domainStats->sum_domainPrice-$domaindisamt;
                   
                      $singledomaintaxamt = ($perdomaindistamt*$taxes)/100;
                      $singledomainamount = $perdomaindistamt+($perdomaindistamt*$taxes)/100;


                      $dnsdisamt = ($domainStats->sum_dnsPrice*$miscsettings->bulk_dns_discount)/100;
                      $dnsamt = $domainStats->sum_dnsPrice-$dnsdisamt;

                      $singlednsdis=($domainStats->average_dnsPrice*$miscsettings->bulk_dns_discount)/100;
                      $singlednsamount=$domainStats->average_dnsPrice-$singlednsdis;

                      $singlednstxtamt = ($singlednsamount*$taxes)/100;

                      $totalamount=$domainamt+$dnsamt;
                      $taxamt = ($totalamount*$taxes)/100;


                      $totalpayableamount=$totalamount+$taxamt;

                      @endphp

                      <input type="hidden" class="form-control" name="domain_count"  value="{{$domainStats->count}}" readonly/>
                      <input type="hidden" class="form-control" name="total_domain_price"  value="{{$domainamt}}" readonly/>
                      <input type="hidden" class="form-control" name="total_dns_price"  value="{{$dnsamt}}" readonly/>
                      <input type="hidden" class="form-control" name="total_amount"  value="{{$totalamount}}" readonly/>
                      <input type="hidden" class="form-control" name="tax_percent"  value="{{$taxes}}" readonly/>
                      <input type="hidden" class="form-control" name="tax_amount"  value="{{$taxamt}}" readonly/>
                      <input type="hidden" class="form-control" name="domain_names"  value="{{json_encode($domainNames)}}" readonly/>
                      <input type="hidden" class="form-control" name="domain_ids"  value="{{json_encode($domainIds)}}" readonly/>

                      <input type="hidden" class="form-control" name="dns_duration"  value="{{$domainStats->domainPeriod}}" readonly/>
                      <input type="hidden" class="form-control" name="dns_price"  value="{{$domainStats->average_dnsPrice}}" readonly/>
                      <input type="hidden" class="form-control" name="dns_taxper"  value="{{$taxes}}" readonly/>
                      <input type="hidden" class="form-control" name="dns_tax"  value="{{$singlednstxtamt}}" readonly/>
                      <input type="hidden" class="form-control" name="dns_disamt"  value="{{$singlednsamount}}" readonly/>
                      <input type="hidden" class="form-control" name="dns_disper"  value="{{$miscsettings->bulk_dns_discount}}" readonly/>
                      <input type="hidden" class="form-control" name="dns_dis"  value="{{$singlednsdis}}" readonly/>
                      <input type="hidden" class="form-control" name="dns_amount"  value="{{$singlednstxtamt+$singlednstxtamt}}" readonly/>

                      <input type="hidden" class="form-control" name="domain_duration"  value="{{$domainStats->domainPeriod}}" readonly/>
                      <input type="hidden" class="form-control" name="domain_price"  value="{{$domainStats->average_domainPrice}}" readonly/>
                      <input type="hidden" class="form-control" name="domain_disper"  value=" {{$miscsettings->bulk_domain_discount}}" readonly/>
                      <input type="hidden" class="form-control" name="domain_dis"  value="{{$singledomaindis}}" readonly/>
                      <input type="hidden" class="form-control" name="domain_disamt"  value="{{$perdomaindistamt}}" readonly/>
                      <input type="hidden" class="form-control" name="domain_taxper"  value="{{$taxes}}" readonly/>
                      <input type="hidden" class="form-control" name="domain_tax"  value="{{$singledomaintaxamt}}" readonly/>
                      <input type="hidden" class="form-control" name="domain_amount"  value="{{$singledomainamount}}" readonly/>

                      <!-- <input type="hidden" class="form-control" name="amount"  value="{{$totalpayableamount}}" readonly/> -->
                      <input type="hidden" class="form-control" name="transaction_type"  value="domainRegisterWithNameServer" readonly/>
                      <input type="hidden" class="form-control" name="remark"  value="DNS and  Domain fee " readonly/>
                      <input type="hidden" class="form-control" name="domain_name"  value="Bulk Domain" readonly/>

                      <input type="hidden" class="form-control" name="amount"  value="{{$totalpayableamount}}" readonly/>

                       <li class="list-group-item ">No of Domains : {{$domainStats->count}} </li>
                       <li class="list-group-item ">Domain  Period : {{number_format($domainStats->domainPeriod,0)}} years</li>                                  
                       <li class="list-group-item ">Domain  Price Per Domain  : ₹{{$domainStats->average_domainPrice}} </li>
                       <li class="list-group-item ">Domain Amount  : ₹{{$domainStats->sum_domainPrice}} </li>   
                       <li class="list-group-item ">Domain Discount (%)  : {{$miscsettings->bulk_domain_discount}} </li>                                  
                       <li class="list-group-item ">Domain Discount Amount  : ₹ {{$domaindisamt}}</li>                                  
                       <li class="list-group-item ">Total Domain Amount  : ₹ {{$domainamt}}</li>                                  
                       <li class="list-group-item ">DNS  Price Per Domain  : ₹{{$domainStats->average_dnsPrice}} </li> 
                       <li class="list-group-item ">DNS Amount  : ₹{{$domainStats->sum_dnsPrice}} </li>
                       <li class="list-group-item ">DNS Discount (%)  : {{$miscsettings->bulk_dns_discount}} </li>   
                       <li class="list-group-item ">DNS Discount Amount  : ₹{{$dnsdisamt}} </li>   
                       <li class="list-group-item ">Total DNS Amount  : ₹{{$dnsamt}} </li>      
                       <li class="list-group-item ">Total Amount : ₹{{$totalamount}} </li>                                                                 
                       <li class="list-group-item ">Tax (%)  : {{$taxes}} </li>                                  
                       <li class="list-group-item ">Tax Amount  : ₹{{$taxamt}} </li>                                  
                       <li class="list-group-item ">Total Payable Amount : ₹{{$totalpayableamount}} </li>                                                                 

               </div>
      

          <div class="col-12 mb-5">
          <div class="row mx-3 justify-content-end">
              <div class="col-auto">
                  <a href="{{ url()->previous() }}">
                      <input type="button" class="btn btn-danger ml-3" id="back" name="back" value="Back" />
                  </a>
              </div>
              <div class="col-auto">
                  <button type="submit" class="btn btn-success mr-4" id="myButton">Make Payment</button>
              </div>
          </div>
        
        </div>


            </form>

          </div>
        </div>
      </div>
    </div>
  </div>
</section>

</div></div>

<script type="module" src="https://pay.billdesk.com/jssdk/v1/dist/billdesksdk/billdesksdk.esm.js"></script></script>
<script nomodule="" src="https://pay.billdesk.com/jssdk/v1/dist/billdesksdk.js"></script> 

<script src="https://code.jquery.com/jquery-latest.min.js"></script>

<script>
              
$(document).ready(function() {


$('body').on('submit', '#editdomainform', function(e) {
  e.preventDefault();
  $('#overlay').show();

  var current = $(this);		
  var data = current.serialize();
  $.ajaxSetup({
    headers: {
      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    }
  });

  $.ajax({
    url: "{{route('bulk.createBulkBilldeskOrder')}}",
    dataType : "json",
    type: "post",
    data : data,
    success : function(response) {
    if(response.status == 'success') {

var flow_config ={
merchantId:response.mid,
bdOrderId: response.orderId,
authToken: response.otoken,
childWindow: false,
returnUrl: response.ru, 
retryCount: 3,
prefs: {
 "payment_categories": ["card", "nb","upi"],
 },
netBanking:{
 "showPopularBanks" : "Y",
 "popularBanks": ["Kotak Bank"," AXIS Bank [Retail]"],
}
} 

var theme_config = {
 sdkPrimaryColor: response.sdkPrimaryColor,
 sdkAccentColor: response.sdkAccentColor,
 sdkBackgroundColor: response.sdkBackgroundColor,
 sdkBannerColor: response.sdkBannerColor
}

var config = {
responseHandler: responseHandler,
merchantLogo: response.logo,
flowConfig: flow_config,
flowType: "payments",
themeConfig: theme_config
}

$('#overlay').hide();

window.loadBillDeskSdk(config);

} else if(response.status == 'error') {
        Swal.fire({
            icon: 'error',
            text: 'Please try again',
            showConfirmButton: true,
        })
      }
    },
  });
});

});

var responseHandler = function (txn) {
 console.log("callback received status:: ",txn.status)
 console.log("callback received response:: ",txn.response)
}


    </script>

@endsection