@extends('layouts.AdminLayout')
@section('content')
    <div class="content-wrapper">
        <div class="container-xxl flex-grow-1 container-p-y">
            <h4 class="fw-bold py-3 mb-2">Manage Active Domains</h4>
            <div class="card">
                <div style="padding:20px">
                    <div class="table-responsive text-nowrap">
                        @if (Session::has('success'))
                            <div class="alert alert-success">{{ Session::get('success') }}</div>
                        @endif
                        @if (Session::has('error'))
                            <div class="alert alert-danger">{{ Session::get('error') }}</div>
                        @endif
                        <table class="table table-striped table-bordered dataTable no-footer" id="dataTable" width="100%"
                            cellspacing="0">
                            <thead class="table-secondary">
                                <tr>
                                    <th>S.No.</th>
                                    <th>Domain Name</th>
                                    <th>Institute Name</th>
                                    <th>Period</th>
                                    <th>Email</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>
                

               
            </div>


</div>

        </div>


</div>
    @endsection
    @section('js')
        <script type="text/javascript">
            $(document).ready(function() {

               
                var table = $('#dataTable').DataTable({
                    processing: true,
                    serverSide: true,
                    ajax: "{{ route('bulkactive.ajaxcall') }}",
                    pageLength: 50,
                    columns: [{
                            data: 'id'
                        },
                        {
                            data: 'domain',
                            orderable: false
                        },
                        {
                            data: 'institute',
                            orderable: false
                        },
                     
                        {
                            data: 'period',
                            orderable: false
                        },
                        {
                            data: 'email',
                            orderable: false
                        },
                        {
                            data: 'Action',
                            orderable: false
                        },
                    ]
                });

            

            });
        </script>
    @endsection
