@extends('layouts.AdminLayout')

@section('content')

<style>
        .loader-container {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.5);
            z-index: 9999;
        }
        .loader {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            color: white;
            font-size: 24px;
        }
        .error-field {
            color: red;
        }
    </style>


<div class="content-wrapper">

<div class="container-xxl flex-grow-1 container-p-y">
    <h4 class="fw-bold py-3 mb-2">Upload Multiple Domain Details</h4>
	
  
		<div class="card">
			<div style="padding:20px">	
				

<p>
<b>Note-</b>

 Please download sample excel format to fill the details of each of multiple domains.     
</p>
						@if (Session::has('success'))
						   <div class="alert alert-success">{{ Session::get('success') }}</div>
						@endif
						
						@if (Session::has('error'))
						   <div class="alert alert-danger">{{ Session::get('error') }}</div>
						@endif
                    
                    <form method="post" id="departmentForm">
                        {!! csrf_field() !!}

                        <input type="hidden" name="type" value="{{$type}}">

                        <div class="form-group col-md-4">
                          <label for="">Period</label>
                          <select class="form-control" name="period" id="period" required>
                            <option>Select</option>
                            <!-- <option value="1">1</option>
                            <option value="2">2</option>
                            <option value="3">3</option>
                            <option value="4">4</option> -->
                            <option value="5">5</option>
                            <!-- <option value="6">6</option>
                            <option value="7">7</option>
                            <option value="8">8</option>
                            <option value="9">9</option> -->
                            <option value="10">10</option>
                          </select>
                        </div>

                        <div class="form-group col-md-4 mt-4">
                          <label for="">Upload Domains</label>
                          <input type="file" class="form-control" name="excel_file" id="excel_file" required>
                        </div>

                     <div class="mt-3">
                     <a href="{{ asset('format.xlsx') }}" class="" download>Download Sample Excel Format</a>
                    
                    </div>

                    <div class="demo-inline-spacing">
                            <br>
                            <button type="submit" class="btn btn-primary submit ">Submit</button>
                            <br><br>
                    </div>

                    </div>

                
                     
                    </form>
                </div>
            </div>
        </div>
             
</div>


@endsection

@section("js")

<script src="https://ajax.aspnetcdn.com/ajax/jquery.validate/1.9/jquery.validate.js"></script>

<script>

	$(document).ready(function(){

        $('body').on('submit', '#departmentForm', function(e) {
                e.preventDefault();

                    Swal.fire({
                        title: "Please wait...",
                        html: "Processing ..."
                    })
                    Swal.showLoading();

					$.ajax({
						url: "{{route('bulkUploadDomain')}}",
                        type: "post",
                        data: new FormData($('#departmentForm')[0]),
                        processData: false,
                        contentType: false,
						success : function(response) {
														
							if(response.status == true) {
								
                                var redirectUrl = "{{ route('bulkPreview') }}";
                                window.location.href = redirectUrl;

							} else {
								
                          Swal.fire({
                            title: "Error!",
                            text: 'Please Upload Excel File.',
                            icon: "error"
                          });
								
							}

						},
                        error: function(){
                        
                               
                        Swal.fire({
                            title: "Error!",
                            text: 'Please Upload Valid Excel  File',
                            icon: "error"
                        });


                        }
					});
					return false;
				
				return false;
		});
		
	});

</script>

@endsection



