@extends('layouts.AdminLayout')

@section('content')

<?php

$action='';

$userid=Auth::guard('admin')->user()->id;

$edit=$del=$add=true;
$priv=getUserHasRoleProgram($userid,10);

if($priv!=null){
    $add=$priv->add_priv==1 ?true:false;
}

?>

<div class="content-wrapper">

<div class="container-xxl flex-grow-1 container-p-y">
    <h4 class="fw-bold py-3 mb-2">Discounts</h4>
		<div class="card">
			<div style="padding:20px">	
					<div class="table-responsive text-nowrap">
						@if (Session::has('success'))
						   <div class="alert alert-success">{{ Session::get('success') }}</div>
						@endif
						
						@if (Session::has('error'))
						   <div class="alert alert-danger">{{ Session::get('error') }}</div>
						@endif
						<table class="table table-striped table-bordered dataTable no-footer" id="dataTable" width="100%" cellspacing="0">
							<thead class="table-secondary">
								<tr>
                                <th>S.No.</th>
								<th>Discount Name</th>
								<th>Discount (in %)</th>
                                <th>Status</th>
								<th>Action</th>
								</tr>
							</thead>
						   
							<tbody>
								
							</tbody>
						</table>
					</div>
					
                <div class="demo-inline-spacing">
                        <br>
						@if($add)
                        <button type="button" class="btn btn-primary addbutton">Add</button>
						@endif
						<br><br>
                </div>
			</div>
		</div>

        <div class="card mt-3">
				
        <div class=" createform d-none">
            <div class="card cblack">

<div class="card-body">
                    
<form method="post" id="departmentForm">
{!! csrf_field() !!}

<div class="row">
<div class="form-group col-md-6 mt-3">
    <label for="" class=" font-layout">Discount Name <span class="inputlabelmedetory text-err"></span></label>
    <input type="text" name="name" id="name" class="form-control specialcharuser" placeholder="" onKeyPress="if(this.value.length==50) return false;">
</div>

<div class="form-group col-md-6 mt-3">
    <label for="" class="font-layout">Discount (in %) <span class="inputlabelmedetory text-err"></span></label>
    <input type="number" name="discount" id="discount" class="discount_d form-control" placeholder="" max="100">
</div>

<div class="form-group col-md-6 mt-3">
  <label for="">Extensions</label>
  <select class=" form-control" name="extension[]" id="extension" multiple>
    @foreach($exts as $ext)
    <option value="{{$ext->id}}">{{$ext->domain_extension}}</option>
    @endforeach
  </select>
</div>

<div class="form-group col-md-6 mt-3">
  <label for="">Status</label>
  <select class=" form-control" name="status" id="status" >
    <option value="" disabled>Select Status</option>
    <option value="1">Active</option>
    <option value="2">Deactive</option>
  </select>
</div>

<div class="form-group col-md-6 mt-3">
    <label for="" class="font-layout">Start Date<span class="inputlabelmedetory text-err"></span></label>
    <input type="date" name="start_date" id="start_date" class="form-control" placeholder="" min="{{date('Y-m-d')}}">
</div>


<div class="form-group col-md-6 mt-3">
    <label for="" class="font-layout">End Date<span class="inputlabelmedetory text-err"></span></label>
    <input type="date" name="end_date" id="end_date" class="form-control" placeholder="" min="{{date('Y-m-d')}}">
</div>

</div>

                    <div class="demo-inline-spacing">
                            <br>
                            <button type="submit" class="btn btn-primary submit ">Submit</button>
                            <button type="button" class="btn btn-danger cancelbutton ">Cancel</button>
                            <br><br>
                    </div>
                     
                    </form>
                </div>
            </div>
        </div>

        <div class="updateform d-none">
			<div class="card cblack">

			<div class="card-body">
							
			<form method="post" id="updateDesignationForm" action="#">
								{!! csrf_field() !!}
			<input type="hidden" name="id" id="id" />

            <div class="row">
<div class="form-group col-md-6 mt-3">
    <label for="" class=" font-layout">Discount Name <span class="inputlabelmedetory text-err"></span></label>
    <input type="text" name="name" id="" class="name form-control specialcharuser" placeholder="" onKeyPress="if(this.value.length==50) return false;">
</div>

<div class="form-group col-md-6 mt-3">
    <label for="" class="font-layout">Discount (in %) <span class="inputlabelmedetory text-err"></span></label>
    <input type="number" name="discount" id="" class="discount form-control discount_d" placeholder="" max="100">
</div>

<div class="form-group col-md-6 mt-3">
  <label for="">Extensions</label>
  <select class="extension form-control" name="extension[]" id="" multiple>
    @foreach($exts as $ext)
    <option value="{{$ext->id}}">{{$ext->domain_extension}}</option>
    @endforeach
  </select>
</div>

<div class="form-group col-md-6 mt-3">
  <label for="">Status</label>
  <select class="status form-control" name="status" id="" >
    <option value="" disabled>Select Status</option>
    <option value="1">Active</option>
    <option value="2">Deactive</option>
  </select>
</div>

<div class="form-group col-md-6 mt-3">
    <label for="" class="font-layout">Start Date<span class="inputlabelmedetory text-err"></span></label>
    <input type="date" name="start_date" id="" class="start_date form-control">
</div>


<div class="form-group col-md-6 mt-3">
    <label for="" class="font-layout">End Date<span class="inputlabelmedetory text-err"></span></label>
    <input type="date" name="end_date" id="" class="end_date form-control" placeholder="" min="{{date('Y-m-d')}}">
</div>

</div>


                               
							  <div class="demo-inline-spacing">
                                    <br>
									<button type="submit" class="btn btn-primary submit ">Update</button>
									<button type="button" class="btn btn-danger cancelbutton ">Cancel</button>
									<br><br>
							</div>
							 
							  
							</form>
							
						</div>
					</div>
				
				</div>
        
<div class="viewform d-none">
<div class="card cblack">

<div class="card-body">

<form>

<div class="row">
<div class="form-group col-md-6 mt-3">
    <label for="" class=" font-layout">Discount Name <span class="inputlabelmedetory text-err"></span></label>
    <input type="text" name="name" id="" class="name1 form-control" placeholder="" disabled>
</div>

<div class="form-group col-md-6 mt-3">
    <label for="" class="font-layout">Discount (in %) <span class="inputlabelmedetory text-err"></span></label>
    <input type="number" name="discount" id="" class="discount1  discount_d form-control" placeholder="" disabled>
</div>

<div class="form-group col-md-6 mt-3">
  <label for="">Extensions</label>
  <select class="extension1 form-control" name="extension[]" id="" multiple disabled>
    @foreach($exts as $ext)
    <option value="{{$ext->id}}">{{$ext->domain_extension}}</option>
    @endforeach
  </select>
</div>

<div class="form-group col-md-6 mt-3">
  <label for="">Status</label>
  <select class="status1 form-control" name="status" id="" disabled>
    <option value="" disabled>Select Status</option>
    <option value="1">Active</option>
    <option value="2">Deactive</option>
  </select>
</div>

<div class="form-group col-md-6 mt-3">
    <label for="" class="font-layout">Start Date<span class="inputlabelmedetory text-err"></span></label>
    <input type="date" name="start_date" id="" class="start_date1 form-control" disabled>
</div>


<div class="form-group col-md-6 mt-3">
    <label for="" class="font-layout">End Date<span class="inputlabelmedetory text-err"></span></label>
    <input type="date" name="end_date" id="" class="end_date1 form-control" placeholder="" min="{{date('Y-m-d')}}" disabled>
</div>

</div>

							  <br>
							  <button type="button" class="btn btn-danger cancelbutton">Cancel</button>
							</form>
						</div>
					</div>
	</div>
</div>


@endsection
@section("js")

<link href="{{ asset('vendor/datatables/dataTables.bootstrap4.min.css') }}" rel="stylesheet">

<script src="{{ asset('vendor/datatables/jquery.dataTables.min.js') }}"></script>
<script src="{{ asset('vendor/datatables/dataTables.bootstrap4.min.js') }}"></script>

	<script type="text/javascript">
		
		$(document).ready(function() {

$('.specialcharuser').on('keypress',function(e){

var regex=new RegExp("^[a-zA-Z0-9&@,. ]");
var key=String.fromCharCode(!e.charCode ? e.which :e.charCode);
if(!regex.test(key)){
    e.preventDefault();
    return false;
}

});
            
			var _ = $('body');
			var createRecord = 'Are you sure you want to save the record?';
			var updateRecord = 'Are you sure you want to modify this record?';
			var deleteRecord = 'Are you sure you want to delete this record?';
			
			var table = $('#dataTable').DataTable({
				processing: true,
				serverSide: true,
				"ajax": {
                    "url": "{{route('discount.ajaxcall')}}",
                    "type": "GET",
                    "datatype": "json",
					"data": function(d){
						d.region_id = $('.state_id').val();
					  }
                },
				columns: [
					{ data: 'id' },
					{ data: 'code',orderable:false },
					{ data: 'extension',orderable:false},
                    { data: 'status',orderable:false},
					{ data: 'Action',orderable:false },
				]
			});

			$('body').on('change', '.state_id', function() {
				
				table.ajax.reload();
			
		    });
			
			$('body').on('click', '.delete', function() {

				var id = $(this).attr('data-id');
				if (confirm(deleteRecord)) {
					$('.viewform').addClass('d-none');
					$('.updateform').addClass('d-none');
					$('.createform').addClass('d-none');
					$.ajaxSetup({
						headers: {
							'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
						}
					});
					
					$.ajax({
						url: "{{route('discount.delete')}}",
						dataType : "json",
						type: "post",
						data : {'id':id},
						success : function(response) {
							$('#name').val('');
							$('.name').val('');
							if(response.status == 'success') {
								
								table.ajax.reload();
								
							} else if(response.status == 'error') {
								
								alert(response.message);
								
							} 
							else if(response.status == 'exceptionError')
							{
								CommonManager.forcelogout();
							}
						},
					});
					
				}
				return false;
			});
			
			$('body').on('submit', '#departmentForm', function(e) {
                e.preventDefault();
				var current = $(this);
				if (confirm(createRecord)) {
					$('.submit', current).attr('disabled', 'disabled');
					var data = current.serialize();
					$.ajax({
						url: "{{route('discount.save')}}",
						dataType : "json",
						type: "post",
						data : data,
						success : function(response) {
							
							$('.submit').removeAttr('disabled');
							
							if(response.status == 'success') {
								$('#name').val('');
								$('.name').val('');
								table.ajax.reload();
								$('.updateform').addClass('d-none');
								$('.createform').addClass('d-none');
								$('.viewform').addClass('d-none');
							} else if(response.status == 'errors') {
								
								$.each(response.message, function(i, message) {
									$('#'+i).after('<span class="Description_error" style="color:red">'+message+'</span>');
								});
								
							} else if(response.status == 'error') {
								$('#name').after('<span class="Description_error" style="color:red">'+response.error+'</span>');
							}
							else if(response.status == 'exceptionError')
							{
								CommonManager.forcelogout();
							}
						},
					});
					return false;
				}
				return false;
			});
			
			$('body').on('submit', '#updateDesignationForm', function(e) {
            e.preventDefault();
			var current = $(this);
			if (confirm(updateRecord)) {
				$('.submit', current).attr('disabled', 'disabled');				
				$('.err').remove();
				var data = current.serialize();
				$.ajax({
					url:"{{route('discount.update')}}",
					dataType : "json",
					type: "post",
					data : data,
					success : function(response) {
						
						$('.submit').removeAttr('disabled');
						
						if(response.status == 'success') {
							$('#name').val('');
							$('.name').val('');
							table.ajax.reload();
							$('.updateform').addClass('d-none');
							$('.createform').addClass('d-none');
							$('.viewform').addClass('d-none');
						} else if(response.status == 'errors') {
							
							$.each(response.message, function(i, message) {
								$('.'+i).after('<span id="Description_error" class="err" style="color:red">'+message+'</span>');
							});

                    
							
						} else if(response.status == 'error') {
							$('#updateDescription').after('<span class="Description_error err" style="color:red">'+response.message+'</span>');
						}
						else if(response.status == 'exceptionError')
						{
							CommonManager.forcelogout();
						}
					},
				});
				return false;
			}
			return false;
		});

    $('body').on('change', '#start_date', function() {checkdate('#'); });

    $('body').on('change', '#end_date', function() {  checkdate('#')});

    $('body').on('change', '.start_date', function() {
        checkdate('.');
    });

    $('body').on('change', '.end_date', function() {
        checkdate('.');
    });

    $('body').on("keypress", '.discount_d', function(e) {
    
    if ($(this).val().length > 2) {
        e.preventDefault();
    }

    });


    function checkdate($opt){

    $start=$($opt+'start_date').val();
	$end=$($opt+'end_date').val();

    if($start!= '' && $end!= '' && $start>= $end)
    {
    alert("Start Date cannot be greater than End Date");
    return false;
    }

    }

			$('body').on('click', '.view', function() {
				var id = $(this).attr('data-id');
				$('.viewform').removeClass('d-none');
				$('.updateform').addClass('d-none');
				$('.createform').addClass('d-none');
				$.ajax({
					url: "{{ route('discount.get') }}",
					dataType : "json",
					type: "get",
					data : {'id':id},
					success : function(response) {
						
						if(response.status == 'success') {

							$('.name1').val(response.data.name);
                            $('.extension1 option[value="'+response.data.extension+'"]').prop('selected', true);
                            $('.status1 option[value="'+response.data.status+'"]').prop('selected', true);
							$('.discount1').val(response.data.discount);
							$('.start_date1').val(response.data.start_date);
							$('.end_date1').val(response.data.end_date);

                            setTimeout(function() {
								$.each(response.extdata, function(index, value){
									$('.extension1 option[value="'+value+'"]').attr("selected", "selected");
								});
							}, 1000);

						} else if(response.status == 'error') {
							alert(response.message);
						}
						
					},
				});
			});
			
			$('body').on('click', '.update', function() {
				var id = $(this).attr('data-id');
				$('#code').val('');
				$.ajax({
					url: "{{ route('discount.get') }}",
					dataType : "json",
					type: "get",
					data : {'id':id},
					success : function(response) {
						
						if(response.status == 'success') {
							
							$('.createform').addClass('d-none');
							$('.viewform').addClass('d-none');
							$('.updateform').removeClass('d-none');
							$('#id').val(response.data.id);
							$('.name').val(response.data.name);
                            // $('.extension option[value="'+response.data.extension+'"]').prop('selected', true);
                            $('.status option[value="'+response.data.status+'"]').prop('selected', true);
							$('.discount').val(response.data.discount);
							$('.start_date').val(response.data.start_date);
							$('.end_date').val(response.data.end_date);

                            setTimeout(function() {
								$.each(response.extdata, function(index, value){
									$('.extension option[value="'+value+'"]').attr("selected", "selected");
								});
							}, 1000);

						} else if(response.status == 'error') {
							alert(response.message);						
						}
						
					},
				});
				
			});
			
			$('body').on('click', '.addbutton', function() {
				$('.createform').removeClass('d-none');
				$('.updateform').addClass('d-none');
				$('.viewform').addClass('d-none');
			});
			
			$('body').on('click', '.cancelbutton', function() {
				$('.createform').addClass('d-none');
				$('.updateform').addClass('d-none');
				$('.viewform').addClass('d-none');
			});
			
		});
	</script>

@endsection



