@extends('layouts.AdminLayout')

@section('content')

<?php

$action='';

$userid=Auth::guard('admin')->user()->id;

$edit=$del=$add=true;
$priv=getUserHasRoleProgram($userid,9);

if($priv!=null){
    $add=$priv->add_priv==1 ?true:false;
}
$head_name = get_heading_name(9);
   if($head_name!=null){
       $heading_name= $head_name;
   }else
   {
      $heading_name="Document Master";
   }

?>

<div class="content-wrapper">

<div class="container-xxl flex-grow-1 container-p-y">
    <h4 class="fw-bold py-3 mb-2">{{$heading_name}}</h4>

		<div class="card">
			<div style="padding:20px">

					<div class="table-responsive text-nowrap">

						@if (Session::has('success'))
						   <div class="alert alert-success">{{ Session::get('success') }}</div>
						@endif

						@if (Session::has('error'))
						   <div class="alert alert-danger">{{ Session::get('error') }}</div>
						@endif

						<table class="table table-striped table-bordered dataTable no-footer" id="dataTable" width="100%" cellspacing="0">
								<thead class="table-secondary">
								<tr>
                                <th>S.No.</th>
								<th>Code</th>
								<th>Document Name</th>
								<th>Document Description</th>
                                <th>Doc Size (in KB)</th>
								<th>Status</th>
								<th>Action</th>
								</tr>
							</thead>

							<tbody>

							</tbody>
						</table>
					</div>

                    <div class="demo-inline-spacing">
                        <br>
						@if($add)
                        <button type="button" class="btn btn-primary addbutton ">Add</button>
						@endif
						<br><br>
                </div>
			</div>
		</div>

        <div class="card mt-3">

        <div class=" createform d-none">
            <div class="card cblack">

                <div class="card-body">

                    <form method="post" id="departmentForm">
                        {!! csrf_field() !!}

                      <div class="form-group">
                        <label for="" class=" font-layout">Doc Name <span class="inputlabelmedetory text-err"></span></label>
                        <input type="text" name="title" id="title" class="form-control specialcharuser" placeholder="" onKeyPress="if(this.value.length==50) return false;">
                      </div>


                        <div class="form-group">
                            <label for="" class=" font-layout">Doc Description <span class="inputlabelmedetory text-err"></span></label>
                            <input type="text" name="description" id="description" class="form-control specialcharuser" placeholder="" onKeyPress="if(this.value.length==100) return false;">
                        </div>

                      <div class="form-group mt-3">
                        <label for="" class=" font-layout">Doc Size (in KB)<span class="inputlabelmedetory text-err"></span></label>
                        <input type="number" step="any" name="size" id="size" class="form-control valid-num" placeholder="">
                      </div>


<div class="form-group mt-3">
  <label for="">Status</label>
  <select class="form-control" name="required" id="required" >
	<option value="1">Required</option>
    <option value="2">Optional</option>
  </select>
</div>

                    <div class="demo-inline-spacing">
                            <br>
                            <button type="submit" class="btn btn-primary submit ">Submit</button>
                            <button type="button" class="btn btn-danger cancelbutton ">Cancel</button>
                            <br><br>
                    </div>

                    </form>
                </div>
            </div>
        </div>


        <div class="updateform d-none">
					<div class="card cblack">
						<!-- <h4 class="fw-bold font-weight-bold card-header headingtext font-layout">{{ __('doc Details Data Update') }}</h4> -->

						<div class="card-body">

							<form method="post" id="updateDesignationForm" action="#">
								{!! csrf_field() !!}
								<input type="hidden" name="id" id="id" />

								<div class="form-group">
									<label for="" class="inputlabel font-layout">Code</label>
									<input type="text" id="code" class="form-control" disabled>
								</div>
								<br>
								<div class="form-group">
									<label for="" class=" font-layout">Doc Name <span class="inputlabelmedetory text-err"></span></label>
									<input type="text" name="title" id="updatetitle" class="form-control title specialcharuser" placeholder="Enter title" onKeyPress="if(this.value.length==50) return false;">
								</div>

                                <div class="form-group">
                                    <label for="" class=" font-layout">Doc Description <span class="inputlabelmedetory text-err"></span></label>
                                    <input type="text" name="description" id="updatedescription" class="form-control specialcharuser" placeholder="" onKeyPress="if(this.value.length==50) return false;">
                                </div>

                      <div class="form-group mt-3">
                        <label for="" class=" font-layout">Doc Size (in KB)<span class="inputlabelmedetory text-err"></span></label>
                        <input type="number" step="any" name="size" id="updatesize" class="valid-num form-control size" placeholder="">
                      </div>

<div class="form-group mt-3">
  <label for="">Status</label>
  <select class="required form-control" name="required" id="" >
	<option value="1">Required</option>
    <option value="2">Optional</option>
  </select>
</div>

							<div class="demo-inline-spacing">
                                    <br>
									<button type="submit" class="btn btn-primary submit">Update</button>
									<button type="button" class="btn btn-danger cancelbutton">Cancel</button>
									<br><br>
							</div>


							</form>

						</div>
					</div>

				</div>

                <div class="viewform d-none">
					<div class="card cblack">
						<!-- <h4 class="fw-bold font-weight-bold card-header headingtext font-layout">{{ __('doc Details') }}</h4> -->
						<div class="card-body">
							<form>
								<div class="form-group">
									<label for="" class="inputlabel font-layout">Code</label>
									<input type="text" id="view_code" class="form-control" disabled>
								</div>
								<br>
								<div class="form-group">
									<label for="" class=" font-layout">Doc Name <span class="inputlabelmedetory text-err"></span></label>
									<input type="text" name="title" id="view_updatetitle" class="form-control" placeholder="Enter title" disabled onKeyPress="if(this.value.length==50) return false;">
								</div>

                                <div class="form-group">
                                    <label for="" class=" font-layout">Doc Description <span class="inputlabelmedetory text-err"></span></label>
                                    <input type="text" name="description" id="view_description" class="form-control" placeholder="" onKeyPress="if(this.value.length==50) return false;">
                                </div>

                    <div class="form-group mt-3">
                        <label for="" class=" font-layout">Doc Size (in KB)<span class="inputlabelmedetory text-err"></span></label>
                        <input type="number" step="any" name="size" id="view_updatesize" class="form-control valid-num" placeholder="" disabled>
                      </div>

							  <br>
							  <button type="button" class="btn btn-danger cancelbutton ">Cancel</button>
							</form>
						</div>
					</div>
	</div>
</div>


@endsection
@section("js")
	<script type="text/javascript">

		$(document).ready(function() {
			var _ = $('body');
			var createRecord = 'Are you sure you want to save the record?';
			var updateRecord = 'Are you sure you want to modify this record?';
			var deleteRecord = 'Are you sure you want to delete this record?';

			var table = $('#dataTable').DataTable({
				processing: true,
				serverSide: true,
				ajax: "{{route('doc.ajaxcall')}}",
				columns: [
					{ data: 'id' },
					{ data: 'code',orderable:false },
					{ data: 'title',orderable:false},
					{ data: 'description',orderable:false},
                    { data: 'size',orderable:false},
					{ data: 'required',orderable:false},
					{ data: 'Action',orderable:false },
				]
			});

			$('body').on('click', '.delete', function() {

				var id = $(this).attr('data-id');
				if (confirm(deleteRecord)) {
					$('.viewform').addClass('d-none');
					$('.updateform').addClass('d-none');
					$('.createform').addClass('d-none');
					$.ajaxSetup({
						headers: {
							'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
						}
					});

					$.ajax({
						url: "{{route('doc.delete')}}",
						dataType : "json",
						type: "post",
						data : {'id':id},
						success : function(response) {
							$('#title').val('');
							$('.title').val('');
							if(response.status == 'success') {

								table.ajax.reload();

							} else if(response.status == 'error') {

								alert(response.message);

							}
							else if(response.status == 'exceptionError')
							{
								CommonManager.forcelogout();
							}
						},
					});

				}
				return false;
			});



			$('body').on('submit', '#departmentForm', function(e) {
                e.preventDefault();
				var current = $(this);
				if (confirm(createRecord)) {
					$('.submit', current).attr('disabled', 'disabled');
					var title = $('#title', current).val();
					$('.title_error').remove();
					if(title == '') {
						$('#title').after('<span class="title_error" style="color:red">Please Enter title.</span>');
						$('.submit').removeAttr('disabled');
						return false;
					}

					var data = current.serialize();
					$.ajax({
						url: "{{route('doc.save')}}",
						dataType : "json",
						type: "post",
						data : data,
						success : function(response) {
							$('.submit').removeAttr('disabled');
							if(response.status == 'success') {
								$('#title').val('');
								$('.title').val('');
								table.ajax.reload();
								$('.updateform').addClass('d-none');
								$('.createform').addClass('d-none');
								$('.viewform').addClass('d-none');
							} else if(response.status == 'errors') {
								$.each(response.message, function(i, message) {
									$('#'+i).after('<span class="title_error" style="color:red">'+message+'</span>');
								});
							} else if(response.status == 'error') {
								$('#title').after('<span class="title_error" style="color:red">'+response.error+'</span>');
							}
							else if(response.status == 'exceptionError')
							{
								CommonManager.forcelogout();
							}
						},
					});
					return false;
				}
				return false;
			});

			$('body').on('submit', '#updateDesignationForm', function(e) {
                e.preventDefault();
			var current = $(this);
			if (confirm(updateRecord)) {
				$('.submit', current).attr('disabled', 'disabled');

				var title = $('#updatetitle', current).val();

				$('.title_error').remove();
				if(title == '') {
					$('#updatetitle').after('<span class="title_error" style="color:red">Please enter title.</span>');
					$('.submit').removeAttr('disabled');
					return false;
				}
				$('.err').remove();
				var data = current.serialize();
				$.ajax({
					url:"{{route('doc.update')}}",
					dataType : "json",
					type: "post",
					data : data,
					success : function(response) {

						$('.submit').removeAttr('disabled');

						if(response.status == 'success') {
							$('#title').val('');
							$('.title').val('');
							table.ajax.reload();
							$('.updateform').addClass('d-none');
							$('.createform').addClass('d-none');
							$('.viewform').addClass('d-none');
						} else if(response.status == 'errors') {
							$.each(response.message, function(i, message) {
									$('.'+i).after('<span class="title_error" style="color:red">'+message+'</span>');
							});
						} else if(response.status == 'error') {
							$('#updatetitle').after('<span class="title_error err" style="color:red">'+response.message+'</span>');
						}
						else if(response.status == 'exceptionError')
						{
						}
					},
				});
				return false;
			}
			return false;
		});
			$('body').on('click', '.view', function() {
				var id = $(this).attr('data-id');
				$('.viewform').removeClass('d-none');
				$('.updateform').addClass('d-none');
				$('.createform').addClass('d-none');
				$.ajax({
					url: "{{ route('doc.docid') }}",
					dataType : "json",
					type: "get",
					data : {'id':id},
					success : function(response) {
						if(response.status == 'success') {
							$('#view_code').val(response.data.id);
							$('#view_updatetitle').val(response.data.title);
							$('#view_updatedescription').val(response.data.description);
							$('#view_updatesize').val(response.data.size);
						} else if(response.status == 'error') {
							alert(response.message);
						}

					},
				});
			});

			$('body').on('click', '.update', function() {
				var id = $(this).attr('data-id');
				$('#code').val('');
				$.ajax({
					url: "{{ route('doc.docid') }}",
					dataType : "json",
					type: "get",
					data : {'id':id},
					success : function(response) {
						if(response.status == 'success') {
							$('.createform').addClass('d-none');
							$('.viewform').addClass('d-none');
							$('.updateform').removeClass('d-none');
							$('#id').val(response.data.id);
							$('#code').val(response.data.id);
							$('#updatetitle').val(response.data.title);
							$('#updatedescription').val(response.data.description);
							$('#updatesize').val(response.data.size);
							$('.required option[value="'+response.data.required+'"]').prop('selected', true);

						} else if(response.status == 'error') {
							alert(response.message);
						}
					},
				});
			});

$('.valid-num').keypress(function(event) {
    var charCode = (event.which) ? event.which : event.keyCode;
    var inputValue = $(this).val();
    var decimalIndex = inputValue.indexOf('.');
      if (charCode == 46) {
      if (decimalIndex != -1 || inputValue.length === 0 || inputValue.length > 11) {
        event.preventDefault();
      }
    } else if ((charCode < 48 || charCode > 57) || (decimalIndex != -1 && inputValue.length - decimalIndex > 2)) {
      event.preventDefault();
    } else if (inputValue.length >= 11 && decimalIndex === -1) {
      event.preventDefault();
    }
 });


 $('.specialcharuser').on('keypress',function(e){

var regex=new RegExp("^[a-zA-Z ]");
var key=String.fromCharCode(!e.charCode ? e.which :e.charCode);
if(!regex.test(key)){
    e.preventDefault();
    return false;
}

});

			$('body').on('click', '.addbutton', function() {
				$('.createform').removeClass('d-none');
				$('.updateform').addClass('d-none');
				$('.viewform').addClass('d-none');
			});

			$('body').on('click', '.cancelbutton', function() {
				$('.createform').addClass('d-none');
				$('.updateform').addClass('d-none');
				$('.viewform').addClass('d-none');
			});

		});
	</script>

@endsection



