@extends('layouts.AdminLayout')
@section('content')

<style>
thead th {
    text-align: center !important;
}

@media screen and (min-width: 1304px){


table.dataTable th:nth-child(3){
      width:200px;
      max-width:200px;
      word-break:break-all;
      white-space:pre-line;
  }
  
    table.dataTable td:nth-child(3){
      width:200px;
      max-width:200px;
      word-break:break-all;
      white-space:pre-line;
	}

  table.dataTable th:nth-child(4){
      width:200px;
      max-width:200px;
      word-break:break-all;
      white-space:pre-line;
  }
  
    table.dataTable td:nth-child(4){
      width:200px;
      max-width:200px;
      word-break:break-all;
      white-space:pre-line;
	}

  table.dataTable th:nth-child(2){
      width:200px;
      max-width:200px;
      word-break:break-all;
      white-space:pre-line;
  }
  
    table.dataTable td:nth-child(2){
      width:200px;
      max-width:200px;
      word-break:break-all;
      white-space:pre-line;
	}

}

	.table.dataTable th {
    vertical-align: top;
	text-align:left;
    }
   


</style>

<div class="content-wrapper">

<div class="container-xxl flex-grow-1 container-p-y">
    <div class="card mb-4">
      <h5 class="card-header bg-info">{{$domaintext}}

      <span class="btn btn-primary exportdata" style="color:whitelcursor:pointer">Export To Excel</span></h4>

      </h5>
      
      <div class="card-body">
          <h5 class="my-4">Search Parameters</h5>
          
          <form method="get" id="chatexport" action="{{ url('/ernetdash/deletedexport') }}">	
			@csrf
			<input type="hidden" name="search_text" class="search_text" >

          <div class="row mb-4">
                  <div class="col-md-3">
                      <label class="form-label">Domain Name </label>
                      <input type="text" class="form-control" name="user_name" id="user_name" maxlength="35">
                  </div>
                  <div class="col-md-3">
                      <label class="form-label">Applicant Name </label>
                      <input type="text" class="form-control" name="name" id="name">
                  </div>

                  <div class="col-md-3">
                      <label class="form-label">Institute Name </label>
                      <input type="text" class="form-control" name="institute_name" id="institute_name">
                  </div>

                  <div class="col-md-3">
                      <label class="form-label">Deletion Mode</label>
                      <select class="form-control"  name="deleted_by" id="deleted_by" >
                          {{-- <option value="">Select</option> --}}
                          <option value="">All Deletion List</option>
                          <option value="1">Auto Delete</option>
                          <option value="2">Manually Delete</option>
                          <option value="3">Auto Deleted-Incomplete</option>
                      </select>
                  </div>


                  
              </div>

              <div class="row mb-4">

              <div class="col-md-3">
                      <label class="form-label">Deleted Domain Status</label>
                      <select class="form-control"  name="is_active" id="is_active" >
                          <option value="">Select</option>
                          <option value="1">Active</option>
                          {{-- <option value="2">Incomplete</option> --}}
                      </select>
              </div>

                  <div class="col-md-3">
                      <label class="form-label">Deleted Date From </label>
                      <input type="text" class="form-control datepicker" name="start_date" placeholder="dd-mm-yyyy" id="created_date" max="{{ date('Y-m-d') }}" value="{{$start??''}}">
                  </div>
                  
                  <div class="col-md-3">
                      <label class="form-label">Deleted Date To </label>
                      <input type="text" class="form-control datepicker" name="end_date" placeholder="dd-mm-yyyy" id="expirey_date" max="{{ date('Y-m-d') }}" value="{{$end??''}}">
                  </div>

                  <div class="col-md-3 d-flex">
                      <button class="btn btn-success search" type="button" id="search_user_btn" name="action" value="submit" style="height: 40px;margin-top: 27px; margin-right: 20px;">Search</button>
                  
                  </div>
                  
              </div>
          <br>
          
     

					<div class="table-responsive text-nowrap">
						@if (Session::has('success'))
						   <div class="alert alert-success">{{ Session::get('success') }}</div>
						@endif
						
						@if (Session::has('error'))
						   <div class="alert alert-danger">{{ Session::get('error') }}</div>
						@endif
						<table class="table table-striped table-bordered dataTable no-footer" id="dataTable" width="100%" cellspacing="0">
						<thead class="table-secondary">

                                  <tr>
                                        <th>S.No.</th>
                                        <th>Applicant<br>Name</th>
                                        <th>Domain<br>Name</th>
                                        <th>Institute<br>Name</th>
                                        <th>Domain Creation<br>Date</th>
                                        <th>Domain Expiry<br>Date</th>
                                        <th>Domain Deleted<br>on</th>
                                        <th>Domain Duration<br>(In Years)</th>
                                        <th>Action</th>
                                  </tr>
            </thead>
            <tbody>
            
            </tbody>
          </table>
        </div>

        </form>

      </div>
    </div>
  </div>
</div>
@endsection
@section("js")

<link rel="stylesheet" href="https://code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
<script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>

<script>
    $(function() {
      $(".datepicker").datepicker({
		 dateFormat: 'dd-mm-yy',
		 constrainInput: false,
		 changeYear:true,
		 changeMonth:true,
		 yearRange:'1980:+0',
		 maxDate:0
	 });
    });
  </script>

<script>
$(document).ready(function() {

var domainText="{{$domaintext}}";

        var table = $('#dataTable').DataTable({
				processing: true,
				serverSide: true,
				"ajax": {
          "url": "{{route('deletedusers.ajaxcall')}}",
          "type": "GET",
          "datatype": "json",
					"data": function(d){
						d.domaintext = domainText;
            d.user_name = $('#user_name').val();
						d.institute_name = $('#institute_name').val();
						d.name = $('#name').val();
						d.deleted_by = $('#deleted_by').val();
						d.is_active = $('#is_active').val();
            d.from_date = $('#created_date').val();
						d.end_date = $('#expirey_date').val();
					  }
                },
				columns: [
					{ data: 'id' },
					{ data: 'app',orderable:false },
					{ data: 'domain',orderable:false},
          { data: 'inst',orderable:false},
          { data: 'appdate',orderable:false},
          { data: 'exp',orderable:false},
          { data: 'del',orderable:false},
					{ data: 'duration',orderable:false },
          { data: 'action',orderable:false },
				]
			});

$('body').on('click', '.search', function() {
	table.ajax.reload();
});

$('body').on('click', '.reset', function() {
	window.location.reload();
});

$('body').on('click', '.exportdata', function() {
	$('#chatexport').submit();
});

$('.dataTables_filter input').keyup(function() {
	$('.search_text').val($(this).val());
});

$('body').on('click', '.restore_button', function() {

var id = $(this).attr('data-id');
var status=$(this).attr('data-status');

if(status==1){
  var text='Are you sure you want move this domain to Hold';
}else{
  var text='Are you sure you want move this domain to Pending Restorable';
}

if (confirm(text)) {
  $.ajaxSetup({
    headers: {
      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    }
  });

  Swal.fire({
        title: "Please wait...",
    })

    Swal.showLoading();

  $.ajax({
    url: "{{route('admin.movedomainFromDelete')}}",
    dataType : "json",
    type: "post",
    data : {'id':id,'status':status},
    success : function(response) {

      if(response.status == 'success') {

       Swal.fire({
            icon: 'success',
            text: 'Domain moved successfully',
            showConfirmButton: true,
        }).then(function () {
            window.location.reload();
        });

      } else if(response.status == 'erorr') {

        alert(response.message);
        window.location.reload();


      }
      else if(response.status == 'exceptionError')
      {
      }
    },
  });

}
return false;
});

$('body').on('click', '.inc_restore_button', function() {

                var id = $(this).attr('data-id');
                var status = $(this).attr('data-status');

                if (status == 1) {
                    var text = 'Are you sure you want move this domain to Hold';
                } else {
                    var text = 'Are you sure you want move this domain to Pending Restorable';
                }

                if (confirm(text)) {
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    });

                    Swal.fire({
                        title: "Please wait...",
                    })

                    Swal.showLoading();

                    $.ajax({
                        url: "{{ route('admin.restoreFromIncDeletedUsers') }}",
                        dataType: "json",
                        type: "post",
                        data: {
                            'id': id,
                            'status': status
                        },
                        success: function(response) {

                            if (response.status == 'success') {

                                Swal.fire({
                                    icon: 'success',
                                    text: 'Domain moved successfully',
                                    showConfirmButton: true,
                                }).then(function() {
                                    window.location.reload();
                                });

                            } else if (response.status == 'erorr') {

                                alert(response.message);
                                window.location.reload();


                            } else if (response.status == 'exceptionError') {}
                        },
                    });

                }
                return false;
            });

});
</script>
@endsection