@extends('layouts.AdminLayout')
@section('content')
<style>
   .check {
   -webkit-appearance: none; 
   height: 20px;
   width: 20px;
   position: relative;
   transition: 0.10s;
   background-color: #FE0006;
   text-align: center;
   font-weight: 600;
   color: white;
   border-radius: 3px;
   outline: none;
   }
   .check:checked {
   background-color: #0E9700;
   }
   .check:before {
   content: "✖";
   }
   .check:checked:before {
   content: "✔";
   }
   .check:hover {
   cursor: pointer;
   opacity: 0.8;
   }
   .nav-tabs .nav-link.active, .nav-tabs .nav-item.show .nav-link {
    color: #fff !important;
    background-color: #5a5cff !important;
   }
</style>
<?php
   $action='';
   
   $userid=Auth::guard('admin')->user()->id;
   
   $edit=$del=$add=true;
   $priv=getUserHasRoleProgram($userid,8);
   
   if($priv!=null){
       $add=$priv->add_priv==1 ?true:false;
   }
   $head_name = get_heading_name(8);
   if($head_name!=null){
       $heading_name= $head_name;
   }else
   {
      $heading_name="Email Settings";
   }
   
   ?>
<div class="container-xxl flex-grow-1 container-p-y">
<div class="row">
<div class="col-12 my-2">
   <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light"></span>{{$heading_name}}</h4>
   <div class="card">
      <div class="card-body">
         <div class="row">
            <div class="col-xl-12">
               <div class="nav-align-top mb-4">
                  <ul class="nav nav-tabs nav-fill" role="tablist">
                     <li class="nav-item">
                        <button
                           type="btton"
                           class="nav-link active"
                           role="tab"
                           data-bs-toggle="tab"
                           data-bs-target="#navs-justified-prices"
                           aria-controls="navs-justified-prices"
                           aria-selectd="true"
                           >
                        Email Settings
                        </button>
                     </li>
                     <li class="nav-item">
                        <button
                           type="button"
                           class="nav-link email"
                           role="tab"
                           data-bs-toggle="tab"
                           data-bs-target="#navs-justified-email"
                           aria-controls="navs-justified-email"
                           aria-selected="false">
                        Email Content
                        </button>
                     </li>
                  </ul>
                  <div class="tab-content" style="box-shadow: none">

<div class="tab-pane fade show active" id="navs-justified-prices" role="tabpanel">
   <div class="mt-3">
      <div class="table-responsive text-nowrap">
         @if (Session::has('success'))
         <div class="alert alert-success">{{ Session::get('success') }}</div>
         @endif
         @if (Session::has('error'))
         <div class="alert alert-danger">{{ Session::get('error') }}</div>
         @endif
         <table class="table table-striped table-bordered cell-border" id="dataTable" width="100%" cellspacing="0">
             <thead class="table-secondary">
               <tr>
                  <th>S.No.</th>
                  <th>Host Name </th>
                  <th>Port Number </th>
                  <th>Username </th>
                  <th>Password</th>
                  <th>Sender Email</th>
                  <th>Status</th>
                  <th>Action</th>
               </tr>
            </thead>
            <tbody>
            </tbody>
         </table>
      </div>
      <div class="demo-inline-spacing">
         <br>
         @if($add)
         <button type="button" class="btn btn-primary addbutton ">Add</button>
         @endif
         <br><br>
      </div>
   </div>
</div>

<div class="">
   <div class="createform d-none">
            <form method="post" id="departmentForm">
               {!! csrf_field() !!}
               <div class="row">
                  <div class="form-group mb-3 mb-3 col-md-6">
                     <label for="" class=" font-layout">Host Name  <span class="inputlabelmedetory text-err"></span></label>
                     <input type="text" name="host_name" id="host_name" class="form-control specialcharuser" placeholder="Enter Host Name"  onKeyPress="if(this.value.length==30) return false;">
                  </div>
                  <div class="form-group mb-3 col-md-6">
                     <label for="" class=" font-layout">Port Number <span class="inputlabelmedetory text-err"></span></label>
                     <input type="number" name="port_number" id="port_number" class="form-control specialcharuser" placeholder="Enter Port Number"  onKeyPress="if(this.value.length==5) return false;">
                  </div>
                  <div class="form-group mb-3 col-md-6">
                     <label for="" class=" font-layout">Username<span class="inputlabelmedetory text-err"></span></label>
                     <input type="text" name="username" id="username" class="form-control specialcharuser" placeholder="Enter username"  onKeyPress="if(this.value.length==30) return false;">
                  </div>
                  <div class="form-group mb-3 col-md-6">
                     <label for="" class=" font-layout">Password <span class="inputlabelmedetory text-err"></span></label>
                     <input type="text" name="password" id="password" class="form-control specialcharuser" placeholder="Enter password"  onKeyPress="if(this.value.length==16) return false;">
                  </div>
                  <div class="form-group mb-3 col-md-6">
                     <label for="" class=" font-layout">Sender Email <span class="inputlabelmedetory text-err"></span></label>
                     <input type="text" name="from_address" id="from_address" class="form-control specialcharemail" placeholder="Enter Sender Email"  onKeyPress="if(this.value.length==30) return false;">
                  </div>
                  <div class="form-group mb-3 col-md-6">
                     <label for="" class=" font-layout">From Name<span class="inputlabelmedetory text-err"></span></label>
                     <input type="text" name="from_name" id="from_name" class="form-control specialcharuser" placeholder="Enter From Name"  onKeyPress="if(this.value.length==30) return false;">
                  </div>
               </div>
               <div class="demo-inline-spacing">
                  <br>
                  <button type="submit" class="btn btn-primary submit ">Submit</button>
                  <button type="button" class="btn btn-danger cancelbutton ">Cancel</button>
                  <br><br>
               </div>
            </form>
   </div>

   <div class="updateform d-none">
    
            <form method="post" id="updateDesignationForm" action="#">
               {!! csrf_field() !!}
               <input type="hidden" name="id" id="id" />
               <br>
               <div class="row">
                  <div class="form-group mb-3 col-md-6">
                     <label for="" class=" font-layout">Host Name <span class="inputlabelmedetory text-err"></span></label>
                     <input type="text" name="host_name" id="updatehost_name" class="form-control specialcharuser" placeholder="Enter Host Name"  onKeyPress="if(this.value.length==30) return false;">
                  </div>
                  <div class="form-group mb-3 col-md-6">
                     <label for="" class=" font-layout">Port Number <span class="inputlabelmedetory text-err"></span></label>
                     <input type="number" name="port_number" id="updateport_number" class="form-control specialcharuser" placeholder="Enter Port Number"  onKeyPress="if(this.value.length==5) return false;">
                  </div>
                  <div class="form-group mb-3 col-md-6">
                     <label for="" class=" font-layout">Username <span class="inputlabelmedetory text-err"></span></label>
                     <input type="text" name="username" id="updateusername" class="form-control specialcharuser" placeholder="Enter Username"  onKeyPress="if(this.value.length==30) return false;">
                  </div>
                  <div class="form-group mb-3 col-md-6">
                     <label for="" class=" font-layout">Password <span class="inputlabelmedetory text-err"></span></label>
                     <input type="text" name="password" id="updatepassword" class="form-control specialcharuser" placeholder="Enter Password"  onKeyPress="if(this.value.length==16) return false;">
                  </div>
                  <div class="form-group mb-3 col-md-6">
                     <label for="" class=" font-layout">Sender Email <span class="inputlabelmedetory text-err"></span></label>
                     <input type="text" name="from_address" id="updatefrom_address" class="form-control specialcharemail" placeholder="Enter Sender Email"  onKeyPress="if(this.value.length==30) return false;">
                  </div>
                  <div class="form-group mb-3 col-md-6">
                     <label for="" class=" font-layout">From Name <span class="inputlabelmedetory text-err"></span></label>
                     <input type="text" name="from_name" id="updatefrom_name" class="form-control specialcharuser" placeholder="Enter From Name"  onKeyPress="if(this.value.length==30) return false;">
                  </div>
                  <div class="form-group mt-3 col-md-6">
                     <label for="">Status</label>
                     <select class="status form-control" name="status" id="updatestatus" >
                        <option value="">Select Status</option>
                        <option value="1">Active</option>
                        <option value="2">Deactive</option>
                     </select>
                  </div>
               </div>
               <div class="demo-inline-spacing">
                  <br>
                  <button type="submit" class="btn btn-primary submit">Update</button>
                  <button type="button" class="btn btn-danger cancelbutton">Cancel</button>
                  <br><br>
               </div>
            </form>
         
   </div>
   <div class="viewform d-none">
         <!-- <h4 class="fw-bold font-weight-bold card-header headingtext font-layout">{{ __('Region Details') }}</h4> -->
            <form>
               <div class="form-group mb-3">
                  <label for="" class=" font-layout">Host Name <span class="inputlabelmedetory text-err"></span></label>
                  <input type="text" name="host_name" id="view_updatehost_name" class="form-control specialcharuser" placeholder="Enter Host Name" disabled>
               </div>
               <div class="form-group mb-3">
                  <label for="" class=" font-layout">Port Number<span class="inputlabelmedetory text-err"></span></label>
                  <input type="text" name="port_number" id="view_updateport_number" class="form-control specialcharuser" placeholder="Enter Port Number" disabled>
               </div>
               <div class="form-group mb-3">
                  <label for="" class=" font-layout">Username<span class="inputlabelmedetory text-err"></span></label>
                  <input type="text" name="username" id="view_updateusername" class="form-control specialcharuser" placeholder="Enter Username" disabled>
               </div>
               <div class="form-group mb-3">
                  <label for="" class=" font-layout">Password<span class="inputlabelmedetory text-err"></span></label>
                  <input type="text" name="password" id="view_updatepassword" class="form-control specialcharuser" placeholder="Enter Password" disabled>
               </div>
               <div class="form-group mb-3">
                  <label for="" class=" font-layout">Sender Email<span class="inputlabelmedetory text-err"></span></label>
                  <input type="text" name="from_address" id="view_updatefrom_address" class="form-control specialcharuser" placeholder="Enter checksum key" disabled>
               </div>
               <div class="form-group mb-3">
                  <label for="" class=" font-layout">From Name <span class="inputlabelmedetory text-err"></span></label>
                  <input type="text" name="from_name" id="view_updatefrom_name" class="form-control specialcharuser" placeholder="Enter From Name" disabled>
               </div>
               <br>
               <button type="button" class="btn btn-danger cancelbutton ">Cancel</button>
            </form>
      
   </div>
   
</div>
                           <div class="tab-pane fade" id="navs-justified-email" role="tabpanel">
                              <form role="form" id="web_setting_form" method="post">
                                 @csrf
                                    <div class="card mb-4" style="box-shadow: none">
                                       <div class="card-body">
                                          <div class="row">
                                          
                                             
                                             <div class="col-sm-2  mt-3">
                                                <label>Domain 60 Days Reminder<span style="color: red">*</span></label>
                                             </div>
                                             <div class="col-sm-4  mt-3">
                                                <textarea class="form-control" name="email_60days" id="email_60days"  rows="2">{{$getSettingData->email_60days}}</textarea>
                                             </div>
                                             <div class="col-sm-2  mt-3">
                                                <label>Domain 45 Days Reminder<span style="color: red">*</span></label>
                                             </div>
                                             <div class="col-sm-4  mt-3">
                                                <textarea class="form-control" name="email_45days" id="email_45days"  rows="2">{{$getSettingData->email_45days}}</textarea>
                                             </div>
                                             <div class="col-sm-2  mt-3">
                                                <label>Domain 30 Days Reminder<span style="color: red">*</span></label>
                                             </div>
                                             <div class="col-sm-4  mt-3">
                                                <textarea class="form-control" name="email_30days" id="email_30days" rows="2">{{$getSettingData->email_30days}}</textarea>
                                             </div>
                                             <div class="col-sm-2  mt-3">
                                                <label>Domain 15 Days Reminder<span style="color: red">*</span></label>
                                             </div>
                                             <div class="col-sm-4  mt-3">
                                                <textarea class="form-control" name="email_15days" id="email_15days" rows="2">{{$getSettingData->email_15days}}</textarea>
                                             </div>
                                       

                      
                                             <div class="col-sm-2  mt-3">
                                                <label>Domain 7 Days Reminder<span style="color: red">*</span></label>
                                             </div>

                                             <div class="col-sm-4  mt-3">
                                                <textarea class="form-control" name="email_7days" id="email_7days"  rows="2">{{$getSettingData->email_7days}}</textarea>
                                             </div>

                                             <div class="col-sm-2 mt-3">
                                                <label>Domain Reminder for 1/2/3 Days<span style="color: red">*</span></label>
                                             </div>
                                             <div class="col-sm-4  mt-3">
                                                <textarea class="form-control" name="email_90days" id="email_90days rows="2">{{$getSettingData->email_90days}} </textarea>
                                             </div>

                                             
                                             <div class="col-sm-2  mt-3">
                                                <label>Domain Hold<span style="color: red">*</span></label>
                                             </div>
                                             <div class="col-sm-4  mt-3">
                                                <textarea class="form-control" name="email_hold" id="email_hold" rows="2">{{$getSettingData->email_hold}}</textarea>
                                             </div>
                                             <div class="col-sm-2  mt-3">
                                                <label>Domain Restorable<span style="color: red">*</span></label>
                                             </div>
                                             <div class="col-sm-4  mt-3">
                                                <textarea class="form-control" name="email_restorable" id="email_restorable" rows="2">{{$getSettingData->email_restorable}}</textarea>
                                             </div>
                                             <div class="col-sm-2  mt-3">
                                                <label>Domain Delete<span style="color: red">*</span></label>
                                             </div>
                                             <div class="col-sm-4  mt-3">
                                                <textarea class="form-control" name="email_delete" id="email_delete" rows="2">{{$getSettingData->email_delete}}</textarea>
                                             </div>
                                             <div class="col-sm-2  mt-3">
                                                <label>Domain Registered<span style="color: red">*</span></label>
                                             </div>
                                             <div class="col-sm-4  mt-3">
                                                <textarea class="form-control" name="email_registered" id="email_registered" rows="2">{{$getSettingData->email_registered}}</textarea>
                                             </div>
                                             <div class="col-sm-2  mt-3">
                                                <label>Domain Renewed<span style="color: red">*</span></label>
                                             </div>
                                             <div class="col-sm-4  mt-3">
                                                <textarea class="form-control" name="email_renewed" id="email_renewed" rows="2">{{$getSettingData->email_renewed}}</textarea>
                                             </div>
                                             <div class="col-sm-2  mt-3">
                                                <label>Document Clarification<span style="color: red">*</span></label>
                                             </div>
                                             <div class="col-sm-4  mt-3">
                                                <textarea class="form-control" name="email_clarification" id="email_clarification" rows="2">{{$getSettingData->email_clarification}}</textarea>
                                             </div>
                                             <div class="col-sm-2  mt-3">
                                                <label>Document Approved<span style="color: red">*</span></label>
                                             </div>
                                             <div class="col-sm-4  mt-3">
                                                <textarea class="form-control" name="email_approved" id="email_approved" rows="2">{{$getSettingData->email_approved}}</textarea>
                                             </div>
                                             <div class="col-sm-2  mt-3">
                                                <label>Domain Email Verification<span style="color: red">*</span></label>
                                             </div>
                                             <div class="col-sm-4  mt-3">
                                                <textarea class="form-control" name="email_nameserver" id="email_nameserver" rows="2">{{$getSettingData->email_nameserver}}</textarea>
                                             </div>

                                             <div class="col-sm-2  mt-3">
                                                <label>Document Rejected Reminder (Every 3 Days)<span style="color: red">*</span></label>
                                             </div>
                                             <div class="col-sm-4  mt-3">
                                                <textarea class="form-control" name="doc_rejection_reminders" id="doc_rejection_reminders" rows="2">{{$getSettingData->doc_rejection_reminders}}</textarea>
                                             </div>

                                             <div class="col-sm-2  mt-3">
                                                <label>Domain Hold Reminders<span style="color: red">*</span></label>
                                             </div>
                                             <div class="col-sm-4  mt-3">
                                                <textarea class="form-control" name="domain_hold_reminders" id="domain_hold_reminders" rows="2">{{$getSettingData->domain_hold_reminders}}</textarea>
                                             </div>

                                             <div class="col-sm-2  mt-3">
                                                <label>Domain Pending Restore Reminders<span style="color: red">*</span></label>
                                             </div>
                                             <div class="col-sm-4  mt-3">
                                                <textarea class="form-control" name="pending_restore_reminders" id="pending_restore_reminders" rows="2">{{$getSettingData->pending_restore_reminders}}</textarea>
                                             </div>

                                             <div class="col-sm-2  mt-3">
                                                <label>Reminder for Document Not Submitted<span style="color: red">*</span></label>
                                             </div>
                                             <div class="col-sm-4  mt-3">
                                                <textarea class="form-control" name="reminder_fresh_final" id="reminder_fresh_final" rows="2">{{$getSettingData->reminder_fresh_final}}</textarea>
                                             </div>

                                             <div class="col-sm-2  mt-3">
                                                <label>Delete Domain Payment Not Submitted <span style="color: red">*</span></label>
                                             </div>
                                             <div class="col-sm-4  mt-3">
                                                <textarea class="form-control" name="delete_payment_pending" id="delete_payment_pending" rows="2">{{$getSettingData->delete_payment_pending}}</textarea>
                                             </div>

                                             <div class="col-sm-2  mt-3">
                                                                <label>Reminder Mail Incompleted Application (After 7
                                                                    Days)<span style="color: red">*</span></label>
                                                            </div>
                                          <div class="col-sm-4  mt-3">
                                                <textarea class="form-control" name="reminder_mail" id="reminder_mail" rows="2">{{ $getSettingData->reminder_mail }}</textarea>
                                          </div>
                                                            
                                       <div class="col-sm-2  mt-3">
                                             <label>Deleted Mail Incompleted Application (After 10
                                                days)<span style="color: red">*</span></label>
                                       </div>
                                       <div class="col-sm-4  mt-3">
                                             <textarea class="form-control" name="deleted_mail" id="deleted_mail" rows="2">{{ $getSettingData->deleted_mail }}</textarea>
                                       </div>


                                       <div class="col-sm-2  mt-3">
                                             <label>Reminder Mail for Rejected Docs - Renewal Application (After 10/20/30 days)<span style="color: red">*</span></label>
                                       </div>
                                       <div class="col-sm-4  mt-3">
                                             <textarea class="form-control" name="renewal_application_mail" id="renewal_application_mail" rows="2">{{ $getSettingData->renewal_application_mail }}</textarea>
                                       </div>

                                          </div>
                                       </div>
                                    </div>
                                <button class="btn btn-success mr-4 float-end" id="web_setting_btn" name="action" value="Submit">Submit</button>
                                </form>
                                 </div>
                           </div>                          
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </div>
</div>
@endsection
@section("js")
<script>
   $('.valid-num').keypress(function(event) {
    var charCode = (event.which) ? event.which : event.keyCode;
    var inputValue = $(this).val();
    var decimalIndex = inputValue.indexOf('.');
      if (charCode == 46) {
      if (decimalIndex != -1 || inputValue.length === 0 || inputValue.length > 14) {
        event.preventDefault();
      }
    } else if ((charCode < 48 || charCode > 57) || (decimalIndex != -1 && inputValue.length - decimalIndex > 2)) {
      event.preventDefault();
    } else if (inputValue.length >= 11 && decimalIndex === -1) {
      event.preventDefault();
    }
   });
   
   
   $('.valid-per').keypress(function(event) {
    var charCode = (event.which) ? event.which : event.keyCode;
    var inputValue = $(this).val();
    var decimalIndex = inputValue.indexOf('.');
      if (charCode == 46) {
      if (decimalIndex != -1 || inputValue.length === 0 || inputValue.length > 2) {
        event.preventDefault();
      }
    } else if ((charCode < 48 || charCode > 57) || (decimalIndex != -1 && inputValue.length - decimalIndex > 2)) {
      event.preventDefault();
    } else if (inputValue.length >= 4 && decimalIndex === -1) {
      event.preventDefault();
    }
   });
   
   $('#web_setting_form').validate({
    rules: {
      reactivation_price: {required: true,},
      hold_deduction_price: {required: true,},
      service_tax: {required: true},
      account_number: {required: true, maxlength:16},
      branch_name: {required: true,},
      email: {required: true,},
      email_address_one: {required: true,},
      email_address_two: {required: true,},
      hold_domain_period: {required: true,},
      restorable_domain_period: {required: true,},
      hold_domain_reminder_period: {required: true,},
      restorable_domain_reminder_period: {required: true,},
    },
    messages:
    {
      reactivation_price:{required: "Please enter reactivation Price",number:"Please enter valid reactivation Price"},
      hold_deduction_price:{required: "Please enter hold deduction price",number:"Please enter valid hold deduction price", maxlength:"Please enter valid hold deduction price"},
      service_tax:{required: "Please enter service tax in %",number:"Please enter valid service tax in %"},
      account_number:{required: "Please enter account number", number:"Please enter valid account number", maxlength:"Please enter valid account number"},
      branch_name:{required: "Please enter branch name",},
      email:{required: "Please enter email id",},
      email_address_one:{required: "Please enter email address 1",},
      email_address_two:{required: "Please enter email address 2",},
      hold_domain_period:{required: "This field is required",},
      restorable_domain_period:{required: "This field is required"},
      hold_domain_reminder_period:{required: "This field is required"},
      restorable_domain_reminder_period:{required: "This field is required"},
    },
    submitHandler:function(form)
    {
      $.ajaxSetup({
        headers: {
          'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
      });
      $.ajax({
        url:"{{route('admin.add-setting-byemail')}}",
        type:'POST',
        dataType:'json',
        data:$("#web_setting_form").serialize(),
        cache: false,
        beforeSend: function(){
          $(".loader-area").show();
        },
        success:function(res)
        {
          if(res.status=='success')
          {
            Swal.fire({
              position: 'center',
              icon: 'success',
              text: res.message,
              showConfirmButton: true,
            }).then(function () {
                window.location = "{{route('admin.email-setting-view')}}";
            });
          }
          else
          {
           Swal.fire({
              position: 'center',
              icon: 'error',
              text: 'Record can not be updated',
              showConfirmButton: true,
            });
          }
        },
        complete: function(){
        $("form").trigger("reset");
        $("#web_setting_btn").prop('disabled',false);
        },
      });
    }
   });
</script>
<script type="text/javascript">
   $(document).ready(function() {

      $('.specialcharuser').on('keypress',function(e){

var regex=new RegExp("^[a-zA-Z0-9.&#@ ]");
var key=String.fromCharCode(!e.charCode ? e.which :e.charCode);
if(!regex.test(key)){
    e.preventDefault();
    return false;
}

});


$('.specialcharemail').on('keypress',function(e){

var regex=new RegExp("^[a-zA-Z0-9.@_ ]");
var key=String.fromCharCode(!e.charCode ? e.which :e.charCode);
if(!regex.test(key)){
    e.preventDefault();
    return false;
}

});


   	var _ = $('body');
   	var createRecord = 'Are you sure you want to save the record?';
   	var updateRecord = 'Are you sure you want to modify this record?';
   	var deleteRecord = 'Are you sure you want to delete this record?';
   
   	var table = $('#dataTable').DataTable({
   		processing: true,
   		serverSide: true,
   		ajax: "{{route('emaiSetting.ajaxcall')}}",
   		columns: [
   			{ data: 'id' },
                     { data: 'host_name',orderable:false},
                     { data: 'port_number',orderable:false},
                     { data: 'username',orderable:false},
                     { data: 'password',orderable:false},
   			{ data: 'from_address',orderable:false},
   			{ data: 'status',orderable:false},
   			{ data: 'Action',orderable:false },
   		]
   	});
   	$('body').on('click', '.delete', function() {
   		var id = $(this).attr('data-id');
   		if (confirm(deleteRecord)) {
   			$('.viewform').addClass('d-none');
   			$('.updateform').addClass('d-none');
   			$('.createform').addClass('d-none');
   			$.ajaxSetup({
   				headers: {
   					'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
   				}
   			});
   
   			$.ajax({
   				url: "{{route('emaiSetting.delete')}}",
   				dataType : "json",
   				type: "post",
   				data : {'id':id},
   				success : function(response) {
                             $('#host_name').val('');
                             $('#port_number').val('');
                             $('#username').val('');
                             $('#password').val('');
   					$('#from_address').val('');
                             $('#from_name').val('');
   					if(response.status == 'success') {
   						table.ajax.reload();
   					} else if(response.status == 'error') {
   						alert(response.message);
   					}
   					else if(response.status == 'exceptionError')
   					{
   						CommonManager.forcelogout();
   					}
   				},
   			});
   
   		}
   		return false;
   	});
   
   
   
   	$('body').on('submit', '#departmentForm', function(e) {
                 e.preventDefault();
   		var current = $(this);
   		if (confirm(createRecord)) {
   			$('.submit', current).attr('disabled', 'disabled');
   
                     var host_name = $('#host_name', current).val();
   			var port_number = $('#port_number', current).val();
                     var username = $('#username', current).val();
                     var password = $('#password', current).val();
                     var from_address = $('#from_address', current).val();
                     var from_name = $('#from_name', current).val();
   
                     $('.host_name_error').remove();
   			if(host_name == '') {
   				$('#host_name').after('<span class="host_name_error" style="color:red">Please Enter Host Name.</span>');
   				$('.submit').removeAttr('disabled');
   				return false;
   			}
   
   			$('.port_number_error').remove();
   			if(port_number == '') {
   				$('#port_number').after('<span class="port_number_error" style="color:red">Please Enter Port Number.</span>');
   				$('.submit').removeAttr('disabled');
   				return false;
   			}
                     $('.username_error').remove();
                     if(username == '') {
   				$('#username').after('<span class="username_error" style="color:red">Please Enter username.</span>');
   				$('.submit').removeAttr('disabled');
   				return false;
   			}
                     $('.password_error').remove();
                     if(password == '') {
   				$('#password').after('<span class="password_error" style="color:red">Please Enter password.</span>');
   				$('.submit').removeAttr('disabled');
   				return false;
   			}
                     $('.from_address_error').remove();
                     if(from_address == '') {
   				$('#from_address').after('<span class="from_address_error" style="color:red">Please Enter Sender Email.</span>');
   				$('.submit').removeAttr('disabled');
   				return false;
   			}
                     $('.from_name_error').remove();
                     if(from_name == '') {
   				$('#from_name').after('<span class="from_name_error" style="color:red">Please Enter From Name.</span>');
   				$('.submit').removeAttr('disabled');
   				return false;
   			}
   
   			var data = current.serialize();
   			$.ajax({
   				url: "{{route('emaiSetting.save')}}",
   				dataType : "json",
   				type: "post",
   				data : data,
   				success : function(response) {
   
   					$('.submit').removeAttr('disabled');
   
   					if(response.status == 'success') {
                                 $('#host_name').val('');
   						$('#port_number').val('');
                                 $('#username').val('');
                                 $('#password').val('');
                                 $('#from_address').val('');
                                 $('#from_name').val('');
   						table.ajax.reload();
   						$('.updateform').addClass('d-none');
   						$('.createform').addClass('d-none');
   						$('.viewform').addClass('d-none');
   					} else if(response.status == 'errors') {
   
   						$.each(response.message, function(i, message) {
   							$('#'+i).after('<span class="Description_error" style="color:red">'+message+'</span>');
   						});
   
   					} else if(response.status == 'error') {
   						$('#description').after('<span class="Description_error" style="color:red">'+response.error+'</span>');
   					}
   					else if(response.status == 'exceptionError')
   					{
   						CommonManager.forcelogout();
   					}
   				},
   			});
   			return false;
   		}
   		return false;
   	});
   
   	$('body').on('submit', '#updateDesignationForm', function(e) {
                 e.preventDefault();
   	var current = $(this);
   	if (confirm(updateRecord)) {
   		$('.submit', current).attr('disabled', 'disabled');
   		var host_name = $('#updatehost_name', current).val();
   		var port_number = $('#updateport_number', current).val();
                 var username = $('#updateusername', current).val();
                 var password = $('#updatepassword', current).val();
                 var from_address = $('#updatefrom_address', current).val();
                 var from_name = $('#updatefrom_name', current).val();
   
   		$('.payment_gateway_error').remove();
   		if(host_name == '') {
   			$('#updatehost_name').after('<span class="host_name_error" style="color:red">Please enter Host Name.</span>');
   			$('.submit').removeAttr('disabled');
   			return false;
   		}
   		$('.port_number_error').remove();
   		if(port_number == '') {
   			$('#updateport_number').after('<span class="port_number_error" style="color:red">Please enter Port Number.</span>');
   			$('.submit').removeAttr('disabled');
   			return false;
   		}
                 $('.username_error').remove();
   		if(username == '') {
   			$('#updateusername').after('<span class="username_error" style="color:red">Please enter username.</span>');
   			$('.submit').removeAttr('disabled');
   			return false;
   		}
                 $('.password_error').remove();
   		if(password == '') {
   			$('#updatepassword').after('<span class="password_error" style="color:red">Please enter password.</span>');
   			$('.submit').removeAttr('disabled');
   			return false;
   		}
                 $('.from_address_error').remove();
   		if(from_address == '') {
   			$('#updatefrom_address').after('<span class="from_address_error" style="color:red">Please enter Sender Email.</span>');
   			$('.submit').removeAttr('disabled');
   			return false;
   		}
                 $('.from_name_error').remove();
   		if(from_name == '') {
   			$('#updatefrom_name').after('<span class="from_name_error" style="color:red">Please enter From Name.</span>');
   			$('.submit').removeAttr('disabled');
   			return false;
   		}
   
   		$('.err').remove();
   		var data = current.serialize();
   		$.ajax({
   			url:"{{route('emaiSetting.update')}}",
   			dataType : "json",
   			type: "post",
   			data : data,
   			success : function(response) {
   
   				$('.submit').removeAttr('disabled');
   
   				if(response.status == 'success') {
                             $('#host_name').val('');
   					$('#port_number').val('');
                             $('#username').val('');
                             $('#password').val('');
                             $('#from_address').val('');
   					$('#from_name').val('');
   					table.ajax.reload();
   
   					$('.updateform').addClass('d-none');
   					$('.createform').addClass('d-none');
   					$('.viewform').addClass('d-none');
   
   				} else if(response.status == 'errors') {
   
   					$.each(response.message, function(i, message) {
   						$('#update'+i).after('<span id="Description_error" class="err" style="color:red">'+message+'</span>');
   					});
   
   				}else if(response.status == 'single') {
   
   					alert(response.message);
   
   				}
   				else if(response.status == 'error') {
   					$('#updateDescription').after('<span class="Description_error err" style="color:red">'+response.message+'</span>');
   				}
   				else if(response.status == 'exceptionError')
   				{
   					CommonManager.forcelogout();
   				}
   			},
   		});
   		return false;
   	}
   	return false;
   });
   	$('body').on('click', '.view', function() {
   		var id = $(this).attr('data-id');
   		$('.viewform').removeClass('d-none');
   		$('.updateform').addClass('d-none');
   		$('.createform').addClass('d-none');
   		$.ajax({
   			url: "{{ route('emaiSetting.regionid') }}",
   			dataType : "json",
   			type: "get",
   			data : {'id':id},
   			success : function(response) {
   
   				if(response.status == 'success') {
                             $('#view_updatehost_name').val(response.data.host_name);
   					$('#view_updateport_number').val(response.data.port_number);
                             $('#view_updateusername').val(response.data.username);
                             $('#view_updatepassword').val(response.data.password);
                             $('#view_updatefrom_address').val(response.data.from_address);
   					$('#view_updatefrom_name').val(response.data.from_name);
   				} else if(response.status == 'error') {
   
   					alert(response.message);
   
   				}
   
   			},
   		});
   	});
   
   	$('body').on('click', '.update', function() {
   		var id = $(this).attr('data-id');
   		$('#code').val('');
   		$.ajax({
   			url: "{{ route('emaiSetting.regionid') }}",
   			dataType : "json",
   			type: "get",
   			data : {'id':id},
   			success : function(response) {
   
   				if(response.status == 'success') {
   
   					$('.createform').addClass('d-none');
   					$('.viewform').addClass('d-none');
   					$('.updateform').removeClass('d-none');
   					$('#id').val(response.data.id);
                             $('#updatehost_name').val(response.data.host_name);
                             $('#updateport_number').val(response.data.port_number);
                             $('#updateusername').val(response.data.username);
                             $('#updatepassword').val(response.data.password);
                             $('#updatefrom_address').val(response.data.from_address);
   					$('#updatefrom_name').val(response.data.from_name);
                             $('#updatestatus option[value="'+response.data.status+'"]').prop('selected', true);
   
   				} else if(response.status == 'error') {
   					alert(response.message);
   				}
   
   			},
   		});
   
   	});
   
   	$('body').on('click', '.addbutton', function() {
   		$('.createform').removeClass('d-none');
   		$('.updateform').addClass('d-none');
   		$('.viewform').addClass('d-none');
   	});
   
   	$('body').on('click', '.cancelbutton', function() {
   		$('.createform').addClass('d-none');
   		$('.updateform').addClass('d-none');
   		$('.viewform').addClass('d-none');
   	});
   
   });
</script>
@endsection